local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable()

local spells = {
	BS["Feed Pet"],
	BS["Eyes of the Beast"],
	BS["Dismiss Pet"],
	BS["Beast Lore"],
	BS["Tame Beast"],
	BS["Scare Beast"],
	BS["Revive Pet"]
}

local macrotext = "/cast [target=pet, dead] [modifier:ctrl] "..BS["Revive Pet"].."; [nopet] "..BS["Call Pet"].."; "..BS["Mend Pet"]

local spellId = {}

function ZPet:UpdateSpells()
	self:ResetSpells()
	for i = 1, #spells do
		self:AddSpell(spells[ZHunterMod_Saved["ZPet"]["order"][i]])
	end
end

function ZPet:Initialize()
	local vars = ZHunterMod_Saved.ZPet
	self:UpdateSpells()
	self:SetSize(vars.size)
	self:SetCount(vars.count)
	self:SetHorizontal(vars.horizontal)
	self:SetVertical(vars.vertical)
	self:SetPerRow(vars.perRow)
	self:SetRoundButton(vars.roundButton)
	self:SetExpandType(vars.expandType)
	self:SetBackgroundColor(vars.bgColor)
	self:SetCooldownDisplay(vars.cooldownDisplay)
	self:SetSpecial(true)
	self:SetAttribute("macrotext", macrotext)
	self:RegisterEvent("UNIT_PET")
	self:RegisterEvent("MODIFIER_STATE_CHANGED")
	self:SetAttribute("ctrl-type1", "spell")
	self:SetAttribute("ctrl-spell1", BS["Revive Pet"])
	spellId[BS["Revive Pet"]] = self:GetSpellId(BS["Revive Pet"])
	spellId[BS["Call Pet"]] = self:GetSpellId(BS["Call Pet"])
	spellId[BS["Mend Pet"]] = self:GetSpellId(BS["Mend Pet"])
	if not ZHunterMod_Saved["ZPet"].enabled then
		self:SetCount(0)
		self:Hide()
	end
end

function ZPet:OnEvent(event, arg1)
	local spell = SecureCmdOptionParse(macrotext)
	self:SetIcon(GetSpellTexture(spell))
	self.id = spellId[spell]
end

ZHunterModOptions.args.pet = {
	type = "group",
	name = "Pet Bar",
	desc = "Options to customize the Pet bar.",
	order = 5,
	args = {}
}
ZHunterModOptions_SetSpellOptions("ZPet", ZHunterModOptions.args.pet.args, spells)