local BS = LibStub("LibBabble-Spell-3.0"):GetLookupTable()

local spells = {
	BS["Aspect of the Viper"],
	BS["Aspect of the Wild"],
	BS["Aspect of the Hawk"],
	BS["Aspect of the Monkey"],
	BS["Aspect of the Cheetah"],
	BS["Aspect of the Pack"],
	BS["Aspect of the Beast"],
	BS["Trueshot Aura"]
}

local texture = "Interface\\Icons\\Spell_Nature_WispSplode"
local macrotext = "/cast %s\n/cast %s"
local spell1 = ""
local spell2 = ""

local function setupParent(self)
	self:SetAttribute("macrotext", macrotext:format(spell1, spell2))
end

local function checkSpecial(self)
	if not ZHunterMod_Saved["ZAspect"].special then return end
	if GetPlayerBuffName(spell1) and spell2 ~= "" then
		self:SetIcon(GetSpellTexture(spell2))
		self.id = self.button[3].id
	elseif spell1 ~= "" then
		self:SetIcon(GetSpellTexture(spell1))
		self.id = self.button[2].id
	end
end

local function checkTextures(self)
	local start = ZHunterMod_Saved["ZAspect"].special and 2 or 1
	for i = start, self.numButtons do
		if GetPlayerBuffName(self.button[i].spell) then
			if not self.button[i].isCustom then
				self.button[i]:SetIcon(texture)
				self.button[i].isCustom = true
			end
		elseif self.button[i].isCustom then
			self.button[i]:SetIcon(GetSpellTexture(self.button[i].spell))
			self.button[i].isCustom = false
		end
	end
end

function ZAspect:UpdateSpells()
	self:ResetSpells()
	for i = 1, #spells do
		self:AddSpell(spells[ZHunterMod_Saved["ZAspect"]["order"][i]])
	end
	checkSpecial(self)
	checkTextures(self)
end

function ZAspect:Initialize()
	local vars = ZHunterMod_Saved.ZAspect
	self:RegisterEvent("PLAYER_AURAS_CHANGED")
	self:UpdateSpells()
	self:SetSize(vars.size)
	self:SetCount(vars.count)
	self:SetHorizontal(vars.horizontal)
	self:SetVertical(vars.vertical)
	self:SetPerRow(vars.perRow)
	self:SetRoundButton(vars.roundButton)
	self:SetExpandType(vars.expandType)
	self:SetBackgroundColor(vars.bgColor)
	self:SetCooldownDisplay(vars.cooldownDisplay)
	if ZHunterMod_Saved["ZAspect"].special then
		self:SetSpecial(true)
		setupParent(self)
	end
	if not ZHunterMod_Saved["ZAspect"].enabled then
		self:SetCount(0)
		self:Hide()
	end
end

function ZAspect:OnEvent(event, arg1, arg2)
	if event == "SPELLBUTTON_CHANGED" then
		if arg1 == 2 then
			spell1 = arg2
		elseif arg1 == 3 then
			spell2 = arg2
		end
		setupParent(self)
	elseif event == "PLAYER_AURAS_CHANGED" then
		checkSpecial(self)
		checkTextures(self)
	end
end

ZHunterModOptions.args.aspect = {
	type = "group",
	name = "Aspect Bar",
	desc = "Options to customize the Aspect bar.",
	order = 2,
	args = {
		special = {
			type = "toggle",
			name = "Special", desc = "Enable/Disable the special feature of the first button (requires a '/console reloadui').",
			order = 10,
			get = function(info) return ZHunterMod_Saved["ZAspect"].special end,
			set = function(info, v)
				ZHunterMod_Saved["ZAspect"].special = v
				ZAspect:SetSpecial(v)
			end
		}
	}
}
ZHunterModOptions_SetSpellOptions("ZAspect", ZHunterModOptions.args.aspect.args, spells)