ZAutoStrip_Order = {16, 17, 18, 5, 7, 1, 3, 10, 8, 6, 9}
ZAutoStrip_On = false

function ZAutoStrip_OnEvent(self, event)
	if ZAutoStrip_On then
		ZAutoStrip_UnequipAll()
	end
	if event == "PLAYER_LOGIN" then
		if ZHunterMod_Saved["ZAutoStrip"]["on"] then
			ZAutoStrip:Show()
		else
			ZAutoStrip:Hide()
		end
		self:UnregisterEvent("PLAYER_LOGIN")
	end
end

function ZAutoStrip_OnClick(self, button)
	if button == "LeftButton" then
		if not UnitAffectingCombat("player") then
			ZAutoStrip_UnequipAll()
		else
			ZAutoStrip_UnequipAll(1)
		end
	elseif button == "RightButton" then
		if ZAutoStrip_On then
			ZAutoStrip_On = nil
			ZAutoStripAutoCast:Hide()
		else
			ZAutoStrip_On = 1
			ZAutoStripAutoCast:Show()
		end
	end
end

function ZAutoStrip_UnequipAll(weapons)
	ZAutoStrip_On = nil
	ZAutoStripAutoCast:Hide()
	local start = 1
	local finish
	if weapons then
		finish = 3
	else
		finish = table.getn(ZAutoStrip_Order)
	end
	for bag=0, 4 do
		for slot=1, GetContainerNumSlots(bag) do
			if not GetContainerItemLink(bag, slot) then
				for i=start, finish do
					if GetInventoryItemLink("player", ZAutoStrip_Order[i]) then
						PickupInventoryItem(ZAutoStrip_Order[i])
						PickupContainerItem(bag, slot)
						start = i + 1
						break
					end
				end
			end
		end
	end
end

SLASH_ZAutoStrip1 = "/zstrip"
SlashCmdList["ZAutoStrip"] = function(msg)
	if msg == "display" then
		if ZAutoStrip:IsVisible() then
			ZAutoStrip:Hide()
			ZHunterMod_Saved["ZAutoStrip"]["on"] = false
		else
			ZAutoStrip:Show()
			ZHunterMod_Saved["ZAutoStrip"]["on"] = true
		end
	elseif msg == "toggle" then
		if ZAutoStrip_On then
			DEFAULT_CHAT_FRAME:AddMessage("You will no longer strip when you leave combat.",0,1,1)
			ZAutoStrip_On = false
			if ZAutoStrip:IsVisible() then ZAutoStripAutoCast:Hide() end
		else
			DEFAULT_CHAT_FRAME:AddMessage("You will strip when you leave combat.",0,1,1)
			ZAutoStrip_On = true
			if ZAutoStrip:IsVisible() then ZAutoStripAutoCast:Show() end
		end
	elseif msg == "now" then
		ZAutoStrip_OnClick(ZAutoStrip, "LeftButton")
	else
		DEFAULT_CHAT_FRAME:AddMessage("Possible Commands: \"display\", \"toggle\", \"now\"",0,1,1)
	end
end