local YurrCombatLog = LibStub("AceAddon-3.0"):GetAddon("YurrCombatLog")
local Addon = LibStub("AceAddon-3.0"):GetAddon("Fortress", "silent")
local L = LibStub("AceLocale-3.0"):GetLocale("YurrCombatLog")
local YurrCombatLogLDB = LibStub("LibDataBroker-1.1")
local LDB = YurrCombatLogLDB:GetDataObjectByName("YurrCombatLog")

function YurrCombatLog:Minimap()
	-- MinimapFrame
	local f = CreateFrame("Frame", tostring(self).."Minimap", Minimap)
	f:SetFrameStrata("LOW")
	f:SetWidth(33)
	f:SetHeight(33)
	f:SetPoint("CENTER")
	f:EnableMouse(true)
	f:Show()
	self.Minimap = f
	
	-- Minimap
	local b = CreateFrame("Button", nil, f)
	b:SetAllPoints(f)
	b:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	
	-- MinimapIcon
	local t = b:CreateTexture(nil, "BACKGROUND")
	t:SetWidth(20)
	t:SetHeight(20)
	t:SetPoint("CENTER")
	MinimapIconTexture = t
	--t:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")
	t:SetTexture("Interface\\Icons\\Ability_MeleeDamage")
	
	-- MinimapBorder
	t = b:CreateTexture(nil, "OVERLAY")
	t:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder")
	t:SetWidth(52)
	t:SetHeight(52)
	t:SetPoint("TOPLEFT")
	
	-- set some scripts
	b:SetScript("OnDragStart", function()
			if(self.db.profile.miniMap.dragable) then
				this.dragme = true
				this:LockHighlight()
			end
		end)
	b:SetScript("OnDragStop", function()
			this.dragme = false
			this:UnlockHighlight()
		end)
	b:SetScript("OnUpdate", function()
			if(this.dragme == true) then
				self:MinimapBeingDragged()
			end
		end)
	b:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this, "ANCHOR_NONE")
		GameTooltip:SetPoint("TOPRIGHT", this, "BOTTOM")
		GameTooltip:ClearLines()
		GameTooltip:AddLine(LDB.text)
		GameTooltip:AddLine("|cffffff00"..L["LeftClick|r to open the YurrCombatLog options menu"])
		if ( Addon ) then
			GameTooltip:AddLine("|cffffff00"..L["RightClick|r to open the Fotress options menu"])
		end
		GameTooltip:Show()
	end)
	b:SetScript("OnLeave", function()
			GameTooltip:Hide()
		end)
	b:SetScript("OnClick", function(_, button)
			if button == "LeftButton" then
				LibStub("AceConfigDialog-3.0"):Open("YurrCombatLog")
			elseif ( Addon ) and button == "RightButton" then
				LibStub("AceConfigDialog-3.0"):Open("YurrCombatLogLDB")
			end
		end)
	
	-- init dragging
	b:RegisterForDrag("LeftButton")
	b.dragme = false
	
	b:RegisterForClicks("LeftButtonUp", "RightButtonUp")
	
	-- update the position of the button
	self:MinimapUpdatePosition()
	
	if ( YurrCombatLog.db.profile.miniMap.Hidden == true ) then
		YurrCombatLog:HideMinimap()
	end
end

function YurrCombatLog:SetMinimapPosition(angle, radius, rounding)
	self.db.profile.miniMap.angle = angle
	if(radius) then
		self.db.profile.miniMap.radius = radius
	end
	if(rounding) then
		self.db.profile.miniMap.rounding = rounding
	end
	self:MinimapUpdatePosition()
	self:OnMinimapMove(angle)
end

function YurrCombatLog:ShowMinimap()
	self.Minimap:Show()
end

function YurrCombatLog:HideMinimap()
	self.Minimap:Hide()
end

function YurrCombatLog:OnMinimapMove(angle)
end

function YurrCombatLog:MinimapBeingDragged()
	local mx, my = Minimap:GetCenter()
	local mz = MinimapCluster:GetScale()
	local cx, cy = GetCursorPosition(UIParent)
	local cz = UIParent:GetEffectiveScale()
	local v = math.deg(math.atan2(cy / cz - my * mz, cx / cz - mx * mz))
	if v < 0 then
		v = v + 360
	elseif v > 360 then
		v = v - 360
	end
	self:SetMinimapPosition(v)
end

local MinimapShapes = {
	-- quadrant booleans (same order as SetTexCoord)
	-- {upper-left, lower-left, upper-right, lower-right}
	-- true = rounded, false = squared
	["ROUND"] 					= {true, true, true, true},
	["SQUARE"] 					= {false, false, false, false},
	["CORNER-TOPLEFT"] 			= {true, false, false, false},
	["CORNER-TOPRIGHT"] 		= {false, false, true, false},
	["CORNER-BOTTOMLEFT"] 		= {false, true, false, false},
	["CORNER-BOTTOMRIGHT"]	 	= {false, false, false, true},
	["SIDE-LEFT"] 				= {true, true, false, false},
	["SIDE-RIGHT"] 				= {false, false, true, true},
	["SIDE-TOP"] 				= {true, false, true, false},
	["SIDE-BOTTOM"] 			= {false, true, false, true},
	["TRICORNER-TOPLEFT"] 		= {true, true, true, false},
	["TRICORNER-TOPRIGHT"] 		= {true, false, true, true},
	["TRICORNER-BOTTOMLEFT"] 	= {true, true, false, true},
	["TRICORNER-BOTTOMRIGHT"] 	= {false, true, true, true},
	}

function YurrCombatLog:MinimapUpdatePosition()
	
	local radius = self.db.profile.miniMap.radius
	local rounding = self.db.profile.miniMap.rounding
	local angle = math.rad(self.db.profile.miniMap.angle)
	
	local x = math.cos(angle)
	local y = math.sin(angle)
	local q = 1;
	if x < 0 then
		q = q + 1;	-- lower
	end
	if y > 0 then
		q = q + 2;	-- right
	end
	local minimapShape = GetMinimapShape and GetMinimapShape() or "ROUND"
	local quadTable = MinimapShapes[minimapShape]
	if quadTable[q] then
		x = x*radius
		y = y*radius
	else
		local diagRadius = math.sqrt(2*(radius)^2)-rounding
		x = math.max(-radius, math.min(x*diagRadius, radius))
		y = math.max(-radius, math.min(y*diagRadius, radius))
	end
	self.Minimap:SetPoint("CENTER", Minimap, "CENTER", x, y-1)
end