YurrCombatLog = LibStub("AceAddon-3.0"):NewAddon("YurrCombatLog", "AceConsole-3.0", "AceEvent-3.0")
local YurrCombatLogLDB = LibStub("LibDataBroker-1.1")
local L = LibStub("AceLocale-3.0"):GetLocale("YurrCombatLog")
local Addon = LibStub("AceAddon-3.0"):GetAddon("Fortress", "silent")
local math_floor = _G.math.floor

local COMBATLOG_LIMIT_PER_FRAME = 1;
local _G = getfenv(0)
local CombatLogQuickButtonFrameProgressBar
local bit_bor = _G.bit.bor
local oldFCF_DockUpdate

local LDB = YurrCombatLogLDB:NewDataObject("YurrCombatLog", {
	launcher = true,
	icon = "Interface\\Icons\\Ability_MeleeDamage",
	label = "YurrCombatLog",
	text = "YurrCombatLog"
})

function LDB:OnEnter()
	GameTooltip:SetOwner(self, "ANCHOR_NONE")
	GameTooltip:SetPoint("TOP", self, "BOTTOM")
	GameTooltip:ClearLines()
	GameTooltip:AddLine(LDB.text)
	GameTooltip:AddLine("|cffffff00"..L["LeftClick|r to open the YurrCombatLog options menu"])
	if ( Addon ) then
		GameTooltip:AddLine("|cffffff00"..L["RightClick|r to open the Fotress options menu"])
	end
	--LDB.OnTooltipShow(GameTooltip)
	GameTooltip:Show()
end

function LDB:OnClick(button)
	if button == "LeftButton" then
		LibStub("AceConfigDialog-3.0"):Open("YurrCombatLog")
	elseif ( Addon ) and button == "RightButton" then
		LibStub("AceConfigDialog-3.0"):Open("FortressYurrCombatLog")
	end
end

function LDB:OnLeave()
    GameTooltip:Hide()
end

function YurrCombatLog:OnInitialize()

	-- Called when the addon is loaded
	self:Config()
	self:RegisterChatCommand("ycl", "ChatCommand")
	self:RegisterChatCommand("yurrcombatlog", "ChatCommand")
	--self:SecureHook("FCF_DockUpdate", "fakeFunction")
	oldFCF_DockUpdate = FCF_DockUpdate

end

function YurrCombatLog:OnEnable()

	-- Called when the addon is enabled
	self:RegisterEvent("COMBAT_LOG_EVENT")
	self:RegisterEvent("CHAT_MSG_COMBAT_XP_GAIN")
	self:RegisterEvent("CHAT_MSG_COMBAT_HONOR_GAIN")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("CHAT_MSG_COMBAT_FACTION_CHANGE")
	self:RegisterEvent("ADDON_LOADED")
	self:RegisterEvent("CHAT_MSG_SKILL")
	outputFrame = self:ChatFrame(self.db.profile.ChatFrame)
	--CombatLogQuickButtonFrame_Custom:Hide()
	--Blizzard_CombatLog_AdjustCombatLogHeight = fakeFunction
	CombatLog_AddEvent = fakeFunction
	--Blizzard_CombatLog_Refilter = fakeFunction
	--COMBATLOG:SetScript("OnEvent", nil)
	self:Minimap()

end

-- Message Limit

local COMBATLOG_MESSAGE_LIMIT = 300;

--Disable stuff
function YurrCombatLog:ADDON_LOADED(events, addonName)

	local config = self.db.profile.filters
	
	if addonName == "Blizzard_CombatLog" then
		--COMBATLOG:UnregisterEvent("COMBAT_LOG_EVENT")
		
		--CombatLogClearEntries()
		COMBATLOG:Clear()
		
		CombatLogQuickButtonFrameProgressBar = _G.CombatLogQuickButtonFrame_CustomProgressBar
		CombatLogQuickButtonFrameProgressBar:Hide()
		--self:Refilter()
		Blizzard_CombatLog_Refilter = function() self:Refilter() end
		
		FCF_DockUpdate = function() oldFCF_DockUpdate() self:ChatFrame() end
		
		
		
		self:applyFilter()
	end

end

function YurrCombatLog:Refilter()
	local count = CombatLogGetNumEntries();
	
	outputFrame:SetMaxLines(COMBATLOG_MESSAGE_LIMIT);

	-- count should be between 1 and COMBATLOG_MESSAGE_LIMIT
	count = max(1, min(count, COMBATLOG_MESSAGE_LIMIT));

	CombatLogSetCurrentEntry(0);
	
	-- Clear the combat log
	outputFrame:Clear();
	
	-- Moved setting the max value here, since we don't really need to reset the max every frame, do we?
	-- We can't add events while refiltering (:AddFilter short circuits) so this should be safe optimization.
	CombatLogQuickButtonFrameProgressBar:SetMinMaxValues(0, count);
	CombatLogQuickButtonFrameProgressBar:SetValue(0);
	CombatLogQuickButtonFrameProgressBar:Show();

	-- Enable the distributed frame
	CombatLogUpdateFrame.refiltering = true;
	CombatLogUpdateFrame:SetScript("OnUpdate", function() self:RefilterUpdate() end)
	
	self:RefilterUpdate()
end

function YurrCombatLog:RefilterUpdate()
	local valid = CombatLogGetCurrentEntry()
	
	-- Clear the combat log
	local total = 0;
	while (valid and total < COMBATLOG_LIMIT_PER_FRAME) do
		-- Log to the window
		
		local output = self:ParseEvent(arg1, CombatLogGetCurrentEntry())
		if output then
			self:AddOutput(output)
		end
		
		--local text, r, g, b, a = CombatLog_OnEvent(Blizzard_CombatLog_CurrentSettings, CombatLogGetCurrentEntry());
		-- NOTE: be sure to pass in nil for the color id or the color id may override the r, g, b values for this message
		--COMBATLOG:AddMessage( text, r, g, b, nil, true );
		
		
		valid = CombatLogAdvanceEntry(-1)
		total = total + 1;
	end
	
	CombatLogQuickButtonFrameProgressBar:SetValue(CombatLogQuickButtonFrameProgressBar:GetValue() + total);

	if ( not valid or (CombatLogQuickButtonFrameProgressBar:GetValue() >= COMBATLOG_MESSAGE_LIMIT) ) then
		CombatLogUpdateFrame.refiltering = false
		CombatLogUpdateFrame:SetScript("OnUpdate", nil)
		CombatLogQuickButtonFrameProgressBar:Hide();
	end
end

--Hook stuff
function fakeFunction()
end

function YurrCombatLog:ChatFrame(frame)

	if frame == 1 then
		frame = ChatFrame1
	elseif frame == 2 then
		frame = ChatFrame2
	elseif frame == 3 then
		frame = ChatFrame3
	elseif frame == 4 then
		frame = ChatFrame4
	elseif frame == 5 then
		frame = ChatFrame5
	elseif frame == 6 then
		frame = ChatFrame6
	elseif frame == 7 then
		frame = ChatFrame7
	end
	
	if frame == nil then
		frame = outputFrame
	end
	
	if self.db.profile.QuickButtonFrameHide == true then
		CombatLogQuickButtonFrame_Custom:Hide()
	else
		CombatLogQuickButtonFrame_Custom:Show()
		CombatLogQuickButtonFrame_Custom:SetParent(frame:GetName() .. "Tab")
		CombatLogQuickButtonFrame_Custom:ClearAllPoints();
		CombatLogQuickButtonFrame_Custom:SetPoint("TOPLEFT", frame:GetName() .. "Tab", "TOPLEFT", 0 , -34)
		CombatLogQuickButtonFrame_Custom:SetPoint("RIGHT", frame, "RIGHT", 0, 0);
		CombatLogQuickButtonFrame_Custom:SetFrameStrata("HIGH")
	end
	
	return frame

end

function YurrCombatLog:ChatCommand(input)

	if not input or input:trim() == "" then
	  LibStub("AceConfigDialog-3.0"):Open("YurrCombatLog")
	else
	  LibStub("AceConfigCmd-3.0").HandleCommand(YurrCombatLog, "ycl", "YurrCombatLog", input)
	end

end

--Converts 4 floats into FF code
function YurrCombatLog:CombatLog_Color_FloatToText(r,g,b,a)

	if ( type(r) == "table" ) then
		r, g, b, a = r.r, r.g, r.b, r.a;
	end
	a = min(1, a or 1) * 255
	r = min(1, r) * 255
	g = min(1, g) * 255
	b = min(1, b) * 255
	
	-- local fmt = "%.2x";
	return ("%.2x%.2x%.2x%.2x"):format(math_floor(a), math_floor(r), math_floor(g), math_floor(b))

end

--Color unit by flags
function YurrCombatLog:colorUnit(name, unitFlags)
	
	local unitColor
	local unitColored
	
	local colors = self.db.profile.unitColors
	
	for mask in pairs( colors ) do
		if ( CombatLog_Object_IsA (unitFlags, mask) )then
			unitColor = self:CombatLog_Color_FloatToText(colors[mask].r, colors[mask].g, colors[mask].b)
			unitColored = "|c"..unitColor..name.."|r"
			break
		end
	end
	return unitColored
	
end

function YurrCombatLog:SwingMissType(missType)

	local missed

	missed = (string.lower(missType))
	return missed

end

--Color anything via school
function YurrCombatLog:colorSpellName(school, name)

	local physical, holy, fire, nature, frost, shadow, arcane, natureshadow, newNameColored, nameColored
	local colors = self.db.profile.spellColors
	
	if type(name) == number then
		name = tostring(name)
	end

	if school == 1 then
		physical = self:CombatLog_Color_FloatToText(colors.physical.r, colors.physical.g, colors.physical.b)
		nameColored = "|c"..physical..name.."|r" --physical
	elseif school == 2 then
		holy = self:CombatLog_Color_FloatToText(colors.holy.r, colors.holy.g, colors.holy.b)
		nameColored = "|c"..holy..name.."|r" --holy
	elseif school == 4 then
		fire = self:CombatLog_Color_FloatToText(colors.fire.r, colors.fire.g, colors.fire.b)
		nameColored = "|c"..fire..name.."|r" --fire
	elseif school == 8 then
		nature = self:CombatLog_Color_FloatToText(colors.nature.r, colors.nature.g, colors.nature.b)
		nameColored = "|c"..nature..name.."|r" --nature
	elseif school == 16 then
		frost = self:CombatLog_Color_FloatToText(colors.frost.r, colors.frost.g, colors.frost.b)
		nameColored = "|c"..frost..name.."|r" --frost
	elseif school == 20 then
		frostfire = self:CombatLog_Color_FloatToText(colors.frostfire.r, colors.frostfire.g, colors.frostfire.b)
		nameColored = "|c"..frostfire..name.."|r" --frostfire
	elseif school == 32 then
		shadow = self:CombatLog_Color_FloatToText(colors.shadow.r, colors.shadow.g, colors.shadow.b)
		nameColored = "|c"..shadow..name.."|r" --shadow
	elseif school == 40 then
		natureshadow = self:CombatLog_Color_FloatToText(colors.natureshadow.r, colors.natureshadow.g, colors.natureshadow.b)
		nameColored = "|c"..natureshadow..name.."|r" --arcane 
	elseif school == 64 then
		arcane = self:CombatLog_Color_FloatToText(colors.arcane.r, colors.arcane.g, colors.arcane.b)
		nameColored = "|c"..arcane..name.."|r" --arcane 
	end
	newNameColored = nameColored
	return newNameColored

end

--Color buffs by Buff/Debuff
function YurrCombatLog:buffColoring(buffName, buffType, amount)

	local buff
	local buffNameColored
	local buffColor
	local colors = self.db.profile.otherColors
	
	if buffType == "BUFF" or buffType == nil then
		buffColor = self:CombatLog_Color_FloatToText(colors.buff.r, colors.buff.g, colors.buff.b)
		
	elseif buffType == "DEBUFF" then
		buffColor = self:CombatLog_Color_FloatToText(colors.debuff.r, colors.debuff.g, colors.debuff.b)
	end
	
	buffNameColored = "|c"..buffColor.." ++ "..buffName.."AMOUNT|r"
	
	if (amount) then
		buffNameColored = string.gsub(buffNameColored, "(AMOUNT)", "("..amount..")")
	else
		buffNameColored = string.gsub(buffNameColored, "(AMOUNT)", (""))
	end
	
	return buffNameColored

end

--Color enchants
function YurrCombatLog:EnchantColoring(enchantName, eventType)

	local enchant, enchantNameColored
	local colors = self.db.profile.otherColors

	if eventType == "ENCHANT_APPLIED" then
		enchant = self:CombatLog_Color_FloatToText(colors.skill.r, colors.skill.g, colors.skill.b)
		enchantNameColored = "|c"..enchant..enchantName.."|r"
	elseif eventType == "ENCHANT_REMOVED" then
		enchant = self:CombatLog_Color_FloatToText(colors.skill.r, colors.skill.g, colors.skill.b)
		enchantNameColored = "|c"..enchant..enchantName.."|r"
	end
	return enchantNameColored

end

--returns environmental damage types
function YurrCombatLog:EnvironmentalDamageType(environmentalType)

	if environmentalType == "DROWNING" then
		environmentalType = "drown"
	elseif environmentalType == "FALLING" then
		environmentalType = "fall"
	elseif environmentalType == "FATIGUE" then
		environmentalType = "fatigue"
	elseif environmentalType == "FIRE" then
		environmentalType = "fire"
	elseif environmentalType == "LAVA" then
		environmentalType = "lava"
	elseif environmentalType == "SLIME" then
		environmentalType = "slime"
	end
	return environmentalType

end

-- NEEDS_IMPROVEMENT
function YurrCombatLog:powerType(powerType)

	if powerType == -2 then
		powerType = HEALTH 
	elseif powerType == 0 then
		powerType = MANA
	elseif powerType == 1 then
		powerType = RAGE
	elseif powerType == 2 then
		powerType = FOCUS
	elseif powerType == 3 then
		powerType = ENERGY
	elseif powerType == 4 then
		powerType = HAPPINESS
	end

end

-- Resists, etc...
function YurrCombatLog:partialDamage(resisted, blocked, absorbed, critical, glancing, crushing)

	local partialDamage
	
	if ( resisted ) then
		resisted = "(R"..resisted..")"
	else 
		resisted = ""
	end
	if ( blocked ) then
		blocked = "(B"..blocked..")"
	else 
		blocked = ""
	end
	if ( absorbed ) then
		absorbed = "(A"..absorbed..")"
	else 
		absorbed = ""
	end
	--[[if ( critical ) then
		critical = "Crit"
	else 
		critical = ""
	end]]
	if ( glancing ) then
		glancing = "(G)"
	else 
		glancing = ""
	end
	if ( crushing ) then
		crushing = "(C)"
	else 
		crushing = ""
	end
	
	partialDamage = resisted..blocked..absorbed..glancing..crushing
	return partialDamage

end

function YurrCombatLog:COMBAT_LOG_EVENT(arg1, ...)
	local output = self:ParseEvent(arg1, ...)
	if output then
		outputFrame:AddMessage(output)
	end
end

--parse the event
function YurrCombatLog:ParseEvent(arg1, timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)

	local otherColors = self.db.profile.otherColors

	local spellId
	local spellName
	local spellSchool
	local amount
	local school
	local resisted
	local blocked
	local absorbed
	local critical
	local glancing
	local crushing
	local source
	local dest
	local spellNameColored
	local meleeName
	local amountColored
	local damageType
	local missed
	local extraSpellId
	local extraSpellName
	local extraSpellSchool
	local extraSpellNameColored
	local environmentalType
	local partialDamage
	local missType
	local powerType
	local buffColor
	local auraType
	local buffNameColored
	local failType
	local itemID
	local itemName
	local enchantNameColored
	
	local output

	--sourceNameColored = self:colorUnit(sourceName, sourceFlags)
	--destNameColored = self:colorUnit(destName, destFlags)

	if ( event == "SWING_DAMAGE" )  then
		amount, school, resisted, blocked, absorbed, critical, glancing, crushing = ...
		meleeName = self:colorSpellName(school, MELEE)
		amountColored = self:colorSpellName(school, amount)
		partialDamage = self:partialDamage(resisted, blocked, absorbed, critical, glancing, crushing)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..meleeName.." "..critical.."[DEST_NAME] "..amountColored..partialDamage
		
	elseif ( event == "SWING_MISSED" )  then
		missType = ...
		missed = self:SwingMissType(missType)
		if missed == "miss" then
			output = "[SOURCE_NAME] "..missed.." [DEST_NAME] "
		else
			output = "[DEST_NAME] "..missed.." [SOURCE_NAME] "
		end
		
	elseif ( event == "RANGE_DAMAGE" )  then
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = ...
		amountColored = self:colorSpellName(spellSchool, amount)
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		partialDamage = self:partialDamage(resisted, blocked, absorbed, critical, glancing, crushing)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical.."[DEST_NAME] "..amountColored..partialDamage
		
	elseif ( event == "RANGE_MISSED" )  then
		spellId, spellName, spellSchool, missType = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		missed = self:SwingMissType(missType)
		if missed == "miss" then
			output = "[SOURCE_NAME] "..spellNameColored.." "..missed.." [DEST_NAME]"
		else
			output = "[SOURCE_NAME] "..spellNameColored.." [DEST_NAME] "..missed
		end
		
	elseif ( event == "SPELL_DAMAGE" )  then
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = ...
		--spellNameColored = self:colorSpellName(spellSchool, spellName)
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		partialDamage = self:partialDamage(resisted, blocked, absorbed, critical, glancing, crushing)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical.."[DEST_NAME] "..amountColored..partialDamage
		
	elseif ( event == "SPELL_MISSED" )  then
		spellId, spellName, spellSchool, missType = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		missed = self:SwingMissType(missType)
		if missed == "miss" then
			output = "[SOURCE_NAME] "..spellNameColored.." "..missed.." [DEST_NAME]"
		else
			output = "[SOURCE_NAME] "..spellNameColored.." [DEST_NAME] "..missed
		end
		
	elseif ( event == "SPELL_HEAL" )  then
		spellId, spellName, spellSchool, amount, critical = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = "Crit " amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical.."[DEST_NAME] "..amountColored
		
	elseif ( event == "SPELL_ENERGIZE" )  then
		spellId, spellName, spellSchool, amount, powerType = ...
		if powerType == -2 then
			powerType = HEALTH
		elseif powerType == 0 then
			powerType = MANA
		elseif powerType == 1 then
			powerType = RAGE
		elseif powerType == 2 then
			powerType = FOCUS
		elseif powerType == 3 then
			powerType = ENERGY
		elseif powerType == 4 then
			powerType = HAPPINESS
		end
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." : [DEST_NAME] + "..amountColored.." "..powerType
		
	elseif ( event == "SPELL_PERIODIC_MISSED" )  then
		spellId, spellName, spellSchool, missType = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		missed = self:SwingMissType(missType)
		if missed == " miss " then
			output = "[SOURCE_NAME] "..spellNameColored..missed.." [DEST_NAME]"
		else
			output = "[SOURCE_NAME] "..spellNameColored.." [DEST_NAME] "..missed
		end
		
	elseif ( event == "SPELL_PERIODIC_DAMAGE" )  then
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(school, amount)
		partialDamage = self:partialDamage(resisted, blocked, absorbed, critical, glancing, crushing)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical..L["Dot"].." [DEST_NAME] ~"..amountColored.."~"..partialDamage
		
	elseif ( event == "SPELL_PERIODIC_HEAL" )  then
		spellId, spellName, spellSchool, amount, critical = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical..L["regen"].." [DEST_NAME] ~"..amountColored.."~"
		
	elseif ( event == "SPELL_PERIODIC_DRAIN" )  then
		spellId, spellName, spellSchool, amount, powerType, extraAmount = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical..L["Drain"].." [DEST_NAME] ~"..amountColored.."~"
		
	elseif ( event == "SPELL_PERIODIC_LEECH" )  then
		spellId, spellName, spellSchool, amount, powerType, extraAmount = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical..L["Leech"].." [DEST_NAME] ~"..amountColored.."~"
		
	elseif ( event == "SPELL_PERIODIC_ENERGIZE" )  then
		spellId, spellName, spellSchool, amount, powerType = ...
		if powerType == -2 then
			powerType = HEALTH
		elseif powerType == 0 then
			powerType = MANA
		elseif powerType == 1 then
			powerType = RAGE
		elseif powerType == 2 then
			powerType = FOCUS
		elseif powerType == 3 then
			powerType = ENERGY
		elseif powerType == 4 then
			powerType = HAPPINESS
		end
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." : [DEST_NAME] + "..amountColored.." "..powerType
		
	elseif ( event == "SPELL_DRAIN" )  then
		spellId, spellName, spellSchool, amount, powerType, extraAmount = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical..L["Drain"].." [DEST_NAME] "..amountColored
		
	elseif ( event == "SPELL_LEECH" )  then
		spellId, spellName, spellSchool, amount, powerType, extraAmount = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical..L["Leech"].." [DEST_NAME] "..amountColored
		
	elseif ( event == "SPELL_INTERRUPT" )  then
		spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool = ...
		buffColor = self:CombatLog_Color_FloatToText(otherColors.skill.r, otherColors.skill.g, otherColors.skill.b)
		extraSpellNameColored = self:colorSpellName(extraSpellSchool, extraSpellName)
		output = "[SOURCE_NAME] |c"..buffColor..INTERRUPT.."|r [DEST_NAME] "..extraSpellNameColored
		
	elseif ( event == "SPELL_EXTRA_ATTACKS" )  then
		spellId, spellName, spellSchool, amount = ...
		amountColored = self:colorSpellName(spellSchool, amount)
		output = "[SOURCE_NAME] "..L["+ 1 attacks"].." ("..spellName..")"
		
	elseif ( event == "SPELL_INSTAKILL" ) then
		spellId, spellName, spellSchool = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		output = "[SOURCE_NAME] "..spellNameColored.." [DEST_NAME] "
		
	elseif ( event == "SPELL_DURABILITY_DAMAGE" ) then
		spellId, spellName, spellSchool = ...
		
	elseif ( event == "SPELL_DURABILITY_DAMAGE_ALL" ) then
		spellId, spellName, spellSchool = ...
		
	elseif ( event == "SPELL_DISPEL_FAILED" )  then
		spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool = ...
		extraSpellNameColored = self:colorSpellName(extraSpellSchool, extraSpellName)
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		output = "[SOURCE_NAME] "..spellNameColored.." ("..extraSpellNameColored..") [DEST_NAME]"..FAILED
		
	elseif ( event == "SPELL_DISPEL" )  then
		spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool, auraType = ...
		extraSpellNameColored = self:colorSpellName(extraSpellSchool, extraSpellName)
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		output = "[SOURCE_NAME] "..spellNameColored.." ("..extraSpellNameColored..") [DEST_NAME]"
		
	elseif ( event == "SPELL_STOLEN" ) then
		spellId, spellName, spellSchool, extraSpellId, extraSpellName, extraSpellSchool, auraType = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		extraSpellNameColored = self:colorSpellName(extraSpellSchool, extraSpellName)
		output = "[SOURCE_NAME] "..spellNameColored.." [DEST_NAME] "..extraSpellNameColored
		
	elseif ( event == "SPELL_AURA_APPLIED" )  then
		spellId, spellName, spellSchool, auraType = ...
		--(source arguments are nil)
		buffNameColored = self:buffColoring(spellName, auraType, nil)
		output = "[DEST_NAME]"..buffNameColored
		
	elseif ( event == "SPELL_AURA_REMOVED" )  then
		spellId, spellName, spellSchool, auraType = ...
		--(source arguments are nil)
		buffColor = self:CombatLog_Color_FloatToText(otherColors.skill.r, otherColors.skill.g, otherColors.skill.b)
		output = "[DEST_NAME]".."|c"..buffColor.." -- "..spellName.."|r"
		
	elseif ( event == "SPELL_AURA_APPLIED_DOSE" )  then
		spellId, spellName, spellSchool, auraType, amount = ...
		--(source arguments are nil)
		buffNameColored = self:buffColoring(spellName, auraType, amount)
		output = "[DEST_NAME]"..buffNameColored
		
	elseif ( event == "SPELL_AURA_REMOVED_DOSE" )  then
		spellId, spellName, spellSchool, auraType, amount = ...
		--(source arguments are nil)
		buffColor = self:CombatLog_Color_FloatToText(otherColors.skill.r, otherColors.skill.g, otherColors.skill.b)
		output = "[DEST_NAME]".."|c"..buffColor.." -- "..spellName.."("..amount..")|r"
		
	elseif ( event == "SPELL_CAST_START" ) then
		spellId, spellName, spellSchool = ...
		
	elseif ( event == "SPELL_CAST_SUCCESS" ) then
		spellId, spellName, spellSchool = ...
		
	elseif ( event == "SPELL_CAST_FAILED" )  then
		spellId, spellName, spellSchool, failType = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		output = spellNameColored..L[" Fail"]..": "..failType
		
		--Special Events
	elseif ( event == "DAMAGE_SHIELD" )  then
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		amountColored = self:colorSpellName(spellSchool, amount)
		buffNameColored = self:buffColoring(spellName, auraType, amount)
		partialDamage = self:partialDamage(resisted, blocked, absorbed, critical, glancing, crushing)
		if critical == 1 then critical = L["Crit "] amountColored = "*"..amountColored.."*" else critical = "" end
		output = "[SOURCE_NAME] "..spellNameColored.." "..critical.."[DEST_NAME] "..amountColored..partialDamage
		
	elseif ( event == "DAMAGE_SPLIT" ) then
		spellId, spellName, spellSchool, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = ...
		
	elseif ( event == "DAMAGE_SHIELD_MISSED" )  then
		spellId, spellName, spellSchool, missType = ...
		spellNameColored = self:colorSpellName(spellSchool, spellName)
		missed = self:SwingMissType(missType)
		output = "[SOURCE_NAME] "..spellNameColored.." [DEST_NAME] "..missed
		
	elseif ( event == "ENCHANT_APPLIED" )  then
		spellName, itemID, itemName = ...
		enchantNameColored = self:EnchantColoring(spellName, event)
		output = L["Enchant"]..": [SOURCE_NAME] "..enchantNameColored..L[" to"].." [DEST_NAME] "..itemName
		
	elseif ( event == "ENCHANT_REMOVED" )  then
		spellName, itemID, itemName = ...
		enchantNameColored = self:EnchantColoring(spellName, event)
		output = L["Enchant"]..": [DEST_NAME] "..enchantNameColored..L[" fades from: "]..itemName
		
	elseif ( event == "PARTY_KILL" )  then
		output = "[SOURCE_NAME] "..ACTION_PARTY_KILL.." [DEST_NAME]"
		
	elseif ( event == "UNIT_DESTROYED" ) then
		output = L["Death"]..": [DEST_NAME]"
		
	elseif ( event == "UNIT_DIED" ) then
		output = L["Death"]..": [DEST_NAME]"
		
	elseif ( event == "ENVIRONMENTAL_DAMAGE" )  then
		environmentalType, amount, school, resisted, blocked, absorbed, critical, glancing, crushing = ...
		environmentalType = self:EnvironmentalDamageType(environmentalType)
		amountColored = self:colorSpellName(school, amount)
		partialDamage = self:partialDamage(resisted, blocked, absorbed, critical, glancing, crushing)
		output = "[DEST_NAME] "..environmentalType.." "..amountColored..partialDamage
	end
	
	if output then
		source = self:colorUnit(sourceName, sourceFlags)
		dest = self:colorUnit(destName, destFlags)
		
		if (source) then
			output = string.gsub(output, "(SOURCE_NAME)", source)
		else 
			output = string.gsub(output, "(SOURCE_NAME)", "N/A")
		end
		if (dest) then
			output = string.gsub(output, "(DEST_NAME)", dest)
		end
		output = string.gsub(output, (UnitName("Player")), UNIT_YOU)
	end
	
	--[[if ( output ) then
		self:AddOutput(output, timestamp, sourceName, sourceFlags, destName, destFlags)
	end]]
	output = self:AddTimestamp(output, timestamp)
	return output

end

--Add message to chatframe
function YurrCombatLog:AddOutput(output)

	local r, g, b, a = 1, 1, 1, 0
	outputFrame:AddMessage(output, r, g, b, nil, true)

end

--Experience
function YurrCombatLog:CHAT_MSG_COMBAT_XP_GAIN(event, fullexp)

	local start, stop, amount, source, totalbonus, bonus, bonustype, group, output
	local experienceEvent = self.db.profile.misc.experience
	local COMBATLOG_XPGAIN_FIRSTPERSON_UNNAMED = COMBATLOG_XPGAIN_FIRSTPERSON_UNNAMED
	local COMBATLOG_XPGAIN_FIRSTPERSON = COMBATLOG_XPGAIN_FIRSTPERSON
	local COMBATLOG_XPGAIN_EXHAUSTION1 = COMBATLOG_XPGAIN_EXHAUSTION1
	local COMBATLOG_XPGAIN_FIRSTPERSON_GROUP = COMBATLOG_XPGAIN_FIRSTPERSON_GROUP
	local COMBATLOG_XPGAIN_EXHAUSTION1_GROUP = COMBATLOG_XPGAIN_EXHAUSTION1_GROUP
	
	if( experienceEvent == true ) then
		-- Quest
		-- You gain %d experience.
		experience = string.gsub(COMBATLOG_XPGAIN_FIRSTPERSON_UNNAMED, "(%%d)", "(.+)")
		start, stop, amount = string.find(fullexp, experience)
		if (amount) then
			output = L["Exp: "]..amount
		end
		
		-- Solo
		-- %s dies, you gain %d experience.
		experience = string.gsub(string.gsub(COMBATLOG_XPGAIN_FIRSTPERSON, "(%%s)", "(.+)"), "(%%d)", "(.+)")
		start, stop, source, amount = string.find(fullexp, experience)
		if (amount) then
			if (source) then
				output = L["Exp: "]..amount.."("..source..")"
			end
		end
		
		-- Solo rested
		-- %s dies, you gain %d experience. (%s exp %s bonus)
		experience = string.gsub(string.gsub(string.gsub(string.gsub(COMBATLOG_XPGAIN_EXHAUSTION1, "(%%s)", "(.+)"), "(%%d)", "(.+)"), "(%%s)", "(.+)"), "(%%s)", "(.+)");
		start, stop, source, amount, totalbonus, bonus, bonustype = string.find(fullexp, experience);
		if (amount) then
			if (source) then
				if (bonus) then
					bonus = string.sub(bonus, string.find(bonus, "+%d+", start))
					output = L["Exp: "]..amount.."("..source..")("..bonustype..bonus..")"
				end
			end
		end
		
		-- Grouped
		-- %s dies, you gain %d experience. (+%d group bonus)
		experience = string.gsub(string.gsub(string.gsub(COMBATLOG_XPGAIN_FIRSTPERSON_GROUP, "(%%s)", "(.+)"), "(%%d)", "(.+)"), "(%%d)", "(.+)")
		start, stop, source, amount, group = string.find(fullexp, experience)
		if (amount) then
			if (source) then
				if (group) then
					group = string.sub(group, string.find(group, "%d+", start))
					output = L["Exp: "]..amount.."("..source..")("..L["G+"]..group..")"
				end
			end
		end
		
		-- Grouped rested
		-- %s dies, you gain %d experience. (%s exp %s bonus, +%d group bonus)
		experience = string.gsub(string.gsub(string.gsub(string.gsub(COMBATLOG_XPGAIN_EXHAUSTION1_GROUP, "(%%s)", "(.+)"), "(%%d)", "(.+)"), "(%%s)", "(.+)"), "(%%d)", "(.+)")
		start, stop, source, amount, totalbonus, bonus, bonustype, group = string.find(fullexp, experience)
		if (amount) then
			if (source) then
				if (bonus) then
					if (group) then
						bonus = string.sub(bonus, string.find(bonus, "+%d+", start))
						group = string.sub(group, string.find(group, "%d+", start))
						output = L["Exp: "]..amount.."("..source..")("..bonustype..bonus..")("..L["G+"]..group..")"
					end
				end
			end
		end
		output = self:AddTimestamp(output)
		outputFrame:AddMessage(output, nil)
	end

end

--Honor
function YurrCombatLog:CHAT_MSG_COMBAT_HONOR_GAIN(event, fullhonor)

	local honor, start, stop, amount, source, output, rank
	local honorEvent = self.db.profile.misc.honor
	local COMBATLOG_HONORAWARD = COMBATLOG_HONORAWARD
	local COMBATLOG_HONORGAIN = COMBATLOG_HONORGAIN

	if ( honorEvent == true ) then
		-- Honor
		-- You have been awarded %d honor points.
		honor = string.gsub(COMBATLOG_HONORAWARD, "(%%d)", "(.+)")
		start, stop, amount = string.find(fullhonor, honor)
		if (amount) then
		   output = L["Honor: "]..amount
		end
		
		-- HonorKill
		-- %s dies, honorable kill Rank: %s (%d Honor Points)
		honor = string.gsub(string.gsub(string.gsub(COMBATLOG_HONORGAIN, "(%%s)", "(.+)"), "(%%s)", "(.+)"), "(%%d)", "(.+)")
		start, stop, source, rank, _, amount = string.find(fullhonor, honor)
		if (source) then
		   if (rank) then
		      if (amount) then
		         amount = string.sub(amount, string.find(amount, "%d+", start))
		         output = L["Honor: "]..amount.." ("..rank.." "..source..")"
		      end
		   end
		end
		output = self:AddTimestamp(output)
		outputFrame:AddMessage(output, nil)
	end

end

--Reputation
function YurrCombatLog:CHAT_MSG_COMBAT_FACTION_CHANGE(event, fullrep)

	local gain, start, stop, faction, amount, output
	local factionEvent = self.db.profile.misc.faction
	local FACTION_STANDING_INCREASED = FACTION_STANDING_INCREASED
	local FACTION_STANDING_DECREASED = FACTION_STANDING_DECREASED

	if( factionEvent == true ) then
		-- Reputation with %s increased by %d.
		gain = string.gsub(string.gsub(FACTION_STANDING_INCREASED, "(%%s)", "(.+)"), "(%%d)", "(.+)")
		start, stop, faction, amount = string.find(fullrep, gain)
		if (faction) then
			if (amount) then
				output = L["Rep: "]..faction.." +"..amount
			end
		end
		
		-- Reputation with %s decreased by %d.
		gain = string.gsub(string.gsub(FACTION_STANDING_DECREASED, "(%%s)", "(.+)"), "(%%d)", "(.+)")
		start, stop, faction, amount = string.find(fullrep, gain)
		if (faction) then
			if (amount) then
				output = L["Rep: "]..faction.." -"..amount
				gain, faction, amount = nil, nil, nil
			end
		end
		output = self:AddTimestamp(output)
		outputFrame:AddMessage(output, nil)
	end

end

--Skillups
function YurrCombatLog:CHAT_MSG_SKILL(event, fullSkillup)

	local start, stop, skill, amount, skillup, output
	local skillEvent = self.db.profile.misc.skill
	local ERR_SKILL_UP_SI = ERR_SKILL_UP_SI

	if ( skillEvent == true ) then
		-- Skillup
		-- Your skill in %s has increased to %d.
		skillup = string.gsub(string.gsub(ERR_SKILL_UP_SI, "(%%s)", "(.+)"), "(%%d)", "(.+)")
		start, stop, skill, amount = string.find(fullSkillup, skillup)
		if (skill) then
			if (amount) then
				output = L["Skill: "]..skill.."("..amount..")"
				output = self:AddTimestamp(output)
				outputFrame:AddMessage(output, nil)
			end
		end
	end

end

--Combat
function YurrCombatLog:PLAYER_REGEN_ENABLED()

	local output
	local combat = self.db.profile.misc.combat
	
	if combat == true then
		output = " -- "..COMBAT
		output = self:AddTimestamp(output)
		outputFrame:AddMessage(output, nil)
	end

end
function YurrCombatLog:PLAYER_REGEN_DISABLED()

	local output
	local combat = self.db.profile.misc.combat
	
	if combat == true then
		output = " ++ "..COMBAT
		output = self:AddTimestamp(output)
		outputFrame:AddMessage(output, nil)
	end

end

function YurrCombatLog:AddTimestamp(output, timestamp)
	local output = output
	local timestamp = timestamp
	local timestampColor
	local timestampDB = self.db.profile.timestamp
	local colors = self.db.profile.otherColors
	
	if ( timestampDB == true ) then
		timestampColor = self:CombatLog_Color_FloatToText(colors.timestampColor.r, colors.timestampColor.g, colors.timestampColor.b)
		timestamp = "|c"..timestampColor..date("[%H:%M:%S]", timestamp).."|r"
		if output then
			output = timestamp..output
		end
	end
	
	return output
end

function YurrCombatLog:getColor(info)
	if info[#info-1] == "unitColors" then
		info[#info] = tonumber(info[#info])
	end
	return self.db.profile[info[#info-1]][info[#info]].r, self.db.profile[info[#info-1]][info[#info]].g, self.db.profile[info[#info-1]][info[#info]].b
end
function YurrCombatLog:setColor(info, r, g, b)
	self.db.profile[info[#info-1]][info[#info]] = { ["r"]=r, ["g"]=g, ["b"]=b }
end

function YurrCombatLog:getEvent(info)
	info[#info-2] = tonumber(info[#info-2])
	return self.db.profile.filters[info[#info-2]].filters[1].eventList[info[#info]]
end
function YurrCombatLog:setEvent(info, value)
	info[#info-2] = tonumber(info[#info-2])
	self.db.profile.filters[info[#info-2]].filters[1].eventList[info[#info]] = value
end

function YurrCombatLog:addFilter(info, value)

	tinsert(self.db.profile.filters, 
		{
			-- Descriptive Information
			name = value,
			hasQuickButton = true,
			quickButtonName = value,
			quickButtonDisplay = {
				solo = true,
				party = true,
				raid = true,
			},
			tooltip = QUICKBUTTON_NAME_SELF_TOOLTIP,

			-- Default Color and Formatting Options
			--settings = CopyTable(COMBATLOG_DEFAULT_SETTINGS)

			-- Coloring
			--settings = CopyTable(COMBATLOG_DEFAULT_SETTINGS)

			-- The actual client filters
			filters = {
				[1] = {
					eventList = {
						  ["ENVIRONMENTAL_DAMAGE"] = true,
						  ["SWING_DAMAGE"] = true,
						  ["SWING_MISSED"] = true,
						  ["RANGE_DAMAGE"] = true,
						  ["RANGE_MISSED"] = true,
						  --["SPELL_CAST_START"] = true,
						  --["SPELL_CAST_SUCCESS"] = true,
						  --["SPELL_CAST_FAILED"] = true,
						  ["SPELL_MISSED"] = true,
						  ["SPELL_DAMAGE"] = true,
						  ["SPELL_HEAL"] = true,
						  ["SPELL_ENERGIZE"] = true,
						  ["SPELL_DRAIN"] = true,
						  ["SPELL_LEECH"] = true,
						  ["SPELL_INSTAKILL"] = true,
						  ["SPELL_INTERRUPT"] = true,
						  ["SPELL_EXTRA_ATTACKS"] = true,
						  --["SPELL_DURABILITY_DAMAGE"] = true,
						  --["SPELL_DURABILITY_DAMAGE_ALL"] = true,
						  ["SPELL_AURA_APPLIED"] = true,
						  ["SPELL_AURA_APPLIED_DOSE"] = true,
						  ["SPELL_AURA_REMOVED"] = true,
						  ["SPELL_AURA_REMOVED_DOSE"] = true,
						  ["SPELL_AURA_BROKEN"] = true,
						  ["SPELL_AURA_BROKEN_SPELL"] = true,
						  ["SPELL_AURA_REFRESH"] = true,
						  ["SPELL_DISPEL"] = true,
						  ["SPELL_STOLEN"] = true,
						  ["ENCHANT_APPLIED"] = true,
						  ["ENCHANT_REMOVED"] = true,
						  ["SPELL_PERIODIC_MISSED"] = true,
						  ["SPELL_PERIODIC_DAMAGE"] = true,
						  ["SPELL_PERIODIC_HEAL"] = true,
						  ["SPELL_PERIODIC_ENERGIZE"] = true,
						  ["SPELL_PERIODIC_DRAIN"] = true,
						  ["SPELL_PERIODIC_LEECH"] = true,
						  ["SPELL_DISPEL_FAILED"] = true,
						  ["DAMAGE_SHIELD"] = true,
						  ["DAMAGE_SHIELD_MISSED"] = true,
						  --["DAMAGE_SPLIT"] = true,
						  ["PARTY_KILL"] = true,
						  ["UNIT_DIED"] = true,
						  ["UNIT_DESTROYED"] = true
					},
					sourceFlags = {
						[1297] = true,
						--[COMBATLOG_FILTER_MY_PET] = true
					},
					destFlags = nil,
					flagOptions = {
						[1] = true,
						[16] = true,
						[256] = true,
						[1024] = true,
					},
				},
				[2] = {
					eventList = {
						  --["ENVIRONMENTAL_DAMAGE"] = true,
						  ["SWING_DAMAGE"] = true,
						  ["SWING_MISSED"] = true,
						  ["RANGE_DAMAGE"] = true,
						  ["RANGE_MISSED"] = true,
						  --["SPELL_CAST_START"] = true,
						  --["SPELL_CAST_SUCCESS"] = true,
						  --["SPELL_CAST_FAILED"] = true,
						  ["SPELL_MISSED"] = true,
						  ["SPELL_DAMAGE"] = true,
						  ["SPELL_HEAL"] = true,
						  ["SPELL_ENERGIZE"] = true,
						  ["SPELL_DRAIN"] = true,
						  ["SPELL_LEECH"] = true,
						  ["SPELL_INSTAKILL"] = true,
						  ["SPELL_INTERRUPT"] = true,
						  ["SPELL_EXTRA_ATTACKS"] = true,
						  --["SPELL_DURABILITY_DAMAGE"] = true,
						  --["SPELL_DURABILITY_DAMAGE_ALL"] = true,
						  --["SPELL_AURA_APPLIED"] = true,
						  --["SPELL_AURA_APPLIED_DOSE"] = true,
						  --["SPELL_AURA_REMOVED"] = true,
						  --["SPELL_AURA_REMOVED_DOSE"] = true,
						  ["SPELL_DISPEL"] = true,
						  ["SPELL_STOLEN"] = true,
						  ["ENCHANT_APPLIED"] = true,
						  ["ENCHANT_REMOVED"] = true,
						  --["SPELL_PERIODIC_MISSED"] = true,
						  --["SPELL_PERIODIC_DAMAGE"] = true,
						  --["SPELL_PERIODIC_HEAL"] = true,
						  --["SPELL_PERIODIC_ENERGIZE"] = true,
						  --["SPELL_PERIODIC_DRAIN"] = true,
						  --["SPELL_PERIODIC_LEECH"] = true,
						  ["SPELL_DISPEL_FAILED"] = true,
						  --["DAMAGE_SHIELD"] = true,
						  --["DAMAGE_SHIELD_MISSED"] = true,
						  --["DAMAGE_SPLIT"] = true,
						  ["PARTY_KILL"] = true,
						  ["UNIT_DIED"] = true,
						  ["UNIT_DESTROYED"] = true,
					},
					sourceFlags = nil,
					destFlags = {
						[1297] = true,
						--[COMBATLOG_FILTER_MY_PET] = true,
					},
					flagOptions = {
						[1] = true,
						[16] = true,
						[256] = true,
						[1024] = true,
					},
				},
			},
		}
	)
	
	self:ParseFilters()

end

function YurrCombatLog:getMisc(info)
	return self.db.profile[info[#info-1]][info[#info]]
end
function YurrCombatLog:setMisc(info, value)
	self.db.profile[info[#info-1]][info[#info]] = value
end


function YurrCombatLog:getFlags(info)
	
	local value
	local filters = self.db.profile.filters
	info[#info-3] = tonumber(info[#info-3])
	info[#info] = tonumber(info[#info])
	
	
	if info[#info-2] == "sourceFlags" then
		return self.db.profile.filters[info[#info-3]].filters[1].flagOptions[info[#info]]
	elseif info[#info-2] == "destFlags" then
		return self.db.profile.filters[info[#info-3]].filters[2].flagOptions[info[#info]]
	end
	
end
function YurrCombatLog:setFlags(info, value)
	local filters = self.db.profile.filters
	info[#info-3] = tonumber(info[#info-3])
	info[#info] = tonumber(info[#info])
	
	if info[#info-2] == "sourceFlags" then
		self.db.profile.filters[info[#info-3]].filters[1].flagOptions[info[#info]] = value
		local sourceFlags = 0
		for k, v in pairs (filters[info[#info-3]].filters[1].flagOptions) do
			if v == true then
				sourceFlags = bit_bor(sourceFlags, k)
			end
		end
		self.db.profile.filters[info[#info-3]].filters[1].sourceFlags = {}
		self.db.profile.filters[info[#info-3]].filters[1].sourceFlags[sourceFlags] = true
	elseif info[#info-2] == "destFlags" then
		self.db.profile.filters[info[#info-3]].filters[2].flagOptions[info[#info]] = value
		local destFlags = 0
		for k, v in pairs (filters[info[#info-3]].filters[2].flagOptions) do
			if v == true then
				destFlags = bit_bor(destFlags, k)
			end
		end
		self.db.profile.filters[info[#info-3]].filters[2].destFlags = {}
		self.db.profile.filters[info[#info-3]].filters[2].destFlags[destFlags] = true
	end
end

function YurrCombatLog:applyFilter(info, value)
	local config = self.db.profile.filters
	
	if ( not config ) then
		return;
	end
	
	if info then
		local sourceFlags2 = 0
		info[#info-1] = tonumber(info[#info-1])
		for k3, v3 in pairs (config[info[#info-1]].filters[1].flagOptions) do
			if v3 == true then
				sourceFlags2 = bit_bor(sourceFlags2, k3)
			end
		end
		local destFlags2 = 0
		for k4, v4 in pairs (config[info[#info-1]].filters[2].flagOptions) do
			if v4 == true then
				destFlags2 = bit_bor(destFlags2, k4)
			end
		end
		self.db.profile.filters[info[#info-1]].filters[1].sourceFlags[sourceFlags2] = value
		self.db.profile.filters[info[#info-1]].filters[2].destFlags[destFlags2] = value
	end
	
	CombatLogResetFilter()
	
	for k in pairs (config) do
		-- Loop over all associated filters
		local eventList;
		for k1,v1 in pairs(config[k].filters) do
			local eList
			-- Only use the first filter's eventList
			eventList = config[k].filters[1].eventList;
			if ( eventList ) then
				for k2,v2 in pairs(eventList) do 
					if ( v2 == true ) then
						eList = eList and (eList .. ", " .. k2) or k2
					end
				end
			end
			
			local sourceFlags, destFlags;
			if ( v1.sourceFlags ) then
				sourceFlags = 0;
				for k2, v2 in pairs(v1.sourceFlags) do
					-- Support for GUIDs
					if ( type (k2) == "string" ) then
						sourceFlags = k2;
						break;
					end
					-- Otherwise OR bits
					if ( v2 ) then
						sourceFlags = bit_bor(sourceFlags, k2);
					end
				end
			end
			if ( v1.destFlags ) then
				destFlags = 0;
				for k2, v2 in pairs(v1.destFlags) do
					-- Support for GUIDs
					if ( type (k2) == "string" ) then
						destFlags = k2;
						break;
					end
					-- Otherwise OR bits
					if ( v2 ) then
						destFlags = bit_bor(destFlags, k2);
					end
				end
			end
			if ( type(sourceFlags) == "string" and destFlags == 0 ) then
				destFlags = nil;
			end
			if ( type(destFlags) == "string" and sourceFlags == 0 ) then
				sourceFlags = nil;
			end

			-- This is a HACK!!!  Need filters to be able to accept empty or zero sourceFlags or destFlags
			if ( sourceFlags == 0 or destFlags == 0 ) then
				CombatLogAddFilter("", COMBATLOG_FILTER_MINE, nil);
			else
				CombatLogAddFilter(eList, sourceFlags, destFlags);
			end
		end
	end
	self:Refilter()
end
function YurrCombatLog:getFilter(info)
	local config = self.db.profile.filters
	info[#info-1] = tonumber(info[#info-1])
	
	local sourceFlags2 = 0
	for k3, v3 in pairs (config[info[#info-1]].filters[1].flagOptions) do
		if v3 == true then
			sourceFlags2 = bit_bor(sourceFlags2, k3)
		end
	end
	local destFlags2 = 0
	for k4, v4 in pairs (config[info[#info-1]].filters[2].flagOptions) do
		if v4 == true then
			destFlags2 = bit_bor(destFlags2, k4)
		end
	end
	if self.db.profile.filters[info[#info-1]].filters[1].sourceFlags[sourceFlags2] == true and self.db.profile.filters[info[#info-1]].filters[2].destFlags[destFlags2] == true then
		return true
	else
		return false
	end
end


-- Copyright 2008 Copystring"