local YurrCombatLog = LibStub("AceAddon-3.0"):GetAddon("YurrCombatLog")
local L = LibStub("AceLocale-3.0"):GetLocale("YurrCombatLog")
local options

-- Make all the constants upvalues. This prevents the global environment lookup + table lookup each time we use one (and they're used a lot)
local COMBATLOG_OBJECT_AFFILIATION_MINE = COMBATLOG_OBJECT_AFFILIATION_MINE
local COMBATLOG_OBJECT_AFFILIATION_PARTY = COMBATLOG_OBJECT_AFFILIATION_PARTY
local COMBATLOG_OBJECT_AFFILIATION_RAID = COMBATLOG_OBJECT_AFFILIATION_RAID
local COMBATLOG_OBJECT_AFFILIATION_OUTSIDER = COMBATLOG_OBJECT_AFFILIATION_OUTSIDER
local COMBATLOG_OBJECT_AFFILIATION_MASK = COMBATLOG_OBJECT_AFFILIATION_MASK
local COMBATLOG_OBJECT_REACTION_FRIENDLY = COMBATLOG_OBJECT_REACTION_FRIENDLY
local COMBATLOG_OBJECT_REACTION_NEUTRAL = COMBATLOG_OBJECT_REACTION_NEUTRAL
local COMBATLOG_OBJECT_REACTION_HOSTILE = COMBATLOG_OBJECT_REACTION_HOSTILE
local COMBATLOG_OBJECT_REACTION_MASK = COMBATLOG_OBJECT_REACTION_MASK
local COMBATLOG_OBJECT_CONTROL_PLAYER = COMBATLOG_OBJECT_CONTROL_PLAYER
local COMBATLOG_OBJECT_CONTROL_NPC = COMBATLOG_OBJECT_CONTROL_NPC
local COMBATLOG_OBJECT_CONTROL_MASK = COMBATLOG_OBJECT_CONTROL_MASK
local COMBATLOG_OBJECT_TYPE_PLAYER = COMBATLOG_OBJECT_TYPE_PLAYER
local COMBATLOG_OBJECT_TYPE_NPC = COMBATLOG_OBJECT_TYPE_NPC
local COMBATLOG_OBJECT_TYPE_PET = COMBATLOG_OBJECT_TYPE_PET
local COMBATLOG_OBJECT_TYPE_GUARDIAN = COMBATLOG_OBJECT_TYPE_GUARDIAN
local COMBATLOG_OBJECT_TYPE_OBJECT = COMBATLOG_OBJECT_TYPE_OBJECT
local COMBATLOG_OBJECT_TYPE_MASK = COMBATLOG_OBJECT_TYPE_MASK
local COMBATLOG_OBJECT_TARGET = COMBATLOG_OBJECT_TARGET
local COMBATLOG_OBJECT_FOCUS = COMBATLOG_OBJECT_FOCUS
local COMBATLOG_OBJECT_MAINTANK = COMBATLOG_OBJECT_MAINTANK
local COMBATLOG_OBJECT_MAINASSIST = COMBATLOG_OBJECT_MAINASSIST
local COMBATLOG_OBJECT_RAIDTARGET1 = COMBATLOG_OBJECT_RAIDTARGET1
local COMBATLOG_OBJECT_RAIDTARGET2 = COMBATLOG_OBJECT_RAIDTARGET2
local COMBATLOG_OBJECT_RAIDTARGET3 = COMBATLOG_OBJECT_RAIDTARGET3
local COMBATLOG_OBJECT_RAIDTARGET4 = COMBATLOG_OBJECT_RAIDTARGET4
local COMBATLOG_OBJECT_RAIDTARGET5 = COMBATLOG_OBJECT_RAIDTARGET5
local COMBATLOG_OBJECT_RAIDTARGET6 = COMBATLOG_OBJECT_RAIDTARGET6
local COMBATLOG_OBJECT_RAIDTARGET7 = COMBATLOG_OBJECT_RAIDTARGET7
local COMBATLOG_OBJECT_RAIDTARGET8 = COMBATLOG_OBJECT_RAIDTARGET8
local COMBATLOG_OBJECT_NONE = COMBATLOG_OBJECT_NONE
local COMBATLOG_OBJECT_SPECIAL_MASK = COMBATLOG_OBJECT_SPECIAL_MASK
local COMBATLOG_FILTER_ME = COMBATLOG_FILTER_ME
local COMBATLOG_FILTER_MINE = COMBATLOG_FILTER_MINE
local COMBATLOG_FILTER_MY_PET = COMBATLOG_FILTER_MY_PET
local COMBATLOG_FILTER_FRIENDLY_UNITS = COMBATLOG_FILTER_FRIENDLY_UNITS
local COMBATLOG_FILTER_HOSTILE_UNITS = COMBATLOG_FILTER_HOSTILE_UNITS
local COMBATLOG_FILTER_HOSTILE_PLAYERS = COMBATLOG_FILTER_HOSTILE_PLAYERS
local COMBATLOG_FILTER_NEUTRAL_UNITS = COMBATLOG_FILTER_NEUTRAL_UNITS
local COMBATLOG_FILTER_UNKNOWN_UNITS = COMBATLOG_FILTER_UNKNOWN_UNITS
local COMBATLOG_FILTER_EVERYTHING = COMBATLOG_FILTER_EVERYTHING
local COMBATLOG = COMBATLOG
local AURA_TYPE_BUFF = AURA_TYPE_BUFF
local AURA_TYPE_DEBUFF = AURA_TYPE_DEBUFF
local SPELL_POWER_MANA = SPELL_POWER_MANA
local SPELL_POWER_RAGE = SPELL_POWER_RAGE
local SPELL_POWER_FOCUS = SPELL_POWER_FOCUS
local SPELL_POWER_ENERGY = SPELL_POWER_ENERGY
local SPELL_POWER_HAPPINESS = SPELL_POWER_HAPPINESS
local SPELL_POWER_RUNES = SPELL_POWER_RUNES
local SCHOOL_MASK_NONE = SCHOOL_MASK_NONE
local SCHOOL_MASK_PHYSICAL = SCHOOL_MASK_PHYSICAL
local SCHOOL_MASK_HOLY = SCHOOL_MASK_HOLY
local SCHOOL_MASK_FIRE = SCHOOL_MASK_FIRE
local SCHOOL_MASK_NATURE = SCHOOL_MASK_NATURE
local SCHOOL_MASK_FROST = SCHOOL_MASK_FROST
local SCHOOL_MASK_SHADOW = SCHOOL_MASK_SHADOW
local SCHOOL_MASK_ARCANE = SCHOOL_MASK_ARCANE
local COMBATLOG_LIMIT_PER_FRAME = COMBATLOG_LIMIT_PER_FRAME
local COMBATLOG_HIGHLIGHT_MULTIPLIER = COMBATLOG_HIGHLIGHT_MULTIPLIER
local COMBATLOG_DEFAULT_COLORS = COMBATLOG_DEFAULT_COLORS
local COMBATLOG_DEFAULT_SETTINGS = COMBATLOG_DEFAULT_SETTINGS
local COMBATLOG_ICON_RAIDTARGET1 = COMBATLOG_ICON_RAIDTARGET1
local COMBATLOG_ICON_RAIDTARGET2 = COMBATLOG_ICON_RAIDTARGET2
local COMBATLOG_ICON_RAIDTARGET3 = COMBATLOG_ICON_RAIDTARGET3
local COMBATLOG_ICON_RAIDTARGET4 = COMBATLOG_ICON_RAIDTARGET4
local COMBATLOG_ICON_RAIDTARGET5 = COMBATLOG_ICON_RAIDTARGET5
local COMBATLOG_ICON_RAIDTARGET6 = COMBATLOG_ICON_RAIDTARGET6
local COMBATLOG_ICON_RAIDTARGET7 = COMBATLOG_ICON_RAIDTARGET7
local COMBATLOG_ICON_RAIDTARGET8 = COMBATLOG_ICON_RAIDTARGET8
local COMBATLOG_EVENT_LIST = COMBATLOG_EVENT_LIST

local CombatLog_Object_IsA = CombatLog_Object_IsA

local defaults = {
	profile = {
		
		ChatFrame = 2,
		timestamp = true,
		QuickButtonFrameHide = true,
		
		allSource = {
			Player = true,
		},
		allDestination = {
			Player = true,
		},
		
		filters = {
			[1] = {
				-- Descriptive Information
				name = "Player",
				hasQuickButton = true,
				quickButtonName = "Player",
				quickButtonDisplay = {
					solo = true,
					party = true,
					raid = true,
				},
				tooltip = QUICKBUTTON_NAME_SELF_TOOLTIP,

				-- Default Color and Formatting Options
				--settings = CopyTable(COMBATLOG_DEFAULT_SETTINGS)

				-- Coloring
				--settings = CopyTable(COMBATLOG_DEFAULT_SETTINGS)

				-- The actual client filters
				filters = {
					[1] = {
						eventList = {
						      ["ENVIRONMENTAL_DAMAGE"] = true,
						      ["SWING_DAMAGE"] = true,
						      ["SWING_MISSED"] = true,
						      ["RANGE_DAMAGE"] = true,
						      ["RANGE_MISSED"] = true,
						      --["SPELL_CAST_START"] = true,
						      --["SPELL_CAST_SUCCESS"] = true,
						      --["SPELL_CAST_FAILED"] = true,
						      ["SPELL_MISSED"] = true,
						      ["SPELL_DAMAGE"] = true,
						      ["SPELL_HEAL"] = true,
						      ["SPELL_ENERGIZE"] = true,
						      ["SPELL_DRAIN"] = true,
						      ["SPELL_LEECH"] = true,
						      ["SPELL_INSTAKILL"] = true,
						      ["SPELL_INTERRUPT"] = true,
						      ["SPELL_EXTRA_ATTACKS"] = true,
						      --["SPELL_DURABILITY_DAMAGE"] = true,
						      --["SPELL_DURABILITY_DAMAGE_ALL"] = true,
						      ["SPELL_AURA_APPLIED"] = true,
						      ["SPELL_AURA_APPLIED_DOSE"] = true,
						      ["SPELL_AURA_REMOVED"] = true,
						      ["SPELL_AURA_REMOVED_DOSE"] = true,
						      ["SPELL_AURA_BROKEN"] = true,
							  ["SPELL_AURA_BROKEN_SPELL"] = true,
							  ["SPELL_AURA_REFRESH"] = true,
						      ["SPELL_DISPEL"] = true,
						      ["SPELL_STOLEN"] = true,
						      ["ENCHANT_APPLIED"] = true,
						      ["ENCHANT_REMOVED"] = true,
						      ["SPELL_PERIODIC_MISSED"] = true,
						      ["SPELL_PERIODIC_DAMAGE"] = true,
						      ["SPELL_PERIODIC_HEAL"] = true,
						      ["SPELL_PERIODIC_ENERGIZE"] = true,
						      ["SPELL_PERIODIC_DRAIN"] = true,
						      ["SPELL_PERIODIC_LEECH"] = true,
						      ["SPELL_DISPEL_FAILED"] = true,
						      ["DAMAGE_SHIELD"] = true,
						      ["DAMAGE_SHIELD_MISSED"] = true,
						      --["DAMAGE_SPLIT"] = true,
						      ["PARTY_KILL"] = true,
						      ["UNIT_DIED"] = true,
						      ["UNIT_DESTROYED"] = true
						},
						sourceFlags = {
							[1297] = true,
							--[COMBATLOG_FILTER_MY_PET] = true
						},
						destFlags = nil,
						flagOptions = {
							[1] = true,
							[16] = true,
							[256] = true,
							[1024] = true,
						},
					},
					[2] = {
						eventList = {
						      --["ENVIRONMENTAL_DAMAGE"] = true,
						      ["SWING_DAMAGE"] = true,
						      ["SWING_MISSED"] = true,
						      ["RANGE_DAMAGE"] = true,
						      ["RANGE_MISSED"] = true,
						      --["SPELL_CAST_START"] = true,
						      --["SPELL_CAST_SUCCESS"] = true,
						      --["SPELL_CAST_FAILED"] = true,
						      ["SPELL_MISSED"] = true,
						      ["SPELL_DAMAGE"] = true,
						      ["SPELL_HEAL"] = true,
						      ["SPELL_ENERGIZE"] = true,
						      ["SPELL_DRAIN"] = true,
						      ["SPELL_LEECH"] = true,
						      ["SPELL_INSTAKILL"] = true,
						      ["SPELL_INTERRUPT"] = true,
						      ["SPELL_EXTRA_ATTACKS"] = true,
						      --["SPELL_DURABILITY_DAMAGE"] = true,
						      --["SPELL_DURABILITY_DAMAGE_ALL"] = true,
						      --["SPELL_AURA_APPLIED"] = true,
						      --["SPELL_AURA_APPLIED_DOSE"] = true,
						      --["SPELL_AURA_REMOVED"] = true,
						      --["SPELL_AURA_REMOVED_DOSE"] = true,
						      ["SPELL_DISPEL"] = true,
						      ["SPELL_STOLEN"] = true,
						      ["ENCHANT_APPLIED"] = true,
						      ["ENCHANT_REMOVED"] = true,
						      --["SPELL_PERIODIC_MISSED"] = true,
						      --["SPELL_PERIODIC_DAMAGE"] = true,
						      --["SPELL_PERIODIC_HEAL"] = true,
						      --["SPELL_PERIODIC_ENERGIZE"] = true,
						      --["SPELL_PERIODIC_DRAIN"] = true,
						      --["SPELL_PERIODIC_LEECH"] = true,
						      ["SPELL_DISPEL_FAILED"] = true,
						      --["DAMAGE_SHIELD"] = true,
						      --["DAMAGE_SHIELD_MISSED"] = true,
						      --["DAMAGE_SPLIT"] = true,
						      ["PARTY_KILL"] = true,
						      ["UNIT_DIED"] = true,
						      ["UNIT_DESTROYED"] = true,
						},
						sourceFlags = nil,
						destFlags = {
							[1297] = true,
							--[COMBATLOG_FILTER_MY_PET] = true,
						},
						flagOptions = {
							[1] = true,
							[16] = true,
							[256] = true,
							[1024] = true,
						},
					},
				},
			},
			[2] = {
				["quickButtonName"] = "Outsider",
				["name"] = "Outsider",
				["hasQuickButton"] = true,
				["tooltip"] = "Show messages of actions done by you and done to you.",
				["quickButtonDisplay"] = {
					["party"] = true,
					["solo"] = true,
					["raid"] = true,
				},
				["filters"] = {
					{
						["eventList"] = {
							["SPELL_PERIODIC_MISSED"] = true,
							["SPELL_INTERRUPT"] = true,
							["UNIT_DESTROYED"] = true,
							["DAMAGE_SHIELD_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["SPELL_AURA_BROKEN"] = true,
							["UNIT_DIED"] = true,
							["SPELL_PERIODIC_ENERGIZE"] = true,
							["SPELL_INSTAKILL"] = true,
							["SPELL_PERIODIC_DAMAGE"] = true,
							["SPELL_PERIODIC_HEAL"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_DAMAGE"] = true,
							["ENVIRONMENTAL_DAMAGE"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SWING_MISSED"] = true,
							["SPELL_AURA_REFRESH"] = true,
							["DAMAGE_SHIELD"] = true,
							["SPELL_AURA_REMOVED_DOSE"] = true,
							["SPELL_PERIODIC_LEECH"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_AURA_APPLIED_DOSE"] = true,
							["SPELL_AURA_REMOVED"] = true,
							["SWING_DAMAGE"] = true,
							["SPELL_AURA_BROKEN_SPELL"] = true,
							["ENCHANT_APPLIED"] = true,
							["RANGE_MISSED"] = true,
							["SPELL_HEAL"] = true,
							["ENCHANT_REMOVED"] = true,
							["SPELL_AURA_APPLIED"] = true,
							["SPELL_PERIODIC_DRAIN"] = true,
							["SPELL_DRAIN"] = true,
						},
						["sourceFlags"] = {
							[1304] = false,
						},
						["flagOptions"] = {
							false, -- [1]
							[256] = true,
							[8] = true,
							[1024] = true,
							[16] = true,
						},
					}, -- [1]
					{
						["eventList"] = {
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SPELL_INTERRUPT"] = true,
							["SWING_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["UNIT_DIED"] = true,
							["ENCHANT_APPLIED"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_INSTAKILL"] = true,
							["UNIT_DESTROYED"] = true,
							["SWING_DAMAGE"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_MISSED"] = true,
							["RANGE_DAMAGE"] = true,
							["ENCHANT_REMOVED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_DRAIN"] = true,
						},
						["destFlags"] = {
							[1304] = false,
						},
						["flagOptions"] = {
							false, -- [1]
							[256] = true,
							[8] = true,
							[1024] = true,
							[16] = true,
						},
					}, -- [2]
				},
			}, -- [2]
			[3] = {
				["quickButtonName"] = "Raid",
				["name"] = "Raid",
				["hasQuickButton"] = true,
				["tooltip"] = "Show messages of actions done by you and done to you.",
				["quickButtonDisplay"] = {
					["party"] = true,
					["solo"] = true,
					["raid"] = true,
				},
				["filters"] = {
					{
						["flagOptions"] = {
							false, -- [1]
							[256] = true,
							[4] = true,
							[1024] = true,
							[16] = true,
						},
						["sourceFlags"] = {
							[1300] = false,
						},
						["eventList"] = {
							["SPELL_PERIODIC_MISSED"] = true,
							["SPELL_INTERRUPT"] = true,
							["UNIT_DESTROYED"] = true,
							["DAMAGE_SHIELD_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["SPELL_AURA_BROKEN"] = true,
							["UNIT_DIED"] = true,
							["SPELL_PERIODIC_ENERGIZE"] = true,
							["SPELL_INSTAKILL"] = true,
							["SPELL_PERIODIC_DAMAGE"] = true,
							["SPELL_PERIODIC_HEAL"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_DAMAGE"] = true,
							["ENVIRONMENTAL_DAMAGE"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SWING_MISSED"] = true,
							["SPELL_AURA_REFRESH"] = true,
							["DAMAGE_SHIELD"] = true,
							["SPELL_AURA_REMOVED_DOSE"] = true,
							["SPELL_PERIODIC_LEECH"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_AURA_APPLIED"] = true,
							["ENCHANT_REMOVED"] = true,
							["SWING_DAMAGE"] = true,
							["SPELL_AURA_BROKEN_SPELL"] = true,
							["ENCHANT_APPLIED"] = true,
							["RANGE_MISSED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_AURA_REMOVED"] = true,
							["SPELL_AURA_APPLIED_DOSE"] = true,
							["SPELL_PERIODIC_DRAIN"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [1]
					{
						["flagOptions"] = {
							false, -- [1]
							[256] = true,
							[4] = true,
							[1024] = true,
							[16] = true,
						},
						["destFlags"] = {
							[1300] = false,
						},
						["eventList"] = {
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SPELL_INTERRUPT"] = true,
							["SWING_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["UNIT_DIED"] = true,
							["ENCHANT_APPLIED"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_INSTAKILL"] = true,
							["UNIT_DESTROYED"] = true,
							["SWING_DAMAGE"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_MISSED"] = true,
							["RANGE_DAMAGE"] = true,
							["ENCHANT_REMOVED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [2]
				},
			}, -- [3]
			[4] = {
				["quickButtonName"] = "Pet",
				["name"] = "Pet",
				["hasQuickButton"] = true,
				["tooltip"] = "Show messages of actions done by you and done to you.",
				["quickButtonDisplay"] = {
					["party"] = true,
					["solo"] = true,
					["raid"] = true,
				},
				["filters"] = {
					{
						["flagOptions"] = {
							true, -- [1]
							[256] = true,
							[4096] = true,
							[1024] = false,
							[16] = true,
						},
						["sourceFlags"] = {
							[4369] = false,
						},
						["eventList"] = {
							["SPELL_PERIODIC_MISSED"] = true,
							["SPELL_INTERRUPT"] = true,
							["UNIT_DESTROYED"] = true,
							["DAMAGE_SHIELD_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["SPELL_AURA_BROKEN"] = true,
							["UNIT_DIED"] = true,
							["SPELL_PERIODIC_ENERGIZE"] = true,
							["SPELL_INSTAKILL"] = true,
							["SPELL_PERIODIC_DAMAGE"] = true,
							["SPELL_PERIODIC_HEAL"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_DAMAGE"] = true,
							["ENVIRONMENTAL_DAMAGE"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SWING_MISSED"] = true,
							["SPELL_AURA_REFRESH"] = true,
							["DAMAGE_SHIELD"] = true,
							["SPELL_AURA_REMOVED_DOSE"] = true,
							["SPELL_PERIODIC_LEECH"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_AURA_APPLIED"] = true,
							["ENCHANT_REMOVED"] = true,
							["SWING_DAMAGE"] = true,
							["SPELL_AURA_BROKEN_SPELL"] = true,
							["ENCHANT_APPLIED"] = true,
							["RANGE_MISSED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_AURA_REMOVED"] = true,
							["SPELL_AURA_APPLIED_DOSE"] = true,
							["SPELL_PERIODIC_DRAIN"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [1]
					{
						["flagOptions"] = {
							true, -- [1]
							[256] = true,
							[4096] = true,
							[1024] = false,
							[16] = true,
						},
						["destFlags"] = {
							[4369] = false,
						},
						["eventList"] = {
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SPELL_INTERRUPT"] = true,
							["SWING_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["UNIT_DIED"] = true,
							["ENCHANT_APPLIED"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_INSTAKILL"] = true,
							["UNIT_DESTROYED"] = true,
							["SWING_DAMAGE"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_MISSED"] = true,
							["RANGE_DAMAGE"] = true,
							["ENCHANT_REMOVED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [2]
				},
			}, -- [4]
			[5] = {
				["quickButtonName"] = "Party",
				["name"] = "Party",
				["hasQuickButton"] = true,
				["tooltip"] = "Show messages of actions done by you and done to you.",
				["quickButtonDisplay"] = {
					["party"] = true,
					["solo"] = true,
					["raid"] = true,
				},
				["filters"] = {
					{
						["flagOptions"] = {
							false, -- [1]
							true, -- [2]
							nil, -- [3]
							false, -- [4]
							[256] = true,
							[16] = true,
							[1024] = true,
						},
						["sourceFlags"] = {
							[1298] = false,
						},
						["eventList"] = {
							["SPELL_PERIODIC_MISSED"] = true,
							["SPELL_INTERRUPT"] = true,
							["UNIT_DESTROYED"] = true,
							["DAMAGE_SHIELD_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["SPELL_AURA_BROKEN"] = true,
							["UNIT_DIED"] = true,
							["SPELL_PERIODIC_ENERGIZE"] = true,
							["SPELL_INSTAKILL"] = true,
							["SPELL_PERIODIC_DAMAGE"] = true,
							["SPELL_PERIODIC_HEAL"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_DAMAGE"] = true,
							["ENVIRONMENTAL_DAMAGE"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SWING_MISSED"] = true,
							["SPELL_AURA_REFRESH"] = true,
							["DAMAGE_SHIELD"] = true,
							["SPELL_AURA_REMOVED_DOSE"] = true,
							["SPELL_PERIODIC_LEECH"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_AURA_APPLIED"] = true,
							["ENCHANT_REMOVED"] = true,
							["SWING_DAMAGE"] = true,
							["SPELL_AURA_BROKEN_SPELL"] = true,
							["ENCHANT_APPLIED"] = true,
							["RANGE_MISSED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_AURA_REMOVED"] = true,
							["SPELL_AURA_APPLIED_DOSE"] = true,
							["SPELL_PERIODIC_DRAIN"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [1]
					{
						["flagOptions"] = {
							false, -- [1]
							true, -- [2]
							[256] = true,
							[1024] = true,
							[16] = true,
						},
						["destFlags"] = {
							[1298] = false,
						},
						["eventList"] = {
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SPELL_INTERRUPT"] = true,
							["SWING_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["UNIT_DIED"] = true,
							["ENCHANT_APPLIED"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_INSTAKILL"] = true,
							["UNIT_DESTROYED"] = true,
							["SWING_DAMAGE"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_MISSED"] = true,
							["RANGE_DAMAGE"] = true,
							["ENCHANT_REMOVED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [2]
				},
			}, -- [5]
			[6] = {
				["quickButtonName"] = "Enemy",
				["name"] = "Enemy",
				["hasQuickButton"] = true,
				["tooltip"] = "Show messages of actions done by you and done to you.",
				["quickButtonDisplay"] = {
					["party"] = true,
					["solo"] = true,
					["raid"] = true,
				},
				["filters"] = {
					{
						["flagOptions"] = {
							false, -- [1]
							[32] = true,
							[1024] = true,
							[512] = true,
							[16384] = true,
							[8] = true,
							[8192] = true,
							[2048] = true,
							[256] = true,
							[64] = true,
							[4096] = true,
							[16] = false,
						},
						["sourceFlags"] = {
							[32616] = false,
						},
						["eventList"] = {
							["SPELL_PERIODIC_MISSED"] = true,
							["SPELL_INTERRUPT"] = true,
							["UNIT_DESTROYED"] = true,
							["DAMAGE_SHIELD_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["SPELL_AURA_BROKEN"] = true,
							["UNIT_DIED"] = true,
							["SPELL_PERIODIC_ENERGIZE"] = true,
							["SPELL_INSTAKILL"] = true,
							["SPELL_PERIODIC_DAMAGE"] = true,
							["SPELL_PERIODIC_HEAL"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_DAMAGE"] = true,
							["ENVIRONMENTAL_DAMAGE"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SWING_MISSED"] = true,
							["SPELL_AURA_REFRESH"] = true,
							["DAMAGE_SHIELD"] = true,
							["SPELL_AURA_REMOVED_DOSE"] = true,
							["SPELL_PERIODIC_LEECH"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_AURA_APPLIED"] = true,
							["ENCHANT_REMOVED"] = true,
							["SWING_DAMAGE"] = true,
							["SPELL_AURA_BROKEN_SPELL"] = true,
							["ENCHANT_APPLIED"] = true,
							["RANGE_MISSED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_AURA_REMOVED"] = true,
							["SPELL_AURA_APPLIED_DOSE"] = true,
							["SPELL_PERIODIC_DRAIN"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [1]
					{
						["flagOptions"] = {
							false, -- [1]
							[32] = true,
							[1024] = true,
							[512] = true,
							[16384] = true,
							[8] = true,
							[8192] = true,
							[4096] = true,
							[256] = true,
							[64] = true,
							[2048] = true,
							[16] = false,
						},
						["destFlags"] = {
							[32616] = false,
						},
						["eventList"] = {
							["SPELL_EXTRA_ATTACKS"] = true,
							["SPELL_MISSED"] = true,
							["SPELL_STOLEN"] = true,
							["SPELL_ENERGIZE"] = true,
							["SPELL_INTERRUPT"] = true,
							["SWING_MISSED"] = true,
							["SPELL_LEECH"] = true,
							["UNIT_DIED"] = true,
							["ENCHANT_APPLIED"] = true,
							["SPELL_DISPEL_FAILED"] = true,
							["SPELL_INSTAKILL"] = true,
							["UNIT_DESTROYED"] = true,
							["SWING_DAMAGE"] = true,
							["PARTY_KILL"] = true,
							["SPELL_DAMAGE"] = true,
							["RANGE_MISSED"] = true,
							["RANGE_DAMAGE"] = true,
							["ENCHANT_REMOVED"] = true,
							["SPELL_HEAL"] = true,
							["SPELL_DISPEL"] = true,
							["SPELL_DRAIN"] = true,
						},
					}, -- [2]
				},
			}, -- [6]
		},
		
		enabledFilters = {
		},
		
		flags = {
			sourceFlags = {
				Player = {

				},
				Outsider = {
					["256"] = "256",
					["64"] = "64",
					["4096"] = "4096",
					["1024"] = "1024",
					["8"] = "8",
					["512"] = "512",
					["8192"] = "8192",
					["16"] = "16",
					["2048"] = "2048",
					["16384"] = "16384",
					["32"] = "32",
				},
				Guardian = {
					["1"] = "1",
					["16"] = "16",
					["8192"] = "8192",
					["64"] = "64",
					["256"] = "256",
					["32"] = "32",
				},
				Focus = {
					["131072"] = "131072",
				},
				Target = {
					["65536"] = "65536",
				},
				Raid = {
					["1024"] = "1024",
					["16"] = "16",
					["256"] = "256",
					["4"] = "4",
					["64"] = "64",
					["32"] = "32",
				},
				Pet = {
					["1"] = "1",
					["4096"] = "4096",
					["16"] = "16",
					["64"] = "64",
					["256"] = "256",
					["32"] = "32",
				},
				Party = {
					["1024"] = "1024",
					["16"] = "16",
					["2"] = "2",
					["64"] = "64",
					["256"] = "256",
					["32"] = "32",
				},
				
			},
			destFlags = {
				Player = {
					["1"] = "1",
					["16"] = "16",
					["256"] = "256",
					["1024"] = "1024",
				},
				Outsider = {
					["256"] = "256",
					["64"] = "64",
					["16"] = "16",
					["1024"] = "1024",
					["8"] = "8",
					["512"] = "512",
					["8192"] = "8192",
					["4096"] = "4096",
					["2048"] = "2048",
					["16384"] = "16384",
					["32"] = "32",
				},
				Guardian = {
					["1"] = "1",
					["16"] = "16",
					["8192"] = "8192",
					["64"] = "64",
					["256"] = "256",
					["32"] = "32",
				},
				Focus = {
					["131072"] = "131072",
				},
				Target = {
					["65536"] = "65536",
				},
				Raid = {
					["1024"] = "1024",
					["16"] = "16",
					["256"] = "256",
					["4"] = "4",
					["64"] = "64",
					["32"] = "32",
				},
				Pet = {
					["1"] = "1",
					["4096"] = "4096",
					["16"] = "16",
					["64"] = "64",
					["256"] = "256",
					["32"] = "32",
				},
				Party = {
					["1024"] = "1024",
					["16"] = "16",
					["2"] = "2",
					["64"] = "64",
					["256"] = "256",
					["32"] = "32",
				},
			},
		},
		
		misc = {
			experience = true,
			faction = true,
			skill = true,
			honor = true,
		},
		
		watches = {
		},
		
		unitColors = {
			[1297] = { -- Player
				["r"] = 0.50,
				["g"] = 0.50,
				["b"] = 1.00,
			},
			[4983] = { -- Pet
				["r"] = 0.50,
				["g"] = 0.30,
				["b"] = 0.15,
			},
			[1396] = { -- Raid
				["r"] = 1.00,
				["g"] = 0.44,
				["b"] = 0.20,
			},
			[1394] = { -- Party
				["r"] = 0.65,
				["g"] = 1.00,
				["b"] = 0.65,
			},
			-- Target
			--[[[65536] = { 
				["r"] = 1.00,
				["g"] = 0.46,
				["b"] = 1.00,
			},]]
			[32584] = { -- Enemy
				["r"] = 1.00,
				["g"] = 0.46,
				["b"] = 1.00,
			},
			[8467] = { -- Guardian
				["r"] = 0.25,
				["g"] = 0.25,
				["b"] = 0.50,
			},
			[131072] = { -- Focus
				["r"] = 0.80,
				["g"] = 0.33,
				["b"] = 0.85,
			},
			[32632] = { -- Outsider
				["r"] = 1.00,
				["g"] = 1.00,
				["b"] = 1.00,
			},
		},
		spellColors = {
			physical = {
				["r"] = 1.00,
				["g"] = 1.00,
				["b"] = 1.00,
			},
			holy = {
				["r"] = 1.00,
				["g"] = 1.00,
				["b"] = 0.30,
			},
			fire = {
				["r"] = 1.00,
				["g"] = 0.15,
				["b"] = 0.18,
			},
			nature = {
				["r"] = 0.40,
				["g"] = 1.00,
				["b"] = 0.40,
			},
			frost = {
				["r"] = 0.30,
				["g"] = 0.30,
				["b"] = 0.90,
			},
			shadow = {
				["r"] = 1.00,
				["g"] = 0.70,
				["b"] = 1.00,
			},
			arcane = {
				["r"] = 0.75,
				["g"] = 0.75,
				["b"] = 0.75,
			},
			natureshadow = {
				["r"] = 0.70,
				["g"] = 0.85,
				["b"] = 0.70,
			},
			frostfire = {
				["r"] = 0.65,
				["g"] = 0.23,
				["b"] = 0.59,
			},
		},
		otherColors = {
			heal = {
				["r"] = 1.00,
				["g"] = 1.00,
				["b"] = 0.30,
			},
			miss = {
				["r"] = 1.00,
				["g"] = 0.5,
				["b"] = 0.5,
			},
			buff = {
				["r"] = 0.20,
				["g"] = 1.00,
				["b"] = 0.20,
			},
			debuff = {
				["r"] = 1.00,
				["g"] = 0.20,
				["b"] = 0.20,
			},
			skill = {
				["r"] = 1.00,
				["g"] = 1.00,
				["b"] = 0.4,
			},
			timestampColor = {
				r = 0.45,
				g = 0.45,
				b = 0.45,
			},
		},
		
		miniMap = {
			dragable = true,
			angle = 282,
			radius = 80,
			rounding = 10,
			Hidden = false
		}
	}
}

function YurrCombatLog:Config()

	self.db = LibStub("AceDB-3.0"):New("YurrCombatLogDB", defaults, "Default")
	self:CreateConfig()
	LibStub("AceConfig-3.0"):RegisterOptionsTable("YurrCombatLog", options)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("YurrCombatLog", "YurrCombatLog")
	options.args.profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	self:ParseFilters()

end

function YurrCombatLog:CreateConfig()
	options = {
		type = "group",
		name = "YurrCombatLog",
		childGroups = "tree",
		handler = YurrCombatLog,
		args = {
			general = {
				type = "group",
				name = "General",
				order = 1,
				--inline = true,
				args = {
					chatFrame = {
						type = "select",
						name = L["ChatFrame"],
						desc = "Select where you want your CombatLog output.",
						values = { "ChatFrame1", "ChatFrame2", "ChatFrame3", "ChatFrame4", "ChatFrame5", "ChatFrame6", "ChatFrame7" },
						order = 1,
						get = function()
							return self.db.profile.ChatFrame
						end,
						set = function(info, value)
							outputFrame:Clear() -- Clear old outputFrame
							outputFrame = self:ChatFrame(value)
							self:Refilter()
							self.db.profile.ChatFrame = value
						end,
					},
					QuickButtonFrameHide = {
						type = "toggle",
						name = "Hide QuickButtonFrame",
						order = 2,
						get = function()
							return self.db.profile.QuickButtonFrameHide
						end,
						set = function(info, value)
							self.db.profile.QuickButtonFrameHide = value
							self:ChatFrame()
						end,
					},
					timestamp = {
						type = "toggle",
						name = "Timestamp",
						order = 3,
						get = function()
							return self.db.profile.timestamp
						end,
						set = function(info, value)
							self.db.profile.timestamp = value
						end,
					},
					timestampColor = {
						type = "color",
						name = "Timestamp Color",
						order = 4,
						get = function(info)
							return
							self.db.profile.otherColors.timestampColor.r, 
							self.db.profile.otherColors.timestampColor.g, 
							self.db.profile.otherColors.timestampColor.b
						end,
						set = function(info, r, g, b)
							self.db.profile.otherColors.timestampColor = { ["r"]=r, ["g"]=g, ["b"]=b }
						end,
					},
				},
			},
			filters = {
			type = "group",
			order = 2,
			name = L["Filters"],
				args = {
					newFilter = {
						type = "input",
						order = 1,
						name = L["newFilter"],
						get = function()
							return
						end,
						set = "addFilter",
					},
					
				},
			},
			misc = {
				type = "group",
				order = 3,
				name = L["Events"],
				args = {
					misc = {
						type = "group",
						name = L["Events"],
						order = 1,
						inline = true,
						args = {
							experience = {
								type = "toggle",
								order = 1,
								name = COMBAT_XP_GAIN,
								set = "setMisc",
								get = "getMisc",
							},
							combat = {
								type = "toggle",
								order = 1,
								name = COMBAT,
								get = function()
								return self.db.profile.misc.combat
							end,
							set = function(info, value)
								self.db.profile.misc.combat = value
							end,
							},
							faction = {
								type = "toggle",
								order = 1,
								name = FACTION,
								get = function()
								return self.db.profile.misc.faction
							end,
							set = function(info, value)
								self.db.profile.misc.faction = value
							end,
							},
							skill = {
								type = "toggle",
								order = 1,
								name = L["Skill"],
								get = function()
								return self.db.profile.misc.skill
							end,
							set = function(info, value)
								self.db.profile.misc.skill = value
							end,
							},
							honor = {
								type = "toggle",
								order = 1,
								name = L["Honor"],
								get = function()
								return self.db.profile.misc.honor
							end,
							set = function(info, value)
								self.db.profile.misc.honor = value
							end,
							},
						},
					},
				},
			},
			colors = {
			type = "group",
			name = L["Colors"],
			order = 4,
				args = {
					unitColors = {
					type = "group",
					name = L["Unit Colors"],
					inline = true,
					order = 1,
						args = {
							["1297"] = { -- Player
								type = "color",
								name = PLAYER,
								set = "setColor",
								get = "getColor",
								order = 1,
							},
							["4983"] = { -- Pet
								type = "color",
								name = PET,
								set = "setColor",
								get = "getColor",
								order = 2,
							},
							["1396"] = { -- Raid
								type = "color",
								name = RAID,
								set = "setColor",
								get = "getColor",
								order = 3,
							},
							["1394"] = { -- Party
								type = "color",
								name = PARTY,
								set = "setColor",
								get = "getColor",
								order = 4,
							},
							-- Target
							--[[["65536"] = { 
								type = "color",
								name = TARGET,
								set = "setColor",
								get = "getColor",
								order = 5,
							},]]
							["32584"] = { -- Enemy
								type = "color",
								name = L["Enemy"],
								set = "setColor",
								get = "getColor",
								order = 5,
							},
							["8467"] = { -- Guardian
								type = "color",
								name = L["Guardian"],
								set = "setColor",
								get = "getColor",
								order = 6,
							},
							["131072"] = { -- Focus
								type = "color",
								name = FOCUS,
								set = "setColor",
								get = "getColor",
								order = 7,
							},
							["32632"] = { -- Outsider
								type = "color",
								name = L["Outsider"],
								set = "setColor",
								get = "getColor",
								order = 8,
							},
						}
					},
					spellColors = {
					type = "group",
					name = L["Spell Colors"],
					inline = true,
					order = 2,
						args = {
							physical = {
								type = "color",
								name = L["Physical"],
								set = "setColor",
								get = "getColor",
								order = 1,
							},
							holy = {
								type = "color",
								name = L["Holy"],
								set = "setColor",
								get = "getColor",
								order = 2,
							},
							fire = {
								type = "color",
								name = L["Fire"],
								set = "setColor",
								get = "getColor",
								order = 3,
							},
							nature = {
								type = "color",
								name = L["Nature"],
								set = "setColor",
								get = "getColor",
								order = 4,
							},
							frost = {
								type = "color",
								name = L["Frost"],
								set = "setColor",
								get = "getColor",
								order = 5,
							},
							shadow = {
								type = "color",
								name = L["Shadow"],
								set = "setColor",
								get = "getColor",
								order = 6,
							},
							arcane = {
								type = "color",
								name = L["Arcane"],
								set = "setColor",
								get = "getColor",
								order = 7,
							},
							natureshadow = {
								type = "color",
								name = L["Nature+shadow"],
								set = "setColor",
								get = "getColor",
								order = 8,
							},
							frostfire = {
								type = "color",
								name = L["Frost+Fire"],
								set = "setColor",
								get = "getColor",
								order = 9,
							},
						}
					},
					otherColors = {
					type = "group",
					name = L["Other Colors"],
					inline = true,
					order = 3,
						args = {
							heal = {
								type = "color",
								name = L["Heal"],
								set = "setColor",
								get = "getColor",
								order = 1,
							},
							miss = {
								type = "color",
								name = MISS,
								set = "setColor",
								get = "getColor",
								order = 2,
							},
							buff = {
								type = "color",
								name = L["Buff"],
								set = "setColor",
								get = "getColor",
								order = 3,
							},
							debuff = {
								type = "color",
								name = L["Debuff"],
								set = "setColor",
								get = "getColor",
								order = 4,
							},
							skill = {
								type = "color",
								name = L["Skill"],
								set = "setColor",
								get = "getColor",
								order = 5,
							},
						}
					}
				}
			},
	--[[		format = {
				order = 5,
			},]]
	--[[		watches = {
				type = "group",
				name = L["Watches"],
				order = 6,
				args = {
					watches = {
						type = "group",
						name = L["Watches"],
						order = 1,
						inline = true,
						args = {
							addName = {
							type = "input",
							name = L["addName"],
							order = 1,
							set = function(info, value) self.db.profile.watches[value] = value
							end,
							get = function() end,
							},
							refilter = {
								type = "execute",
								name = L["Refilter"],
								width = "half",
								order = 2,
								func = function() self:Refilter() end,
							},
							removeName = {
							type = "input",
							name = L["removeName"],
							order = 3,
							set = function(info, value) self.db.profile.watches[value] = nil
							end,
							get = function() end,
							},
							listnames = {
							type = "header",
							name = function()
								local newvalue = ""
								for key,value in pairs(self.db.profile.watches) do newvalue = value..", "..newvalue end
								return newvalue
							end,
							order = 4,
							},
						},
					},
				},
			},]]
			minimap = {
				type = "group",
				name = L["Minimap Options"],
				order = 7,
				args = {
					minimap = {
						type = "group",
						name = L["Minimap Options"],
						order = 1,
						inline = true,
						args = {
							hideIcon = {
								type = "toggle",
								name = L["Hide minimap icon"],
								desc = L["Hide minimap icon"],
								width = "full",
								order = 1,
								get = function(info) 
									return self.db.profile.miniMap.Hidden
								end,
								set = function(info, value)
									self.db.profile.miniMap.Hidden = value
									if ( self.db.profile.miniMap.Hidden == true ) then
										self:HideMinimap()
									elseif ( self.db.profile.miniMap.Hidden == false ) then
										self:ShowMinimap()
									end
								end,
							},
							radius = {
								type = "range",
								name = L["Radius"],
								min = 0,
								max = 160,
								step = 1,
								order = 2,
								get = function() return self.db.profile.miniMap.radius end,
								set = function(info, value)
									self.db.profile.miniMap.radius = value
									self:MinimapUpdatePosition()
								end,
							},
							angle = {
								type = "range",
								name = L["Angle"],
								min = 0,
								max = 360,
								step = 1,
								order = 3,
								get = function() return self.db.profile.miniMap.angle end,
								set = function(info, value)
									self.db.profile.miniMap.angle = value
									self:MinimapUpdatePosition()
								end,
							},
						},
					},
				},
			},
		}
	}
end

function YurrCombatLog:ParseFilters()
	
	local COMBATLOG_OBJECT_AFFILIATION_MINE = tostring(COMBATLOG_OBJECT_AFFILIATION_MINE)
	local COMBATLOG_OBJECT_AFFILIATION_PARTY = tostring(COMBATLOG_OBJECT_AFFILIATION_PARTY)
	local COMBATLOG_OBJECT_AFFILIATION_RAID = tostring(COMBATLOG_OBJECT_AFFILIATION_RAID)
	local COMBATLOG_OBJECT_AFFILIATION_OUTSIDER = tostring(COMBATLOG_OBJECT_AFFILIATION_OUTSIDER)
	local COMBATLOG_OBJECT_REACTION_FRIENDLY = tostring(COMBATLOG_OBJECT_REACTION_FRIENDLY)
	local COMBATLOG_OBJECT_REACTION_NEUTRAL = tostring(COMBATLOG_OBJECT_REACTION_NEUTRAL)
	local COMBATLOG_OBJECT_REACTION_HOSTILE = tostring(COMBATLOG_OBJECT_REACTION_HOSTILE)
	local COMBATLOG_OBJECT_CONTROL_PLAYER = tostring(COMBATLOG_OBJECT_CONTROL_PLAYER)
	local COMBATLOG_OBJECT_CONTROL_NPC = tostring(COMBATLOG_OBJECT_CONTROL_NPC)
	local COMBATLOG_OBJECT_TYPE_PLAYER = tostring(COMBATLOG_OBJECT_TYPE_PLAYER)
	local COMBATLOG_OBJECT_TYPE_NPC = tostring(COMBATLOG_OBJECT_TYPE_NPC)
	local COMBATLOG_OBJECT_TYPE_PET = tostring(COMBATLOG_OBJECT_TYPE_PET)
	local COMBATLOG_OBJECT_TYPE_GUARDIAN = tostring(COMBATLOG_OBJECT_TYPE_GUARDIAN)
	local COMBATLOG_OBJECT_TYPE_OBJECT = tostring(COMBATLOG_OBJECT_TYPE_OBJECT)
	local COMBATLOG_OBJECT_TARGET = tostring(COMBATLOG_OBJECT_TARGET)
	local COMBATLOG_OBJECT_FOCUS = tostring(COMBATLOG_OBJECT_FOCUS)

	
	local filters = self.db.profile.filters
	for key in pairs(filters) do
		local filterName = filters[key].name
		local keyString = tostring(key)
		if filterName then
			options.args.filters.args[keyString] = {
				type = "group",
				name = filterName,
				childGroups = "tab",
				args = {
					[filterName] = {
						type = "header",
						name = L["Filters for "]..filterName,
						order = 1,
					},
					events = {
						type = "group",
						name = L["Event"],
						order = 2,
						args = {
							all = {
								type = "toggle",
								name = L["All"],
								order = 1,
								width = "full",
								set = function(info, value)
									local events = self.db.profile.filters.events
									for key in pairs (events[info[#info-2]]) do
										self.db.profile.filters.events[info[#info-2]][key] = value
									end
									self.db.profile.allSource[info[#info-2]] = value
								end,
								get = function(info) return self.db.profile.allSource[info[#info-2]] end
							},
							SWING_DAMAGE = {
								type = "toggle",
								name = L["Melee Damage"],
								--desc = "["..UNIT_YOU.."] "..MELEE.." "..L["Crit "].."["..EXAMPLE_TARGET_MONSTER.."] 80".."(B20)",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SWING_MISSED = {
								type = "toggle",
								name = L["Melee Missed"],
								--desc = "["..UNIT_YOU.."] "..MISS.." ["..EXAMPLE_TARGET_MONSTER.."]",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							RANGE_DAMAGE = {
								type = "toggle",
								name = L["Ranged Damage"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(2764).." "..L["Crit "].."["..EXAMPLE_TARGET_MONSTER.."] 80".."(B20)",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							RANGE_MISSED = {
								type = "toggle",
								name = L["Ranged Missed"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(2764).." "..MISS.." ["..EXAMPLE_TARGET_MONSTER.."]",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_DAMAGE = {
								type = "toggle",
								name = L["Spelldamage"],
								--desc = "["..UNIT_YOU.."] "..EXAMPLE_SPELL_FROSTBOLT.." "..L["Crit "].."["..EXAMPLE_TARGET_MONSTER.."] 80".."(R20)",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_MISSED = {
								type = "toggle",
								name = RESIST,
								--desc = "["..UNIT_YOU.."] "..EXAMPLE_SPELL_FROSTBOLT.." ["..EXAMPLE_TARGET_MONSTER.."] "..MISS,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_HEAL = {
								type = "toggle",
								name = SHOW_COMBAT_HEALING,
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(2053).." "..L["Crit "].."["..UNIT_YOU.."] 80",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_ENERGIZE = {
								type = "toggle",
								name = L["Energize"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(27222).." : ["..UNIT_YOU.."] + ".."80".." "..MANA,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_PERIODIC_MISSED = {
								type = "toggle",
								name = L["Resist(periodic)"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(11671).." ["..EXAMPLE_TARGET_MONSTER.."] "..RESIST,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_PERIODIC_DAMAGE = {
								type = "toggle",
								name = L["Spelldamage(periodic)"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(11671).." "..L["Dot"].." ["..EXAMPLE_TARGET_MONSTER.."] ~80~(R20)",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_PERIODIC_HEAL = {
								type = "toggle",
								name = L["Heals(periodic)"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(25222).." "..L["regen"].." ["..UNIT_YOU.."] ~80~",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_PERIODIC_DRAIN = {
								type = "toggle",
								name = L["Drains(periodic)"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(27220).." "..L["Drain"].." ["..EXAMPLE_TARGET_MONSTER.."] ~80~",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_PERIODIC_LEECH = {
								type = "toggle",
								name = L["Leech(periodic)"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(30908).." "..L["Leech"].." ["..EXAMPLE_TARGET_MONSTER.."] ~80~",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_PERIODIC_ENERGIZE = {
								type = "toggle",
								name = L["Energize(periodic)"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(34914).." : ["..UNIT_YOU.."] + 80".." "..MANA,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_DRAIN = {
								type = "toggle",
								name = DRAINS,
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(28734).." "..L["Drain"].." ["..UNIT_YOU.."] 80",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_LEECH = {
								type = "toggle",
								name = L["Leech"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(30908).." "..L["Leech"].." ["..UNIT_YOU.."] 80",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_INTERRUPT = {
								type = "toggle",
								name = INTERRUPTS,
								--desc = "["..UNIT_YOU.."] "..INTERRUPT.." ["..EXAMPLE_TARGET_MONSTER.."] "..EXAMPLE_SPELL_FROSTBOLT,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_EXTRA_ATTACKS = {
								type = "toggle",
								name = EXTRA_ATTACKS,
								--desc = "["..UNIT_YOU.."] "..L["+ 1 attacks"].." ("..GetSpellInfo(16459)..")",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							--SPELL_INSTAKILL
							--SPELL_DURABILITY_DAMAGE
							--SPELL_DURABILITY_DAMAGE_ALL
							SPELL_DISPEL = {
								type = "toggle",
								name = DISPELS,
								--desc = "["..UNIT_YOU.."] "..L["dispel "]..GetSpellInfo(31651).." ["..UNIT_YOU.."]",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_DISPEL_FAILED = {
								type = "toggle",
								name = DISPELS.." ("..FAILED..")",
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(475).." ("..GetSpellInfo(31651)..") ["..UNIT_YOU.."] "..FAILED,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_STOLEN = {
								type = "toggle",
								name = L["Spellstolen"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(30449).." ["..EXAMPLE_TARGET_MONSTER.."] "..GetSpellInfo(35917),
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_AURA_APPLIED = {
								type = "toggle",
								name = L["Buffs and Debuffs"],
								--desc = "["..UNIT_YOU.."] ++ "..GetSpellInfo(27127),
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_AURA_REMOVED = {
								type = "toggle",
								name = L["Buffs/Debuffs removed"],
								--desc = "["..UNIT_YOU.."] -- "..GetSpellInfo(27127),
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_AURA_APPLIED_DOSE = {
								type = "toggle",
								name = L["Buffs/Debuffs (stacking)"],
								--desc = "["..UNIT_YOU.."] ++ "..GetSpellInfo(30451),
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							SPELL_AURA_REMOVED_DOSE = {
								type = "toggle",
								name = L["Buffs/Debuffs removed (stacking)"],
								--desc = "["..UNIT_YOU.."] -- "..GetSpellInfo(30451),
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							--SPELL_CAST_START
							--SPELL_CAST_SUCCESS
							SPELL_CAST_FAILED = {
								type = "toggle",
								name = FAILED,
								--desc = GetSpellInfo(11294)..L[" Fail"]..": "..ERR_OUT_OF_ENERGY,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							DAMAGE_SHIELD = {
								type = "toggle",
								name = DAMAGE_SHIELD,
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(27150).." ".."["..EXAMPLE_TARGET_MONSTER.."] 80(R20)",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							--DAMAGE_SPLIT
							DAMAGE_SHIELD_MISSED = {
								type = "toggle",
								name = L["Damage Shield resist"],
								--desc = "["..UNIT_YOU.."] "..GetSpellInfo(27150).." ["..EXAMPLE_TARGET_MONSTER.."] "..RESIST,
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							ENCHANT_APPLIED = {
								type = "toggle",
								name = L["Enchant applied"],
								--desc = L["Enchant"]..": ["..UNIT_YOU.."] "..GetSpellInfo(28019)..L[" to"].." ["..UNIT_YOU.."] "..L["Fang of the Leviathan"],
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							ENCHANT_REMOVED = {
								type = "toggle",
								name = L["Enchant removed"],
								--desc = L["Enchant"]..": ["..UNIT_YOU.."] "..GetSpellInfo(28019)..L[" fades from: "]..L["Fang of the Leviathan"],
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							PARTY_KILL = {
								type = "toggle",
								name = L["Party/Raid kills"],
								--desc = "["..UNIT_YOU.."] "..ACTION_PARTY_KILL.." ["..EXAMPLE_TARGET_MONSTER.."]",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							--UNIT_DESTROYED
							UNIT_DIED = {
								type = "toggle",
								name = DEATHS,
								--desc = L["Death"]..": ["..UNIT_YOU.."]",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
							ENVIRONMENTAL_DAMAGE = {
								type = "toggle",
								name = ENVIRONMENTAL_DAMAGE,
								--desc = "["..UNIT_YOU.."] "..L["Fire"].." 80",
								order = 1,
								set = "setEvent",
								get = "getEvent",
							},
						},
					},
					sourceFlags = {
						type = "group",
						name = L["Done by"],
						order = 4,
						args = {
							affiliation = {
								type = "group",
								name = L["Affiliation"],
								inline = true,
								order = 1,
								args = {
									[COMBATLOG_OBJECT_AFFILIATION_MINE] = {
										type = "toggle",
										name = "Player",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_AFFILIATION_PARTY] = {
										type = "toggle",
										name = "Party",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_AFFILIATION_RAID] = {
										type = "toggle",
										name = "Raid",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_AFFILIATION_OUTSIDER] = {
										type = "toggle",
										name = "Outsider",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							reaction = {
								type = "group",
								name = L["Reaction"],
								inline = true,
								order = 2,
								args = {
									[COMBATLOG_OBJECT_REACTION_FRIENDLY] = {
										type = "toggle",
										name = "Friendly",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_REACTION_NEUTRAL] = {
										type = "toggle",
										name = "Neutral",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_REACTION_HOSTILE] = {
										type = "toggle",
										name = "Hostile",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							Ownership = {
								type = "group",
								name = L["Ownership"],
								inline = true,
								order = 3,
								args = {
									[COMBATLOG_OBJECT_CONTROL_PLAYER] = {
										type = "toggle",
										name = "Player",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_CONTROL_NPC] = {
										type = "toggle",
										name = "NPC",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							Unittype = {
								type = "group",
								name = L["Unit type"],
								inline = true,
								order = 4,
								args = {
									[COMBATLOG_OBJECT_TYPE_PLAYER] = {
										type = "toggle",
										name = "Player",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_NPC] = {
										type = "toggle",
										name = "NPC",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_PET] = {
										type = "toggle",
										name = "Pet",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_GUARDIAN] = {
										type = "toggle",
										name = "Guardian",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_OBJECT] = {
										type = "toggle",
										name = "Object",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							Special = {
								type = "group",
								name = L["Special flags"],
								inline = true,
								order = 5,
								args = {
									[COMBATLOG_OBJECT_TARGET] = {
										type = "toggle",
										name = "Target",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_FOCUS] = {
										type = "toggle",
										name = "Focus",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
						},
					},
					destFlags = {
						type = "group",
						name = L["Done to"],
						order = 4,
						args = {
							affiliation = {
								type = "group",
								name = L["Affiliation"],
								inline = true,
								order = 1,
								args = {
									[COMBATLOG_OBJECT_AFFILIATION_MINE] = {
										type = "toggle",
										name = "Player",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_AFFILIATION_PARTY] = {
										type = "toggle",
										name = "Party",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_AFFILIATION_RAID] = {
										type = "toggle",
										name = "Raid",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_AFFILIATION_OUTSIDER] = {
										type = "toggle",
										name = "Outsider",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							reaction = {
								type = "group",
								name = L["Reaction"],
								inline = true,
								order = 2,
								args = {
									[COMBATLOG_OBJECT_REACTION_FRIENDLY] = {
										type = "toggle",
										name = "Friendly",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_REACTION_NEUTRAL] = {
										type = "toggle",
										name = "Neutral",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_REACTION_HOSTILE] = {
										type = "toggle",
										name = "Hostile",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							Ownership = {
								type = "group",
								name = L["Ownership"],
								inline = true,
								order = 3,
								args = {
									[COMBATLOG_OBJECT_CONTROL_PLAYER] = {
										type = "toggle",
										name = "Player",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_CONTROL_NPC] = {
										type = "toggle",
										name = "NPC",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							Unittype = {
								type = "group",
								name = L["Unit type"],
								inline = true,
								order = 4,
								args = {
									[COMBATLOG_OBJECT_TYPE_PLAYER] = {
										type = "toggle",
										name = "Player",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_NPC] = {
										type = "toggle",
										name = "NPC",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_PET] = {
										type = "toggle",
										name = "Pet",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_GUARDIAN] = {
										type = "toggle",
										name = "Guardian",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_TYPE_OBJECT] = {
										type = "toggle",
										name = "Object",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
							Special = {
								type = "group",
								name = L["Special flags"],
								inline = true,
								order = 5,
								args = {
									[COMBATLOG_OBJECT_TARGET] = {
										type = "toggle",
										name = "Target",
										set = "setFlags",
										get = "getFlags",
									},
									[COMBATLOG_OBJECT_FOCUS] = {
										type = "toggle",
										name = "Focus",
										set = "setFlags",
										get = "getFlags",
									},
								},
							},
						},
					},
					toggle = {
						type = "toggle",
						name = L["Toggle Filter"],
						order = 5,
						set = "applyFilter",
						get = "getFilter",
					},
					refilter = {
						type = "execute",
						name = L["Refilter"],
						order = 6,
						width = "half",
						func = function() self:Refilter() self:applyFilter() end,
					},
					removeFilter = {
						type = "execute",
						name = L["Remove this Filter"],
						order = 7,
						func = function(info)
							options.args.filters.args[info[#info-1]] = nil
							info[#info-1] = tonumber(info[#info-1])
							self.db.profile.filters[info[#info-1]] = nil
						end,
					}
				}
			}
		end
	end
end
