﻿--===================================================================================================================--
-- Name:        YouWereKilledBy
-- Version:     1.0
-- Description: YouWereKilledBy simply displays the player who landed the killing blow on you in the Blizzard ErrorFrame.
-- Author:      Lifetapt @ Alterac Mountains / lifetapt@gmail.com
--===================================================================================================================--

YWKB = CreateFrame("MessageFrame","YWKB", UIParent)

YWKB_VERSION = "1.0"

--Default Settings==================>
YWKB_Prefs = {}

--Detection Variables=================>
local lastDamager = "Unknown";
local lastDamagerTime = 0;

function YWKB:OnEvent(event)

  if (event == "COMBAT_LOG_EVENT_UNFILTERED") then
    local bit_band = _G.bit.band
    if bit_band(arg5, 0x548) == 0x548 then
      hostileSource = true;
      if arg7 == UnitName("player") then  --if the destination of the combat log event is the player, then store the attacker's name.
        lastDamagerTime = GetTime();
        lastDamager = arg4
      end
    end
    bit_band = nil;
    
  elseif (event == "PLAYER_DEAD") then
    if lastDamager ~= "Unknown" and lastDamager ~= nil then
      self:AddMessage(string.format(YWKB_YWKB, lastDamager), 1.0, 0.1, 0.1, 1.0)
    end
  end

end

function YWKB:OnUpdate()  
  
  if lastDamager ~= "Unknown" then
    if (GetTime() - lastDamagerTime) > 8 then
      lastDamagerTime = 0;
      lastDamager = "Unknown";
    end
  end
  
end

YWKB:RegisterEvent("PLAYER_DEAD");
YWKB:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
YWKB:SetScript("OnEvent", YWKB.OnEvent)
YWKB:SetScript("OnUpdate", YWKB.OnUpdate)
YWKB:SetFrameStrata("HIGH")
YWKB:SetWidth(512)
YWKB:SetHeight(60)
YWKB:SetPoint("TOP",0,-80)
YWKB:SetInsertMode("TOP")
YWKB:SetTimeVisible(4)
YWKB:SetFadeDuration(0.5)
YWKB:SetFont("Fonts\\FRIZQT__.TTF", 19, "OUTLINE")
YWKB:Show()

YWKB:AddMessage("YWKB Loaded.")
