-- YouFail.lua by Stabbarella of Silver Hand
-- Developed by Randomaddon, also known as Letter of the Velen realm.
-- Timer concept from CT_BuffMod, modified to meta class by Stabbarella
-- 1.1.1 : Now triggers on death
-- 1.1.2 : Don't trigger in bgs
-- 1.3   : Supports preferences via the 2.4 Interface->Addons UI


local YouFail_VERSION = "You Fail! 1.3"
local YouFail_SIGNON = YouFail_VERSION.." loaded."

local animationTimer = nil;

YouFailTimer = {timeLeft = 0, timerMethod = nil}

local localEnabled;
local localBattleGroundsEnabled;

-- Timer function to count down from self.timeLeft to 0.  When 0 is reached, call function self.timerMethod
function YouFailTimer:tick(elapsed)
	local timeLeft = self.timeLeft - elapsed;
	if (self.timeLeft <= 0) then
		self:timerMethod();
	else
		self.timeLeft = timeLeft;
	end
end

function YouFailTimer:new(o)
	o = o or {}   -- create object if user does not provide one
	setmetatable(o, self)
	self.__index = self
	return o
end

function YouFail_AnimateStep1(self)	
	if (not localEnabled) then
	 return;
	end
	YouFailFrame:SetScale(2);
	YouFailStamper:Show();
	--PlaySoundFile("Interface\\Addons\\YouFail\\YouFail1.wav");
	animationTimer = YouFailTimer:new{timeLeft = 0.1, timerMethod=YouFail_AnimateStep2One};
end

function YouFail_AnimateStep2One(self)
	YouFailFrame:SetScale(1.5);
	animationTimer = YouFailTimer:new{timeLeft = 0.1, timerMethod=YouFail_AnimateStep2};
end

function YouFail_AnimateStep2(self)
	YouFailFrame:SetScale(1);
	PlaySoundFile("Interface\\Addons\\YouFail\\YouFail.wav");
	animationTimer = YouFailTimer:new{timeLeft = 0.4, timerMethod=YouFail_AnimateStep3};
end

function YouFail_AnimateStep3(self)
	YouFailStamper:Hide();
	YouFailStamp:Show();
	--YouFailFrame:SetScale(3);
	--PlaySoundFile("Interface\\Addons\\YouFail\\YouFail4.wav");
	animationTimer = YouFailTimer:new{timeLeft = 2, timerMethod=YouFail_AnimateStep4};
end

function YouFail_AnimateStep4(self)
	YouFailStamp:Hide();
	animationTimer = nil; -- ick global
end

function YouFail_Player_Is_In_Battlefield()
	local status, mapName, instanceID, minlevel, maxlevel, teamSize;
	for i=1, MAX_BATTLEFIELD_QUEUES do
 		status, mapName, instanceID, minlevel, maxlevel, teamSize = GetBattlefieldStatus(i);
		if (status == "active") then
			return true;
		end
	end
	return false;
end
		


-- When the AddOn loads...
function YouFail_OnLoad(self)
	-- Register the game events neccesary for our functionality
	self:RegisterEvent("ADDON_LOADED");		-- Our saved variable (total cash accumulated).
	self:RegisterEvent("PLAYER_ENTERING_WORLD");	
	self:RegisterEvent("CHAT_MSG_PARTY");
	self:RegisterEvent("CHAT_MSG_CHANNEL");
	self:RegisterEvent("PLAYER_DEAD");
end



-- Based upon our registered events, we want different things to happen when each event occurs.
function YouFail_OnEvent(self, event, ...)
	if (YouFail_Player_Is_In_Battlefield() == true) then
		if (not localBattleGroundsEnabled) or (not localEnabled) then
			return;
		end
	end

	-- This displays our total cash accumulation in the main chat window, and updates that value in our frame.
	if ( event == "ADDON_LOADED" ) then
		local addon = select(1, ...);
		if ( addon == "YouFail" ) then
			DEFAULT_CHAT_FRAME:AddMessage(YouFail_SIGNON);
		end
		return;
	end
	
	if ( event == "CHAT_MSG_PARTY") then
		local msg = string.lower(select(1, ...));
		if (string.find(msg, "you fail") ~= nil) then
			YouFail_AnimateStep1(self);
		end
	end

	if ( event == "CHAT_MSG_CHANNEL") then
		local msg = string.lower(select(1, ...));
		if (string.find(msg, "you fail") ~= nil) then
			YouFail_AnimateStep1(self);
		end
	end

	if ( event == "CHAT_MSG_CHANNEL") then
		local msg = string.lower(select(1, ...));
		if (string.find(msg, "Epic Fail") ~= nil) then
			YouFail_AnimateStep1(self);
		end
	end

	if ( event == "CHAT_MSG_CHANNEL") then
		local msg = string.lower(select(1, ...));
		if (string.find(msg, "you fail") ~= nil) then
			YouFail_AnimateStep1(self);
		end
	end
	
	if ( event == "PLAYER_DEAD") then
		YouFail_AnimateStep1(self);
	end
	
	-- This sets a variable to track the player's current money, so we can calculate against that.
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		return;
	end
end

-- Function for our time-based animation.
function YouFail_OnUpdate(self, elapsed)
	if ( not animationTimer ) then
		return;
	end
	
	animationTimer:tick(elapsed);	
end

----------------------------------- OPTIONS

function YouFailOptionsFrame_OnLoad(frame)
 	frame.name = "You Fail!";
	frame.okay = YouFailOptionsSaveVariables;
	frame.cancel = YouFailOptionsCancel;

	InterfaceOptions_AddCategory(frame);
  	
	frame:RegisterEvent("VARIABLES_LOADED"); -- eventually will call OnEvent
end

-- OnEvent
function YouFailOptionsFrame_OnEvent()
	-- VARIABLES_LOADED event
	if ( event == "VARIABLES_LOADED" ) then
		-- execute event code in this function
		YouFailOptionsFrame_VARIABLES_LOADED();
	end
end


function YouFailOptionsFrame_VARIABLES_LOADED()
	-- Here is where we default our preferences; Yukky.  This should only be called when the saved variables file is missing
	if ( not YouFail_Preferences ) then 
		YouFail_Preferences = {enabled = 1, enabledInBattleGrounds = 1};
	end
	
	YouFailOptionsCopyPreferencesToLocals();
	
	YouFailOptionsFrameEnabledText:SetText("Enabled");
	YouFailOptionsFrameBattleGroundsText:SetText("in battlegrounds");
	YouFailOptionsSetupButtons();
end

function YouFailOptionsSaveVariables()
	YouFailOptionsCopyLocalsToPreferences();
end

function YouFailOptionsCancel()
	YouFailOptionsCopyPreferencesToLocals();
	YouFailOptionsSetupButtons();	
end

-- Enabled checkbox checked
function YouFailOptionsEnabledClicked(self)
	localEnabled = YouFailOptionsFrameEnabled:GetChecked();
	YouFailOptionsSetupButtons();
end

-- Enabled checkbox checked
function YouFailOptionsBattleGroundsEnabledClicked(self)
	localBattleGroundsEnabled = YouFailOptionsFrameBattleGrounds:GetChecked();
end

function YouFailOptionsCopyPreferencesToLocals()
	localEnabled = YouFail_Preferences.enabled;
	localBattleGroundsEnabled = YouFail_Preferences.battleGroundsEnabled;
end

function YouFailOptionsCopyLocalsToPreferences()
	YouFail_Preferences.enabled = localEnabled;
	YouFail_Preferences.battleGroundsEnabled = localBattleGroundsEnabled;
end

function YouFailOptionsSetupButtons()
	if (localEnabled) then
		YouFailOptionsFrameBattleGrounds:Enable();
	else
		YouFailOptionsFrameBattleGrounds:Disable();
	end

	YouFailOptionsFrameEnabled:SetChecked(localEnabled);
	YouFailOptionsFrameBattleGrounds:SetChecked(localBattleGroundsEnabled);

end