if select(2, UnitClass('player')) ~= "SHAMAN" then
	return
end
local _G = getfenv(0);
local dewdrop = AceLibrary("Dewdrop-2.0");
local tablet = AceLibrary("Tablet-2.0");
local L = AceLibrary("AceLocale-2.2"):new("Yata");
---------------------
-- Options Support --
---------------------


function Yata:InitOptions()
	local options = {
		type="group",
		args = {
			totembar = {
				name = L["Totembar"],
				desc = L["Totembar configuration"],
				type = "group",
				args = {
					lock = {
						name = L["Lock the frame"],
						desc = L["Lock the frame"],
						type = "toggle",
						get = function() return self.db.profile.Locked end,
						set = function(v)
							self.db.profile.Locked = v;
							if(self.IsInitialized) then
								if(v) then
									self.TotemBar.Header.Frame.Texture:Hide();
								else
									self.TotemBar.Header.Frame.Texture:Show();
								end
								self.TotemBar:SaveConfig();
							end
						end,
						disabled = function() return InCombatLockdown() end,
					},
					buttonlock = {
						name = L["Button Lock"],
						type = "toggle",
						desc = L["Button Lock"],
						get = function() return self.db.profile.ButtonLocked end,
						set = function(v)
							self.db.profile.ButtonLocked = v;
							if(self.IsInitialized) then
								self.TotemBar:SetupSwap(v);
								self:EditMacro();
							end
						end,
						disabled = function() return InCombatLockdown() end,
					},
					scale = {
						name = L["Button Scale"],
						desc = L["Scale the buttons"],
						type = "range",
						get = function() return self.db.profile.ButtonScale end,
						set = function(v)
							self.db.profile.ButtonScale = v;
							if(self.IsInitialized) then
								self.TotemBar.Header.Frame:SetScale(self.db.profile.ButtonScale);
								self.TotemBar:SaveConfig();
							end
						end,
						min = 0.5,
						max = 1.5,
						step = 0.01,
						bigStep = 0.05,
						disabled = function() return InCombatLockdown() end,
					},
					popupscale = {
						name = L["Popup Button Scale"],
						desc = L["Scale the popup buttons"],
						type = "range",
						get = function() return self.db.profile.PopupButtonScale end,
						set = function(v)
							self.db.profile.PopupButtonScale = v;
							if(self.IsInitialized) then
								for k,b in self.TotemBar:TotemButtons() do
									if(b.ButtonID > 10) then
										b.Frame:SetScale(self.db.profile.PopupButtonScale);
									end
								end
								self.TotemBar:SaveConfig();
							end
						end,
						min = 0.5,
						max = 1.0,
						step = 0.01,
						bigStep = 0.05,
						disabled = function() return InCombatLockdown() end,
					},
					invertbar = {
						name = L["Invert popup direction"],
						desc = L["Invert popup direction"],
						type = "toggle",
						get = function() return self.db.profile.InvertBar end,
						set = function(v)
							self.db.profile.InvertBar = v;
							if(self.IsInitialized) then
								self.TotemBar:SetStyle(self.db.profile.ButtonStyle);
								self.TotemBar:SaveConfig();
							end
						end,
						disabled = function() return InCombatLockdown() end,
					},
					verticalbar =
					{
						name = L["Vertical bar direction"],
						desc = L["Vertical bar direction"],
						type = "toggle",
						get = function() return self.db.profile.VerticalBar end,
						set = function(v)
							self.db.profile.VerticalBar = v;
							if(self.IsInitialized) then
								self.TotemBar:SetStyle(self.db.profile.ButtonStyle);
								self.TotemBar:SaveConfig();
							end
						end,
						disabled = function() return InCombatLockdown() end,
					},
					style = {
						name = L["Button Style"],
						desc = L["Button Style"],
						type = "group",
						args = {
						},
						disabled = function() return InCombatLockdown() end,
					},
					macroreset = {
						name = L["Set Macro Reset Key"],
						desc = L["Set Macro Reset Key"],
						type = "text",
						validate = {"alt","shift","ctrl"};
						get = function()
							return self.db.profile.MacroResetKey;
						end,
						set = function(k)
							if k == nil then
								self.db.profile.MacroResetKey = "shift";
							else
								self.db.profile.MacroResetKey = k;
								self:EditMacro();
							end
						end,
						disabled = function() return InCombatLockdown() end,
					},
					alltotemcooldowns = {
					    name = L["All Totem Cooldowns"],
					    desc = L["All Totem Cooldowns"],
					    type = "toggle",
						get = function() return self.db.profile.AllTotemCooldowns end,
						set = function(v)
							self.db.profile.AllTotemCooldowns = v;
						end,
						disabled = function() return InCombatLockdown() end,
					},
				},
				disabled = function() return InCombatLockdown() end,
			},
			tooltips = {
				name = L["Tooltips"],
				desc = L["Tooltip configuration"],
				type = "group",
				args = {
					showtooltip = {
						name = L["Show Tooltip"],
						type = "toggle",
						desc = L["Show Tooltip"],
						get = function() return self.db.profile.ShowTooltip end,
						set = function(v)
							self.db.profile.ShowTooltip = v;
							self.db.profile.ShowTTOOC = v;
							if(self.IsInitialized) then
								self.TotemBar:SaveConfig();
							end
						end,
					},
					showooconly = {
						name = L["Out of combat only"],
						type = "toggle",
						desc = L["Out of combat only"],
						get = function() return self.db.profile.ShowTTOOC end,
						set = function(v)
							self.db.profile.ShowTTOOC = v;
							if(self.IsInitialized) then
								self.TotemBar:SaveConfig();
							end
						end,
					},
					shorttooltip = {
						name = L["Show short tooltip"],
						type = "toggle",
						desc = L["Show short tooltip"],
						get = function() return self.db.profile.ShortTooltip end,
						set = function(v)
							self.db.profile.ShortTooltip = v;
							if(self.IsInitialized) then
								self.TotemBar:SaveConfig();
							end
						end,
					},
				},
				disabled = function() return InCombatLockdown() end,
			},
			totemsets = {
				name = L["Totemsets"],
				desc = L["Totemsets"],
				type = "group",
				args = {
					header = {
						type = "header",
						name = L["No active Set"],
						order = 1,
					},
					addset = {
						name = L["Add"],
						desc = L["Add"],
						type = "execute",
						func = function()
							self.TotemBar.EditSet = true;
							self.TotemBar:SetupSwap(nil);
							self.TotemBar:SaveConfig();
							self.db.profile.ButtonLocked = false;
							StaticPopup_Show("YataAddSet");
						end,
					},
					loadset = {
						name = L["Load"],
						desc = L["Load Set"],
						type = "group",
						args = {},
						disabled = function() return next(Yata.options.args.totemsets.args.loadset.args) == nil end
					},
					deleteset = {
						name = L["Delete"],
						desc = L["Delete Set"],
						type = "group",
						args = {},
						disabled = function() return next(Yata.options.args.totemsets.args.deleteset.args) == nil end
					},
					reset = {
						name = L["Switch to default layout"],
						desc = L["Switch to default layout"],
						type = "execute",
						func = function()
							self.TotemBar:ResetSet();
						end,
					},
				},
				disabled = function() return InCombatLockdown() end,
			},
			keybindings = {
				name = L["Keybindings"],
				desc = L["Keybindings"],
				type = "group",
				args = {},
				disabled = function() return InCombatLockdown() end,
			},
			totemtimers = {
				name = L["Totem Timers"],
				desc = L["Totem Timers"],
				type = "group",
				args = {},
				disabled = function() return InCombatLockdown() end,
			},
			reload = {
				name = L["Reload Yata"],
				desc = L["Reload Yata"],
				type = "execute",
				func = function()
					self:Reload();
				end,
				disabled = function() return InCombatLockdown() end,
			},
		}
	};
	self:InitDialogs();
	self:InitStyles(options);
	Yata.OnMenuRequest = options;
	return options;
end

function Yata:InitStyles(input)
	local options =  input.args.totembar.args.style.args;
	for k,v in pairs(Yata.Styles) do
		local stylename = v.Name;
		options[stylename] =
		{
			name = stylename,
			desc = stylename,
			type = "toggle",
			get = function()
				return (self.db.profile.ButtonStyle == stylename) or (not self.db.profile.ButtonStyle and stylename == "Default");
			end,
			set = function()
				if(self.IsInitialized) then
					self.TotemBar:SetStyle(stylename);
				end
			end,
			isRadio = true,
			disabled = function() return InCombatLockdown() end,
		};
	end
end


-- Originally found in Closetgnome by Rabbit
function Yata:InitDialogs()
	if not StaticPopupDialogs then
		StaticPopupDialogs = {}
	end
	StaticPopupDialogs["YataAddSet"] = {
		text = L["Please enter the name for your Set, it the name is already existing the two Sets will be merged, any changes to the button layout will be now done on this set."],
		button1 = L["Add"],
		button2 = L["Cancel"],
		OnCancel = function()
		        self.TotemBar:CancelSetCreation();
				self.TotemBar:SetupSwap(true);
				self.db.profile.ButtonLocked = true;
				self.TotemBar.EditSet = false;
		end,
		sound = "levelup2",
		whileDead = 1,
		hideOnEscape = 1,
		timeout = 0,
		OnShow = function()
			-- We have to do this onshow to reset the previous text
			_G[this:GetName().."EditBox"]:SetText("");
		end,
		OnAccept = function()
			local name = _G[this:GetParent():GetName().."EditBox"]:GetText();
			self.TotemBar:AddTotemSet(name);
			self.TotemBar:SetupSwap(true);
			self.db.profile.ButtonLocked = true;
			self.TotemBar.EditSet = false;
		end,
		hasEditBox = 1,
	}
	StaticPopupDialogs["YataDeleteSet"] = {
		text = L["Are you sure you want to delete the set %s?"],
		button1 = L["Delete"],
		button2 = L["Cancel"],
		showAlert = 1,
		timeout = 0,
		OnAccept = function() self.TotemBar:DeleteTotemSet(); end,
		OnCancel = function() end,
	}

end

-------------
-- Profile --
-------------
function Yata:InitProfile()
	-- TotemsOrder
	if(not self.db.profile.TotemsOrder) then
		self.db.profile.TotemsOrder = {"Earth","Fire","Water","Air"};
		for i=1,4 do
			self.db.profile.TotemsOrder[self.db.profile.TotemsOrder[i]] = {};
		end
	end
	-- TotemSets, ActiveSet
	if(not self.db.profile.TotemSets) then
		self.db.profile.TotemSets = {};
	end
	if(not self.db.profile.ActiveSet) then
		self.db.profile.ActiveSet = "";
	end
end
-----------
-- FuBar --
-----------


function Yata:OnTextUpdate()
    if(self.db.profile.ActiveSet ~= "" and self.db.profile.ActiveSet) then
    	self:SetText(self.db.profile.ActiveSet);
    else
    	self:SetText(L["No Set"]);
    end
end

-- originally found in ClosetGnome by rabbit
function Yata:OnTooltipUpdate()
	local cat = nil;
	local function clickfunc(name)
		if(name == "" and self.db.profile.ActiveSet ~= "") then
			self.TotemBar:ResetSet();
		else
			self.TotemBar:LoadTotemSet(name);
		end
		Yata:UpdateTooltip();
	end
	local sets = {};
	for k in pairs(self.db.profile.TotemSets) do
		table.insert(sets, k)
	end;
	table.sort(sets);
	for i, set in ipairs(sets) do
		if (not cat) then
			cat = tablet:AddCategory(
				"text", L["Available Totemsets"],
				"showWithoutChildren", false,
				"child_hasCheck", true,
				"child_checked", false,
				"child_isRadio", true
			);
		end
		local displayName = "  "..set;
		local checked = false;
		if(self.db.profile.ActiveSet == set) then
			checked = true;
		end
		cat:AddLine(
			"text", displayName,
			"func", clickfunc,
			"arg1", set,
			"checked", checked
		);
	end
	local checked = false;
	if(self.db.profile.ActiveSet == "") then
		checked = true;
	end
	if(cat) then
		cat:AddLine("text", "  "..L["No Set"], "func", clickfunc, "arg1", "", "checked", checked);
	end
	sets = nil;

	if (cat ~= nil) then
		tablet:SetHint(L["Please click on any Set Name to equip or click on 'No Set' to return to the default Totembar"]);
	else
		tablet:SetHint(L["No Totemsets created"]);
	end
end

-----------------
-- Macro Stuff --
-----------------

function Yata:EditMacro()
	if(InCombatLockdown()) then return end;
	local num = GetNumMacros();
	local numIcons = GetNumMacroIcons();
	local iconid = 0;
	for i=1,numIcons do
		if(GetMacroIconInfo(i) == "Interface\\Icons\\INV_Misc_QuestionMark") then
			iconid = i;
			break;
		end
	end
	if(iconid == 0) then Yata:Print(L["Couldn't find Icon"]); return end;
	local macro = "#showtooltip\n/castsequence reset=combat/"..self.db.profile.MacroResetKey.." ";
	for i=1,4 do
		if(self.TotemBar.Buttons[i] and self.TotemBar.Buttons[i+1]) then
			macro = string.format("%s%s, ",macro,self.TotemBar.Buttons[i].Totem.Name);
		elseif(self.TotemBar.Buttons[i] and not self.TotemBar.Buttons[i+1]) then
			macro = string.format("%s%s",macro,self.TotemBar.Buttons[i].Totem.Name);
		end
	end
	local macroindex = 0;
	macroindex = GetMacroIndexByName("YataTotemStomp");
	if(macroindex > 0) then
		EditMacro(macroindex, "YataTotemStomp",iconid,macro,1);
	else
		if(num < 18) then
			CreateMacro("YataTotemStomp",iconid,macro,1,1);
		else Yata:Print(L["No more Macros allowed"]);
		end
	end
end