if select(2, UnitClass('player')) ~= "SHAMAN" then
	DisableAddOn("Yata")
	return
end
-----------------
-- Declaration --
-----------------
Yata = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "AceConsole-2.0", "AceDebug-2.0", "CandyBar-2.0");
local L = AceLibrary("AceLocale-2.2"):new("Yata");
local dewdrop = AceLibrary("Dewdrop-2.0");
local defaults = {
	Locked = true,
	ButtonScale = 1.0,
	PopupButtonScale = 0.8,
	ButtonLocked = true,
	ShowTooltip = true,
	ShowTTOOC = true,
	ActiveTotemset = "Default",
	InvertBar = false,
	VerticalBar = false,
	TimersEnabled = true,
	TimerBarScale = 1.0,
	TimerBarLocked = true,
	ShortTooltip = false,
	TimerBarTexture = "Blizzard",
	MacroResetKey = "shift",
	AllTotemCooldowns = false,
};
Yata:RegisterDB("YataDB");
Yata:RegisterDefaults('profile', defaults);

-- Fubar Stuff
Yata.hideWithoutStandby = true;
local defaultIcon = "Interface\\Icons\\Spell_Nature_EarthBindTotem.blp";
Yata.hasIcon = defaultIcon;
Yata.hasNoColor = true;
Yata.defaultMinimapPosition = 200;
Yata.clickableTooltip  = true;
Yata.independentProfile = true;
-----------------
-- Common Code --
-----------------

function Yata:OnInitialize()
	local short, long = self:GetProfile();
	if (short == "Default") then
		self:Print("Char based Profiles are default now");
		self:SetProfile("char");
	end
	self:InitProfile();
	self.options = self:InitOptions();
	self:InitTimerOptions();
	self:RegisterChatCommand({"/Yata"}, self.options );
	self:RegisterEvent("LEARNED_SPELL_IN_TAB", "Reload");
	self:RegisterEvent("AceEvent_FullyInitialized", "StartTotems");		
end

function Yata:OnEnable()
	if(not self.IsInitialized) then
		self:StartTotems();
	else
		self.TotemBar:Show();
	end
end

function Yata:StartTotems()
	if(not self:TotemsInit()) then return; end
	self.TotemBar = Yata.Class.FlexTotemBar:new(self.db);
	self.TotemBar:CreateBar();
	self.TotemBar:LoadConfig();
	-- Create Candy Anchor
	self:InitTimers();
	self:CandyAnchor();
	self.IsInitialized = true;
	if(self:IsEventRegistered("AceEvent_FullyInitialized")) then
		self:UnregisterEvent("AceEvent_FullyInitialized");
	end
end

function Yata:OnDisable()
	self.TotemBar:Hide();
end

function Yata:Reload()
	self:OnDisable();
	self.IsInitialized = false;
	self:OnEnable();
	if IsAddOnLoaded("cyCircled") then
		local cydb = cyCircled:AcquireDBNamespace("Yata");
		if(cydb) then
			if(cydb.profile["Main"] or cydb.profile["Popup"]) then
				cyCircled_Yata.elements = {};
				cyCircled_Yata:SetupElements();
				cyCircled_Yata:ApplySkin();
				cyCircled_Yata:ApplyColors();
				self:Print(L["Reapplied cyCircled skin"]);
			end
		end
	end
	self:Print(L["Yata reloaded"]);
end
function Yata:CheckShowToolTip()
	if(not self.db.profile.ShowTooltip) then return nil end;
	if(self.db.profile.ShowTooltip and self.db.profile.ShowTTOOC and InCombatLockdown()) then return nil end;
	return true;
end

-------------------
-- The real deal --
-------------------

