local Yap = LibStub("AceAddon-3.0"):NewAddon("Yap", "AceHook-3.0")

function Yap:OnEnable()
	for i = 1, NUM_CHAT_WINDOWS do
		local cf = _G["ChatFrame"..i]
		
		-- Hook AddMessage
		self:RawHook(cf, "AddMessage", true)
		
		-- Change Font
		cf:SetFont("Fonts\\FRIZQT__.TTF", 12)
		
		-- Add Scrolling
		cf:SetScript("OnMouseWheel", function()
			if arg1 > 0 then
				if IsShiftKeyDown() then
					this:ScrollToTop()
				elseif IsControlKeyDown() then
					this:PageUp()
				else
					this:ScrollUp()
				end
			elseif arg1 < 0 then
				if IsShiftKeyDown() then
					this:ScrollToBottom()
				elseif IsControlKeyDown() then
					this:PageDown()
				else
					this:ScrollDown()
				end
			end
		end)
		cf:EnableMouseWheel(true)
		
		-- Hide Buttons
		_G["ChatFrame"..i.."UpButton"]:Hide()
		_G["ChatFrame"..i.."UpButton"]:SetScript("OnShow", function() this:Hide() end)
		_G["ChatFrame"..i.."DownButton"]:Hide()
		_G["ChatFrame"..i.."DownButton"]:SetScript("OnShow", function() this:Hide() end)
		_G["ChatFrame"..i.."BottomButton"]:Hide()
		_G["ChatFrame"..i.."BottomButton"]:SetScript("OnShow", function() this:Hide() end)
	end
	
	-- Hide The Other Button
	_G["ChatFrameMenuButton"]:Hide()
	
	-- Move Edit Box To Top
	_G["ChatFrameEditBox"]:ClearAllPoints()
	_G["ChatFrameEditBox"]:SetPoint("BOTTOMLEFT", "ChatFrame1", "TOPLEFT", -5, 0)
	_G["ChatFrameEditBox"]:SetPoint("BOTTOMRIGHT", "ChatFrame1", "TOPRIGHT", 5, 0)
	
	-- Allow Edit Box Cursor Movement Without Alt Key Pressed
	_G["ChatFrameEditBox"]:SetAltArrowKeyMode(false)
end

function Yap:AddMessage(frame, text, ...)
	text = tostring(text) or ""

	-- Named Channels
	text = text:gsub("%[Guild%]", "[G]")
	text = text:gsub("%[Officer%]", "[O]")
	text = text:gsub("%[Party%]", "[P]")
	text = text:gsub("%[Raid%]", "[R]")
	text = text:gsub("%[Raid Leader%]", "[RL]")
	text = text:gsub("%[Raid Warning%]", "[RW]")
	text = text:gsub("%[Battleground%]", "[BG]")
	text = text:gsub("%[Battleground Leader%]", "[BGL]")
	
	-- Numbered Channels
	text = text:gsub("%[(%d+)%. General%]", "[%1. G]")
	text = text:gsub("%[(%d+)%. Trade%]", "[%1. T]")
	text = text:gsub("%[(%d+)%. LocalDefense%]", "[%1. LD]")
	text = text:gsub("%[(%d+)%. GuildRecruitment%]", "[%1. GR]")
	text = text:gsub("%[(%d+)%. WorldDefense%]", "[%1. WD]")
	text = text:gsub("%[(%d+)%. LookingForGroup%]", "[%1. LFG]")

	-- Timestamps
	text = "|cff20b2aa"..date("%H:%M").."|||r "..text

	return self.hooks[frame].AddMessage(frame, text, ...)
end
