--local yacl_prefix="yacl"; fiest version
local yacl_prefix="Yacl";

local STRING_LEN=string.len;
local FORMAT    =format;

-- *******************************************************************************
-- addon message worker functions
-- *******************************************************************************

function yacl:addon_command_reset()
   
end

-- *******************************************************************************
-- message dispatcher table
-- *******************************************************************************

yacl.addon_commands=
{
   ["reset"]=yacl.addon_command_reset;
};

-- *******************************************************************************
-- generic message dispatcher
-- *******************************************************************************

function yacl:on_message_addon(...)
   local prefix,message,channel,sender=select(1,...);
   if(prefix==yacl_prefix) then
      if(sender~=self.player_name) then
         
         local _GMATCH  =gmatch;    -- speedup function lookup
         local _TONUMBER=tonumber;  -- speedup function lookup
         
         -- the combat message start with the guid and ends with a colon ';'
         for guid,command in _GMATCH(message,"(0x[%x]*)=([^;]*)") do
            if(yacl_global_settings.m_use_sync) then
               local combat_player=yacl_database.players[guid];
               -- the sender must be in our table,or something is wrong
               if(combat_player) then
                  local update=false;
                  -- get the last reference point for that player
                  local temp_player  =self.temp[guid];
                  if(temp_player) then
                     -- parse through all section syntax is "section_name(content)"
                     for section_name,spells in _GMATCH(command,"([%a]*)%(([^%)]*)%)") do
                        -- the sections schould already exist
                        local temp_section=temp_player[section_name];
                        local section     =combat_player[section_name];
                        if(section and temp_section) then
                           -- parse through the spells in that section
                           -- syntax is "spellID[content]"
                           for spellId_string, spelldata in _GMATCH(spells,"([-%d]*)%[([^%]]*)%]") do
                              local spellId=_TONUMBER(spellId_string);
                              if(spellId) then
                                 local temp_spell=temp_section[spellId];
                                 local spell     =     section[spellId];
                                 if(not spell) then
                                    spell=yacl_spell.new();
                                    section[spellId]=spell;
                                    update=true;
                                 end
                                 local value=1;
                                 for key,value_string in _GMATCH(spelldata,"(%a)([-%d%.]*)") do
                                    -- ignore keys we do not know (to stay compatible)
                                    if(yacl_spell_default[key]~=nil) then
                                       if(value_string~="") then
                                          --local t=FORMAT("section %s : key=%s value=%s",section_name,key,value_string);
                                          --self:debug(t);
                                          value=_TONUMBER(value_string);
                                       else
                                          --local t=FORMAT("section %s : key=%s value=last",section_name,key);
                                          --self:debug(t);
                                       end
                                       if(temp_spell) then
                                          if(key~="x") then
                                             spell[key]=temp_spell[key]+value;
                                             temp_spell[key]=spell[key];
                                          else
                                             if(value>spell[key]) then
                                                spell[key]=value;
                                             end
                                          end
                                       else
                                          spell[key]=value;
                                       end
                                    end
                                 end
                                 if(not temp_spell) then
                                    temp_section[spellId]=yacl_copy_table(spell);
                                 end
                              end
                           end
                        end
                     end
                  else
                     -- create complete new temp entry for player
                     self.temp[guid]=yacl_copy_table(combat_player);
                  end
                  if(update) then yacl_database.m_structure_update=true; end
                  yacl_database.value_update=true;
               else
                  --self:debug("on_message_addon - guid not in combat list");
               end
            end
            return;
         end
         
         --self:debug("yacl addon message:" .. message .. " from " .. sender);
         for cmd,param in _GMATCH( message, "[, ]*([%w]*)[= ]*([%w]*)") do
            --self:debug("cmd="..cmd .. " param="..param);
            local entry=self.addon_commands[cmd];
            if(entry) then
               entry(self,sender,param);
            else
               if(cmd~="") then
                  self:debug("yacl unknown addon command:",cmd);
               end
            end
         end
         
      end
   end
end

-- ************************************************************
--
-- ************************************************************

local section_names ={ "d" , "h" , "i" , "di" , "hi" };
local section_cnames={ "d_changed","h_changed","i_changed","di_changed","hi_changed" };

function yacl:send_combat_messages(force)
   if(self.addon_channel and yacl_global_settings.m_use_sync) then
      local t=GetTime();
      if(t-self.m_combat_message_time>2) then
         self.m_combat_message_time=t;
         if(not ChatThrottleLib.bQueueing) then
            if(self.send_pet and yacl_database.players[self.pet_guid]) then
               --send pet data
               local l=self:create_person_combat_message(self.pet_guid,
               section_cnames[self.section_count],
               section_names [self.section_count]);
               --if(l>0) then self:debug("Sending pet section " .. self.section_count .. " len=" .. l); end
               self.section_count=self.section_count+1;
               if(self.section_count>5) then
                  self.section_count=1;
                  self.send_pet     =false;
               end
            else
               --send player data
               local l=self:create_person_combat_message(self.player_guid,
               section_cnames[self.section_count],
               section_names [self.section_count]);
               -- if(l>0) then self:debug("Sending player section " .. self.section_count .. " len=" .. l); end
               self.section_count=self.section_count+1;
               if(self.section_count>5) then
                  self.section_count=1;
                  self.send_pet     =true;
               end
            end
         end
      end
   end
end

function yacl:create_person_combat_message(guid,change,section)
   local l=0;
   if(guid) then
      local person     =yacl_database.players[guid];
      local temp_person=self.temp[guid];
      if(person and temp_person) then
         if(person[change]) then
            person[change]=nil;
            local t=guid .. "=".. self:create_section_deltas(section,temp_person[section],person[section]) .. ";";
            --self:debug(t);
            l=STRING_LEN(t);
            if(l<=238) then
               ChatThrottleLib:SendAddonMessage("NORMAL",yacl_prefix,t,self.addon_channel);
            else
               self:debug("WARNING : MAX MESSAGE LENGTH EXCEEDED !");
            end
            yacl_merge_table(person[section],temp_person[section]);
         end
      else
         --self:debug("create_person_combat_message - no temp person");
      end
   end
   return l;
end

local function PairsBySortedValue(t)
   local sort={};
   for key in pairs(t) do table.insert(sort,key); end
   table.sort(sort,
   function(a,b)
      local v1=t[a];
      local v2=t[b];
      return v1 < v2;
   end );
   local i=0;
   local iter=function()
      i=i+1;
      if(sort[i]==nil) then return nil; end
      return sort[i],t[sort[i]];
   end
   return iter;
end

function yacl:create_section_deltas(section_name,old_section,section)
   local m=0;  -- count the spells that have delta data
   local t=""; -- the compressed concatenated result string for one section
   for spellId,spell in pairs(section) do
      local old_spell=old_section[spellId];
      local t0="";      -- we are bulding a small string that we later concatenate with the bigger one
      local n=0;        -- count the number of keys we find
      local value=1;    -- starting value is assumed to be one
      if(old_spell) then
         -- we had that spell already in the last transmission. So we are calculating deltas.
         -- zero values (havent chanegd are already filtered out by the delta function
         yacl_spell.delta(old_spell,spell);
         -- the iterator we use here, is delivering the values for that spell in ascending order.
         -- an compression rule is, that no value means repeat last value. The first value is
         -- assumed to be always 1.
         -- in that way, we are compression a string like
         -- "e10s10n1c1" (e.g. a heal that healed for 10 points without overheal and critted one time) into
         -- "nce10s"
         for key,v in PairsBySortedValue(old_spell) do
            if(v~=value) then
               value=v;
               t0=t0..FORMAT("%s%s",key,v);
            else
               t0=t0..key;
            end
            n=n+1;
         end
      else
         -- same as above, but the spell is new in the list.
         for key,v in PairsBySortedValue(spell) do
            if(v~=value) then
               value=v;
               t0=t0..FORMAT("%s%s",key,v);
            else
               t0=t0..key;
            end
            n=n+1;
         end
      end
      if(n>0) then
         t=t..FORMAT("%d[%s]",spellId,t0);
         m=m+1;
      end
   end
   if(m>0) then
      return FORMAT("%s(%s)",section_name,t);
   end
   return "";
end


