--[[
--	Xparky is a rewrite of FuXPFu to use Ace3 and deFu it
--	Mouse frame selection shamelessly stolen from Dash (Kyhax)
--]]

Xparky = LibStub("AceAddon-3.0"):NewAddon("Xparky", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0", "AceBucket-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("Xparky")
local reg = LibStub("AceConfigRegistry-3.0")
local dialog = LibStub("AceConfigDialog-3.0")
local _G = getfenv(0)

Xparky.options = {}

local options = Xparky.options  

Xparky.db = {}
local db  



--[[ Local helper functions --]]
--
local function getHex(Bar)
	local Colours
	if(type(Bar) == "string") then
		Colours = db.barColours[Bar]
		return string.format("|r|cff%02x%02x%02x", Colours.Red*255, Colours.Green*255, Colours.Blue*255)
	elseif(type(Bar) == "number") then
		Colours = FACTION_BAR_COLORS[Bar]
		if Colours then
			return string.format("|r|cff%02x%02x%02x", Colours.r*255, Colours.g*255, Colours.b*255)
		else return "" end
	else
		return ""
	end
end

--[[ Base Bar functions ]] --
local function cloneTable(t)
	local clone = {}
	if not t then return clone end
	for i,v in pairs(t) do
		if type(v) == "table" then
			clone[i] = cloneTable(v)
		else
			clone[i] = v
		end
	end
	return clone
end


function Xparky:StartGathering()
	Xparky:ScheduleTimer("getFactions", 0.5, Xparky)
	Xparky:ScheduleTimer("GenerateBars", 1, Xparky)
	Xparky:ScheduleTimer("GenerateBarList", 2, Xparky)
end

local function MouseOver()
	if db.MouseTooltip then
		GameTooltip:SetOwner(Anchor, "ANCHOR_CURSOR")
		Xparky:UpdateBars(nil, true)
		if GetMouseFocus() == Anchor then
			GameTooltip:Show()
		end
	end
	if db.MouseHide then
		Xparky:ConnectBars()
	end
end

local function HideBars()
	XPBar:Hide()
	RestBar:Hide()
	NoXPBar:Hide()
	RepBar:Hide()
	NoRepBar:Hide()
	Shadow:Hide()
end


local function MouseOut()
	if db.MouseTooltip then
		if GameTooltip:IsOwned(Anchor) then
			GameTooltip:SetOwner(UIParent)
			GameTooltip:Hide()
		end
	end
	if db.MouseHide then
		HideBars()
	end
end

function Xparky:OnEnable()
	Xparky.db = LibStub("AceDB-3.0"):New("XparkyDB")
	if not Xparky.db.profile.Bars then
		Xparky:Print("Registering default values")
		Xparky.db.profile.Bars = {
				BarNames = { "XPBar", "RepBar" },
				XPBar = {
					Name = "XPBar",
					BarType = "XP",
					Note = "default",
				},
				RepBar = {
					Name = "RepBar",
					BarType = "Rep",
					Faction = 1,
				}
			}

	end
	self.Events = CreateFrame("Frame", XparkyEvents)
	self:InitialiseOptions()
	
	db = Xparky.db.profile
	reg:RegisterOptionsTable("Xparky", options)
	self:RegisterChatCommand("xp", function() dialog:Open("Xparky") end)

	self:StartGathering()
end

function Xparky:GenerateBars()
	for i,v in ipairs(db.Bars.BarNames) do
		if db.Bars[v] then
			self:New(db.Bars[v])
		end
	end
	self:InitialiseEvents()
end


function Xparky:InitialiseEvents()
	self:RegisterEvent("PLAYER_XP_UPDATE", "UpdateBars")
	self:RegisterEvent("PLAYER_REGEN_DISABLED","DisableUpdate")
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "EnableUpdate")
	self:RegisterBucketEvent("UPDATE_EXHAUSTION", 60, "UpdateBars")
	self:RegisterBucketEvent("UPDATE_FACTION", 5, "UpdateBars")
	hooksecurefunc("SetWatchedFactionIndex", Xparky.getFactions)
	if InCombatLockdown() then
		Xparky.UpdateMe = false
	else
		Xparky.UpdateMe = true
	end
end


function Xparky:DisableUpdate()
	Xparky.UpdateMe = false
end

function Xparky:EnableUpdate()
	Xparky.UpdateMe = true
end

function Xparky:UpdateBars()
	if self.UpdateMe then
		for Name,Bar in ipairs(self.Bars) do
			Bar:Update()
		end
	end
end

--[[ Generic Bar Functions ]] -- 

function Xparky:inheritsFrom( baseClass, defaults )
	local new_class = defaults or {}
	local class_mt = { __index = new_class }

	function new_class:create(defaults)
		local new_inst = cloneTable(defaults) or {}
		setmetatable( new_inst, class_mt )
		return new_inst
	end

	if baseClass then
		setmetatable( new_class, { __index = baseClass })
		new_class.base = baseClass;
	end

	return new_class
end

function Xparky:New(Bar)

	local MakeBar = { ["XP"] = Xparky.XPBar, ["Rep"] = Xparky.RepBar, ["Honour"] = Xparky.HonourBar }
	
	if self.Bars and self.Bars[Bar.Name] then 
		self.Bars[Bar.Name]:ConstructBar() 
		return 
	end

	Bar = MakeBar[Bar.BarType]:Setup(Bar)

	if not self.Bars then self.Bars = {} end
	
	self.Bars[Bar.Name] = Bar
	return Bar
end

