
--[[ XP Bar Functions ]]--

Xparky.XPBar = Xparky:inheritsFrom(Xparky.BaseBar, {
				BarType = "XP",
				Sections = {},
				Events = {"PLAYER_XP_UPDATE", "UPDATE_EXHAUSTION" },
				BarOrder = { [1] = "XPBar", [2] = "RestBar", [3] = "NoXPBar" },
				db = {}
			})

local defaults = {
				Colours = {
					XPBar = { Red = 0, Green = 0.4, Blue = 0.9, Alpha = 1 },
					NoXPBar = { Red = 0.3, Green = 0.3, Blue = 0.3, Alpha = 1 },
					RestBar = { Red = 1, Green = 0.2, Blue = 1, Alpha = 1 },
				}
}

local XPBar = Xparky.XPBar

function XPBar:SetupDefaults(db)
	
	self.base.SetupDefaults(self, db)
	for k,v in pairs(defaults) do
		if(not db[k]) then
			db[k] = v
		end 
	end
end

function XPBar:Setup(o)
	Xparky:Print("creating XPBar")
	o = XPBar:create(o or {})
	o.db = Xparky.db.profile.Bars[o.Name]
	o:SetupDefaults(o.db)
	o.Sections[1] = Xparky.SparkSection:Setup({Name = "XPBar"..o.Name, Colours = o.db.Colours.XPBar, Spark = o.db.Spark})
	o.Sections[2] = Xparky.BasicSection:Setup({Name = "RestBar"..o.Name, Colours = o.db.Colours.RestBar})
	o.Sections[3] = Xparky.BasicSection:Setup({Name = "NoXPBar"..o.Name, Colours = o.db.Colours.NoXPBar})
	o:ConstructBar()
	return o
end

function XPBar:Update()
	self.base.Update(self)
	
	local Rest, CurrXP, MaxXP = GetXPExhaustion() or 0, UnitXP("player") or 0, UnitXPMax("player") or 0
	local Percent = (self.db.BarLength/MaxXP)
	Xparky:Print("Updating XPBar")	
	self.Sections[1]:Length(Percent * CurrXP)
	if Rest > (MaxXP - CurrXP) then
		self.Sections[2]:Length(Percent * (MaxXP - CurrXP))
		self.Sections[3]:Length(0)
	else
		self.Sections[2]:Length(Percent * Rest)
		self.Sections[3]:Length(Percent * (MaxXP-CurrXP))
	end

end

