--[[ Spark bar inherits from Basic Bar ]]--
--

local angles = {[180] = { 1,0,1,1,0,0,0,1}, [0] = {0,1,0,0,1,1,1,0}, [270] = {1,1,0,1,1,0,0,0}, [90] = {0,0,1,0,0,1,1,1}}
Xparky.SparkSection = Xparky:inheritsFrom(Xparky.BasicSection, {
	Spark1File =  "Interface\\AddOns\\Xparky\\Textures\\glow.tga",
	Spark2File =  "Interface\\AddOns\\Xparky\\Textures\\glow2.tga"
	})

local SparkSection = Xparky.SparkSection;

local function GetXY(Width, Rotate)
	if Rotate == 0 then
		return 20 , 0
	elseif Rotate == 90 then
		return 0, -(20)
	elseif Rotate == 180 then
		return -(20), 0
	elseif Rotate == 270 then
		return 0, 20
	end
end

function SparkSection:Setup(o)
	o = SparkSection:create(o or {})
	self.base.Setup(self, o)
	return o
end

function SparkSection:Breadth(Size)
	local height = self.base.Breadth(self, Size);
	
	if height then
		return height
	end

	if self.Rotate == 0 or self.Rotate == 180 then
		self.SparkBase:SetHeight(Size * 10)
		self.SparkOverlay:SetHeight(Size * 10)
	else
		self.SparkBase:SetWidth(Size * 10)
		self.SparkOverlay:SetWidth(Size * 10)
	end
end


function SparkSection:Length(Size)
	local width = self.base.Length(self,Size)
	
	if width then
		return width
	end
	if self.Rotate == 0 or self.Rotate == 180 then
		self.SparkBase:SetWidth(128)
		self.SparkOverlay:SetWidth(128)
	else
		self.SparkBase:SetHeight(128)
		self.SparkOverlay:SetHeight(128)
	end 
end

function SparkSection:RotateBar(deg)
	self.base.RotateBar(self, deg, self.Texture)

	self.SparkBase:SetTexture(self.Spark1File)
	self.base.RotateBar(self, deg, self.SparkBase)
	self.SparkBase:SetTexture(self.SparkOverlay)
	self.base.RotateBar(self, deg, self.SparkOverlay)
end

function SparkSection:CreateTextures()
	local sparkBase = self.Base:CreateTexture(self.Name .. "Spark", "OVERLAY")
	sparkBase:SetTexture(self.Spark1File)
	sparkBase:SetBlendMode("ADD")
	sparkBase:SetParent(self.Base)
	sparkBase:SetAlpha(self.Spark or 0.01)
	self.SparkBase = sparkBase

	local sparkOverlay = self.Base:CreateTexture(self.Name .. "Spark2", "OVERLAY")
	sparkOverlay:SetTexture(self.Spark2File)
	sparkOverlay:SetBlendMode("ADD")
	sparkOverlay:SetParent(self.Base)
	sparkOverlay:SetAlpha(self.Spark or 0.01)
	self.SparkOverlay = sparkOverlay

	return self.base.CreateTextures(self)
end

function SparkSection:SetColour()
	
	self.base.SetColour(self)

	if self.Colours then
		self.SparkBase:SetVertexColor(self.Colours.Red, self.Colours.Green, self.Colours.Blue, self.Spark)
		self.SparkOverlay:SetVertexColor(self.Colours.Red, self.Colours.Green, self.Colours.Blue, self.Spark)
	end
end

function SparkSection:Update()
	self.base.Update(self)
end

function SparkSection:ConstructBar(BarAnchorFrom, BarAnchorTo, Attached, First)
	self.base.ConstructBar(self, BarAnchorFrom, BarAnchorTo, Attached, First)
	Xparky:Print("Constructing Spark")
	
	local x,y = GetXY(self:Length(), self.Rotate)	
	self.SparkBase:ClearAllPoints()
	self.SparkOverlay:ClearAllPoints()
	self.SparkBase:SetPoint(BarAnchorTo, self.Base, BarAnchorTo, x, y)
	self.SparkOverlay:SetPoint(BarAnchorTo, self.Base, BarAnchorTo, x, y)
end
