
--[[ RepBar Functions ]] --

Xparky.RepBar = Xparky:inheritsFrom(Xparky.BaseBar, {
				BarType = "Rep",
				Events = {"UPDATE_FACTION"},
				Sections = {},
				db = {},
				BarOrder = { [1] = "RepBar", [2] = "NoRepBar" }
})

local defaults = {
				Colours = {
					RepBar = { Red = 1, Green = 0.2, Blue = 1, Alpha = 1 },
					NoRepBar = { Red = 0, Green = 0.3, Blue = 1, Alpha = 1 },
				},
				Faction = 6,
		}
		
local RepBar = Xparky.RepBar

function RepBar:SetupDefaults(db)
	self.base.SetupDefaults(self, db)
	for k,v in pairs(defaults) do
		if(not db[k]) then
			db[k] = v
		end 
	end
end

function RepBar:Setup(o)
	Xparky:Print("creating RepBar "..o.Name)
	o = RepBar:create(o or {})
	o.db = Xparky.db.profile.Bars[o.Name]
	o:SetupDefaults(o.db)
	o.Sections[1] = Xparky.SparkSection:Setup({Name = "RepBar"..o.Name, Colours = o.db.Colours.RepBar, Spark = o.db.Spark})
	o.Sections[2] = Xparky.BasicSection:Setup({Name = "NoRepBar"..o.Name, Colours = o.db.Colours.NoRepBar})
	o:ConstructBar()
	return o
end

function RepBar:Update()
	self.base.Update(self)

	local name, description, standingID, bottomValue, topValue, earnedValue = GetFactionInfo(self.db.Faction) 
	local Percent = self.db.BarLength/(topValue - bottomValue)
	self.Sections[1]:Length(Percent * (earnedValue - bottomValue))
	self.Sections[2]:Length(Percent * (topValue - earnedValue))
end

