local options = Xparky.options
local L = LibStub("AceLocale-3.0"):GetLocale("Xparky")
local reg = LibStub("AceConfigRegistry-3.0")
local db
local Strata = { "BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG", "FULLSCREEN", "FULLSCREEN_DIALOG", "TOOLTIP" }

currentBar = {Type = "XP"}

factionTable = {}
factionSort = {}

function Xparky:InitialiseOptions()
	db = Xparky.db.profile
	options.args.profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(Xparky.db)
end

options.type = "group"
options.name  = "Xparky"
options.get  = function( k )  return db[k.arg] end
options.set  = function( k, v ) db[k.arg] = v; Xparky:UpdateBars(k.arg) end



options.args = {}

options.args.bars = {
	type = "group",
	name = L["Bars"],
	desc = L["Bar Modifications"],
	order = 1,
	args = {
		CreateBars = {
			type = "group",
			name = "Create a new bar",
			order =  1,
			inline = true,
			set = function(k, v) currentBar[k.arg] = v; reg:NotifyChange("Xparky") end,
			get = function(k) return currentBar[k.arg] end,
			args = {
				type = {
					type = "select",
					name = "Bar Type",
					order = 1,
					values = { XP = "XP Bar", Rep = "Rep Bar", Honour = "Honour Bar" },
					arg = "Type",
				},
				name = {
					type = "input",
					name = "Bar Name",
					order = 3,
					width = "full",
					set = function(k,v) 
							if v == "" then 
								currentBar.Name = nil 
								return 
							end 
							currentBar.Name = string.gsub(v, " ", ""); 
							for i,name in ipairs(db.Bars.BarNames) do
								if name == currentBar.Name then
									Xparky:Print("There is a bar with that name already")
									currentBar.Name = nil
									return
								end
							end
							reg:NotifyChange("Xparky") 
						end,
					arg = "Name"
				},
				rep = {
					type = "select",
					name = "Faction",
					order = 2,
					hidden = function() return currentBar.Type ~= "Rep" end,
					values = factionSort,
					set = function(k,v) 
							currentBar.FactionIndex = v; 
							currentBar.Faction = factionSort[v]; 
							reg:NotifyChange("Xparky") 
						end,
					arg = "FactionIndex",
				},
				create = {
					type = "execute",
					name = "Create Bar",
					hidden = function() 
								return	(currentBar.Type == "XP" and not currentBar.Name) or 
										(currentBar.Type == "Rep" and (not currentBar.Name or not currentBar.Faction)) 
							end,
					func =	function(k,v) 
								table.insert(db.Bars.BarNames, currentBar.Name)
								if currentBar.Type == "XP" then
									db.Bars[currentBar.Name] = {Name = currentBar.Name, BarType = "XP" }
								elseif currentBar.Type == "Rep" then
									db.Bars[currentBar.Name] = {Name = currentBar.Name, BarType = "Rep", Faction = factionTable[currentBar.Faction] }
								elseif currentBar.Type == "Honour" then
									db.Bars[currentBar.Name] = {Name = currentBar.Name, BarType = "Honour"}
								end
								currentBar.Name = nil
								Xparky:GenerateBars()
								Xparky:GenerateBarList()
							end
				},
			},
		},
	},
}

options.args.bars.args.barlist = {
	type = "group",
	name = "Bar List",
	order = 1,
	args = {}
}

options.args.help = {
	type = "group",
	order = 100,
	name = L["Documentation"],
	args = {
		desc = {
			type = "group",
			name = L["Description"],
			args = {
				text = {
					type = "description",
					name = L["DESCRIPTION"],
					order = 1
				},
			},
		},
		faq = { 
			type = "group",
			name = L["FAQ"],
			args = {
				text = {
					type = "description",
					name = L["FAQ_TEXT"],
					order = 2
				},
			},
		},
		about = {
			type = "group",
			name = L["About"],
			args = {
				text = {
					type = "description",
					name = L["ADDON_INFO"],
					order = 3
				}
			}
		}
	}
}


function Xparky:getFactions()
	for factionIndex = 1, GetNumFactions() do
		local name, _, _, _, _, _, _, _,isHeader = GetFactionInfo(factionIndex)
		if not isHeader then
			factionTable[name] = factionIndex
			table.insert(factionSort, name)
		end
	end
	if GetNumFactions() == 0 then
		self:ScheduleTimer("getFactions", 1)
	else
		table.sort(factionSort, function(a,b) return a:gsub("The ", "") < b:gsub("The ", "") end)
	end
end

function getBaseMetatable(t)
	if not getmetatable(t) then
		return t
	else
		return getBaseMetatable(getmetatable(t))
	end
end


function Xparky:GenerateBarList()
	Xparky.options.args.bars.args.barlist.args = {}
	for i,BarName in ipairs(db.Bars.BarNames) do
		local Bar = Xparky.Bars[BarName]
		if Bar then
			Xparky.options.args.bars.args.barlist.args[Bar.Name] = Bar.Options
		else
			db.Bars.BarNames[i] = nil
		end
	end
	reg:NotifyChange("Xparky")
end



local mouser = CreateFrame("Frame")
local tb = {A = "top", B = "bottom", 
				SideA = function(frame) return MouseIsOver(frame, 0, frame:GetHeight()/2, 0, 0) end, 
				SideB = function(frame) return MouseIsOver(frame, 0 - frame:GetHeight()/2, 0, 0, 0) end, 
			}
local lr = {A = "left", B = "right",
				SideA = function(frame) return MouseIsOver(frame, 0, 0, 0, 0 - frame:GetWidth()/2) end, 
				SideB = function(frame) return MouseIsOver(frame, 0, 0, frame:GetHeight()/2, 0) end, 
			}
mouser.tooltip = _G.GameTooltip
mouser.setCursor = _G.SetCursor

function mouser:OnUpdate(elap)
    if IsMouseButtonDown("RightButton") then
        return self:Stop()
    end

    local frame = GetMouseFocus()
    local name = frame and frame:GetName() or tostring(frame)
    
    SetCursor("CAST_CURSOR")
    if not frame then return end
    self.tooltip:SetOwner(frame, "ANCHOR_BOTTOMLEFT")
	local side
	if mouser.side.SideA(frame) then
		side = mouser.side.A
	else
		side = mouser.side.B
	end
    self.tooltip:SetText(name .. " ("..side..")", 1.0, 0.82, 0)
    self.tooltip:Show()
    
    if IsMouseButtonDown("LeftButton") then
        self:Stop()
        if not type(frame.GetName) == 'function' or not frame:GetName() then
            Xparky:Print("This frame has no global name, and cannot be added via the mouse")
        else
        	mouser.bar:AttachBarToFrame(name, side)
        	mouser.bar:ConstructBar()
			mouser.bar = nil
			mouser.side = nil
        	reg:NotifyChange("Xparky")
        end
    end
end

function mouser:Start(angle)
	if angle == 90 or angle == 270 then
		mouser.side = lr
	else
		mouser.side = tb
	end
	Xparky:Print(mouser.bar.Name)
    self:SetScript("OnUpdate", self.OnUpdate)
end

function mouser:Stop()
    self.tooltip:Hide()
    self:SetScript("OnUpdate", nil)
end
hooksecurefunc(_G.GameMenuFrame, "Show", function() mouser:Stop() end)

function Xparky:MouseOver()
	if db.MouseTooltip then
		GameTooltip:SetOwner(Anchor, "ANCHOR_CURSOR")
		Xparky:UpdateBars(nil, true)
		if GetMouseFocus() == Anchor then
			GameTooltip:Show()
		end
	end
	if db.MouseHide then
		Xparky:ConnectBars()
	end
end

function Xparky:MouseOut()
	if db.MouseTooltip then
		if GameTooltip:IsOwned(Anchor) then
			GameTooltip:SetOwner(UIParent)
			GameTooltip:Hide()
		end
	end
	if db.MouseHide then
		HideBars()
	end
end

local mouser = CreateFrame("Frame")
local tb = {A = "top", B = "bottom", 
				SideA = function(frame) return MouseIsOver(frame, 0, frame:GetHeight()/2, 0, 0) end, 
				SideB = function(frame) return MouseIsOver(frame, 0 - frame:GetHeight()/2, 0, 0, 0) end, 
			}
local lr = {A = "left", B = "right",
				SideA = function(frame) return MouseIsOver(frame, 0, 0, 0, 0 - frame:GetWidth()/2) end, 
				SideB = function(frame) return MouseIsOver(frame, 0, 0, frame:GetHeight()/2, 0) end, 
			}
mouser.tooltip = _G.GameTooltip
mouser.setCursor = _G.SetCursor

function mouser:OnUpdate(elap)
    if IsMouseButtonDown("RightButton") then
        return self:Stop()
    end

    local frame = GetMouseFocus()
    local name = frame and frame:GetName() or tostring(frame)
    
    SetCursor("CAST_CURSOR")
    if not frame then return end
    self.tooltip:SetOwner(frame, "ANCHOR_BOTTOMLEFT")
	local side
	if mouser.side.SideA(frame) then
		side = mouser.side.A
	else
		side = mouser.side.B
	end
    self.tooltip:SetText(name .. " ("..side..")", 1.0, 0.82, 0)
    self.tooltip:Show()
    
    if IsMouseButtonDown("LeftButton") then
        self:Stop()
        if not type(frame.GetName) == 'function' or not frame:GetName() then
            Xparky:Print("This frame has no global name, and cannot be added via the mouse")
        else
        	mouser.bar:AttachBarToFrame(name, side)
        	mouser.bar:ConstructBar()
			mouser.bar = nil
			mouser.side = nil
        	reg:NotifyChange("Xparky")
        end
    end
end

function mouser:Start(angle)
	if angle == 90 or angle == 270 then
		mouser.side = lr
	else
		mouser.side = tb
	end
	Xparky:Print(mouser.bar.Name)
    self:SetScript("OnUpdate", self.OnUpdate)
end

function mouser:Stop()
    self.tooltip:Hide()
    self:SetScript("OnUpdate", nil)
end
hooksecurefunc(_G.GameMenuFrame, "Show", function() mouser:Stop() end)

function Xparky:MouseOver()
	if db.MouseTooltip then
		GameTooltip:SetOwner(Anchor, "ANCHOR_CURSOR")
		Xparky:UpdateBars(nil, true)
		if GetMouseFocus() == Anchor then
			GameTooltip:Show()
		end
	end
	if db.MouseHide then
		Xparky:ConnectBars()
	end
end

function Xparky:MouseOut()
	if db.MouseTooltip then
		if GameTooltip:IsOwned(Anchor) then
			GameTooltip:SetOwner(UIParent)
			GameTooltip:Hide()
		end
	end
	if db.MouseHide then
		HideBars()
	end
end

--[[

o.Options = {
					type = "group",
					handler = o,
					name = o.Name,
					set = function(info,v) 
							Xparky.db.profile.Bars[info.handler.Name][info.arg] = v;
							info.handler[info.arg] = v
							info.handler:ConstructBar()
							if info.type ~= "range" then
								reg:NotifyChange("Xparky")
							end
						end,
					get = function(info) return info.handler[info.arg] end,
					args = {
						barname = {
							type = "header",
							order = 1,
							name = o.Name
						},
						width = {
							type = "range",
							name = "Bar Length",
							desc = "How long the bar is",
							min = 0.1, max = 2000, step = 1,
							arg = "BarWidth",
							hidden = function(info) return info.handler.Attach and info.handler.Attach ~= "" end,
							order = 2,
						},
						spacer = {
							type = "description",
							name = "",
							desc = "",
							hidden = function(info) return not info.handler.Attach or info.handler.Attach == "" end,
							order = 2,
						},
						thickness = {
							type = "range",
							name = "Bar Thickness",
							desc = "How thick the bar is",
							min = 0.1, max = 32, step = 0.5,
							arg = "Thickness",
							order = 3
						},
						spark = {
							type = "range",
							name = "Spark intensity",
							desc = "Alpha of the spark",
							min = 0, max = 1, step = 0.05,
							arg = "Spark",
							order = 4,
						},
						rotation = {
							type = "select",
							name = "Bar Rotation",
							desc = "Angle at which the bar runs",
							values = {[0] = 0, [90] = 90, [180] = 180, [270] = 270},
							order = 5,
							arg = "Rotate"
						},
						label = {
							type = "toggle",
							name = "Show Label",
							desc = "Show the bar label",
							arg = "ShowLabel",
						},
						attach = {
							type = "execute",
							name = "Attach to frame",
							func = function(info) mouser.bar = info.handler; mouser:Start(info.handler.Rotate) end,
							order = 6,
						},
						attached = {
							type = "input",
							name = "Attached to frame",
							arg = "Attach",
							order = 7,
						},
						side = {
							type = "select",
							name = "Side of frame",
							arg = "Attached",
							hidden = function(info) return info.handler.Attach and info.handler.Attach ~= "" end,
							values = function(info) if info.handler.Rotate == 90 or info.handler.Rotate == 270 then return { left = "Left", right = "Right" } else return {top = "Top", bottom = "Bottom" } end end,
						},
						xoffset = {
							type = "input",
							name = "X offset",
							desc = "Offset from the frame in the X axis",
							arg = "Xoffset",
							order = 8,
							hidden = function(info) return not info.handler.Attach or info.handler.Attach == "" end,
						},
						yoffset = {
							type = "input",
							name = "Y offset",
							desc = "Offset from the frame in the Y axis",
							arg = "Yoffset",
							order = 9,
							hidden = function(info) return not info.handler.Attach or info.handler.Attach == "" end,
						},
						colours = {
							type = "group",
							inline = true,
							name = "Colours",
							desc = "Colours of the sections",
							order = 10,
							get = function(info)
									local t = info.handler.Colours[info.arg] or { Red = 1, Green = 1, Blue = 1, Alpha = 1}
									return t.Red, t.Green, t.Blue, t.Alpha
									end,
							set = function(info, r, g ,b, a)
									local t = info.handler.Colours[info.arg]
									if not Xparky.db.profile.Bars[info.handler.Name].Colours then 
										Xparky.db.profile.Bars[info.handler.Name].Colours = {}
									end
									if not Xparky.db.profile.Bars[info.handler.Name].Colours[info.arg] then 
										Xparky.db.profile.Bars[info.handler.Name].Colours[info.arg] = {} 
									end
									local dbt = Xparky.db.profile.Bars[info.handler.Name].Colours[info.arg]
									t.Red, t.Green, t.Blue, t.Alpha = r, g, b, a
									dbt.Red, dbt.Green, dbt.Blue, dbt.Alpha = r, g, b, a
									info.handler:ConstructBar()
									end,
							args = {}
						},
						delete = {
							type = "execute",
							name = "Delete Bar",
							desc = "Delete this bar",
							func = function(info) 
										Xparky.db.profile.Bars[info.handler.Name] = nil
										XparkyBar.Bars[info.handler.Name].Anchor:Hide()
										XparkyBar.Bars[info.handler.Name] = nil
										Xparky:GenerateBarList()
									end,
						},
					}
				}

				--]]
