
--[[ Honour Bar Functions ]]--

Xparky.HonourBar = Xparky.inheritsFrom(Xparky.BaseBar, {
				BarType = "Honour",
				Colours = {
					HonourBar = { Red = 1, Green = 0.2, Blue = 1, Alpha = 1 },
					TargetBar = { Red = 0.2, Green = 1, Blue = 1, Alpha = 1 },
					NoHonourBar = { Red = 0, Green = 0.3, Blue = 1, Alpha = 1 },
				},
				Events = {"HONOR_CURRENCY_UPDATE"},
				BarOrder = { [1] = "HonourBar", [2] = "TargetBar", [3] = "NoHonourBar" },
				Rotate = 0,
				Target = 8000,
				BarWidth = 300,
	})

local HonourBar = Xparky.HonourBar

function HonourBar:Setup(o)
	o = HonourBar:create(o or {})

	o.Sections[1] = Xparky.SparkBar:Setup({Name = "HonourBar"..o.Name, Colours = o.Colours.XPBar, Rotate = o.Rotate})
	o.Sections[2] = Xparky.BasicBar:Setup({Name = "NoHonourBar"..o.Name, Colours = o.Colours.RestBar, Rotate = o.Rotate})
	o.Sections[3] = Xparky.BasicBar:Setup({Name = "TargetBar"..o.Name, Colours = o.Colours.NoXPBar, Rotate = o.Rotate})
	o:ConstructBar()
--[[
	o.Options.args.target = {
		type = "input",
		name = "Target Honour",
		desc = "Point at which to switch colours from the Honour Bar to the Target Bar, ie, when you've reached your target",
		arg = "Target"
	}
	o.Options.args.maxlimit = {
		type = "toggle",
		name = "Max Limit",
		desc = "Show the max limit of the honour cap at 75k, otherwise, the bar limit will be the Target value",
		arg = "MaxLimit"
	}
--]]
	return o
end

function HonourBar:Update()
	local BarWidth
	local Attached = getglobal(self.Attached) or self.Attached
	if not Attached or Attached:GetName() == UIParent then
		BarWidth = self.BarWidth
	else
		BarWidth = Attached:GetWidth()
	end
	
	self.Sections[1]:Breadth(self.Thickness)
	self.Sections[2]:Breadth(self.Thickness)
	self.Sections[3]:Breadth(self.Thickness)
	self:Length(BarWidth)
	self:Breadth(self.Thickness)
	self.Label:Hide()

	if self.ShowLabel then	
		self.Label:SetTextHeight(self.Thickness)
		self.Label:SetParent(self.Sections[3].Anchor)
		self.Label:ClearAllPoints()
		self.Label:SetPoint("CENTER", self.Anchor, "CENTER")
		self.Label:Show()
	end
	local max, current = self.Target, GetHonorCurrency()
	if self.MaxLimit then
		max = 75000
	end

	local Percent = BarWidth/max
	self.Sections[1]:Length(Percent * current)
	self.Sections[2]:Length(Percent * current)
	self.Sections[3]:Length(Percent * (max - current))
	self.Anchor:SetFrameLevel(self.Sections[3].Anchor:GetFrameLevel() + 2)

	if current >= self.Target then
		self.Sections[1]:Length(0)
	else
		self.Sections[2]:Length(0)
	end
end

