local angles = {[180] = { 1,0,1,1,0,0,0,1}, [0] = {0,1,0,0,1,1,1,0}, [270] = {1,1,0,1,1,0,0,0}, [90] = {0,0,1,0,0,1,1,1}}

Xparky.BasicSection = {
				Rotate = 0,
				Colours = {Red = 0.5, Green = 0.3, Blue = 0.1, Alpha = 1},
				TextureFile = "Interface\\AddOns\\Xparky\\Textures\\texture.tga"
}

local BasicSection = Xparky.BasicSection

function BasicSection:AttachBarToFrame(frame, side)
	Xparky:Print("Attach "..self.Name.." to "..frame.." on the "..side.." side")
	self.Attach = frame
	self.Attached = side
	Xparky.db.profile.Bars[self.Name].Attach = frame
	Xparky.db.profile.Bars[self.Name].Attached = side
end

function BasicSection:Setup(o)
	o = o or {}
	setmetatable(o, self)
	self.__index = self
	o.Base = CreateFrame("Frame", o.Name .. "Xparky", UIParent)
	o:CreateTextures()
	o:Length(100)
	o:Breadth(o.Thick)
	return o
end

function BasicSection:Length(Size)
	if self.Rotate == 0 or self.Rotate == 180 then
		if not Size then
			return self.Base:GetWidth()
		end
		self.Base:SetWidth(Size)
	else
		if not Size then 
			return self.Base:GetHeight()
		end
		self.Base:SetHeight(Size)
	end
end

function BasicSection:Breadth(Size)
	if self.Rotate == 0 or self.Rotate == 180 then
		if not Size then
			return self.Base:GetHeight()
		end
		self.Base:SetHeight(Size)
	else
		if not Size then
			return self.Base:GetWidth()
		end
		self.Base:SetWidth(Size)
	end
end

function BasicSection:SetStrata()
	self.Base:SetFrameStrata(Strata[self.Strata])
end

function BasicSection:RotateBar(deg, texture)
	
	local coords = angles[deg]
	
	texture:SetTexCoord(coords[1], coords[2], coords[3], coords[4], coords[5], coords[6], coords[7], coords[8] )
end

function BasicSection:CreateTextures()
	local tex = self.Base:CreateTexture(self.Name .. "Texture", "ARTWORK")
	tex:SetTexture(self.TextureFile)
	tex:ClearAllPoints()
	tex:SetParent(self.Base)
	tex:SetAllPoints(self.Base)
	tex:Show()
	self.Texture = tex
	return 
end

function BasicSection:SetColour()
	if self.Colours then
		self.Texture:SetVertexColor(self.Colours.Red, self.Colours.Green, self.Colours.Blue, self.Colours.Alpha)
	end
end

function BasicSection:Update()
	self:SetColour()
end

function BasicSection:ConstructBar(BarAnchorFrom, BarAnchorTo, Attached, First)
	Xparky:Print("Constructing Bar "..self.Name.." "..BarAnchorFrom.." to "..BarAnchorTo.." on "..Attached:GetName())
	self:SetColour()
	self:RotateBar(self.Rotate, self.Texture)
	self.Base:ClearAllPoints()
	self.Base:SetPoint(BarAnchorFrom, Attached, First and BarAnchorFrom or BarAnchorTo)
	self.Base:SetParent(Attached)
	self.Base:Show()
end
