local defaultBar = {}

local reg = LibStub("AceConfigRegistry-3.0")
local event = LibStub("AceEvent-3.0")
local Strata = { "BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG", "FULLSCREEN", "FULLSCREEN_DIALOG", "TOOLTIP" }
local angles = {[180] = { 1,0,1,1,0,0,0,1}, [0] = {0,1,0,0,1,1,1,0}, [270] = {1,1,0,1,1,0,0,0}, [90] = {0,0,1,0,0,1,1,1}}



local Connections = {	["bottom"] = {"TOPLEFT", "BOTTOMLEFT"},
						["top"] = { "BOTTOMLEFT", "TOPLEFT"},
						["left"] = { "TOPRIGHT", "TOPLEFT"},
						["right"] = { "TOPLEFT", "TOPRIGHT"},
						[0] = { "LEFT", "RIGHT" },
						[90] = { "TOP", "BOTTOM" },
						[180] = { "RIGHT", "LEFT"},
						[270] = { "BOTTOM", "TOP"}
					}


Xparky.BaseBar = {
	Options = {}
}

local defaults = {
	Attached = "left",
	Xoffset = 0,
	Yoffset = 0,
	Rotate = 0,
	BarLength = 600,
	BarBreadth = 8,
	Spark = 1,
	Attach = "UIParent",
}

local BaseBar = Xparky.BaseBar

function BaseBar:Length(Size)
	if self.db.Rotate == 0 or self.db.Rotate == 180 then
		if not Size then
			return self.Anchor:GetWidth()
		end
		self.Anchor:SetWidth(Size)
	else
		if not Size then 
			return self.Anchor:GetHeight()
		end
		self.Anchor:SetHeight(Size)
	end
	self.db.BarLength = Size
end

function BaseBar:Breadth(Size)
	if self.db.Rotate == 0 or self.db.Rotate == 180 then
		if not Size then
			return self.Anchor:GetHeight()
		end
		self.Anchor:SetHeight(Size)
	else
		if not Size then
			return self.Anchor:GetWidth()
		end
		self.Anchor:SetWidth(Size)
	end
	self.db.BarBreadth = Size
end

function BaseBar:SetupDefaults(db)
	Xparky:Print("Setting up defaults on "..self.Name)
	for k,v in pairs(defaults) do
		if(not db[k]) then
			db[k] = v
		end
	end
end

function BaseBar:ConstructBar()
	local Attached = nil

	local FrameAnchorFrom, FrameAnchorTo
	local BarAnchorFrom, BarAnchorTo, x, y
	
	FrameAnchorFrom = Connections[self.db.Attached][1]
	FrameAnchorTo = Connections[self.db.Attached][2]
	BarAnchorFrom = Connections[self.db.Rotate][1]
	BarAnchorTo = Connections[self.db.Rotate][2]

	-- Adjust the width of all the sections according to bar type and values
	
	if not self.Anchor then
		self.Anchor = CreateFrame("Frame", self.Name.."XparkyAnchor", UIParent)
		self.Anchor.Bar = self
		self.Anchor:EnableMouse(true)
		self.Anchor:RegisterForDrag("LeftButton")
		self.Anchor:SetMovable(true)
		self.Anchor:SetScript("OnDragStart", function(self)
				self:StartMoving()
		end)
		self.Anchor:SetScript("OnDragStop", function(self)
				self:StopMovingOrSizing()
				self.Bar:SavePoint()
		end)
		self:SetupOptions()
	end
	
	-- Reattach to parent anchor correctly
	self.Anchor:ClearAllPoints()
	Attached = self.db.Attach and getglobal(self.db.Attach) or nil
	self.Anchor:SetParent(Attached or UIParent)
	if Attached then
		if Attached == UIParent then
			if tonumber(self.db.Xoffset) > 0 and tonumber(self.db.Yoffset) > 0 then
				self.Anchor:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", tonumber(self.db.Xoffset) or 0, tonumber(self.db.Yoffset) or 0)
			else
				self.Anchor:SetPoint("CENTER", UIParent)
			end
		else
			self.Anchor:SetPoint(FrameAnchorFrom, Attached, FrameAnchorTo, tonumber(self.db.Xoffset) or 0, tonumber(self.db.Yoffset) or 0)
		end
	end
	
	Attached = self.Anchor
	self:Update()
	-- Attach each section according to orientation
	for i, Bar in ipairs(self.Sections) do
		if Attached == self.Anchor then -- If we're attaching the first section
			Bar:ConstructBar(BarAnchorFrom, BarAnchorTo, Attached, true) -- attach to the base background bar
		else
			Bar:ConstructBar(BarAnchorFrom, BarAnchorTo, Attached) -- attach to the end of the previous section
		end
		Attached = Bar.Base
	end
end

function BaseBar:SavePoint()
	if self.Anchor:GetParent() == UIParent then
		self.db.Xoffset, self.db.Yoffset = self.Anchor:GetLeft(), self.Anchor:GetBottom()
	end
end

function BaseBar:Update()
	-- Update the section colours
	self.Sections[1].Spark = self.db.Spark
	
	for _,section in ipairs(self.Sections) do
		section:Update()
		section:Breadth(self.db.BarBreadth)
	end
	

	self:Breadth(self.db.BarBreadth)

	local Attached = self.db.Attach and getglobal(self.db.Attach) or nil
	if Attached and Attached ~= UIParent then
		if self.db.Rotate == 0 or self.db.Rotate == 180 then
			self.db.BarLength = Attached:GetWidth()
		else
			self.db.BarLength = Attached:GetHeight()
		end
	end

	self:Length(self.db.BarLength)
	self.Sections[2].Base:SetFrameLevel(self.Sections[1].Base:GetFrameLevel() - 1)
	self.Anchor:SetFrameLevel(self.Sections[#self.Sections].Base:GetFrameLevel() + 1)
end

function BaseBar:SetupOptions()

self.Options = {
					type = "group",
					handler = self,
					name = self.Name,
					set = function(info,v) 
							Xparky:Print("Setting "..info.arg.." on "..info.handler.Name.." to "..v)
							info.handler.db[info.arg] = v;
							info.handler:ConstructBar()
							if info.type ~= "range" then
								reg:NotifyChange("Xparky")
							end
						end,
					get = function(info) return info.handler.db[info.arg] end,
					args = {
						barname = {
							type = "header",
							order = 1,
							name = self.Name
						},
						width = {
							type = "range",
							name = "Bar Length",
							desc = "How long the bar is",
							min = 0.1, max = 2000, step = 1,
							arg = "BarLength",
							hidden = function(info) return info.handler.db.Attach and info.handler.db.Attach ~= "UIParent" end,
							order = 2,
						},
						spacer = {
							type = "description",
							name = "",
							desc = "",
							hidden = function(info) return not info.handler.db.Attach or info.handler.db.Attach == "" end,
							order = 2,
						},
						thickness = {
							type = "range",
							name = "Bar Thickness",
							desc = "How thick the bar is",
							min = 0.1, max = 32, step = 0.5,
							arg = "BarBreadth",
							order = 3
						},
						spark = {
							type = "range",
							name = "Spark intensity",
							desc = "Alpha of the spark",
							min = 0, max = 1, step = 0.05,
							arg = "Spark",
							order = 4,
						},
						rotation = {
							type = "select",
							name = "Bar Rotation",
							desc = "Angle at which the bar runs",
							values = {[0] = 0, [90] = 90, [180] = 180, [270] = 270},
							order = 5,
							arg = "Rotate"
						},
						label = {
							type = "toggle",
							name = "Show Label",
							desc = "Show the bar label",
							arg = "ShowLabel",
						},
						attach = {
							type = "execute",
							name = "Attach to frame",
							func = function(info) mouser.bar = info.handler; mouser:Start(info.handler.Rotate) end,
							order = 6,
						},
						attached = {
							type = "input",
							name = "Attached to frame",
							arg = "Attach",
							order = 7,
						},
						side = {
							type = "select",
							name = "Side of frame",
							arg = "Attached",
							hidden = function(info) return info.handler.db.Attach and info.handler.db.Attach ~= "" end,
							values = function(info) if info.handler.Rotate == 90 or info.handler.Rotate == 270 then return { left = "Left", right = "Right" } else return {top = "Top", bottom = "Bottom" } end end,
						},
						xoffset = {
							type = "input",
							name = "X offset",
							desc = "Offset from the frame in the X axis",
							arg = "Xoffset",
							order = 8,
							hidden = function(info) return not info.handler.db.Attach or info.handler.db.Attach == "" end,
						},
						yoffset = {
							type = "input",
							name = "Y offset",
							desc = "Offset from the frame in the Y axis",
							arg = "Yoffset",
							order = 9,
							hidden = function(info) return not info.handler.db.Attach or info.handler.db.Attach == "" end,
						},
						colours = {
							type = "group",
							inline = true,
							name = "Colours",
							desc = "Colours of the sections",
							order = 10,
							get = function(info)
									local t = info.handler.Colours[info.arg] or { Red = 1, Green = 1, Blue = 1, Alpha = 1}
									return t.Red, t.Green, t.Blue, t.Alpha
									end,
							set = function(info, r, g ,b, a)
									local t = info.handler.Colours[info.arg]
									if not Xparky.db.profile.Bars[info.handler.Name].Colours then 
										Xparky.db.profile.Bars[info.handler.Name].Colours = {}
									end
									if not Xparky.db.profile.Bars[info.handler.Name].Colours[info.arg] then 
										Xparky.db.profile.Bars[info.handler.Name].Colours[info.arg] = {} 
									end
									local dbt = Xparky.db.profile.Bars[info.handler.Name].Colours[info.arg]
									t.Red, t.Green, t.Blue, t.Alpha = r, g, b, a
									dbt.Red, dbt.Green, dbt.Blue, dbt.Alpha = r, g, b, a
									info.handler:ConstructBar()
									end,
							args = {}
						},
						delete = {
							type = "execute",
							name = "Delete Bar",
							desc = "Delete this bar",
							func = function(info) 
										Xparky.db.profile.Bars[info.handler.Name] = nil
										Xparky.Bars[info.handler.Name].Anchor:Hide()
										Xparky.Bars[info.handler.Name] = nil
										Xparky:GenerateBarList()
									end,
						},
					}
				}

end

