Xolpass_dirs = {"N", "N2", "E", "E2", "S", "S2", "W", "W2", "p", "p2", "p3", "o", "o2", "o3"};
XolpassOptions = {}

function Xolpass_SlashHandler(msg)
    if string.find(strlower(msg), "toggle") then
        if XolpassOptionsForm:IsShown() then
        	XolpassOptionsForm:Hide();
            DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Xolpass|r: Is hidden...");
        else
            XolpassOptionsForm:Show();
        	DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Xolpass|r: Is shown...");
        end
    elseif string.find(strlower(msg), "%d%d,%d%d") then
        DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Xolpass|r: Destination set to - "..msg);
        Xolpass_SetDestinationExecute = true;
        Xolpass_SetDestinationValue = (msg);
    elseif string.find(strlower(msg), "clear") then
        Xolpass_SetDestinationExecute = nil;
        DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Xolpass|r: Destination cleared.");
    else
        DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Xolpass|r Commands:");
        DEFAULT_CHAT_FRAME:AddMessage("|cffcccc00toggle|r - Toggles the option window.");
        DEFAULT_CHAT_FRAME:AddMessage("|cffcccc00xx,xx|r - Sets a destination and displays it on the compass.");
        DEFAULT_CHAT_FRAME:AddMessage("|cffcccc00clear|r - Clears your custom destination.");
        DEFAULT_CHAT_FRAME:AddMessage("|cffcccc00(blank)|r - Displays this.");
    end
end

function Xolpass_OnLoad()
    -- Slash commands
    SlashCmdList["XOLPASS"] = Xolpass_SlashHandler;
    SLASH_XOLPASS1 = "/xolpass";
	SLASH_XOLPASS2 = "/xp";

	DEFAULT_CHAT_FRAME:AddMessage("Xolpass loaded.");
    
    this:RegisterEvent("VARIABLES_LOADED");

	-- Code borrowed from SimpleCompass and modified.
	-- Create a table of all the Minimap's children objectSimpleCompass_Saved.
	local children = {Minimap:GetChildren()};

	for i=getn(children), 1, -1 do
		-- Iterate over them all, starting from the end of the list to see if the object reference is a model.
		-- If it is, and it has no name (in case some addon attached a model to it), it's probably the right one.
		if children[i]:IsObjectType("Model") and not children[i]:GetName() then
			-- Found, setting as the addon's local to keep the reference.
			minimapPlayerModel = children[i];
			return;
		end
	end
end

function Xolpass_CheckVariables()
    if event == "VARIABLES_LOADED" then
        if not Xolpass_Destination then
            Xolpass_Destination = 0;
        end
        if not XolpassPing then
            Xolpass_Ping = 0;
            XolpassPing = {};
            XolpassPing.x = 0;
            XolpassPing.y = 0;
        end
        if XolpassOptions.IsHidden then
            this:Hide();
            XolpassOptionsFormHidden:SetChecked(1);
        else
            XolpassOptionsFormHidden:SetChecked(nil);
            this:Show();
        end
        if XolpassOptions.IsLocked then
            XolpassOptionsFormLocked:SetChecked(1);
        else
            XolpassOptionsFormLocked:SetChecked(nil);
        end
        if XolpassOptions.GetWidth then
            XolpassOptionsFormSliderWidth:SetValue(XolpassOptions.GetWidth);
            XolpassOptionsFormSliderWidthText:SetText("Width: "..XolpassOptions.GetWidth)
            XolpassForm:SetWidth(XolpassOptions.GetWidth);
        else
            XolpassOptionsFormSliderWidth:SetValue(360);
            XolpassOptionsFormSliderWidthText:SetText("Width: "..360)
            XolpassForm:SetWidth(360);
        end
        if XolpassOptions.GetAlpha then
            XolpassOptionsFormSliderAlpha:SetValue(XolpassOptions.GetAlpha);
            XolpassOptionsFormSliderAlphaText:SetText("Alpha: "..floor(XolpassOptions.GetAlpha*100))
            XolpassForm:SetAlpha(XolpassOptions.GetAlpha);
        else
            XolpassOptionsFormSliderAlpha:SetValue(360);
            XolpassOptionsFormSliderAlphaText:SetText("Alpha: "..100)
            XolpassForm:SetAlpha(1);
        end
        if XolpassOptions.Arrow then
            if XolpassOptions.Arrow == "N" then XolpassOptionsSetArrow = "North" else XolpassOptionsSetArrow = "South" end
            XolpassOptionsFormArrow:SetChecked(XolpassOptions.Arrow);
            XolpassOptionsFormArrowText:SetText("Pointing "..XolpassOptionsSetArrow);
        end
    end
end

function Xolpass_ProcessPing()
    if event == "MINIMAP_PING" then
        Xolpass_PingTimerStart = 1;
        XolpassPing = {};
        XolpassPing.x = arg2;
        XolpassPing.y = arg3;
        XolpassPing.who = arg1;
        XolpassPing.Execute = true;
        XolpassFormp:Show();
        XolpassFormp2:Show();
        XolpassFormp3:Show();
        DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Xolpass|r: "..UnitName(XolpassPing.who).." pinged the minimap.");
    end
end

function Xolpass_ShowPing()
    if XolpassPing.Execute then
        local x, y = XolpassPing.x, XolpassPing.y; 
        local modifier = 8;
        
    	if x < 0 and y < 0 then Xol_ping = 90-modifier+atan((y)/(x)); end
        if x < 0 and y > 0 then Xol_ping = 90-modifier+atan((y)/(x)); end
        if x > 0 and y < 0 then Xol_ping = 270-modifier+atan((y)/(x)); end
        if x > 0 and y > 0 then Xol_ping = 270-modifier+atan((y)/(x)); end
        Xolpass_Ping = Xol_ping;
    else
        Xolpass_PingTimerStart = 0;
        XolpassFormp:Hide();
        XolpassFormp2:Hide();
        XolpassFormp3:Hide();
    end
    if Xolpass_PingTimerStart > 0 then
        Xolpass_PingTimerStart = Xolpass_PingTimerStart + 1;
        --DEFAULT_CHAT_FRAME:AddMessage(Xolpass_PingTimerStart);
    end
    if Xolpass_PingTimerStart > 360 then
        Xolpass_PingTimerStart = 0;
        XolpassPing.Execute = false;
    end
end

function Xolpass_GetFacing()
	return math.deg(minimapPlayerModel:GetFacing());
end

function Xolpass_MoveDir(which)
	local framename = "XolpassForm";
	if which:GetName() == framename.."S" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180, 1);
	end
	if which:GetName() == framename.."E" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180-90, 1);
	end 
	if which:GetName() == framename.."N" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180-90-90, 1);
	end
	if which:GetName() == framename.."W" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180-90-90-90, 1);
	end
	if which:GetName() == framename.."S2" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180+90+90+90+90, 1);
	end
	if which:GetName() == framename.."E2" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180+90+90+90, 1);
	end 
	if which:GetName() == framename.."N2" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180+90+90, 1);
	end  
	if which:GetName() == framename.."W2" then
		which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-180+90, 1);
	end
   	if which:GetName() == framename.."o" then
   	   which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()+360-Xolpass_Destination, 1);
   	end
   	if which:GetName() == framename.."o2" then
   	   which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-Xolpass_Destination, 1);
   	end
   	if which:GetName() == framename.."o3" then
   	   which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-360-Xolpass_Destination, 1);
   	end
	if which:GetName() == framename.."p" then
	   which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()+360-Xolpass_Ping, 1);
	end
	if which:GetName() == framename.."p2" then
	   which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-Xolpass_Ping, 1);
	end
	if which:GetName() == framename.."p3" then
	   which:SetPoint("CENTER", XolpassForm, "CENTER", Xolpass_GetFacing()-360-Xolpass_Ping, 1);
	end
end

function Xolpass_HideDir()
	for i=1, getn(Xolpass_dirs) do
    	if getglobal("XolpassForm"..Xolpass_dirs[i]):GetLeft() > XolpassForm:GetLeft()+2 and getglobal("XolpassForm"..Xolpass_dirs[i]):GetRight() < XolpassForm:GetRight()-2 then
		    if Xolpass_dirs[i] == "o" or Xolpass_dirs[i] == "o2" or Xolpass_dirs[i] == "o3" then
	            if Xolpass_SetDestinationExecute then
	               getglobal("XolpassForm"..Xolpass_dirs[i]):Show();
	            end
            else
                getglobal("XolpassForm"..Xolpass_dirs[i]):Show();
            end
        else
			getglobal("XolpassForm"..Xolpass_dirs[i]):Hide();
		end
    end
end

function Xolpass_HideArrow()
    if not XolpassOptions.Arrow then
        Xolpass_Arrow = "N";
    else
        Xolpass_Arrow = XolpassOptions.Arrow;
    end
    if Xolpass_Arrow == "N" then
        local leftdiff = XolpassFormLArrow:GetLeft() - getglobal("XolpassForm"..Xolpass_Arrow):GetRight();
        local rightdiff = getglobal("XolpassForm"..Xolpass_Arrow.."2"):GetLeft() - XolpassFormRArrow:GetRight();
        if leftdiff > rightdiff then
            XolpassFormLArrow:Hide();
            XolpassFormRArrow:Show();
        else
            XolpassFormLArrow:Show();
            XolpassFormRArrow:Hide();
        end
    else
        if XolpassFormCenter:GetCenter() < XolpassFormS:GetCenter() then
            XolpassFormLArrow:Hide();
            XolpassFormRArrow:Show();
        else
            XolpassFormLArrow:Show();
            XolpassFormRArrow:Hide();
        end
    end
end

function Xolpass_SetDestination(destination)
    local x = strsub(destination, 1, 2);
    local y = strsub(destination, 4, 5);
	local px, py = GetPlayerMapPosition("player");
    --local left, top = WorldMapDetailFrame:GetLeft(), WorldMapDetailFrame:GetTop();
	--local width = WorldMapDetailFrame:GetWidth();
	--local height = WorldMapDetailFrame:GetHeight();
	--local scale = WorldMapDetailFrame:GetEffectiveScale();
	--local cx = (x/scale - left) / width;
	--local cy = (top - y/scale) / height;
	--if cx < px and cy < py then Xol_dir = 90-atan((cy-py)/(cx-px)); end
    --if cx < px and cy > py then Xol_dir = 90-atan((cy-py)/(cx-px)); end
    --if cx > px and cy < py then Xol_dir = 270-atan((cy-py)/(cx-px)); end
    --if cx > px and cy > py then Xol_dir = 270-atan((cy-py)/(cx-px)); end
    local cx = tonumber(x)/100;
	local cy = tonumber(y)/100;
	local relx = cx-px;
	local rely = cy-py;
	if cx < px and cy < py then Xol_dir = 90-atan(rely/relx); end
    if cx < px and cy > py then Xol_dir = 90-atan(rely/relx); end
    if cx > px and cy < py then Xol_dir = 270-atan(rely/relx); end
    if cx > px and cy > py then Xol_dir = 270-atan(rely/relx); end
    XolpassFormPositions:SetText(string.format("Player: %.1f,%.1f Destination: %.0f,%.0f Direction: %.0f", 100*px, 100*py, 100*cx, 100*cy, Xol_dir));
    Xolpass_Destination = Xol_dir;
    if cx > px-0.005 and cx < px+0.005 and cy > py-0.005 and cy < py+0.005 then
        DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00Xolpass|r: You have arrived at destination - "..100*cx..","..100*cy);
        Xolpass_SetDestinationExecute = nil;
        XolpassFormPositions:SetText("No destination set.");
    end
end

function XolpassFrame_OnMouseUp(self, button, down)

	-- Check the button used
	if (button == "RightButton") then
		XolpassOptionsForm:Show();
	end

end;