----------------------------
--      Declaration       --
----------------------------

local AceOO = AceLibrary("AceOO-2.0")
local dewdrop = AceLibrary("Dewdrop-2.0")
local BC = LibStub("LibBabble-Class-3.0"):GetLookupTable()
local SEA = AceLibrary("SpecialEvents-Aura-2.0")
local L = AceLibrary("AceLocale-2.2"):new("XRS")
local crayon = LibStub("LibCrayon-3.0")

XRS.buff = AceOO.Class("AceDebug-2.0", "AceEvent-2.0")

----------------------------
--      Main Functions    --
----------------------------

function XRS.buff.prototype:init(pos, data)
	-- Call Superclass
	XRS.buff.super.prototype.init(self)

	-- Debugging state
	self:SetDebugging(false)

	-- Save data
	self.data = data
	self.pos = pos

	-- group init
	if not self.data.group then
		self.data.group = {}
		for i=1,8 do
			self.data.group[i] = true
		end
	end

	if not self.data.invertBuff then
		self.data.invertBuff = false
	end

	self.buffRaidPosition = 1

	-- Register Events
	self:RegisterEvent("SpecialEvents_UnitBuffGained", "BuffGained")
	self:RegisterEvent("SpecialEvents_UnitBuffLost", "BuffLost")
	self:RegisterEvent("SpecialEvents_AuraRaidRosterUpdate", "RaidRosterUpdate")
	
	self.rru = "XRS_BuffClass-" .. math.random()
	self:ScheduleRepeatingEvent(self.rru, self.RaidRosterUpdate, 1, self)

	-- Create the visual bar
	self:CreateBuff()

	-- Fill the table
	self:UpdateBuffTable()
end

function XRS.buff.prototype:Disable()
	self:RemoveBuff()

	self:Debug(self.data.buffs[1], "unregistered")
end

function XRS.buff.prototype:CreateBuff()
	-- The button
	self.button = CreateFrame("Button", "XRSBuffButton"..self.pos, XRS.frame, "SecureActionButtonTemplate")
	self.button:Hide()
	self.button:SetWidth(20)
	self.button:SetHeight(20)
	local  _,_,tmpicon = GetSpellInfo(self.data.buffs[1])
	if (tmpicon == nil) then
		if (self.data.buffs[1] == GetSpellInfo(1459)) then
			_,_,tmpicon = GetSpellInfo(1459)
		elseif (self.data.buffs[1] == GetSpellInfo(1243)) then
			_,_,tmpicon = GetSpellInfo(1243)
		elseif (self.data.buffs[1] == GetSpellInfo(1126)) then
			_,_,tmpicon = GetSpellInfo(1126)
		elseif (self.data.buffs[1] == GetSpellInfo(14752)) then
			_,_,tmpicon = GetSpellInfo(14752)
		elseif (self.data.buffs[1] == GetSpellInfo(976)) then
			_,_,tmpicon = GetSpellInfo(976)
		elseif (self.data.buffs[1] == GetSpellInfo(20217)) then
			_,_,tmpicon = GetSpellInfo(20217)
		elseif (self.data.buffs[1] == GetSpellInfo(19977)) then
			_,_,tmpicon = GetSpellInfo(19977)
		elseif (self.data.buffs[1] == GetSpellInfo(19740)) then
			_,_,tmpicon = GetSpellInfo(19740)
		elseif (self.data.buffs[1] == GetSpellInfo(1038)) then
			_,_,tmpicon = GetSpellInfo(1038)
		elseif (self.data.buffs[1] == GetSpellInfo(20911)) then
			_,_,tmpicon = GetSpellInfo(20911)
		elseif (self.data.buffs[1] == GetSpellInfo(19742)) then
			_,_,tmpicon = GetSpellInfo(19742)
		elseif (self.data.buffs[1] == GetSpellInfo(25782)) then
			_,_,tmpicon = GetSpellInfo(25782)
		elseif (self.data.buffs[1] == GetSpellInfo(25894)) then
			_,_,tmpicon = GetSpellInfo(25894)
		elseif (self.data.buffs[1] == GetSpellInfo(25890)) then
			_,_,tmpicon = GetSpellInfo(25890)
		elseif (self.data.buffs[1] == GetSpellInfo(25895)) then
			_,_,tmpicon = GetSpellInfo(25895)
		elseif (self.data.buffs[1] == GetSpellInfo(25899)) then
			_,_,tmpicon = GetSpellInfo(25899)
		elseif (self.data.buffs[1] == GetSpellInfo(25898)) then
            _,_,tmpicon = GetSpellInfo(25898)
		end					
	end
	self.button:SetNormalTexture(tmpicon or "Interface\\Icons\\INV_ValentinesCandy")
	local bc = self
	self.button:SetScript("PreClick", function(self, button, down)
		if ( IsShiftKeyDown() and arg1 == "LeftButton" ) then
			bc:PrintMissingBuffs()
		elseif ( IsControlKeyDown() and arg1 == "LeftButton") then
			bc.tooltip:Close()
			bc.tooltip:Detach()
		elseif ( arg1 == "LeftButton" ) then
			if InCombatLockdown() then return end
			local spell = bc.data.buffs[1]
			local unit = bc:GetBuffUnit(spell)
			if unit then
				self:SetAttribute("type", "spell")
				self:SetAttribute("spell", spell)
				self:SetAttribute("unit", unit)
				
				XRS:Print(string.format("%s: %s", crayon:Silver(UnitName(unit)), crayon:Orange(spell)))
			end
		end
	end)
	self.button:SetScript("PostClick", function(self, button, down)
		if InCombatLockdown() then return end
		self:SetAttribute("spell", nil)
		self:SetAttribute("unit", nil)
		self:SetAttribute("type", nil)
	end)

	-- The tooltip
	self.tooltip = XRS.bufftooltip:new(self)

	-- the string count
	self.count = self.button:CreateFontString("$parentCount","ARTWORK","GameFontNormalSmall")
	self.count:SetWidth(20)
	self.count:SetHeight(20)
	self.count:SetFont(self.count:GetFont(),10,"OUTLINE")
	self:UpdateFontColor()
	self.count:SetPoint("CENTER", self.button, "CENTER", 0, 0)
	self.count:Show()

	local yposition = ((math.floor(self.pos / 5))*22)+8
	local xposition = (math.fmod(self.pos,5)*22)+10

	self.button:SetPoint("BOTTOMLEFT", XRS.frame, "BOTTOMLEFT", xposition, yposition)

	-- Register dewdrop
	dewdrop:Register(self.button, 'children', function(level, value) self:CreateDDMenu(level, value) end)

	self:RegisterBinding(self.data.keybinding)

	self.button:Show()

	self:Debug(self.data.buffs[1], "created")
end

function XRS.buff.prototype:GetBuffUnit(spell)
	local bt = self:GetBuffTable()
	local unit
	
	if self.buffRaidPosition >= 40 then self.buffRaidPosition = 1 end
	
	for i=self.buffRaidPosition, 40 do
		local raidID = "raid"..i
		self.buffRaidPosition = i
		if bt[raidID] == false and UnitIsVisible(raidID) and (IsSpellInRange(spell, raidID)==1) then
			local _, class = UnitClass(raidID)
			local _, _, subgroup, _, _, _, _, online, isDead = GetRaidRosterInfo(i)
			if self:IsGroup(subgroup) and self:IsClass(class) then
				unit = raidID
				self.buffRaidPosition = i + 1
				break
			end
		end
	end
	
	return unit
end

-------------------------------------------------------------------------------
-- Keybindings inspired by rabbit                                            --
-------------------------------------------------------------------------------

function XRS.buff.prototype:ValidateBinding(combo)
	return AceLibrary("AceConsole-2.0").keybindingValidateFunc(combo)
end

function XRS.buff.prototype:RegisterBinding(combo)
	if not combo then return end

	if not self:ValidateBinding(combo) then
		self:Print(string.format(L["%s is not a valid keybinding."], "|cffd9d919"..combo.."|r"))
		return
	end

	local comboCopy = combo
	self.data.keybinding = comboCopy
	SetBindingClick(comboCopy, self.button:GetName())
end

function XRS.buff.prototype:ClearBinding()
	if not self.data.keybinding then return end

	SetBinding(self.data.keybinding)

	XRS:Print(string.format(L["Removing keybinding for button %s."], "|cffd9d919"..self.data.buffs[1].."|r"))
	self.data.keybinding = nil
end

function XRS.buff.prototype:RemoveBuff()
	-- Remove everything
	self:UnregisterAllEvents()
	self:CancelScheduledEvent(self.rru)

	local registered = dewdrop:IsRegistered(self.button)
	if registered then 
		dewdrop:Close()
		dewdrop:Unregister(self.button) 
	end
	self.button:Hide()
	self.count:Hide()
	self.count = nil
	self.button = nil
end


function XRS.buff.prototype:BuffGained(unitid, buff)
	local id = select(3, unitid:find("^raid(%d+)$"))
	if id then
		buff = strtrim(buff)
		if self:InBuffTable(buff) then
			--self:Debug("gain", id, buff, UnitName(unitid))
			self.bufftable[unitid] = true
			self.count:SetText(self:GetMissingBuffCount())
			self.tooltip:Refresh()
		end
	end
end

function XRS.buff.prototype:BuffLost(unitid, buff)
	local id = select(3, unitid:find("^raid(%d+)$"))
	if id then
		buff = strtrim(buff)
		if self:InBuffTable(buff) then
			--self:Debug("lost", id, buff, UnitName(unitid))
			self.bufftable[unitid] = false
			self.count:SetText(self:GetMissingBuffCount())
			self.tooltip:Refresh()
		end
	end
end

function XRS.buff.prototype:RaidRosterUpdate()
	self.count:SetText(self:GetMissingBuffCount())
end

function XRS.buff.prototype:InBuffTable(buff)
	for _,v in ipairs(self.data.buffs) do
		if v == buff then
			return true
		end
	end
	return false
end

function XRS.buff.prototype:UpdateBuffTable()
	-- The table to store the values
	self.bufftable = {}

	for i=1,40 do
		local raidID = "raid"..i
		local _, class = UnitClass(raidID)
		local _, _, subgroup, _, _, _, _, online, isDead = GetRaidRosterInfo(i)
		if UnitExists(raidID) and online and self:IsGroup(subgroup) and self:IsClass(class) and self:UnitHasBuff(raidID) then
			self.bufftable[raidID] = true
		else
			self.bufftable[raidID] = false
		end
	end
	self.count:SetText(self:GetMissingBuffCount())
end

function XRS.buff.prototype:GetMissingBuffCount()
	local count = 0
	for k,v in pairs(self.bufftable) do
		local id = select(3, k:find("^raid(%d+)$"))
		local class = select(2, UnitClass(k))
		local subgroup, _, _, _, _, online, isDead = select(3, GetRaidRosterInfo(id))
		if (not v and not self.data.invertBuff) or (v and self.data.invertBuff) then
			if (self.data.unitIsVisible and UnitIsVisible(k)) or (not self.data.unitIsVisible) then 
				if UnitExists(k) and online and not isDead and self:IsGroup(subgroup) and self:IsClass(class) then
					count = count + 1
				end
			end
		end
	end
	return count
end

function XRS.buff.prototype:UnitHasBuff(raidID)
	for _,v in pairs(self.data.buffs) do
		if SEA:UnitHasBuff(raidID, v) then
			return true
		end
	end
	return false
end

function XRS.buff.prototype:CreateDDMenu(level, value)
	-- Create drewdrop menu
	if level == 1 then
		dewdrop:AddLine( 'text', self.data.buffs[1], 'isTitle', true )
		dewdrop:AddLine('text', L["Buff_Text"],
						'hasArrow', true,
						'value', "buff",
						'tooltipTitle', L["Buff_TTTitle"],
						'tooltipText', L["Buff_TTText"]
						)
		dewdrop:AddLine('text', L["Classes"],
						'hasArrow', true,
						'value', "classes",
						'tooltipTitle', L["Classes_TTTitle"],
						'tooltipText', L["Classes_TTText"]
						)
		dewdrop:AddLine( 'text', L["Groups"],
						 'hasArrow', true,
						 'value', "groups",
						 'tooltipTitle', L["Groups_TTTitle"],
						 'tooltipText', L["Groups_TTText"]
						)
		dewdrop:AddLine('text', L["Keybinding"],
						'hasArrow', true,
						'hasEditBox', true,
						'editBoxText', self.data.keybinding,
						'editBoxIsKeybinding', true,
						'editBoxFunc', function(name)
							if (name==nil) then
								self:ClearBinding()
							else
								self:RegisterBinding(name)
							end
						end,
						'tooltipText', L["Set the Keybinding for the button"]
						)
		dewdrop:AddLine('text', L["Invert"],
						'checked', self.data.invertBuff,
						'func', function() 
							self.data.invertBuff = not self.data.invertBuff
							self:UpdateFontColor()
							self.count:SetText(self:GetMissingBuffCount())
						end)
		dewdrop:AddLine('text', L["UnitIsVisible"],
						'checked', self.data.unitIsVisible,
						'func', function() 
							self.data.unitIsVisible = not self.data.unitIsVisible
							self.count:SetText(self:GetMissingBuffCount())
						end)
		dewdrop:AddLine()
		dewdrop:AddLine('text', L["Delete_Buff_Text"],
						'func', function()
								self:DeleteBuff()
							end,
						'tooltipTitle', L["Delete_Buff_TTTitle"],
						'tooltipText', L["Delete_Buff_TTText"]
						)
	elseif level == 2 then
		if value == "buff" then
			dewdrop:AddLine('text', L["Predefined_Text"],
							'hasArrow', true,
							'value', "predefined",
							'tooltipTitle', L["Predefined_TTTitle"],
							'tooltipText', L["Predefined_TTText"]
							)
			local editBoxText = self.data.buffs[2] and "" or self.data.buffs[1]
			dewdrop:AddLine(
							'text', L["Enter_Buff"],
							'hasArrow', true,
							'hasEditBox', true,
							'editBoxFunc', function(name)
								self:ChangeBuff({name})
							end,
							'editBoxText', editBoxText,
							'tooltipTitle', L["Enter_Buff_TTTitle"],
							'tooltipText', L["Enter_Buff_TTText"]
							)
		elseif value == "classes" then
			local isChecked
			isChecked = self:IsClass("druid")
			dewdrop:AddLine('text', BC["Druid"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("druid") end)
			isChecked = self:IsClass("hunter")
			dewdrop:AddLine('text', BC["Hunter"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("hunter") end)
			isChecked = self:IsClass("mage")
			dewdrop:AddLine('text', BC["Mage"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("mage") end)
			isChecked = self:IsClass("paladin")
			dewdrop:AddLine('text', BC["Paladin"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("paladin") end)
			isChecked = self:IsClass("priest")
			dewdrop:AddLine('text', BC["Priest"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("priest") end)
			isChecked = self:IsClass("rogue")
			dewdrop:AddLine('text', BC["Rogue"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("rogue") end)
			isChecked = self:IsClass("Shaman")
			dewdrop:AddLine('text', BC["Shaman"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("shaman") end)
			isChecked = self:IsClass("warlock")
			dewdrop:AddLine('text', BC["Warlock"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("warlock") end)
			isChecked = self:IsClass("warrior")
			dewdrop:AddLine('text', BC["Warrior"],
							'checked', isChecked,
							'func', function() self:AddRemoveClass("warrior") end)
		elseif value == "groups" then
			for i=1,8 do
				local isChecked
				local number = i
				isChecked = self:IsGroup(number)
				dewdrop:AddLine( 'text', L["Group"].." "..number,
								 'checked', isChecked,
								 'func', function() self:AddRemoveGroup(number) end)
			end
		end
	elseif level == 3 then
		if value == "predefined" then
			-- AI/AB
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(1459),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(1459) and self.data.buffs[2] == GetSpellInfo(23028),
							'func', function() self:ChangeBuff({GetSpellInfo(1459), (GetSpellInfo(23028))}) end)
			-- Fort
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(1243),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(1243) and self.data.buffs[2] == GetSpellInfo(21562),
							'func', function() self:ChangeBuff({GetSpellInfo(1243), (GetSpellInfo(21562))}) end)
			-- Mark
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(1126),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(1126) and self.data.buffs[2] == GetSpellInfo(21849),
							'func', function() self:ChangeBuff({GetSpellInfo(1126), (GetSpellInfo(21849))}) end)
			-- Spirit
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(14752),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(14752) and self.data.buffs[2] == GetSpellInfo(27681),
							'func', function() self:ChangeBuff({GetSpellInfo(14752), (GetSpellInfo(27681))}) end)
			-- Shadow Protection
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(976),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(976) and self.data.buffs[2] == GetSpellInfo(27683),
							'func', function() self:ChangeBuff({GetSpellInfo(976), (GetSpellInfo(27683))}) end)
			-- Kings
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(20217),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(20217) and self.data.buffs[2] == GetSpellInfo(25898),
							'func', function() self:ChangeBuff({GetSpellInfo(20217), (GetSpellInfo(25898))}) end)
			-- Light
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(19977),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(19977) and self.data.buffs[2] == GetSpellInfo(25890),
							'func', function() self:ChangeBuff({GetSpellInfo(19977), (GetSpellInfo(25890))}) end)
			-- Might
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(19740),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(19740) and self.data.buffs[2] == GetSpellInfo(25782),
							'func', function() self:ChangeBuff({GetSpellInfo(19740), (GetSpellInfo(25782))}) end)
			-- Salv
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(1038),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(1038) and self.data.buffs[2] == GetSpellInfo(25895),
							'func', function() self:ChangeBuff({GetSpellInfo(1038), (GetSpellInfo(25895))}) end)
			-- Sanct
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(20911),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(20911) and self.data.buffs[2] == GetSpellInfo(25899),
							'func', function() self:ChangeBuff({GetSpellInfo(20911), (GetSpellInfo(25899))}) end)
			-- Wisdom
			dewdrop:AddLine('text', L["Group"] .. GetSpellInfo(19742),
							'isRadio', true,
							'checked', self.data.buffs[1] == GetSpellInfo(19742) and self.data.buffs[2] == GetSpellInfo(25894),
							'func', function() self:ChangeBuff({GetSpellInfo(19742), (GetSpellInfo(25894))}) end)
		end
	end
end

function XRS.buff.prototype:ChangeBuff(buff)
	self.data.buffs = {}
	for k,v in pairs(buff) do
		self.data.buffs[k] = v
	end
	local  _,_,tmpicon = GetSpellInfo(self.data.buffs[1])
	if (tmpicon == nil) then
		if (self.data.buffs[1] == GetSpellInfo(1459)) then
			_,_,tmpicon = GetSpellInfo(1459)
		elseif (self.data.buffs[1] == GetSpellInfo(1243)) then
			_,_,tmpicon = GetSpellInfo(1243)
		elseif (self.data.buffs[1] == GetSpellInfo(1126)) then
			_,_,tmpicon = GetSpellInfo(1126)
		elseif (self.data.buffs[1] == GetSpellInfo(14752)) then
			_,_,tmpicon = GetSpellInfo(14752)
		elseif (self.data.buffs[1] == GetSpellInfo(976)) then
			_,_,tmpicon = GetSpellInfo(976)
		elseif (self.data.buffs[1] == GetSpellInfo(20217)) then
			_,_,tmpicon = GetSpellInfo(20217)
		elseif (self.data.buffs[1] == GetSpellInfo(19977)) then
			_,_,tmpicon = GetSpellInfo(19977)
		elseif (self.data.buffs[1] == GetSpellInfo(19740)) then
			_,_,tmpicon = GetSpellInfo(19740)
		elseif (self.data.buffs[1] == GetSpellInfo(1038)) then
			_,_,tmpicon = GetSpellInfo(1038)
		elseif (self.data.buffs[1] == GetSpellInfo(20911)) then
			_,_,tmpicon = GetSpellInfo(20911)
		elseif (self.data.buffs[1] == GetSpellInfo(19742)) then
			_,_,tmpicon = GetSpellInfo(19742)
		elseif (self.data.buffs[1] == GetSpellInfo(25782)) then
			_,_,tmpicon = GetSpellInfo(25782)
		elseif (self.data.buffs[1] == GetSpellInfo(25894)) then
			_,_,tmpicon = GetSpellInfo(25894)
		elseif (self.data.buffs[1] == GetSpellInfo(25890)) then
			_,_,tmpicon = GetSpellInfo(25890)
		elseif (self.data.buffs[1] == GetSpellInfo(25895)) then
			_,_,tmpicon = GetSpellInfo(25895)
		elseif (self.data.buffs[1] == GetSpellInfo(25899)) then
			_,_,tmpicon = GetSpellInfo(25899)
		elseif (self.data.buffs[1] == GetSpellInfo(25898)) then
            _,_,tmpicon = GetSpellInfo(25898)
		end					
	end
	self.button:SetNormalTexture(tmpicon or "Interface\\Icons\\INV_ValentinesCandy")
	self:UpdateBuffTable()
end

function XRS.buff.prototype:DeleteBuff()
	self:RemoveBuff()
	XRS:DeleteBuff(self)
end

function XRS.buff.prototype:SetPosition(pos)
	self.pos = pos-1

	local yposition = ((math.floor(self.pos / 5))*22)+8
	local xposition = (math.fmod(self.pos,5)*22)+10

	self.button:SetPoint("BOTTOMLEFT", XRS.frame, "BOTTOMLEFT", xposition, yposition)
end

function XRS.buff.prototype:GetObject()
	return self.button
end

function XRS.buff.prototype:GetType()
	return "button"
end

function XRS.buff.prototype:GetBuffs()
	return self.data.buffs
end

function XRS.buff.prototype:GetBuffTable()
	return self.bufftable
end

function XRS.buff.prototype:ToString()
	return self.data.buffs[1]
end

function XRS.buff.prototype:IsClass(class)
	if not class then return false end
	for _,v in ipairs(self.data.c) do
		if v:lower() == class:lower() then return true end
	end
	return false
end

function XRS.buff.prototype:IsGroup(group)
	return self.data.group[group]
end

function XRS.buff.prototype:AddRemoveClass(class)
	self:Debug("Class: "..class)
	if self:IsClass(class) then
		self:Debug("Remove: "..class)
		self:RemoveClass(class)
	else
		self:Debug("Add: "..class)
		self:AddClass(class)
	end
	self:UpdateBuffTable()
end

function XRS.buff.prototype:AddRemoveGroup(group)
	self.data.group[group] = not self.data.group[group]
	self:UpdateBuffTable()
end

function XRS.buff.prototype:RemoveClass(class)
	for k,v in ipairs(self.data.c) do
		if v:lower() == class:lower() then
			table.remove(self.data.c, k)
		end
	end
end

function XRS.buff.prototype:AddClass(class)
	table.insert(self.data.c, class)
end

function XRS.buff.prototype:PrintMissingBuffs()
	if not IsRaidLeader() and not IsRaidOfficer() then 
		XRS:Print("Need Leader/Admin rights to do this!")
	else
		local t = {}
		for k,v in pairs(self.bufftable) do
			local id = select(3, k:find("^raid(%d+)$"))
			local class = select(2, UnitClass(k))
			local subgroup, _, _, _, _, online, isDead = select(3, GetRaidRosterInfo(id))
			if (self.data.unitIsVisible and UnitIsVisible(k)) or (not self.data.unitIsVisible) then 
				if v == false and UnitExists(k) and online and not isDead and self:IsGroup(subgroup) and self:IsClass(class) then
					local name = UnitName(k)
					table.insert(t, name)
				end
			end
		end
		
		local count = table.getn(t)
		local name = self:ToString()
		
		if (count==0) then self:RaidOutput(string.format("%s :: "..L["Full buffed!"], name)) return end
		if (count>0) then self:RaidOutput(string.format("%s :: "..count..L[" missing."], name)) end
		
		self:RaidOutput(table.concat(t, ", "))
	end
end

function XRS.buff.prototype:RaidOutput(msg)
	SendChatMessage(msg, "RAID")
end

-- Cast a buff on a specified person
function XRS.buff.prototype:BuffPerson(id, spells)
	local selfCast = GetCVar("autoSelfCast")
	SetCVar("autoSelfCast", "0")
	local initialTarget = UnitName("target")
	local isEnemy = UnitIsEnemy("player","target")

	ClearTarget()
	if IsShiftKeyDown() then
		CastSpellByName(spells[2])
	else
		CastSpellByName(spells[1])
	end
	if UnitIsVisible(id) and SpellCanTargetUnit(id) then
		XRS:Print(string.format("%s: %s", crayon:Silver(UnitName(id)), crayon:Orange(spells[2] or spells[1])))
		SpellTargetUnit(id)
	end

	if SpellIsTargeting() then SpellStopCasting() end
	XRS:ReTarget(initialTarget, isEnemy)
	SetCVar("autoSelfCast", selfCast)
end

function XRS.buff.prototype:UpdateFontColor()
	if self.data.invertBuff then
		self.count:SetTextColor(0.2,0.9,0.2)
	else
		self.count:SetTextColor(0.9,0.4,0.4)
	end
end

function XRS.buff.prototype:SetWidth(width)
	local buffcount = math.floor(width/22)
	local yposition = ((math.floor(self.pos / buffcount))*22)+8
	local xposition = (math.fmod(self.pos,buffcount)*22)+10

	self.button:SetPoint("BOTTOMLEFT", XRS.frame, "BOTTOMLEFT", xposition, yposition)
end

