--This is the internal name of the mod.
local XBARMOD="XPortalBar";
local dbver="1";

--Default settings and other info about the mod
XBarModData[XBARMOD]={
	----REQUIRED VALUES----
	["nbuttons"]=12,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=false,
	["nchecks"]=0,
	["mchecks"]=false,
	["nsliders"]=0,
	["msliders"]=false,
	["ftexint"]=nil,
	["foptioncb"]=nil,
	["fbuttoncb"]=nil,
	["fbuttonid"]=nil,
};

function XPortalBar_OnLoad()
	--Each bar must catch its own event notifications
	local Class;

	-- Nonlocalized class check
	_, Class = UnitClass("player");
	if (Class == "MAGE") then
		-- For this mod, only mages have portals, so only enable if needed
		XBarModData[XBARMOD]["enabled"]=true;
		this:RegisterEvent("SPELLS_CHANGED");
		this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
	end
end

function XPortalBar_OnEvent()
	local refreshdb=false;

	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "SPELL_UPDATE_COOLDOWN" and XBarPlayerName) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	end
end