----------------------------------------------------------------------
-- X-Perl EMotion: Adds event-driven animations to the 3D portraits --
----------------------------------------------------------------------
-- This is an extension to X-Perl and it does nothing useful, but it
-- will make the character portraits a bit more alive.
--
-- You will see all 3D unit portraits react to different events, e.g.:
--   * get up on login or resurection,
--   * talking, shouting, waving on chat messages,
--   * casting,
--   * stumble back on taking a hit or drop dead when they die.
-- No configuration options, just try it.
--
-- This code demonstrates the idea, but is far from perfect.
-- Feedback and code improvements are welcome.
--
-- There are some difficult limitations: The animations are not exact
-- and will never look as good as the real characters, the camera
-- position is not optimal, there is not always the (correct)
-- animation on an event, animations do not have the right duration.
--
-- Most important limitation:
-- Some animations will flicker, even if the model supports it!
--   (btw: If the model does not support the specific animation, this
--    will also flicker, because it is not checked in this code :-)
-------------------------------------------------------------------
-- v0.2	first release (MIT License)
-- v0.3 discarded! tried to adapt to XPerl 2.2.9 frame changes; added pet frame
-- v0.4 replaced the dying detection for new combat log in patch 2.4; 
--      added code to display dead animation for dead units; fixed channeling
-- v0.5 experiments with camera positioning
-- v0.6 reverted camera code! It causes more problems than it solves;
--      started to blacklist broken animations.
-- v0.6a added orc and undead female, fewer combat animations, cleaned some code
--
-------------------------------------------------------------------
-- Copyright (c) 2007-2008 Ghost (account on curse.com)
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this software and associated documentation files (the "Software"), to deal
-- in the Software without restriction, including without limitation the rights
-- to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
-- copies of the Software, and to permit persons to whom the Software is
-- furnished to do so, subject to the following conditions:
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
-- OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
-- THE SOFTWARE.
-------------------------------------------------------------------

local debugmode = false;
local events = {
 		"CHAT_MSG_SAY",
		"CHAT_MSG_YELL",
		"CHAT_MSG_PARTY",
		"CHAT_MSG_WHISPER",
		"CHAT_MSG_CHANNEL",
		"CHAT_MSG_GUILD",
		"CHAT_MSG_OFFICER",
		"UNIT_PORTRAIT_UPDATE",
    "COMBAT_LOG_EVENT",   -- CHAT_MSG_COMBAT_FRIENDLY_DEATH replaced in 2.4.0 with COMBAT_LOG_EVENT 
		"UNIT_COMBAT",
		"UNIT_SPELLCAST_START",
		"UNIT_SPELLCAST_STOP",
		"UNIT_SPELLCAST_CHANNEL_START",
		"UNIT_SPELLCAST_CHANNEL_STOP",
		"UNIT_SPELLCAST_SUCCEEDED",
		}

function XPerl_EMotion_Register(self)
	for i,event in pairs(events) do
		self:RegisterEvent(event)
	end
	self:SetScript("OnEvent", XPerl_EMotion_OnEvent)
	self:SetScript("OnAnimFinished", XPerl_EMotion_OnAnimFinished)
	self:SetScript("OnUpdateModel", XPerl_EMotion_OnUpdateModel)
 	if self.Iunit == "target" then
		self:RegisterEvent("PLAYER_TARGET_CHANGED")
	elseif self.Iunit == "focus" then
		self:RegisterEvent("PLAYER_FOCUS_CHANGED")
	elseif self.Iunit == "player" then
		self:RegisterEvent("PLAYER_CAMPING")
		self:RegisterEvent("PLAYER_LEVEL_UP")
		self:RegisterEvent("PLAYER_UNGHOST")
	end
end

-- Start to wait for login
function XPerl_EMotion_RegisterInit(self)
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:SetScript("OnEvent", XPerl_EMotion_OnEvent)
end

--function XPerl_EMotion_Unregister(self)
--	for i,event in pairs(events) do
--		self:UnregisterEvent(event)
--	end
--	self:SetScript("OnUpdate", nil)
--end

function XPerl_EMotion_checkBlacklist(self, sequence)
  local mod = self:GetModel();
  if (type(mod) ~= "string") then
    return false;
  elseif (strfind(mod, "basiliskoutland") and (sequence == 6 or sequence == 1)) then
    return false;
  elseif (strfind(mod, "epicdruidflight")) then
    return false;
  elseif (strfind(mod, "stormcrowdruid")) then
    return false;
  elseif (strfind(mod, "gnomefemale") and sequence == 186) then
    return 208;
  elseif (strfind(mod, "bloodelffemale") and sequence == 208) then
    return 64;
  elseif (strfind(mod, "draenei") and sequence == 1) then
    return 6; -- male and female
  elseif (strfind(mod, "dwarfmale") and sequence == 1) then
    return 6;
--  elseif (strfind(mod, "bloodelffemale") and (sequence == 70 or sequence == 9)) then
--    return false; -- animation would be offscreen
--  elseif (strfind(mod, "nightelffemale") and sequence == 51) then
--    return 52; -- animation would be offscreen
  elseif (strfind(mod, "nightelf")) then
    return sequence;
  elseif (strfind(mod, "gnome")) then
    return sequence;
  elseif (strfind(mod, "dwarf")) then
    return sequence;
  elseif (strfind(mod, "draenei")) then
    return sequence;
  elseif (strfind(mod, "tauren")) then
    return sequence;
  elseif (strfind(mod, "human")) then
    return sequence;
  elseif (strfind(mod, "bloodelf")) then
    return sequence;
  elseif (strfind(mod, "orc")) then
    return sequence;
  elseif (strfind(mod, "scourge")) then
    return sequence;
  elseif (strfind(mod, "troll")) then
    return sequence;
  end
  if (debugmode and sequence ~= 1 and sequence ~= 6 and sequence ~= 9 and sequence ~= 10) then
    DEFAULT_CHAT_FRAME:AddMessage("DEBUG XPerl_EMotion_checkBlackList "..sequence.." "..self.Iunit.." "..self:GetModel());
  end
  return sequence;
end

function XPerl_EMotion_mote(self, sequence)	-- start animation
	sequence = XPerl_EMotion_checkBlacklist(self, sequence);
  if (sequence) then
    self.Ienabled = 1
    self.Iseqnumber = sequence
    self.Iseqtime = 0
    self.Ielapsed = nil
  end
end

--test animation sequence on target portrait
function xperl_mt(sequence)
	local FrameName = getglobal("XPerl_TargetportraitFrameportrait3D")
	XPerl_EMotion_mote(FrameName, sequence);
end

function XPerl_EMotion_RegisterFrame(frame, unit, optionName)
  --DEFAULT_CHAT_FRAME:AddMessage("DEBUG XPerl_EMotion_RegisterFrame "..frame);
	local function Setup(self, unit, sts)
		self.Iunit = unit
		self.Ienabled = 0
		self.Iseqnumber = 0
		self.Iseqtime = 0
		self.Icasting = 0
		self.Iloaded = true;
		--self.Idefer = false;
		self.Iduration = false;
	end

	local frameName = frame.."portraitFrameportrait3D"
	local targetFrame = getglobal(frameName)
	
	if targetFrame == nil then 
		DEFAULT_CHAT_FRAME:AddMessage("XPerl_EMotion error. Something went wrong with the frame "..frameName);
	else
	  if (targetFrame.Iunit) then
	   DEFAULT_CHAT_FRAME:AddMessage("XPerl_EMotion warning. Duplicate init for frame "..frameName);
	  else
  		Setup(targetFrame, unit, 0)
  		XPerl_EMotion_Register(targetFrame)

  		frameName = frame.."portraitFrame"
  		targetFrame = getglobal(frameName)
  		targetFrame:SetScale(1.1)	-- OPTIONAL zoom each hooked portrait a little bit :-)
    end 
	end
end

--------------------------------------------------
--
-- Event/Update Handlers
--
--------------------------------------------------

function XPerl_EMotion_OnEvent(self, event, newarg1)
	if event == "COMBAT_LOG_EVENT" then
	  if arg2 == "PARTY_KILL" or arg2 == "UNIT_DIED" then
	    if UnitName(self.Iunit) then
        if UnitName(self.Iunit) == arg7 then
          XPerl_EMotion_mote(self, 1)	-- 1,"Death" (7),0,768,500,8,0,
        elseif UnitName(self.Iunit) == arg4 then  -- killing blow?
          XPerl_EMotion_mote(self, 73)	-- EMOTERUDE=73, maybe EMOTEFLEX
        end
      end
    end
	elseif strsub(event, 1, 8) == "CHAT_MSG" then
		-- arg1 chat message	arg2 author	arg3 language
		if arg2 == UnitName(self.Iunit) then
			arg1 = string.lower(arg1);	-- Not tested if arg1 can be changed without a problem
			local anim = 208;	-- 208,"EmoteTalkNoSheathe" (2249),0,264,"Stand" (1),3,60,
			if event == "CHAT_MSG_YELL" then
				anim = 81	-- 81,"EmoteShout" (837),16,264,"Stand" (1),3,0,
			elseif strsub(arg1, 1, 2) == "ye" or strsub(arg1, 1, 2) == "ja" or strsub(arg1, 1, 1) == "+" then
				anim = 185	-- 185,"EmoteYes" (2000),0,0,0,"Stand" (1),0,
			elseif strsub(arg1, 1, 2) == "no" or strsub(arg1, 1, 2) == "ne" or strsub(arg1, 1, 1) == "-" then
				anim = 186	-- 186,"EmoteNo" (2009),0,0,0,3,0,
			elseif strsub(arg1, 1, 4) == "haha" or strsub(arg1, 1, 4) == "hihi" or strsub(arg1, 1, 3) == "lol" then
				anim = 70	-- 70,"EmoteLaugh" (715),16,264,"Stand" (1),3,0,
			elseif strsub(arg1, 1, 2) == "ha" or strsub(arg1, 1, 2) == "hi" then
				anim = 67	-- 67,"EmoteWave" (683),16,264,2,3,0,
			elseif strsub(arg1, 1, 2) == "gz" or strsub(arg1, 1, 4) == "grat" or strsub(arg1, 1, 6) == "congra" then
				anim = 80	-- 80,"EmoteApplaud" (824),16,264,"Stand" (1),"Stand" (1),0,
			elseif strsub(arg1, 1, 5) == "aggro" or strsub(arg1, 1, 3) == "add" then
				anim = 84	-- 84,"EmotePoint" (867),16,264,"Stand" (1),3,0,
			elseif strfind(arg1, "?") then
				anim = 65	-- 65,"EmoteTalkQuestion" (656),16,264,"Stand" (1),"Stand" (1),0,
			elseif strfind(arg1, "!") then
				anim = 64	-- 64,"EmoteTalkExclamation" (635),16,264,"Stand" (1),3,0,
			end
			XPerl_EMotion_mote(self, anim)
		end
	elseif event == "PLAYER_UNGHOST" then
		self.Iloaded = true;	-- delay until the portrait is loaded
	elseif event == "PLAYER_TARGET_CHANGED"
		or event == "PLAYER_FOCUS_CHANGED" then
		self.Ienabled = 0;
		if UnitIsDeadOrGhost(self.Iunit) == 1 then
		  XPerl_EMotion_mote(self, 6)
		end
	elseif arg1 == self.Iunit then   -- test unit events only if they match to this unit frame
		--XPerl_ShowMessage("unit evt");
		if event == "UNIT_PORTRAIT_UPDATE" then
			if self.Iloaded then
				self.Iloaded = false;
				XPerl_EMotion_mote(self, 101)	-- 101,"SleepUp" (1049),0,1280,"Stand" (1),18,99,
				if (debugmode) then
          XPerl_PlayernameFrametext:SetText("");	-- OPTIONAL delete my own player name in XPerl, I know my name
        end
				--self:SetCamera(0)   -- OPTIONAL set to character or portrait camera
			end
		elseif event == "PLAYER_CAMPING" then	-- don't know when this event fires
			XPerl_ShowMessage("Camping event fired");
			XPerl_EMotion_mote(self, 96)	-- 96,"SitGroundDown" (997),16,256,"Stand" (1),0,0,
		elseif event == "PLAYER_LEVEL_UP" then
			XPerl_ShowMessage();
			XPerl_EMotion_mote(self, 68)	-- 68,"EmoteCheer" (693),16,256,"Stand" (1),3,0,
		elseif event == "UNIT_COMBAT" then
			if arg2 == "WOUND" then
				--XPerl_ShowMessage();
				-- this event occurs a lot, so limit it
				if self.Ienabled ~= 1 or self.Iseqtime > 1500 then
  				if arg3 == "CRITICAL" then
	   				XPerl_EMotion_mote(self, 10);	-- 10,"CombatCritical" (66),0,296,20,"Death" (7),9,
  				elseif arg3 == "GLANCING" then
  				  -- do nothing
          elseif arg3 == "CRUSHING" then
  				  XPerl_EMotion_mote(self, 121); -- 121,"Knockdown" (1276),0,"Swim" (384),50,10,0,
          else
	   				XPerl_EMotion_mote(self, 9);	-- 9,"CombatWound" (54),0,296,20,"Death" (7),8,
  				end
  			end
  		end
--		elseif event == "UNIT_ATTACK" then
--			XPerl_ShowMessage();
--			XPerl_EMotion_mote(self, 17);	-- 17,"Attack1H" (151),32,296,20,3,16,   -- 17 does NOT WORK
		elseif event == "UNIT_SPELLCAST_START" then
			XPerl_EMotion_mote(self, 52)	-- 52,"ReadySpellOmni" (487),4,256,"Stand" (1),2,31,
			self.Icasting = 1;
		elseif event == "UNIT_SPELLCAST_CHANNEL_START" then
			XPerl_EMotion_mote(self, 51)	-- 51,"ReadySpellDirected" (468),4,256,"Stand" (1),2,52,
      -- FIXED: channeled spells fire CHANNEL_START, CAST_SUCCEEDED, a lot of CAST_STOP and a CHANNEL_STOP
		elseif event == "UNIT_SPELLCAST_STOP"
			or event == "UNIT_SPELLCAST_CHANNEL_STOP" then
			if self.Icasting ~= 0 then	-- do not stop animation on instant casts, they do not fire an ..CAST_START event
				self.Ienabled = 0;
				self.Icasting = 0;
			end
		elseif event == "UNIT_SPELLCAST_SUCCEEDED" then
			if self.Ienabled == 0 then
				XPerl_EMotion_mote(self, 54)	-- 54,"SpellCastOmni" (520),4,264,20,2,"Dead" (33),
			end
  	elseif event == "PLAYER_ENTERING_WORLD" then
  		if (getglobal("XPerl_PlayerportraitFrameportrait3D").Iunit) then
  		  -- already initialized TODO implement check
  		else
  		  XPerl_ShowMessage();
    		XPerl_EMotion_RegisterFrame("XPerl_Player", "player", false)	-- delayed init
    		XPerl_EMotion_RegisterFrame("XPerl_Target", "target", false)
    		XPerl_EMotion_RegisterFrame("XPerl_Focus", "focus", false)
    		XPerl_EMotion_RegisterFrame("XPerl_party1", "party1", false)
    		XPerl_EMotion_RegisterFrame("XPerl_party2", "party2", false)
    		XPerl_EMotion_RegisterFrame("XPerl_party3", "party3", false)
    		XPerl_EMotion_RegisterFrame("XPerl_party4", "party4", false)
    		XPerl_EMotion_RegisterFrame("XPerl_Player_Pet", "pet", false)
  		end
  		if (debugmode) then
        SetCurrentTitle(-1);	-- OPTIONAL WORKAROUND because WoW switches on my title on every instance zoning...
      end
    end
  else
    --XPerl_ShowMessage();
		-- discard event
	end
end

function XPerl_EMotion_OnAnimFinished(self)		-- does not work unfortunately -- somehow occurs only after :SetModel("Character\\NightElf\\Female\\NightElfFemale.mdx") 
	DEFAULT_CHAT_FRAME:AddMessage("Debug message OnAnimFinished:"..self.Iunit.." "..self.Iseqtime);
	self.Ienabled = 0;
end

function XPerl_EMotion_OnUpdateModel(self)
	if not self:IsShown() then
		return
	end

	if self.Ienabled ~= 1 then
		return
	end

	local elapsed = 0;
	if self.Ielapsed then
		elapsed = GetTime()-self.Ielapsed
	end
	self.Ielapsed = GetTime()

	self.Iseqtime = self.Iseqtime + (elapsed * 800);	-- some slow-motion; 1000 would be correct
	if self.Iseqtime > 5000 then	-- hard coded 5sec. duration, as I do not know the correct value from the model
	  if UnitIsDeadOrGhost(self.Iunit) == nil then
		  self.Ienabled = 0;
		else
		  XPerl_EMotion_mote(self, 6);
		end
	end
	self:SetSequenceTime(self.Iseqnumber, self.Iseqtime);
end

function XPerl_EMotion_OnLoad(self)
	--DEFAULT_CHAT_FRAME:AddMessage("DEBUG XPerl_EMotion_OnLoad");
	XPerl_EMotion_RegisterInit(self)
end