----------------------------------------------------------------------
-- X-Perl EHeal
----------------------------------------------------------------------
-- This is an extension to X-Perl and will display incoming healing
-- data from LibHealComm-3.0
-------------------------------------------------------------------
-- v0.1	Idea present, code missing
-- v0.2	(included lib version 80690) First release, request for comments
--
-------------------------------------------------------------------
-- Copyright (c) 2007-2008 Ghost (account on curse.com)
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this software and associated documentation files (the "Software"), to deal
-- in the Software without restriction, including without limitation the rights
-- to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
-- copies of the Software, and to permit persons to whom the Software is
-- furnished to do so, subject to the following conditions:
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
-- OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
-- THE SOFTWARE.
-------------------------------------------------------------------

local debugmode = true;
local lookAhead = 2.0; -- seconds
local checkInterval = 0.5; -- seconds
local healBars = {};
local HealComm = LibStub:GetLibrary("LibHealComm-3.0");
local raidNeedsUpdate = false;
local lastUpdate = 0;


-- XPerl_EHeal_MakeTexture
local function XPerl_EHeal_MakeTexture(self)
	local tex = XPerl_GetBarTexture()
	self.newlife = self:CreateTexture("A", "ARTWORK")  -- was nil, name is not used, just easier to find in debug output
	self.newlife:SetTexture(tex)
	self.newlife:SetBlendMode("ADD")
	self.newlife:SetVertexColor(1, 1, 0)

	self.newlife:ClearAllPoints()
	self.newlife:SetPoint("RIGHT")
	self.newlife:SetWidth(1)
	self.newlife:SetHeight(self:GetHeight())
	self.newlife:Show()
	
	tex = "Interface\\Addons\\XPerl\\Images\\XPerl_ArcaneBarSpark"   -- needs extra \ to escape \
	self.barSpark = self:CreateTexture("B", "ARTWORK")
	self.barSpark:SetTexture(tex)
	self.barSpark:SetPoint("CENTER", self, "LEFT", 30, 1)
	self.barSpark:SetBlendMode("ADD")
	self.barSpark:Show()
	self.barSpark.startTime = GetTime();	-- spark will show on init
end

-- 1) init heal frame for the given frame if not present
-- 2) set unit for that frame
local function XPerl_EHeal_RegisterFrame(unit, frame)
	if unit == nil then
		return;
	end
	local healthframe = frame.statsFrame.healthBar;
	if healthframe == nil then
		return;
	end
	if healthframe.healFrame then
		healBars[unit] = healthframe.healFrame;
	else
		local bar = CreateFrame("StatusBar", nil, healthframe) -- frame is used as parent
		healthframe.healFrame = bar;
		bar:SetAllPoints()
		bar:Show()
		healthframe:Show()
		healBars[unit] = bar;
		XPerl_EHeal_MakeTexture(bar);
	end
end

local function XPerl_EHeal_RegisterUnit(unit)
	if unit == nil then
		return;
	end 
	local frame = getglobal("XPerl_"..unit);
	if frame == nil then
		return;
	end
	XPerl_EHeal_RegisterFrame(unit, frame)
end

local function XPerl_EHeal_RegisterRaid()
	-- XPerl_Raid_Grp1UnitButton1, ...
	for _, frame in pairs(XPerl_Raid_GetFrameArray()) do
		if (frame:IsVisible()) then
			local unit = frame.partyid
			XPerl_EHeal_RegisterFrame(unit, frame)
		end
	end
end

function ehealstart()
	XPerl_EHeal_RegisterUnit("Player");
	XPerl_EHeal_RegisterUnit("Target");
	XPerl_EHeal_RegisterUnit("Focus");
	XPerl_EHeal_RegisterUnit("party1");
	XPerl_EHeal_RegisterUnit("party2");
	XPerl_EHeal_RegisterUnit("party3");
	XPerl_EHeal_RegisterUnit("party4");
	XPerl_EHeal_RegisterRaid();
	XPerl_EHeal:SetScript("OnUpdate", XPerl_EHeal_OnUpdate)
end

function ehealtest()
	local bar = healBars["Player"];
	if bar then
  	bar.newlife:SetWidth(50);
  	bar.barSpark.startTime = GetTime();
  	bar:Show()
  else
--
  end
end

function gethealbars()
	return healBars;
end

function getlookahead()
	return lookAhead;
end

function setlookahead(seconds)
	lookAhead = seconds;
end

local function XPerl_EHeal_RegisterInit(self) -- self="XPerl_EHeal"
	self:RegisterEvent("PARTY_MEMBERS_CHANGED")
	self:SetScript("OnEvent", XPerl_EHeal_OnEvent)
	self.lastUpdate = 0;
	self:SetParent(getglobal("XPerl_PlayerstatsFrame"))
end

local function XPerl_EHeal_checkHeal(unit, frame)
	local incoming, a, nextTime, b, c = HealComm:UnitIncomingHealGet(unit, GetTime() + lookAhead)
	-- 5247, 0, 171443.555, 5247, "Healer" 
	if incoming and incoming > 0 then
		if nextTime == nil then
			return;
		end
		nextTime = nextTime - GetTime();
		local width = incoming/UnitHealthMax(unit);
		if width > 1 then
			width = 1;
		end
		if nextTime < 0.3 then
			nextTime = 0.3;	-- For surge protection. Check at most 3 times extra per second.
		end
		frame.newlife:SetWidth(frame:GetWidth() * width);
		frame.barSpark.startTime = GetTime()-lookAhead+nextTime;
		frame:Show()
	else
		frame:Hide()
	end
end

--------------------------------------------------
--
-- Event/Update Handlers
--
--------------------------------------------------

function XPerl_EHeal_OnEvent(self, event, newarg1)
--  XPerl_ShowMessage();
	if healBars["Player"] then
		self.raidNeedsUpdate = true;
	else
		ehealstart();
	end
end

function XPerl_EHeal_OnUpdate(self, elapsed)
	self.lastUpdate = self.lastUpdate + elapsed;
	if debugmode or GetNumRaidMembers() > 0 or GetNumPartyMembers() > 0 then  -- LibHealComm only notifies when grouped
		-- move the sparks
		for unit, frame in pairs(healBars) do
			if (frame:IsVisible()) then
				-- no sanity check for those values, be careful
				if (frame.barSpark.startTime + lookAhead > GetTime()) then
					local width = frame:GetWidth();
					local position = (lookAhead-(GetTime()-frame.barSpark.startTime))/lookAhead*width;
					if position < 0 then
						position = 0
					end
					frame.barSpark:SetPoint("CENTER", frame, "LEFT", position, 1)
				else
					XPerl_EHeal_checkHeal(unit, frame);	--heal should have arrived, check for the next one (does this work with lag?)
				end
			end
		end
		-- checks for healing are done every 0.5? sec
		if self.lastUpdate > checkInterval then
			self.lastUpdate = 0;
			if self.raidNeedsUpdate then
				self.raidNeedsUpdate = false;
				-- init and update all raid frames, because some could have moved
				XPerl_EHeal_RegisterRaid();
			end
			-- update healing prophecies for everyone
			for unit, frame in pairs(healBars) do
				if (frame:GetParent():IsVisible()) then
					XPerl_EHeal_checkHeal(unit, frame);
				end
			end
		end
	end
end

function XPerl_EHeal_OnLoad(self)
	XPerl_EHeal_RegisterInit(self)
end
