--This is the internal name of the mod.
local XBARMOD="XConjureBar";
local dbver="1";

--Default settings and other info about the mod
getfenv()["XBarModData"][XBARMOD]={
	----REQUIRED VALUES----
	["nbuttons"]=0,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=false,
	["nchecks"]=0,
	["mchecks"]=false,
	["nsliders"]=0,
	["msliders"]=false,
	["ftexint"]=nil,
	["foptioncb"]=nil,
	["fbuttoncb"]=nil,
	["fbuttonid"]=nil,
};

function XConjureBar_OnLoad()
	--Each bar must catch its own event notifications
	local Class,_;

	-- Nonlocalized class check
	_, Class = UnitClass("player");
	if (Class == "MAGE") then
		-- For this mod, only mages have conjours, so only enable if needed
		getfenv()["XBarModData"][XBARMOD]["enabled"]=true;
		XBarModData[XBARMOD]["nbuttons"],_=XBar_CountSpells(XBARMOD);
		this:RegisterEvent("SPELLS_CHANGED");
		this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
	else
		this:SetScript("OnUpdate",nil);
		-- Reduces lag
	end
end

function XConjureBar_OnEvent()
	local refreshdb=false;

	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "SPELL_UPDATE_COOLDOWN" and getfenv()["XBarPlayerName"]) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "ACTIONBAR_UPDATE_USABLE") then
		XBar_UpdateCooldowns(XBARMOD);
	end
end
