--This is the internal name of the mod.
local XBARMOD="XWarlockBar";
local dbver="3";

--Default settings and other info about the mod
getfenv()["XBarModData"][XBARMOD]={
	----REQUIRED VALUES----
	["nbuttons"]=0,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=false,
	["nchecks"]=1,
	["check1"]="WrapBar",
	["dcheck1"]=false,
	["mchecks"]=false,
	["nsliders"]=0,
	["msliders"]=false,
	["ftexint"]=nil,
	["foptioncb"]=XBARMOD.."_OptionCB",
	["fbuttonid"]=XBARMOD.."_ButtonID",
	["fbuttoncb"]=XBARMOD.."_ButtonCB",
	["forientcb"]=XBARMOD.."_Orient",
};

-- Save some space for information that orient callback function needs
local orientindex,orientrow;

function XWarlockBar_OnLoad()
	local Class,i,v,n,_,h;

	-- Nonlocalized class check
	_, Class = UnitClass("player");
	if (Class == "WARLOCK") then
		--Each bar must catch its own event notifications
		getfenv()["XBarModData"][XBARMOD]["enabled"]=true;
		XBarModData[XBARMOD]["nbuttons"],XBarModData[XBARMOD]["nchecks"]=XBar_CountSpells(XBARMOD);
		this:RegisterEvent("SPELLS_CHANGED");
		this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("BAG_UPDATE");
		this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
	else
		this:SetScript("OnUpdate",nil);
		-- Reduces lag
	end

	n=1;
	for i,v in pairs(getfenv()["XWarlockBarSpells"]) do
		if (v~=" ") then
			n=n+1;
			if (strsub(v,1,1)=="#") then
				--Menu header
				h=strsub(v,2);
				XBarModData[XBARMOD]["mcheck"..n]=h;
				XBarModData[XBARMOD]["check"..n]="";
				XBarModData[XBARMOD]["dcheck"..n]=nil;
			else
				XBarModData[XBARMOD]["check"..n]=v;
				XBarModData[XBARMOD]["dcheck"..n]=true;
			end
		end
	end
	XBarModData[XBARMOD]["nchecks"]=n;
end

function XWarlockBar_OnEvent()
	local refreshdb=false;

	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "SPELL_UPDATE_COOLDOWN" and getfenv()["XBarPlayerName"]) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "BAG_UPDATE" and getfenv()["XBarPlayerName"]) then
		-- Updating on bag update because of the reagents required campfires.
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "ACTIONBAR_UPDATE_USABLE") then
		XBar_UpdateCooldowns(XBARMOD);
	end
end

function XWarlockBar_ButtonID(id,spellname)
	local newid=id;

	if (not getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD][spellname]) then
		newid=nil;
	end

	return newid;
end

function XWarlockBar_OptionCB(option,value)
	XBar_Update(XBARMOD);
end

function XWarlockBar_ButtonCB(button,spellname,index)
	local x;
	if IsConsumableSpell(spellname) then
		x=GetSpellCount(spellname);
		if x==nil then
			x=1;
		end
	else
	    x=1;
	end
	XBar_ShowCount(XBARMOD,index,x);
end

function XWarlockBar_Orient(index,point,anchor,anchorpoint,xdir,ydir,magnitude)
	local pt=point;
	local an=anchor;
	local ap=anchorpoint;
	local xd=xdir;
	local yd=ydir;
	local mag=magnitude;

	-- only change if we need
	if (getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD]["WrapBar"]) then
		local bar=getfenv()["XBARMOD".."Button"..tostring(index)];

		if (index==1) then
			-- save the first button as our reference position
			orientrow=1;
			orientindex=1;
		end

		if (mag == XBAR_SPBIG) and (orientrow > 0) then
			-- This is a new spacer
			orientrow=(orientrow+1) * -1;
		end

		if (orientrow < 1) then
			-- Last button was a spacer, need to wrap
			orientrow=orientrow*-1;
			an=XBARMOD.."Button"..tostring(orientindex);
			orientindex=index;
			if (xd ~= 0) and (yd==0) then
				-- All horizontal bars will expand downwards
				pt="TOP";
				ap="BOTTOM";
				xd=0;
				yd=-1;
				mag=XBAR_SPSMALL;
			elseif (xd==0) and (yd ~= 0) then
				-- All vertical bars will expand to the right
				pt="LEFT";
				ap="RIGHT";
				xd=1;
				yd=0;
				mag=XBAR_SPSMALL;
			else
				-- If we encounter some wierd combination, we will cancel the row increment
				orientrow=orientrow-1;
			end
		end
	end
	return pt,an,ap,xd,yd,mag;
end
