--This is the internal name of the mod.
local XBARMOD="XTradeBar";
local dbver="2";

local specialized=false;
local minors = {2,3,4,7,8,9,10,11,19,20,23,24,25,28,29,30};
local majors = {5,12,21,26,31};

--Default settings and other info about the mod
getfenv()["XBarModData"][XBARMOD]={
	----REQUIRED VALUES----
	["nbuttons"]=17,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=true,
	["nchecks"]=0,
	["nsliders"]=0,
	["msliders"]=false,
	["ftexint"]=nil,
	["foptioncb"]=XBARMOD.."_OptionCB",
	["fbuttoncb"]=nil,
	["fbuttonid"]=XBARMOD.."_ButtonID",
};

function XTradeBar_OnLoad()
	local i,v,h;
	
	--Each bar must catch its own event notifications
	getfenv()["XBarModData"][XBARMOD]["enabled"]=true;
	v,XBarModData[XBARMOD]["nchecks"]=XBar_CountSpells(XBARMOD);
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("BAG_UPDATE");
	this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");

	for i,v in pairs(getfenv()["XTradeBarSpells"]) do
		if (strsub(v,1,1)=="#") then
			--Menu header
			h=strsub(v,2);
			getfenv()["XBarModData"][XBARMOD]["mcheck"..i]=h;
			getfenv()["XBarModData"][XBARMOD]["check"..i]="";
			getfenv()["XBarModData"][XBARMOD]["dcheck"..i]=nil;
		else
			getfenv()["XBarModData"][XBARMOD]["check"..i]=XBar_Spellname(v);
			getfenv()["XBarModData"][XBARMOD]["dcheck"..i]=true;
		end
	end
end

function XTradeBar_OnEvent()
	local refreshdb=false;
	
	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "SPELL_UPDATE_COOLDOWN" and getfenv()["XBarPlayerName"]) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "BAG_UPDATE" and getfenv()["XBarPlayerName"]) then
		-- Updating on bag update because of the reagents required campfires.
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "ACTIONBAR_UPDATE_USABLE") then
		XBar_UpdateCooldowns(XBARMOD);
	end
end

function XTradeBar_ButtonID(id,spellname)
	local newid=id;
	local i,v,sn;
	local ismajor,isminor;

-- Logic flow (assuming a spell is enabled):
--   Always show the minor professions if we see them
--   The presence of a minor profession indicates a specialty
--   If we show a minor, hide the appropriate major.
--   A spell will never be a major and a minor
--   All minor spells will be immediately followed by their corresponding major

	-- If we don't even know the spell in the first place, don't bother testing, as we'll just mess something up.
	if (id==nil) then
		return nil;
	end

	if (not getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD][spellname]) then
		newid=nil;
		-- If someone decided it'd be fun to disable the major spell on their own while having a specialized profession, lets not let it affect the next profession.
		if specialized then
			for i,v in pairs(majors) do
				sn=XBar_Spellname(XTradeBarSpells[v]);
				if (spellname==sn) then
					specialized=false;
					break;
				end
			end
		end
	else
		ismajor=false;
		isminor=false;

		-- Perform checks to see what we have
		for i,v in pairs(minors) do
			sn=XBar_Spellname(XTradeBarSpells[v]);
			if ((spellname==sn) and (newid~=nil)) then
				-- this is a Minor profession (specialty)
				isminor=true;
				if (specialized) then
					-- we found something already, don't show this
					-- This is primarily for weaponsmithing, as there are 2 levels of specialization
					newid=false;
				else
					specialized=true;
				end
				break;
			end
		end

		for i,v in pairs(majors) do
			sn=XBar_Spellname(XTradeBarSpells[v]);
			if (spellname==sn) then
				-- this is a Major profession (unspecialized)
				ismajor=true;
				if specialized then
					-- Hide the main one
					specialized=false;
					newid=nil;
				end
				break;
			end
		end

		-- note that if this is not a major or minor spell, the button will be shown as normal
		if (not ismajor) and (not isminor) then
			-- Reset the specialization attribute for the next profession just in case.
			specialized=false;
		end
	end

	return newid;
end

function XTradeBar_OptionCB(option,value)
	XBar_Update(XBARMOD);
end
