-------------------------------------------------------------------------------
-- English localization (Default)
-- By Dr. Doom
-------------------------------------------------------------------------------

-- Bindings
getfenv()["BINDING_HEADER_XTRADEBAR_TITLE"]  = "XBar";
getfenv()["BINDING_NAME_XTRADEBAR_SHOWHIDE"] = "Show/hide XTradeBar";

-- As of XTradeBar 1.05 (XBar 1.10) or higher, the specialties must come right before their respective tradeskills
-- Note that the master weaponsmithing skills take precedence over the general skill "weaponsmith" and must appear before

-- The idhack meta command is being used to fix the issues with some tradeskills.  Any profession skill that opens the tradeskill window uses it.
-- Improper use of the idhack meta command will cause taint (see xbar\scriptnotes.txt).

-- Tradeskills
getfenv()["XTradeBarSpells"] = {
    "#Alchemy",
	"&idhack&Transmutation Master",
	"&idhack&Potion Master",
	"&idhack&Elixir Master",
	"&idhack&Alchemy",
    "#Blacksmithing",
	"&idhack&Master Swordsmith",
	"&idhack&Master Axesmith",
	"&idhack&Master Hammersmith",
	"&idhack&Armorsmith",
	"&idhack&Weaponsmith",
	"&idhack&Blacksmithing",
    "#Mining",
	"&idhack&Smelting",
    "#Enchanting",
	"&idhack&Enchanting",
	"Disenchant",
    "#Engineering",
	"&idhack&Gnomish Engineer",
	"&idhack&Goblin Engineer",
	"&idhack&Engineering",
    "#Leatherworking",
	"&idhack&Dragonscale Leatherworking",
	"&idhack&Elemental Leatherworking",
	"&idhack&Tribal Leatherworking",
	"&idhack&Leatherworking",
    "#Tailoring",
	"&idhack&Mooncloth Tailoring",
	"&idhack&Spellfire Tailoring",
	"&idhack&Shadoweave Tailoring",
	"&idhack&Tailoring",
    "#Jewelcrafting",
	"&idhack&Jewelcrafting",
	"Prospecting",
    "#Rogue",
	"Poisons",
	"Pick Lock",
	"Pick Pocket",
    "#Secondary",
	"&idhack&First Aid",
	"&idhack&Cooking",
	"Basic Campfire",
	"Fishing",
    "#Tracking",
	"Find Minerals",
	"Find Herbs",
	"Find Treasure",
	"Find Fish",
};


local i,v;

-- Auto-translate the spells
if (GetLocale() ~= "enUS") and (GetLocale() ~= "enGB") then
	if getfenv()["XBARLOCALIZER"] then
		for i,v in pairs(getfenv()["XTradeBarSpells"]) do
			-- We are presuming that everything we need to use the idhack meta command for is a tradeskill, which is not in Babble-Spell, but in Babble-Tradeskill instead
			if strsub(getfenv()["XTradeBarSpells"][i],1,8)=="&idhack&" then
				getfenv()["XTradeBarSpells"][i]="&idhack&"..XBar_BabbleTrade(strsub(getfenv()["XTradeBarSpells"][i],2));
			else
				getfenv()["XTradeBarSpells"][i]=XBar_BabbleSpell(getfenv()["XTradeBarSpells"][i]);
			end
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer not loaded.");
	end
end
