--This is the internal name of the mod.
local XBARMOD="XTrackBar";
local dbver="2";

local ForceTexture;

--Default settings and other info about the mod
getfenv()["XBarModData"][XBARMOD]={
	----REQUIRED VALUES----
	["nbuttons"]=0,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=true,
	["nchecks"]=0,
	["nsliders"]=0,
	["ftexint"]=XBARMOD.."_Texture", --< This is our texture interceptor function
	["foptioncb"]=XBARMOD.."_OptionCB",
	["fbuttonid"]=XBARMOD.."_ButtonID",
};

function XTrackBar_OnLoad()
	--Each bar must catch its own event notifications
	getfenv()["XBarModData"][XBARMOD]["enabled"]=true;
	XBarModData[XBARMOD]["nbuttons"],XBarModData[XBARMOD]["nchecks"]=XBar_CountSpells(XBARMOD);
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("UPDATE_BONUS_ACTIONBAR");
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
	this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");

	for i,v in pairs(getfenv()["XTrackBarSpells"]) do
		getfenv()["XBarModData"][XBARMOD]["check"..i]=v;
		getfenv()["XBarModData"][XBARMOD]["dcheck"..i]=true;
	end
end

function XTrackBar_OnEvent()
	local refreshdb=false,t;
	
	ForceTexture=nil;
	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event=="PLAYER_AURAS_CHANGED") then
		-- Catch the event so we know which one to put up there.
		local icon = GetTrackingTexture();
		if (icon) then
			ForceTexture=icon;
			XBar_UpdateCooldowns(XBARMOD);
		else
			ForceTexture="";
		end
	elseif ((getfenv()["XBarPlayerName"]) and (
		(event == "SPELL_UPDATE_COOLDOWN") or
		 (event == "UPDATE_BONUS_ACTIONBAR")
		 )) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "ACTIONBAR_UPDATE_USABLE") then
		XBar_UpdateCooldowns(XBARMOD);
	end
end

function XTrackBar_Texture(texture, spellname)
	local t=texture;

	-- Will highlight any tracking textures the player has
	if (ForceTexture==texture) then
		t = "Interface\\Icons\\Spell_Nature_WispSplode";
	elseif ((ForceTexture==nil) and (GetTrackingTexture()==texture)) then
		-- We have not caught an aura-update event yet
		t = "Interface\\Icons\\Spell_Nature_WispSplode";
	end
	
	return t;
end

function XTrackBar_ButtonID(id,spellname)
	local newid=id;

	if (not XBarData[getfenv()["XBarOptionSet"]]["mods"][XBARMOD][spellname]) then
		newid=nil;
	end

	return newid;
end

function XTrackBar_OptionCB(option,value)
	XBar_Update(XBARMOD);
end
