-------------------------------------------------------------------------------
-- English localization (Default)
-------------------------------------------------------------------------------

-- Bindings
getfenv()["BINDING_HEADER_XTRACKBAR_TITLE"]  = "XBar";
getfenv()["BINDING_NAME_XTRACKBAR_SHOWHIDE"] = "Show/hide XTrackBar";

-- Tracking Abilities
getfenv()["XTrackBarSpells"] = {
	"Track Beasts",
	"Track Humanoids",
	"Track Undead",
	"Track Hidden",
	"Track Elementals",
	"Track Demons",
	"Track Giants",
	"Track Dragonkin",
	"Find Minerals",
	"Find Herbs",
	"Find Treasure",
	"Find Fish",
	"Sense Undead",
	"Sense Demons",
};

local i,v;

-- Auto-translate the spells
if (GetLocale() ~= "enUS") and (GetLocale() ~= "enGB") then
	if getfenv()["XBARLOCALIZER"] then
		for i,v in pairs(getfenv()["XTrackBarSpells"]) do
			if strsub(getfenv()["XTrackBarSpells"][i],1,1)~=" " then
				getfenv()["XTrackBarSpells"][i]=XBar_BabbleSpell(getfenv()["XTrackBarSpells"][i]);
			end
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer not loaded.");
	end
end
