--This is the internal name of the mod.
local XBARMOD="XTotemBar";
local dbver="0";

--Default settings and other info about the mod
getfenv()["XBarModData"][XBARMOD]={
	----REQUIRED VALUES----
	["nbuttons"]=0,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=false,
	["nchecks"]=2,
	["check1"]="HighlightAuraTotems",
	["dcheck1"]=true,
	["check2"]="WrapBar",
	["dcheck2"]=false,
	["nsliders"]=0,
	["msliders"]=false,
	--sliders will be set up later in the OnLoad procedure.
	["ftexint"]=XBARMOD.."_Texture",
	["foptioncb"]=XBARMOD.."_Option",
	["forientcb"]=XBARMOD.."_Orient",
};

-- Save some space for information that orient callback function needs
local orientindex,orientrow;

function XTotemBar_OnLoad()
	--Each bar must catch its own event notifications
	local Class,_;

	-- Nonlocalized class check
	_, Class = UnitClass("player");
	if (Class == "SHAMAN") then
		-- For this mod, only hunters have these spells, so only enable if needed
		getfenv()["XBarModData"][XBARMOD]["enabled"]=true;
		XBarModData[XBARMOD]["nbuttons"],_=XBar_CountSpells(XBARMOD);
		this:RegisterEvent("SPELLS_CHANGED");
		this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("PLAYER_AURAS_CHANGED");
		this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
	else
		this:SetScript("OnUpdate",nil);
		-- Reduces lag
	end
end

function XTotemBar_OnEvent()
	local refreshdb=false;

	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "SPELL_UPDATE_COOLDOWN" and getfenv()["XBarPlayerName"]) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "PLAYER_AURAS_CHANGED") then
		XBar_Update(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "ACTIONBAR_UPDATE_USABLE") then
		XBar_UpdateCooldowns(XBARMOD);
	end
end

function XTotemBar_Texture(texture,spellname)
	local t = texture;
	local b,z;

	-- Will highlight the totem the player has out (if it is an aura effect)
	for z = 1, 50 do
		b=UnitBuff("player",z);

		if (b==nil) then
			break;
		elseif (b==strsub(spellname,1,strlen(b))) then
			-- We found the spell, lets see if we need to update it.
			if (getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD]["HighlightAuraTotems"]) then
				t = "Interface\\Icons\\Spell_Nature_WispSplode";
			end
		end
	end

	return t;
end

function XTotemBar_Option(option,value)
	-- We only have one option, so no need to check to see which one it is
	-- The value is unimportant as well, as we do the same action either way
	XBar_Update(XBARMOD);
end

function XTotemBar_Orient(index,point,anchor,anchorpoint,xdir,ydir,magnitude)
	local pt=point;
	local an=anchor;
	local ap=anchorpoint;
	local xd=xdir;
	local yd=ydir;
	local mag=magnitude;

	-- only change if we need
	if (getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD]["WrapBar"]) then
		local bar=getfenv()["XBARMOD".."Button"..tostring(index)];

		if (index==1) then
			-- save the first button as our reference position
			orientrow=1;
			orientindex=1;
		end

		if (mag == XBAR_SPBIG) and (orientrow > 0) then
			-- This is a new spacer
			orientrow=(orientrow+1) * -1;
		end

		if (orientrow < 1) then
			-- Last button was a spacer, need to wrap
			orientrow=orientrow*-1;
			an=XBARMOD.."Button"..tostring(orientindex);
			orientindex=index;
			if (xd ~= 0) and (yd==0) then
				-- All horizontal bars will expand downwards
				pt="TOP";
				ap="BOTTOM";
				xd=0;
				yd=-1;
				mag=XBAR_SPSMALL;
			elseif (xd==0) and (yd ~= 0) then
				-- All vertical bars will expand to the right
				pt="LEFT";
				ap="RIGHT";
				xd=1;
				yd=0;
				mag=XBAR_SPSMALL;
			else
				-- If we encounter some wierd combination, we will cancel the row increment
				orientrow=orientrow-1;
			end
		end
	end
	return pt,an,ap,xd,yd,mag;
end
