-------------------------------------------------------------------------------
-- English localization (Default)
-------------------------------------------------------------------------------

-- Bindings
getfenv()["BINDING_HEADER_XTOTEMBAR_TITLE"]  = "XBar";
getfenv()["BINDING_NAME_XTOTEMBAR_SHOWHIDE"] = "Show/hide XTotemBar";

-- Totems
getfenv()["XTotemBarSpells"] = {
	-- Earth Element
	"Stoneskin Totem",
	"Earthbind Totem",
	"Stoneclaw Totem",
	"Strength of Earth Totem",
	"Tremor Totem",
	"Earth Elemental Totem",
	-- Fire Element
	" ",
	"Searing Totem",
	"Fire Nova Totem",
	"Magma Totem",
	"Flametongue Totem",
	"Frost Resistance Totem",
	"Totem of Wrath",
	"Fire Elemental Totem",
	-- Water Element
	" ",
	"Poison Cleansing Totem",
	"Healing Stream Totem",
	"Mana Spring Totem",
	"Fire Resistance Totem",
	"Disease Cleansing Totem",
	"Mana Tide Totem",
	-- Air Element
	" ",
	"Grounding Totem",
	"Nature Resistance Totem",
	"Windfury Totem",
	"Sentry Totem",
	"Windwall Totem",
	"Grace of Air Totem",
	"Tranquil Air Totem",
	"Wrath of Air Totem",
};

local i,v;

-- Auto-translate the spells
if (GetLocale() ~= "enUS") and (GetLocale() ~= "enGB") then
	if getfenv()["XBARLOCALIZER"] then
		for i,v in pairs(getfenv()["XTotemBarSpells"]) do
			if strsub(getfenv()["XTotemBarSpells"][i],1,1)~=" " then
				getfenv()["XTotemBarSpells"][i]=XBar_BabbleSpell(getfenv()["XTotemBarSpells"][i]);
			end
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer not loaded.");
	end
end
