--This is the internal name of the mod.
local XBARMOD="XBuffBar";
local dbver="2";

--Default settings and other info about the mod
XBarModData[XBARMOD]={
	----REQUIRED VALUES----
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=true,
	["nchecks"]=0,
	["nsliders"]=0,
	["ftexint"]=XBARMOD.."_Texture",
	["foptioncb"]=XBARMOD.."_OptionCB",
	["fbuttonid"]=XBARMOD.."_ButtonID",
	["fbuttoncb"]=XBARMOD.."_ButtonCB",
};

function XBuffBar_OnLoad()
	--Each bar must catch its own event notifications
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
	this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");

	local i,v,h;
	local nb=0;
	local mb=0;

	v,i=XBar_CountSpells(XBARMOD);
	XBarModData[XBARMOD]["nchecks"]=i+1; -- Account for the extra check
	XBarModData[XBARMOD]["check1"]="HighlightAuras";
	XBarModData[XBARMOD]["dcheck1"]=true;

	-- Calculate max buttons
	for i,v in pairs(getfenv()["XBuffBarSpells"]) do
		if strsub(getfenv()["XBuffBarSpells"][i],1,1)=="#" then
			if nb>mb then
				mb=nb;
			end
			nb=0;
		else
			nb=nb+1;
		end
	end
	if nb>mb then
		mb=nb;
	end
	XBarModData[XBARMOD]["nbuttons"]=mb;

	for i,v in pairs(getfenv()["XBuffBarSpells"]) do
		if (strsub(v,1,1)=="#") then
			--Menu header
			h=strsub(v,2);
			XBarModData[XBARMOD]["mcheck"..i+1]=h;
			XBarModData[XBARMOD]["check"..i+1]="";
			XBarModData[XBARMOD]["dcheck"..i+1]=nil;
		else
			XBarModData[XBARMOD]["check"..i+1]=v;
			XBarModData[XBARMOD]["dcheck"..i+1]=true;
		end
	end
end

function XBuffBar_OnEvent()
	local refreshdb=false;

	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "PLAYER_AURAS_CHANGED" and getfenv()["XBarPlayerName"]) then
		XBar_Update(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	elseif ((getfenv()["XBarPlayerName"]) and (event == "SPELL_UPDATE_COOLDOWN")) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "ACTIONBAR_UPDATE_USABLE") then
		XBar_UpdateCooldowns(XBARMOD);
	end
end

function XBuffBar_Texture(texture,spellname)
	local t = texture;
	local b,z;

	-- Will highlight any spells that cause a buff
	for z = 1, 50 do
		b=UnitBuff("player",z);

		if (b==nil) then
			break;
		elseif (b==spellname) then
			-- We found the spell
			if (getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD]["HighlightAuras"]) then
				t = "Interface\\Icons\\Spell_Nature_WispSplode";
			end
		end
	end

	return t;
end

function XBuffBar_ButtonID(id,spellname)
	local newid=id;

	if (not getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD][spellname]) then
		newid=nil;
	end

	return newid;
end

function XBuffBar_ButtonCB(button,spellname,index)
	local x;
	if IsConsumableSpell(spellname) then
		x=GetSpellCount(spellname);
		if x==nil then
			x=1;
		end
	else
	    x=1;
	end
	XBar_ShowCount(XBARMOD,index,x);
end

function XBuffBar_OptionCB(option,value)
	XBar_Update(XBARMOD);
end
