-------------------------------------------------------------------------------
-- English localization (Default)
-------------------------------------------------------------------------------

-- Bindings
getfenv()["BINDING_HEADER_XBUFFBAR_TITLE"]  = "XBar";
getfenv()["BINDING_NAME_XBUFFBAR_SHOWHIDE"] = "Show/hide XBuffBar";

-- Most of these buffs affect a party.  Some buffs that only affect the caster are included
-- if the class only has a few of them.  Warlocks and Rogues have so many other abilities
-- they will be in a separate bar.

-- Buffs
getfenv()["XBuffBarSpells"] = {
	-- Druid Buffs (3)
	"#Druid",
	"Omen of Clarity",
	"Mark of the Wild",
	"Gift of the Wild",
	"Thorns",
	-- Hunter buffs (1)
	"#Hunter",
	"Trueshot Aura",
	-- Mage Buffs (11)
	"#Mage",
	"Arcane Intellect",
	"Arcane Brilliance",
	"Fire Ward",
	"Frost Ward",
	"Frost Armor",
	"Ice Armor",
	"Mage Armor",
	"Molten Armor",
	"Mana Shield",
	"Amplify Magic",
	"Dampen Magic",
	-- Pally buffs (15)
	"#Paladin",
	"Blessing of Might",
	"Blessing of Protection",
	"Blessing of Wisdom",
	"Blessing of Freedom",
	"Blessing of Kings",
	"Blessing of Salvation",
	"Blessing of Sanctuary",
	"Blessing of Light",
	"Blessing of Sacrifice",
	"Greater Blessing of Might",
	"Greater Blessing of Wisdom",
	"Greater Blessing of Kings",
	"Greater Blessing of Salvation",
	"Greater Blessing of Sanctuary",
	"Greater Blessing of Light",
	"Righteous Fury",
	-- Priest Buffs (13)
	"#Priest",
	"Shadowform",
	"Inner Fire",
	"Power Word: Fortitude",
	"Divine Spirit",
	"Power Word: Shield",
	"Shadow Protection",
	"Touch of Weakness",
	"Shadowguard",
	"Symbol of Hope",
	"Fear Ward",
	"Prayer of Fortitude",
	"Prayer of Spirit",
	"Prayer of Shadow Protection",
	-- Rogue Buffs (0)
	-- Shaman buffs (11)
	"#Shaman",
	"Rockbiter Weapon",
	"Flametongue Weapon",
	"Frostbrand Weapon",
	"Windfury Weapon",
	"Lightning Shield",
	"Earth Shield",
	"Water Shield",
	"Water Walking",
	"Water Breathing",
	"Bloodlust",
	"Heroism",
	-- Warlock Buffs (5)
	"#Warlock",
	"Demon Skin",
	"Demon Armor",
	"Fel Armor",
	"Unending Breath",
	"Detect Invisibility",
	-- Warrior Buffs (12)
	"#Warrior",
	"Battle Shout",
	"Demoralizing Shout",
	"Intimidating Shout",
	"Challenging Shout",
	"Commanding Shout",
	"Piercing Howl",
	"Spell Reflection",
	"Shield Wall",
	"Last Stand",
	"Intervene",
	"Retaliation",
	"Recklessness",
};

-- Maximum bar size only needs to be 15, since no class will ever have more than that on

local i,v;

-- Auto-translate the spells
if (GetLocale() ~= "enUS") and (GetLocale() ~= "enGB") then
	if getfenv()["XBARLOCALIZER"] then
		for i,v in pairs(getfenv()["XBuffBarSpells"]) do
			if strsub(getfenv()["XBuffBarSpells"][i],1,1)=="#" then
				getfenv()["XBuffBarSpells"][i]="#"..XBar_BabbleClass(strsub(getfenv()["XBuffBarSpells"][i],2));
			else
				getfenv()["XBuffBarSpells"][i]=XBar_BabbleSpell(getfenv()["XBuffBarSpells"][i]);
			end
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer not loaded.");
	end
end

