local addonName = "XBar"

if not cyCircled.modules["XBar"] then

cyCircled_XBar = cyCircled:NewModule(addonName)

function cyCircled_XBar:AddonLoaded()
	self.db = cyCircled:AcquireDBNamespace(addonName)
	cyCircled:RegisterDefaults(addonName, "profile", {
		["Aspect"] = true,
	})
	
	self:SetupElements()
	self:OnEnable()

	local n,i,bn;
	n=XBarData[XBarOptionSet]["nmods"];
	if (n) and n>0 then
		for i=1,n do
			bn=XBarData[XBarOptionSet]["mod"..i];
			if (XBarModData[bn]) and (XBarModData[bn]["enabled"]) then
				XBar_Update(bn);
			end
		end
	end
end

function cyCircled_XBar:GetElements()
	local rt={};
	local i,n,bn;
	
	n=XBarData[XBarOptionSet]["nmods"];
	if (n) and n>0 then
		for i=1,n do
			bn=XBarData[XBarOptionSet]["mod"..i];
			if (XBarModData[bn]) and (XBarModData[bn]["enabled"]) then
				rt[bn]=true;
			end
		end
	else
		return {};
	end

	return rt;
end

function cyCircled_XBar:SetupElements()
	local rt={};
	local i,n,b,c,m;
	
	n=XBarData[XBarOptionSet]["nmods"];
	if (n) and n>0 then
		for i=1,n do
			m=XBarData[XBarOptionSet]["mod"..i];
			if XBarModData[m] and XBarModData[m]["loaded"] then
				rt[m]={
					args = {
						button = { width = 28, height = 28, },
						nt = false,
						ht = true,
						pt = true,
						ct = false,
						ft = false,
						icon=false,
						hotkey=false,
						count = true,
						cooldown=true,
						hotkey = false,
						eborder = false,
						autocast=false,
					},
					elements = {},
				}
				b=XBarModData[m]["nbuttons"];
				if (b) and (b>0) then
					for c=1,b do
						tinsert(rt[m].elements, format(m.."Button%d", c));
					end
				end
			end
		end
	else
		rt={};
	end

	self.elements=rt;
end
end
