local LBS, LBC, LBT;
local locale=GetLocale();

-- This code provides a generalized interface in which to retrieve localizations from Babble.
if not getfenv()["AceLibrary"]:HasInstance("Babble-Spell-2.2") then
	DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer: Babble-Spell failed to load.");
	LBS=nil;
else
	LBS=AceLibrary("Babble-Spell-2.2");
end

if not getfenv()["AceLibrary"]:HasInstance("Babble-Class-2.2") then
	DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer: Babble-Class failed to load.");
	LBC=nil;
else
	LBC=AceLibrary("Babble-Class-2.2");
end

if not AceLibrary:HasInstance("Babble-Tradeskill-2.2") then
	DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer: Babble-Tradeskill failed to load.");
	LBT=nil;
else
	LBT=AceLibrary("Babble-Tradeskill-2.2");
end

-- Set this so mods can see if we're loaded or not
XBARLOCALIZER = true;

if locale == "enUS" or locale == "enGB" then
	-- If using enUS or enGB, flush the database to save memory
	XBarBackupDB={};
else
	if (LBS==nil) and (LBC==nil) and (LBT==nil) then
		-- If all mods loaded ok, flush the database to save memory
		XBarBackupDB={};
	else
		-- This is a non enUS version client, test for the localization existence and flush if not found
		if (XBarBackupDB[locale]==nil) then
			DEFAULT_CHAT_FRAME:AddMessage("XBarLocalizer: Locale '"..locale.."' not found!");
			XBarBackupDB={};
		end
	end
end


function XBar_BabbleSpell(text)
	local r;
	r=text;

	if LBS==nil then
		r=XBarBackupDB[locale][text]
	else
		r=LBS[text];
	end
	-- if we don't have it, just return the same value given
	if r==nil then
		r=text;
	end
	
	return r;
end

function XBar_BabbleClass(text)
	local r;
	r=text;

	if LBC==nil then
		r=XBarBackupDB[locale][text]
	else
		r=LBC[text];
	end
	-- if we don't have it, just return the same value given
	if r==nil then
		r=text;
	end
	
	return r;
end

function XBar_BabbleTrade(text)
	local r;
	r=text;

	if LBT==nil then
		r=XBarBackupDB[locale][text]
	else
		r=LBT[text];
	end
	-- if we don't have it, just return the same value given
	if r==nil then
		r=text;
	end
	
	return r;
end
