--This is the internal name of the mod.
local XBARMOD="XAspectBar";
local dbver="0";

--Default settings and other info about the mod
XBarModData[XBARMOD]={
	----REQUIRED VALUES----
	["nbuttons"]=0,
	["dbver"]=dbver,
	["dhorizontal"]=true,
	["dhidebar"]=false,
	["dorder"]="az",
	["dscale"]=1,
	["dtooltips"]=true,
	["booktype"]=BOOKTYPE_SPELL,
	["enabled"]=false,
	["nchecks"]=0,
	["mchecks"]=false,
	["nsliders"]=0,
	["msliders"]=false,
	--sliders will be set up later in the OnLoad procedure.
	["ftexint"]=XBARMOD.."_Texture",
};

function XAspectBar_OnLoad()
	--Each bar must catch its own event notifications
	local Class,_;

	-- Nonlocalized class check
	_, Class = UnitClass("player");
	if (Class == "HUNTER") then
		-- For this mod, only hunters have aspects, so only enable if needed
		XBarModData[XBARMOD]["enabled"]=true;
		XBarModData[XBARMOD]["nbuttons"],XBarModData[XBARMOD]["nsliders"]=XBar_CountSpells(XBARMOD);
		this:RegisterEvent("SPELLS_CHANGED");
		this:RegisterEvent("SPELL_UPDATE_COOLDOWN");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("PLAYER_AURAS_CHANGED");
		this:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
	else
		this:SetScript("OnUpdate",nil);
		-- Reduces lag
	end

	-- Set up sliders that we missed earlier
	local i,v;

	for i,v in pairs(getfenv()["XAspectBarSpells"]) do
		getfenv()["XBarModData"][XBARMOD]["slider"..i]=v;
		getfenv()["XBarModData"][XBARMOD]["slider"..i.."min"]=0;
		getfenv()["XBarModData"][XBARMOD]["slider"..i.."max"]=6;
		getfenv()["XBarModData"][XBARMOD]["slider"..i.."step"]=1;
		getfenv()["XBarModData"][XBARMOD]["slider"..i.."format"]="%i";
		getfenv()["XBarModData"][XBARMOD]["dslider"..i]=0;
	end
end

function XAspectBar_OnEvent()
	local refreshdb=false;

	-- XBar has built in functionality to update its plugins
	if (event == "SPELLS_CHANGED") then
		XBar_Scale(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "SPELL_UPDATE_COOLDOWN" and getfenv()["XBarPlayerName"]) then
		XBar_UpdateCooldowns(XBARMOD);
	elseif (event == "PLAYER_AURAS_CHANGED") then
		XBar_Update(XBARMOD);
	elseif (event == "PLAYER_ENTERING_WORLD") then
		-- Let XBar know we're here so it can set up our data
		-- Double check just in case XBar hasn't got this yet.
		XBar_BuildPlayerName();
		XBar_RegisterAddon(XBARMOD);
		XBar_Update(XBARMOD);
	elseif (event == "ACTIONBAR_UPDATE_USABLE") then
		XBar_UpdateCooldowns(XBARMOD);
	end
end

function XAspectBar_Texture(texture,spellname)
	local t = texture;
	local b,p,z;

	-- Will highlight the aspect the player has
	for z = 1, 50 do
		b=UnitBuff("player",z);

		if (b==nil) then
			break;
		elseif (b==spellname) then
			-- We found the buff which is an aspect
			t = "Interface\\Icons\\Spell_Nature_WispSplode";

			-- While we're here, lets sneak in some action bar switching
			-- This function cannot be performed in combat.
			if (not InCombatLockdown()) then
				-- Looking for an aspect's defined bar.
				p=getfenv()["XBarData"][getfenv()["XBarOptionSet"]]["mods"][XBARMOD][b];

				-- Don't bother switching if they have it disabled.
				if (p>0) then
					ChangeActionBarPage(p);
					break;
				end
			end
		end
	end

	return t;
end