﻿LatencyButton_Position = 0;
Minimap_Latency = {};
Minimap_Latency.X = 0;
Minimap_Latency.Y = 0;

function WoWLatencyOnLoad(panel)
    LatencyShow = 0;
    LatencyHide = 0;
    this:RegisterEvent("VARIABLES_LOADED");
    tinsert(UISpecialFrames,"WoWLatency");
    panel.name = "WoW Latency";
    InterfaceOptions_AddCategory(panel);
end

function WoWLatencyOnShow()
    getglobal(this:GetName().."LatencyShow"):SetChecked( LatencyShow );
    getglobal(this:GetName().."LatencyHide"):SetChecked( LatencyHide );
end

function WoWLatencyOnEvent()
    if (event == "VARIABLES_LOADED") then
        if (LatencyShow == 0) then
            LatencyMinimapButton:Hide();
        else
            LatencyMinimapButton:Show();
        end
        if (LatencyHide == 0) then
            MainMenuBarPerformanceBarFrame:Show();
        else
            MainMenuBarPerformanceBarFrame:Hide();
        end
    end
end

function ShowLatencyOnClick()
    if (LatencyShow == 0) then
        LatencyShow = 1;
        LatencyMinimapButton:Show();
    else
        LatencyShow = 0;
        LatencyMinimapButton:Hide();
    end
end

function HideLatencyOnClick()
    if (LatencyHide == 0) then
        LatencyHide = 1;
        MainMenuBarPerformanceBarFrame:Hide();
    else
        LatencyHide = 0;
        MainMenuBarPerformanceBarFrame:Show();
    end
end

function Latency_MinimapIcon_SetMinimap()
    Minimap_Latency.X = getglobal("Minimap"):GetWidth()+20;
    Minimap_Latency.Y = getglobal("Minimap"):GetHeight()+20;
end

function Latency_MinimapIcon_UpdatePosition()
    LatencyMinimapButton:SetPoint(
		"TOPLEFT",
		"Minimap",
		"TOPLEFT",
		54 - (Minimap_Latency.X/2 * cos(LatencyButton_Position)),
		(Minimap_Latency.Y/2 * sin(LatencyButton_Position)) - 55
	);
end

function Latency_MinimapIcon_Drag()
    local xpos, ypos = GetCursorPosition();
    local xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom();
    xpos = xmin-xpos/UIParent:GetScale()+70;
    ypos = ypos/UIParent:GetScale()-ymin-70;
    Latency_MinimapIcon_SetPosition(math.deg(math.atan2(ypos, xpos)));
end

function Latency_MinimapIcon_SetPosition(pos)
    if (pos < 0) then
        pos = pos + 360;
    end
    LatencyButton_Position = pos;
    Latency_MinimapIcon_UpdatePosition();
end