--orinigaly written by Thrissa of Eminence, Blackrock 
--Updated by Wendol of Lost Soldiers of Darkness, Area52 for BC functionality and tracking all 3 quests.
--BIG SPECIAL thanks to Kjado from the wowinterface.com forums!!  for helping me and writing most of the code for the progress bar..

local WINTERREP_VERSION = "2.0.4";
local WINTERREP_EXHALTED = 42000;


function WinterRep_OnLoad()
	this:RegisterEvent("QUEST_LOG_UPDATE");
	-- Register our slash command
	SLASH_WINTERREP1 = "/wr";
	SlashCmdList["WINTERREP"] = WinterRep_Slash
      repbar = CreateFrame("STATUSBAR", nil, WinterRepFrame)
      repbar:SetPoint("LEFT", WinterRepFrame, "LEFT", 9, -16)
      repbar:SetWidth(318)
      repbar:SetHeight(10)
      repbar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
      repbar:SetStatusBarColor(0,255,0)
      repbar:SetMinMaxValues(0, 1)
      repbar2 = CreateFrame("STATUSBAR", nil, WinterRepFrame)
      repbar2:SetPoint("LEFT", WinterRepFrame, "LEFT", 7, -15)
      repbar2:SetWidth(320)
      repbar2:SetHeight(18)
      repbar2:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
      repbar2:SetStatusBarColor(0,0,0,0)
      repbar2:SetMinMaxValues(0, 1)
      repbar2:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", edgeFile = "Interface/Tooltips/UI-Tooltip-Border", tile = true, tileSize = 10, edgeSize = 10, insets = { left = 0, right = 0, top = 0, bottom = 0 }})
      
    if( DEFAULT_CHAT_FRAME ) then
	DEFAULT_CHAT_FRAME:AddMessage("WinterRep v"..WINTERREP_VERSION.." loaded.");
    end
end

function WinterRep_Slash(arg1)
  if (arg1 ~= "") then
    WinterRep_Spam(arg1);
  else
    WinterRep_ToggleUI();
  end
end

function WinterRep_OnEvent(event)
  if (event == "QUEST_LOG_UPDATE") then
    --WinterRep_debug("QUEST_LOG_UPDATE called");
    WinterRep_UpdateRep();
    WinterRep_UpdateQuest();
    WinterRep_UpdateStats();
  end
end

function WinterRep_ToggleUI()
  if (WinterRepFrame:IsShown()) then
    WinterRepFrame:Hide();
  else
    WinterRepFrame:Show();
  end
end

function WinterRep_UpdateQuest(arg1)
  local found1 = false;
  local found2 = false;
  local found3 = false;
  local output1 = "";
  local output2 = "";
  local output3 = "";
  local output4 = "";
  local output5 = "";
  local output6 = "";
  for i = 0, GetNumQuestLogEntries() do
    local questLogTitleText, level, questTag, isHeader, isCollapsed, isComplete = GetQuestLogTitle(i);
    if (isCollapsed and questLogTitleText == "Winterspring") then
      ExpandQuestHeader(i);
    end
    if (questLogTitleText and string.find(questLogTitleText, "Frostsaber Provisions")) then
      found1 = true;
      SelectQuestLogEntry(i);
      -- get Shardtooth
      local text, typ, finished = GetQuestLogLeaderBoard(1);
      for item, now, max in string.gmatch(text,"([^:]+): (%d+)/(%d+)$") do
        if (item and now and max) then
          local color = "bbbbbb";
          if (now == "0") then
            color = "dd0000"; -- red
          elseif (now == "1") then
            color = "ffff00"; -- yellow
          elseif (now == "2") then
            color = "ffff00"; -- yellow
          elseif (now == "3") then
            color = "ffff00"; -- yellow
          elseif (now == "4") then
            color = "ffff00"; -- yellow
          elseif (now == "5") then
            color = "00ff00"; -- green
          end
          if (arg1 == "status") then
            output1 = now.."/"..max.." Shardtooth Meat, ";
          else
            WinterRepFrameQuest1:SetText("|c00"..color..now.."/"..max.." Shardtooth Meat");
          end
        end
      end
      -- get Chillwind
      local text, typ, finished = GetQuestLogLeaderBoard(2);
      for item, now, max in string.gmatch(text,"([^:]+): (%d+)/(%d+)$") do
        if (item and now and max) then
          local color = "bbbbbb";
          if (now == "0") then
            color = "dd0000"; -- red
          elseif (now == "1") then
            color = "ffff00"; -- yellow
          elseif (now == "2") then
            color = "ffff00"; -- yellow
          elseif (now == "3") then
            color = "ffff00"; -- yellow
          elseif (now == "4") then
            color = "ffff00"; -- yellow
          elseif (now == "5") then
            color = "00ff00"; -- green
          end
          if (arg1 == "status") then
            output2 = output1..now.."/"..max.." Chillwind Meat. ";
          else
            WinterRepFrameQuest2:SetText("|c00"..color..now.."/"..max.." Chillwind Meat");
            WinterRepFrameNoQuest1:SetText("");
            WinterRepFrameNoQuest2:SetText("");
            WinterRepFrameNoQuest3:SetText("");

          end
        end
      end
    end
    if (questLogTitleText and string.find(questLogTitleText, "Winterfall Intrusion")) then
      found2 = true;
      SelectQuestLogEntry(i);
      -- get Shaman
      local text, typ, finished = GetQuestLogLeaderBoard(1);
      for item, now, max in string.gmatch(text,"([^:]+): (%d+)/(%d+)$") do
        if (item and now and max) then
          local color = "bbbbbb";
          if (now == "0") then
            color = "dd0000"; -- red
          elseif (now == "1") then
            color = "ffff00"; -- yellow
          elseif (now == "2") then
            color = "ffff00"; -- yellow
          elseif (now == "3") then
            color = "ffff00"; -- yellow
          elseif (now == "4") then
            color = "ffff00"; -- yellow
          elseif (now == "5") then
            color = "00ff00"; -- green
          end
          if (arg1 == "status") then
            output3 = now.."/"..max.." Shamans, ";
          else
            WinterRepFrameQuest3:SetText("|c00"..color..now.."/"..max.." Shamans");
          end
        end
      end
      -- get Ursa
      local text, typ, finished = GetQuestLogLeaderBoard(2);
      for item, now, max in string.gmatch(text,"([^:]+): (%d+)/(%d+)$") do
        if (item and now and max) then
          local color = "bbbbbb";
          if (now == "0") then
            color = "dd0000"; -- red
          elseif (now == "1") then
            color = "ffff00"; -- yellow
          elseif (now == "2") then
            color = "ffff00"; -- yellow
          elseif (now == "3") then
            color = "ffff00"; -- yellow
          elseif (now == "4") then
            color = "ffff00"; -- yellow
          elseif (now == "5") then
            color = "00ff00"; -- green
          end
          if (arg1 == "status") then
            output4 = output3..now.."/"..max.." Ursas. ";
          else
            WinterRepFrameQuest4:SetText("|c00"..color..now.."/"..max.." Ursas");
            WinterRepFrameNoQuest4:SetText("");
            WinterRepFrameNoQuest5:SetText("");
            WinterRepFrameNoQuest6:SetText("");
          end
        end
      end
    end
    if (questLogTitleText and string.find(questLogTitleText, "Rampaging Giants")) then
      found3 = true;
      SelectQuestLogEntry(i);
      -- get Giants
      local text, typ, finished = GetQuestLogLeaderBoard(1);
      for item, now, max in string.gmatch(text,"([^:]+): (%d+)/(%d+)$") do
        if (item and now and max) then
          local color = "bbbbbb";
          if (now == "0") then
            color = "dd0000"; -- red
          elseif (now == "1") then
            color = "ffff00"; -- yellow
          elseif (now == "2") then
            color = "ffff00"; -- yellow
          elseif (now == "3") then
            color = "ffff00"; -- yellow
          elseif (now == "4") then
            color = "00ff00"; -- green
          end
          if (arg1 == "status") then
            output5 = now.."/"..max.." Giants, ";
          else
            WinterRepFrameQuest5:SetText("|c00"..color..now.."/"..max.." Giants");
          end
        end
      end
      -- get Preservers
      local text, typ, finished = GetQuestLogLeaderBoard(2);
      for item, now, max in string.gmatch(text,"([^:]+): (%d+)/(%d+)$") do
        if (item and now and max) then
          local color = "bbbbbb";
          if (now == "0") then
            color = "dd0000"; -- red
          elseif (now == "1") then
            color = "ffff00"; -- yellow
          elseif (now == "2") then
            color = "ffff00"; -- yellow
          elseif (now == "3") then
            color = "ffff00"; -- yellow
          elseif (now == "4") then
            color = "00ff00"; -- green
          end
          if (arg1 == "status") then
            output6 = output5..now.."/"..max.." Preservers.";
          else
            WinterRepFrameQuest6:SetText("|c00"..color..now.."/"..max.." Preservers");
            WinterRepFrameNoQuest7:SetText("");
            WinterRepFrameNoQuest8:SetText("");
            WinterRepFrameNoQuest9:SetText("");
          end
        end
      end
    end
  end
  if (arg1 ~= nil and found1) then
    WinterRep_output("<Frostsaber Provisions> "..output2);
  elseif (arg1 ~= nil and not found1) then
    WinterRep_output("<WinterRep> I don't have the Frostsaber Provisions Quest.");
  end
  if (arg1 ~= nil and found2) then
    WinterRep_output("<Winterfall Intrusion> "..output4);
  elseif (arg1 ~= nil and not found2) then
    WinterRep_output("<WinterRep> I don't have the Winterfall Intrusion Quest.");
  end
  if (arg1 ~= nil and found3) then
    WinterRep_output("<Rampaging Giants> "..output6);
  elseif (arg1 ~= nil and not found3) then
    WinterRep_output("<WinterRep> I don't have the Rampaging Giants Quest.");
  end
  if (not found1) then
    WinterRepFrameQuest1:SetText("");
    WinterRepFrameQuest2:SetText("");
    WinterRepFrameNoQuest1:SetText("|c00ffff00Missing:");
    WinterRepFrameNoQuest2:SetText("|c00ffff00Frostsaber");
    WinterRepFrameNoQuest3:SetText("|c00ffff00Provisions");
  end
  if (not found2) then
    WinterRepFrameQuest3:SetText("");
    WinterRepFrameQuest4:SetText("");
    WinterRepFrameNoQuest4:SetText("|c00ffff00Missing:");
    WinterRepFrameNoQuest5:SetText("|c00ffff00Winterfall");
    WinterRepFrameNoQuest6:SetText("|c00ffff00Intrusion");
  end
  if (not found3) then
    WinterRepFrameQuest5:SetText("");
    WinterRepFrameQuest6:SetText("");
    WinterRepFrameNoQuest7:SetText("|c00ffff00Missing:");
    WinterRepFrameNoQuest8:SetText("|c00ffff00Rampaging");
    WinterRepFrameNoQuest9:SetText("|c00ffff00Giants");
  end
end

function WinterRep_UpdateStats()
  local WinterRep = WinterRep_getRep();
  local rep_per = 250;
  if (UnitRace("player") == "Human") then
    rep_per = 275;
  end
  questsDone = math.floor(WinterRep/rep_per);
  questsTotal = math.ceil(WINTERREP_EXHALTED/rep_per);
  questsTodo = math.ceil((WINTERREP_EXHALTED-WinterRep)/rep_per);
  WinterRepFrameStats1:SetText(questsDone.."/"..questsTotal.." ("..questsTodo.." to go)");
  local percent = math.ceil((WinterRep/WINTERREP_EXHALTED)*100*100)/100;
  WinterRepFrameStatsPercent:SetText(percent.."%");
end

function WinterRep_UpdateRep()
  -- find num quests done
  local WinterRep = WinterRep_getRep();
  local rep_per = 250;
  if (UnitRace("player") == "Human") then
    rep_per = 275;
  end
  questsDone = math.floor(WinterRep/rep_per);
  questsTotal = math.ceil(WINTERREP_EXHALTED/rep_per);
  repbar:SetValue(questsDone/questsTotal);

end

function WinterRep_Spam(arg1)
  local outputType = "auto";
  local outputWhisper = "";
  if (arg1 ~= "") then
    local i, y = string.find(arg1, "w");
    if (i == 1 and string.len(arg1) > 2) then
      outputType = "whisper";
      outputWhisper = string.sub(arg1, (y+2));
		end
		local i, y = string.find(arg1, "general");
    if (i == 1 and string.len(arg1) == 7) then
      outputType = "general";
		end
	       local i, y = string.find(arg1, "p");
		if (i == 1 and string.len(arg1) == 1) then
      outputType = "party";
		end
		local i, y = string.find(arg1, "g");
		if (i == 1 and string.len(arg1) == 1) then
      outputType = "guild";
		end
		local i, y = string.find(arg1, "l");
		if (i == 1 and string.len(arg1) == 1) then
      outputType = "local";
		end
  end
  local WinterRep = WinterRep_getRep();
  local quests;
  local rep_per = 250;
  if (UnitRace("player") == "Human") then
    rep_per = 275;
  end
  quests = math.ceil((WINTERREP_EXHALTED-WinterRep)/rep_per);
  local progress_bar = "[";
  local percent = math.ceil((WinterRep/WINTERREP_EXHALTED)*100*100)/100;
  local chars = 0;
  for i = 0, math.floor(percent/5) do
    progress_bar = progress_bar .. "=";
    chars = chars + 1;
  end
  if (math.floor(percent/5) < percent/5) then
    progress_bar = progress_bar .. ">";
    chars = chars + 1;
  end
  for i = chars, 20 do
    progress_bar = progress_bar .. "_";
  end
  progress_bar = progress_bar .. "]";
  WinterRep_output("Wintersaber Rep: "..progress_bar .." "..percent.."%, "..quests.." more ("..WinterRep.."/"..WINTERREP_EXHALTED..")", outputType, outputWhisper);
end

function WinterRep_getRep()
  local i = 0;
  local WinterRep = 0;
  for i = 0, GetNumFactions() do 
    local name, description, standingId, bottomValue, topValue, earnedValue, atWarWith, canToggleAtWar, isHeader, isCollapsed = GetFactionInfo(i);
    if (name == "Wintersaber Trainers") then
      WinterRep = earnedValue;
    end
  end
  return WinterRep;
end

function WinterRep_debug(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end;

function WinterRep_output(msg, outType, target)
  if (outType == "whisper" and target ~= "") then
    SendChatMessage(msg, "WHISPER", this.language, target);
  elseif (outType == "general") then
    SendChatMessage(msg,"CHANNEL", this.language,GetChannelName("General - "..GetRealZoneText()));
  elseif (outType == "guild") then
    SendChatMessage(msg, "GUILD");
  elseif (outType == "party") then
    SendChatMessage(msg, "PARTY");
  elseif (outType == "local") then
    DEFAULT_CHAT_FRAME:AddMessage(msg);
  elseif (GetNumPartyMembers() > 0) then
    SendChatMessage(msg, "PARTY");
  else
    DEFAULT_CHAT_FRAME:AddMessage(msg);
  end
end