local mod = Whisp:NewModule("FuBar Plugin", "AceEvent-3.0", "LibFuBarPlugin-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("Whisp")
mod.modName = L["FuBar Plugin"]

local options = {
	showButton = {
		type = "toggle",
		name = L["FuBar/Minimap button"],
		desc = L["Toggle to show/hide the FuBar/Minimap button"],
		get = function() return mod.db.profile.showFuBar end,
		set = function(_,v)
			mod.db.profile.showFuBar = v
			if v then
				mod:Show()
			else
				mod:Hide()
			end
		end,
	},
	attachMinimap = {
		type = "toggle",
		name = L["Attach to minimap"],
		desc = L["Attach to minimap"],
		get = function() return mod:IsFuBarMinimapAttached() end,
		set = function(_,v)	mod:ToggleFuBarMinimapAttached() end,
	},
	showIcon = {
		type = "toggle",
		name = L["Show icon"],
		desc = L["Show icon"],
		get = function() return mod:IsFuBarIconShown() end,
		set = function(_,v) mod:ToggleFuBarIconShown() end,
	},
	showText = {
		type = "toggle",
		name = L["Show text"],
		desc = L["Show text"],
		get = function() return mod:IsFuBarTextShown() end,
		set = function(_,v) mod:ToggleFuBarTextShown() end,
	},
	position = {
		type = "select",
		name = L["Position"],
		desc = L["Position"],
		values = {LEFT = L["Left"], CENTER = L["Center"], RIGHT = L["Right"]},
		get = function() return mod:GetPanel() and mod:GetPanel():GetPluginSide(mod) end,
		set = function(_,v)	mod:GetPanel():SetPluginSide(mod, v) end,
	},
}

local defaults = {
	profile = {
		showFuBar = true,                  -- Show the FuBar/Minimap button
	},
	char = {
		tooltipTimeFrame = "Session",      -- Which messages should be shown on the fubar tooltop
		tooltipSort = "Time",              -- Sort method for messages on the fubar tooltip
		frameWidth = 500,											 -- Width of the frame
	}
}

local fubarFrame = {}

function mod:OnInitialize()
	self.db = Whisp.db:RegisterNamespace("FuBar Plugin", defaults)
	fubarFrame = Whisp:CreateMyFrame("FUBAR", self.db.char.frameWidth)
	mod.fubarFrame = fubarFrame
end

function mod:OnEnable()
	mod:SetFuBarOption('tooltipType', "Tablet-2.0")
	mod:SetFuBarOption('clickableTooltip', true)
	mod:SetFuBarOption('iconPath', [[Interface\Addons\Whisp\icon]])
	mod:SetFuBarIcon([[Interface\Addons\Whisp\icon]])                 -- iconPath needs to be set twice... bugged?
	mod:SetFuBarOption('independentProfile', true)
	mod:RegisterMessage("WHISP_MESSAGE", "OnUpdate")
	mod:RegisterMessage("WHISP_SKIN", "OnSkinUpdate")
end

function mod:OnUpdate()
	mod:UpdateFuBarPlugin()
end

function mod:OnSkinUpdate()
	Whisp:SkinMyFrame(fubarFrame)
end

function mod:OnUpdateFuBarText()
  if Whisp.lastSender and Whisp.db.realm.chatHistory[Whisp.lastSender] then
    local v = Whisp.db.realm.chatHistory[Whisp.lastSender]
    local inc = v.incoming[#v.incoming]
    local color = inc and Whisp.db.char.colorIncoming or Whisp.db.char.colorOutgoing
    mod:SetFuBarText(Whisp:Colorise(Whisp.lastSender, Whisp:HexColor(color)))
  else
    mod:SetFuBarText(Whisp.lastSender and Whisp.lastSender or "Whisp")  
  end
end

function mod:OnFuBarClick(button)
  if Whisp.lastSender then
    if IsControlKeyDown() then
      Whisp:ShowLogFrame(self.lastSender)
    else
      ChatFrameEditBox:Show()
      ChatFrameEditBox:SetText("/w "..Whisp.lastSender.." ")
      ChatEdit_ParseText(ChatFrameEditBox, 0)
    end
  end
end

function mod:OpenMenu()
	Whisp:OpenConfig()
end

local tablet = AceLibrary("Tablet-2.0")
mod.tablet = tablet
function mod:OnUpdateFuBarTooltip()
  -- Set the height of the tooltip to something more convenient
  tablet.tooltip.registration.maxHeight = UIParent:GetTop()/3

  -- Setup clickable header
  local cat = tablet:AddCategory(
    'text', L["Timeframe"],
    'text2', L[mod.db.char.tooltipTimeFrame],
    'textR', 0.6, 'textG', 0.6, 'textB', 1,
    'text2R', 1, 'text2G', 0.8, 'text2B', 0,
    'columns', 2,
    'func', function() -- Allow click to cycle through timeframe
          if mod.db.char.tooltipTimeFrame == "Session" then
            mod.db.char.tooltipTimeFrame = "Hour"
          elseif mod.db.char.tooltipTimeFrame == "Hour" then
            mod.db.char.tooltipTimeFrame = "Day"
          elseif mod.db.char.tooltipTimeFrame == "Day" then
            mod.db.char.tooltipTimeFrame = "Week"
          elseif mod.db.char.tooltipTimeFrame == "Week" then
            mod.db.char.tooltipTimeFrame = "All"
          else
            mod.db.char.tooltipTimeFrame = "Session"
          end
        end,
    'hasCheck', true,
    'checked', true,
    'checkIcon', "Interface\\Buttons\\UI-PlusButton-Up",
    'hideBlankLine', true
  )
  cat:AddLine()
  local cat = tablet:AddCategory(
    'text', L["Sort by"],
    'text2', L[mod.db.char.tooltipSort],
    'textR', 0.6, 'textG', 0.6, 'textB', 1,
    'text2R', 1, 'text2G', 0.8, 'text2B', 0,
    'columns', 2,
    'func', function() -- Allow click to cycle through timeframe
          if mod.db.char.tooltipSort == "Time" then
            mod.db.char.tooltipSort = "Name"
          else
            mod.db.char.tooltipSort = "Time"
          end
        end,
    'hasCheck', true,
    'checked', true,
    'checkIcon', "Interface\\Buttons\\UI-PlusButton-Up",
    'hideBlankLine', true
  )
  cat:AddLine()

  -- Setup data
  local contacts = {}
  for i,v in pairs(Whisp.db.realm.chatHistory) do
    tinsert(contacts, {time = v.time[#v.time], plr = i, inc = v.incoming[#v.incoming]})
  end
  if mod.db.char.tooltipSort == "Name" then
    table.sort(contacts, function(a,b) return a.plr<b.plr end)
  else
    table.sort(contacts, function(a,b) return a.time>b.time end)
  end
  
  local tf = mod.db.char.tooltipTimeFrame
  for i=1, #contacts do
    local inc = contacts[i].inc
    local plr = contacts[i].plr
    local systime = contacts[i].time
    local skip = false
    
    if   ((tf == "Session") and (systime < Whisp.sessionStart))
      or ((tf == "Hour")    and (time() - systime > 3600))
      or ((tf == "Day")     and (time() - systime > 86400))
      or ((tf == "Week")    and (time() - systime > 604800))
    then
      skip = true
    end
    
    if not skip then
      if (tf == "Week") or (tf == "All") then
        systime = date("%d/%m - %H:%M:%S", systime)
      else
        systime = date("%H:%M:%S", systime)
      end
      local color = inc and Whisp.db.char.colorIncoming or Whisp.db.char.colorOutgoing
      cat:AddLine(
          'text', systime,
          'text2', plr,
          'text2R', color[1],
          'text2G', color[2],
          'text2B', color[3],
          'func', function(plr) 
            if IsControlKeyDown() then
              Whisp:ShowLogFrame(plr)
            else
              ChatFrameEditBox:Show()
              ChatFrameEditBox:SetText("/w "..plr.." ")
              ChatEdit_ParseText(ChatFrameEditBox, 0)
            end
          end,
          'arg1', plr,
          'onEnterFunc', function(plr) mod:ShowFuBarFrame(plr) end,
          'onEnterArg1', plr,
          'onLeaveFunc', function() mod:HideFuBarFrame() end,
          'onLeaveArg1', plr
      )
    end
  end
  tablet:SetHint(L["Click to reply\nControl-click to open log"])
  tablet:SetTitle("Whisp")
end

function mod:ShowFuBarFrame(plr)
  if not plr then return end
  local tip = tablet.tooltip
  local left, right, top, bottom = tip:GetLeft(), tip:GetRight(), tip:GetTop(), tip:GetBottom()
  local cx, cy = UIParent:GetRight()/2, UIParent:GetTop()/2
  local anchor, align = "", ""
  if top > cy * 1.5 then
    anchor, align = "TOP", "BOTTOM"
    if right > cx * 1.5 then
      anchor, align = "TOPRIGHT", "BOTTOMRIGHT"
    elseif left < cx * 0.5 then
      anchor, align = "TOPLEFT", "BOTTOMLEFT"
    end
  elseif bottom < cy * 0.5 then 
    anchor, align = "BOTTOM", "TOP"
    if right > cx * 1.5 then
      anchor, align = "BOTTOMRIGHT", "TOPRIGHT"
    elseif left < cx * 0.5 then
      anchor, align = "BOTTOMLEFT", "TOPLEFT"
    end
  else
    if right > cx * 1.5 then
      anchor, align = "RIGHT", "LEFT"
    else
      anchor, align = "LEFT", "RIGHT"
    end
  end
  fubarFrame:ClearAllPoints()
  fubarFrame:SetPoint(anchor, tip, align)
  Whisp:UpdateMyFrame(fubarFrame, plr)
  fubarFrame:Show()
end

function mod:HideFuBarFrame()
	fubarFrame:Hide()
end

function mod:GetOptions()
	return options
end

function mod:Info()
	return L["Allows you to quickly review your message history using a button on either your FuBar or Minimap."]
end