--[[
	Where To Now?
	Version 1.3
]]

WhereToNow_Version = "1.3";

-- Message zones
function WhereToNow_Msg(msg, channel, debug)
	if (msg == nil) then
		return;
	end
	if debug == nil then
		debug = 10;
	end
	if (channel == "Error") then
		DEFAULT_CHAT_FRAME:AddMessage(RED_FONT_COLOR_CODE..WHERETONOW_TITLE.." "..WHERETONOW_ERROR..": |r"..msg);
	elseif (channel == "Debug") then
		DEFAULT_CHAT_FRAME:AddMessage(LIGHTYELLOW_FONT_COLOR_CODE..WHERETONOW_TITLE.." "..WHERETONOW_DEBUG..": |r"..msg);
	else
		DEFAULT_CHAT_FRAME:AddMessage(GREEN_FONT_COLOR_CODE..WHERETONOW_TITLE..": |r"..msg);
	end
end

-- Loading Function
function WhereToNow_Load()

	-- Slash Commands
	SlashCmdList["WhereToNow"] = WhereToNow_CommandLine;
	SLASH_WhereToNow1 = "/wheretonow";
	SLASH_WhereToNow2 = "/where2now";
	SLASH_WhereToNow3 = "/w2n";
	SLASH_WhereToNow4 = "/wtn";

	if (not WhereToNow_Options) then
		WhereToNow_Options = {
			["Sort"] = "Min", -- Other values: "Name" & "Max"
		}
	end

	WhereToNow_Msg(WHERETONOW_VERSION.." "..WhereToNow_Version.." "..WHERETONOW_NOWLOADED);
end

function WhereToNow_CommandLine(cmd)
	-- Force lowercase so we don't have to double-up our options! Also makes it more user-proof.
	cmd = strlower(cmd);

	if (cmd == "minimap off") then
		WhereToNowMinimapButton:Hide();
		WhereToNow_Msg("Hiding minimap button.");
	elseif (cmd == "minimap on") then
		WhereToNowMinimapButton:Show();
		WhereToNow_Msg("Showing minimap button.");
	elseif (cmd == "minimap") then
		if (WhereToNowMinimapButton:IsVisible()) then
			WhereToNowMinimapButton:Hide();
			WhereToNow_Msg("Hiding minimap button.");
		else
			WhereToNowMinimapButton:Show();
			WhereToNow_Msg("Showing minimap button.");
		end
	elseif (cmd == "sort name") then
		WhereToNow_Options["Sort"] = "Name";
		WhereToNow_Msg("Now sorting alphabetically by name.");
	elseif (cmd == "sort min") then
		WhereToNow_Options["Sort"] = "Min";
		WhereToNow_Msg("Now sorting by minimum level.");
	elseif (cmd == "sort max") then
		WhereToNow_Options["Sort"] = "Max";
		WhereToNow_Msg("Now sorting by maximum level.");
	else
		WhereToNow_Parse(cmd);
	end
end

local OutputModes = {
	"whisper",
	"guild",
	"raid",
	"party",
	"say",
	"yell",
}

function WhereToNow_Parse(cmd)
	local channel, player, level;

	local commands = {};
	for v in string.gmatch(cmd,"[^ ]+") do
		tinsert(commands,v);
	end

	for k,v in pairs(commands) do
		for o=1,#OutputModes do
			if OutputModes[o] == v then
				channel = v;
			end
		end
		if tonumber(v) ~= nil then
			level = v;
		end
		if channel ~= nil and v ~= channel then
			player = v;
		end
	end

--	WhereToNow_Msg("Parse Test: Level="..tostring(level)..", Channel="..tostring(channel)..", Player="..tostring(player))

	if ((channel == "whisper") and (player == nil)) then
		WhereToNow_Msg(WHERETONOW_ERROR_WRONGCMDORDERWHISPER,"Error");
		return;
	end

	WhereToNow_Main(tonumber(level), player, channel);
end

-- Torn out into it's own function to make things easier. Also, we don't have to double up our code.
-- Returns 2 arrays of the zones and instances found for the specified level, and 2 variables indicating how many zones & instances were found.
function WhereToNow_GetLists(Level)
	local zonearray, instancearray = {}, {};
	local zonefound, instancefound = 0, 0;

	sort(WhereToNowDatabase);
	for ZName, v in pairs(WhereToNowDatabase) do
		if ((WhereToNowDatabase[ZName]["min"] <= Level) and (WhereToNowDatabase[ZName]["max"] >= Level)) then
			if WhereToNow_Options["Sort"] == "Min" then
				if (not zonearray[WhereToNowDatabase[ZName]["min"]..ZName]) then
					zonearray[WhereToNowDatabase[ZName]["min"]..ZName] = {
						["name"] = ZName,
						["min"] = WhereToNowDatabase[ZName]["min"],
						["max"] = WhereToNowDatabase[ZName]["max"],
					}
					zonefound = zonefound + 1;
				end
			elseif WhereToNow_Options["Sort"] == "Max" then
				if (not zonearray[WhereToNowDatabase[ZName]["max"]..ZName]) then
					zonearray[WhereToNowDatabase[ZName]["max"]..ZName] = {
						["name"] = ZName,
						["min"] = WhereToNowDatabase[ZName]["min"],
						["max"] = WhereToNowDatabase[ZName]["max"],
					}
					zonefound = zonefound + 1;
				end
			-- Sort by Name by Default!
			else
				if (not zonearray[ZName]) then
					zonearray[ZName] = {
						["name"] = ZName,
						["min"] = WhereToNowDatabase[ZName]["min"],
						["max"] = WhereToNowDatabase[ZName]["max"],
					}
					zonefound = zonefound + 1;
				end
			end
		end
		for Instance,v in pairs(WhereToNowDatabaseDungeon) do
			if (Zname == WhereToNowDatabaseDungeon[Instance]["Zone"]) then
				if ((WhereToNowDatabaseDungeon[Instance]["min"] <= Level) and (WhereToNowDatabaseDungeon[Instance]["max"] >= Level)) then
					if WhereToNow_Options["Sort"] == "Min" then
						if (not instancearray[WhereToNowDatabaseDungeon[Instance]["min"]..Instance]) then
							instancearray[WhereToNowDatabaseDungeon[Instance]["min"]..Instance] = {
								["name"] = Instance,
								["min"] = WhereToNowDatabaseDungeon[Instance]["min"],
								["max"] = WhereToNowDatabaseDungeon[Instance]["max"],
							}
							instancefound = instancefound + 1;
						end
					elseif WhereToNow_Options["Sort"] == "Max" then
						if (not instancearray[WhereToNowDatabaseDungeon[Instance]["max"]..Instance]) then
							instancearray[WhereToNowDatabaseDungeon[Instance]["max"]..Instance] = {
								["name"] = Instance,
								["min"] = WhereToNowDatabaseDungeon[Instance]["min"],
								["max"] = WhereToNowDatabaseDungeon[Instance]["max"],
							}
							instancefound = instancefound + 1;
						end
					else
						if (not instancearray[Instance]) then
							instancearray[Instance] = {
								["name"] = Instance,
								["min"] = WhereToNowDatabaseDungeon[Instance]["min"],
								["max"] = WhereToNowDatabaseDungeon[Instance]["max"],
							}
							instancefound = instancefound + 1;
						end
					end
				end
			end
		end
	end

	return zonearray, instancearray, zonefound, instancefound;
end

function WhereToNow_Main(Level, Character, Channel)
	local output = "None";

	if (Level == nil) then
		Level = UnitLevel("player");
	end
	if (Channel ~= nil) and (Character ~= nil) then
		output = Channel;
	end

	local zonearray, instancearray, zonefound, instancefound = WhereToNow_GetLists(Level);

	local msg1, msg2;
	local ColorCode1, ColorCode2 = NORMAL_FONT_COLOR_CODE, "|r";
	if Channel ~= nil then
		ColorCode1 = "";
		ColorCode2 = "";
	end

	sort(zonearray);
	sort(instancearray);

	if zonefound > 0 then
		local zonetxt = "";
		for title,v in WhereToNow_pairsByKeys(zonearray) do
			if zonetxt ~= "" then zonetxt = zonetxt..", " end
			zonetxt = zonetxt..zonearray[title]["name"];
		end
		msg1 = ColorCode1..WHERETONOW_REC_ZONES..Level..": "..ColorCode2..zonetxt..".";
	end
	if instancefound > 0 then
		local instancetxt = "";
		for title,v in WhereToNow_pairsByKeys(instancearray) do
			if (instancetxt ~= "") then instancetxt = instancetxt..", "; end
			instancetxt = instancetxt..instancearray[title]["name"];
		end
		msg2 = ColorCode1..WHERETONOW_REC_INSTANCES..": "..ColorCode2..instancetxt..".";
	end
	if zonefound <= 0 and instancefound <=0 then
		msg1 = ColorCode1..WHERETONOW_REC_NONE..ColorCode2;
	end

--	WhereToNow_Msg("Output Test: Level="..tostring(Level)..", Channel="..tostring(Channel)..", Player="..tostring(Character))

	if (Channel == "party") then
		if msg1 ~= nil then
			SendChatMessage(msg1,"PARTY");
		end
		if msg2 ~= nil then
			SendChatMessage(msg2,"PARTY");
		end
	elseif (Channel == "guild") then
		if msg1 ~= nil then
			SendChatMessage(msg1,"GUILD");
		end
		if msg2 ~= nil then
			SendChatMessage(msg2,"GUILD");
		end
	elseif (Channel == "say") then
		if msg1 ~= nil then
			SendChatMessage(msg1,"SAY");
		end
		if msg2 ~= nil then
			SendChatMessage(msg2,"SAY");
		end
	elseif (Channel == "yell") then
		if msg1 ~= nil then
			SendChatMessage(msg1,"YELL");
		end
		if msg2 ~= nil then
			SendChatMessage(msg2,"YELL");
		end
	elseif (Channel == "raid") then
		if msg1 ~= nil then
			SendChatMessage(msg1,"RAID");
		end
		if msg2 ~= nil then
			SendChatMessage(msg2,"RAID");
		end
	elseif (Channel == "whisper") then
		if msg1 ~= nil then
			SendChatMessage(msg1,"WHISPER",nil,Character);
		end
		if msg2 ~= nil then
			SendChatMessage(msg2,"WHISPER",nil,Character);
		end
	else
		if msg1 ~= nil then
			WhereToNow_Msg(msg1);
		end
		if msg2 ~= nil then
			WhereToNow_Msg(msg2);
		end
	end
end

function WhereToNow_Tooltip()
	local Level=UnitLevel("player");
	local output = "";
	local zonefound, instancefound = 0, 0;
	local instancelist = {};

	local zonearray, instancearray, zonefound, instancefound = WhereToNow_GetLists(Level);

	if (instances == "") then
		instances = WHERETONOW_NONE;
	end
	if (zones == "") then
		zones = WHERETONOW_NONE;
	end

	sort(zonearray);
	sort(instancearray);

	if zonefound > 0 then
		local zonetxt = "";
		for title,v in WhereToNow_pairsByKeys(zonearray) do
			if zonetxt ~= "" then zonetxt = zonetxt.."\n" end
			local minmax = zonearray[title]["min"];
			if (zonearray[title]["min"] ~= zonearray[title]["max"]) then
				minmax = minmax.."-"..zonearray[title]["max"];
			end
			zonetxt = zonetxt..zonearray[title]["name"].." ("..minmax..")";
		end
		output = output.."\n"..NORMAL_FONT_COLOR_CODE..WHERETONOW_REC_ZONES..Level..":\n|r"..zonetxt;
	end
	if instancefound > 0 then
		local instancetxt = "";
		for title,v in WhereToNow_pairsByKeys(instancearray) do
			if (instancetxt ~= "") then instancetxt = instancetxt.."\n"; end
			local minmax = instancearray[title]["min"];
			if (instancearray[title]["min"] ~= instancearray[title]["max"]) then
				minmax = minmax.."-"..instancearray[title]["max"];
			end
			instancetxt = instancetxt..instancearray[title]["name"].." ("..minmax..")";
		end
		output = output.."\n\n"..NORMAL_FONT_COLOR_CODE..WHERETONOW_REC_INSTANCES..":\n|r"..instancetxt;
	end

	if zonefound <= 0 and instancefound <= 0 then
		output = WHERETONOW_REC_NONE;
	end

	return output;
end

-- Toolset
-- Functions that we can use as tools.

function WhereToNow_MapList()
	local zonelist = {}
	local continentNames = { GetMapContinents() };
	for ckey, cval in pairs(continentNames) do
		local ZoneNames = { GetMapZones(ckey) };
		for zkey, zval in pairs(ZoneNames) do
			zonelist[zval] = 1;
		end
	end

	return zonelist;
end

-- Let's us sort tables!
-- Copy/Pasted from LUA Website
function WhereToNow_pairsByKeys (t, f)
	local a = {}
		for n in pairs(t) do table.insert(a, n) end
		table.sort(a, f)
		local i = 0      -- iterator variable
		local iter = function ()   -- iterator function
			i = i + 1
			if a[i] == nil then return nil
			else return a[i], t[a[i]]
			end
		end
	return iter
end