--[[
	Zone/Instance Database
	Version 1.3
]]
local version = GetBuildInfo();

WhereToNowDatabase = {
	["Azuremyst Isle"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Dun Morogh"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Durotar"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Elwynn Forest"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Eversong Forest"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Mulgore"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Teldrassil"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Tirisfal Glades"] = {
		["min"] = 1,
		["max"] = 10,
	},
	["Ghostlands"] = {
		["min"] = 10,
		["max"] = 20,
	},
	["Loch Modan"] = {
		["min"] = 10,
		["max"] = 20,
	},
	["Westfall"] = {
		["min"] = 10,
		["max"] = 20,
	},
	["Bloodmyst Isle"] = {
		["min"] = 10,
		["max"] = 20,
	},
	["Darkshore"] = {
		["min"] = 10,
		["max"] = 20,
	},
	["Ghostlands"] = {
		["min"] = 10,
		["max"] = 20,
	},
	["Silverpine Forest"] = {
		["min"] = 10,
		["max"] = 20,
	},
	["The Barrens"] = {
		["min"] = 10,
		["max"] = 25,
	},
	["Redridge Mountains"] = {
		["min"] = 15,
		["max"] = 25,
	},
  	["Stonetalon Mountains"] = {
		["min"] = 15,
		["max"] = 27,
	},
  	["Ashenvale Forest"] = {
		["min"] = 18,
		["max"] = 30,
	},
  	["Duskwood"] = {
		["min"] = 18,
		["max"] = 30,
	},
  	["Wetlands"] = {
		["min"] = 20,
		["max"] = 30,
	},
  	["Hillsbrad Foothills"] = {
		["min"] = 20,
		["max"] = 30,
	},
	["Thousand Needles"] = {
		["min"] = 25,
		["max"] = 35,
	},
  	["Arathi Highlands"] = {
		["min"] = 30,
		["max"] = 40,
	},
  	["Desolace"] = {
		["min"] = 30,
		["max"] = 40,
	},
  	["Alterac Mountains"] = {
		["min"] = 30,
		["max"] = 40,
	},
  	["Stranglethorn Vale"] = {
		["min"] = 30,
		["max"] = 45,
	},
  	["Dustwallow Marsh"] = {
		["min"] = 35,
		["max"] = 45,
	},
  	["Badlands"] = {
		["min"] = 35,
		["max"] = 45,
	},
  	["Swamp of Sorrows"] = {
		["min"] = 35,
		["max"] = 45,
	},
	["Hinterlands"] = {
		["min"] = 40,
		["max"] = 50,
	},
  	["Feralas"] = {
		["min"] = 40,
		["max"] = 50,
	},
  	["Tanaris"] = {
		["min"] = 40,
		["max"] = 50,
	},
  	["Searing Gorge"] = {
		["min"] = 45,
		["max"] = 50,
	},
  	["Blasted Lands"] = {
		["min"] = 45,
		["max"] = 55,
	},
  	["Azshara"] = {
		["min"] = 45,
		["max"] = 55,
	},
  	["Felwood"] = {
		["min"] = 48,
		["max"] = 55,
	},
  	["Un'goro Crater"] = {
		["min"] = 48,
		["max"] = 55,
	},
	["Burning Steppes"] = {
		["min"] = 50,
		["max"] = 58,
	},
  	["Western Plaguelands"] = {
		["min"] = 50,
		["max"] = 58,
	},
  	["Eastern Plaguelands"] = {
		["min"] = 53,
		["max"] = 60,
	},
  	["Winterspring"] = {
		["min"] = 53,
		["max"] = 60,
	},
  	["Silithus"] = {
		["min"] = 55,
		["max"] = 60,
	},
  	["Deadwind Pass"] = {
		["min"] = 55,
		["max"] = 70,
	},
	--[[ Who needs Moonglade?!
  	["Moonglade"] = {
		["min"] = 58,
		["max"] = 60,
	},
	]]

--	Burning Crusade Zones

  	["Hellfire Peninsula"] = {
		["min"] = 58,
		["max"] = 63,
	},
  	["Zangarmarsh"] = {
		["min"] = 60,
		["max"] = 64,
	},
	["Terokkar Forest"] = {
		["min"] = 62,
		["max"] = 65,
	},
  	["Nagrand"] = {
		["min"] = 64,
		["max"] = 67,
	},
  	["Blade's Edge Mountains"] = {
		["min"] = 65,
		["max"] = 68,
	},
  	["Netherstorm"] = {
		["min"] = 67,
		["max"] = 70,
	},
  	["Shadowmoon Valley"] = {
		["min"] = 67,
		["max"] = 70,
	},
	["Isle of Quel'Danas "] = {
		["min"] = 70,
		["max"] = 73,
	},

}
--	Lich King Zones
if version > "3.0.0" then
	WhereToNowDatabase["Borean Tundra"] = {
		["min"] = 68,
		["max"] = 72,
	}
  	WhereToNowDatabase["Howling Fjord"] = {
		["min"] = 68,
		["max"] = 72,
	}
	WhereToNowDatabase["Dragonblight"] = {
		["min"] = 71,
		["max"] = 74,
	}
  	WhereToNowDatabase["Grizzly Hills"] = {
		["min"] = 73,
		["max"] = 75,
	}
  	WhereToNowDatabase["Zul'Drak"] = {
		["min"] = 74,
		["max"] = 77,
	}
  	WhereToNowDatabase["Sholazar Basin"] = {
		["min"] = 76,
		["max"] = 78,
	}
  	WhereToNowDatabase["Crystalsong Forest"] = {
		["min"] = 77,
		["max"] = 80,
	}
  	WhereToNowDatabase["Storm Peaks"] = {
		["min"] = 77,
		["max"] = 80,
	}
  	WhereToNowDatabase["Icecrown"] = {
		["min"] = 77,
		["max"] = 80,
	}
  	WhereToNowDatabase["Wintergrasp"] = {
		["min"] = 77,
		["max"] = 80,
	}
end

WhereToNowDatabaseDungeon = {
	["Ragefire Chasm"] = {
		["zone"] = "Durotar",
		["limit"] = 8,
		["min"] = 13,
		["max"] = 20,
	},
	["Wailing Caverns"] = {
		["zone"] = "The Barrens",
		["limit"] = 10,
		["min"] = 16,
		["max"] = 24,
	},
	["The Deadmines"] = {
		["zone"] = "Westfall",
		["limit"] = 10,
		["min"] = 16,
		["max"] = 24,
	},
	["Shadowfang Keep"] = {
		["zone"] = "Silverpine Forest",
		["limit"] = 14,
		["min"] = 17,
		["max"] = 25,
	},
	["Blackfathom Deeps"] = {
		["zone"] = "Darkshore",
		["limit"] = 19,
		["min"] = 20,
		["max"] = 28,
	},
	["Stormwind Stockade"] = {
		["zone"] = "Elwynn Forest",
		["limit"] = 15,
		["min"] = 21,
		["max"] = 29,
	},
	["Razorfen Kraul"] = {
		["zone"] = "The Barrens",
		["limit"] = 17,
		["min"] = 23,
		["max"] = 31,
	},
	["Gnomeregan"] = {
		["zone"] = "Dun Morogh",
		["limit"] = 15,
		["min"] = 24,
		["max"] = 32,
	},
	["Razorfen Downs"] = {
		["zone"] = "The Barrens",
		["limit"] = 25,
		["min"] = 33,
		["max"] = 41,
	},
	["The Scarlet Monastery: Graveyard"] = {
		["zone"] = "Tirisfal Glades",
		["limit"] = 20,
		["min"] = 28,
		["max"] = 36,
	},
	["The Scarlet Monastery: Library"] = {
		["zone"] = "Tirisfal Glades",
		["limit"] = 20,
		["min"] = 31,
		["max"] = 39,
	},
	["The Scarlet Monastery: Armory"] = {
		["zone"] = "Tirisfal Glades",
		["limit"] = 20,
		["min"] = 33,
		["max"] = 41,
	},
	["The Scarlet Monastery: Cathedral"] = {
		["zone"] = "Tirisfal Glades",
		["limit"] = 20,
		["min"] = 36,
		["max"] = 44,
	},
	["Uldaman"] = {
		["zone"] = "Badlands",
		["limit"] = 30,
		["min"] = 36,
		["max"] = 44,
	},
	["Maraudon"] = {
		["zone"] = "Desolace",
		["limit"] = 30,
		["min"] = 40,
		["max"] = 52,
	},
	["Zul'Farrak"] = {
		["zone"] = "Tanaris",
		["limit"] = 35,
		["min"] = 42,
		["max"] = 50,
	},
	["Temple of Atal'Hakkar"] = {
		["zone"] = "Dustwallow Marsh",
		["limit"] = 35,
		["min"] = 45,
		["max"] = 54,
	},
	["Blackrock Depths"] = {
		["zone"] = "Searing Gorge",
		["limit"] = 45,
		["min"] = 48,
		["max"] = 60,
	},
	["Dire Maul: East"] = {
		["zone"] = "Feralas",
		["limit"] = 45,
		["min"] = 54,
		["max"] = 61,
	},
	["Dire Maul: West"] = {
		["zone"] = "Feralas",
		["limit"] = 45,
		["min"] = 56,
		["max"] = 61,
	},
	["Dire Maul: North"] = {
		["zone"] = "Feralas",
		["limit"] = 45,
		["min"] = 56,
		["max"] = 61,
	},
	["Lower Blackrock Spire"] = {
		["zone"] = "Burning Steppes",
		["limit"] = 45,
		["min"] = 53,
		["max"] = 61,
	},
	["Stratholme"] = {
		["zone"] = "Eastern Plaguelands",
		["limit"] = 45,
		["min"] = 56,
		["max"] = 61,
	},
	["Scholomance"] = {
		["zone"] = "Western Plaguelands",
		["limit"] = 45,
		["min"] = 56,
		["max"] = 61,
	},
	["Hellfire Citadel: Hellfire Ramparts"] = {
		["zone"] = "Hellfire Peninsula",
		["limit"] = 55,
		["min"] = 59,
		["max"] = 67,
	},
	["Hellfire Citadel: The Blood Furnace"] = {
		["zone"] = "Hellfire Peninsula",
		["limit"] = 55,
		["min"] = 60,
		["max"] = 68,
	},
	["Hellfire Citadel: Shattered Halls"] = {
		["zone"] = "Hellfire Peninsula",
		["limit"] = 55,
		["min"] = 69,
		["max"] = 70,
	},
	["Coilfang Reservoir: Slave Pens"] = {
		["zone"] = "Zangarmarsh",
		["limit"] = 55,
		["min"] = 61,
		["max"] = 69,
	},
	["Coilfang Reservoir: The Underbog"] = {
		["zone"] = "Zangarmarsh",
		["limit"] = 55,
		["min"] = 62,
		["max"] = 70,
	},
	["Coilfang Reservoir: The Steamvault"] = {
		["zone"] = "Zangarmarsh",
		["limit"] = 55,
		["min"] = 69,
		["max"] = 70,
	},
	["Auchindoun: Mana-Tombs"] = {
		["zone"] = "Terokkar Forest",
		["limit"] = 55,
		["min"] = 63,
		["max"] = 70,
	},
	["Auchindoun: Auchenai Crypts"] = {
		["zone"] = "Terokkar Forest",
		["limit"] = 55,
		["min"] = 64,
		["max"] = 70,
	},
	["Auchindoun: Sethekk Halls"] = {
		["zone"] = "Terokkar Forest",
		["limit"] = 55,
		["min"] = 66,
		["max"] = 70,
	},
	["Auchindoun: Shadow Labyrinth"] = {
		["zone"] = "Terokkar Forest",
		["limit"] = 65,
		["min"] = 69,
		["max"] = 70,
	},
	["Caverns of Time: Escape from Durnholde Keep"] = {
		["zone"] = "Tanaris",
		["limit"] = 66,
		["min"] = 66,
		["max"] = 68,
	},
	["Caverns of Time: Opening the Dark Portal"] = {
		["zone"] = "Tanaris",
		["limit"] = 66,
		["min"] = 68,
		["max"] = 70,
	},
	["Tempest Keep: The Mechanar"] = {
		["zone"] = "Netherstorm",
		["limit"] = 68,
		["min"] = 68,
		["max"] = 70,
	},
	["Tempest Keep: The Botanica"] = {
		["zone"] = "Netherstorm",
		["limit"] = 68,
		["min"] = 69,
		["max"] = 70,
	},
	["Tempest Keep: The Arcatraz"] = {
		["zone"] = "Netherstorm",
		["limit"] = 68,
		["min"] = 69,
		["max"] = 70,
	},
	["Magisters' Terrace"] = {
		["zone"] = "Isle of Quel'Danas",
		["limit"] = 70,
		["min"] = 70, -- Will show up at 69, but you can't get in until 70.
		["max"] = 70,
	},
}

--	Lich King Instances
if version > "3.0.0" then
	WhereToNowDatabaseDungeon["Utgarde Keep"] = {
		["zone"] = "Howling Fjord",
		["limit"] = "?",
		["min"] = 70,
		["max"] = 72,
	}
	WhereToNowDatabaseDungeon["The Nexus"] = {
		["zone"] = "Borean Tundra",
		["limit"] = "?",
		["min"] = 70,
		["max"] = 72,
	}
	WhereToNowDatabaseDungeon["Azjol-Nerub"] = {
		["zone"] = "Dragonblight",
		["limit"] = "?",
		["min"] = 72,
		["max"] = 74,
	}
	WhereToNowDatabaseDungeon["Drak'Tharon Keep"] = {
		["zone"] = "Grizzly Hills",
		["limit"] = "?",
		["min"] = 74,
		["max"] = 76,
	}
	WhereToNowDatabaseDungeon["Halls of Stone"] = {
		["zone"] = "Storm Peaks",
		["limit"] = "?",
		["min"] = 77,
		["max"] = 79,
	}
	WhereToNowDatabaseDungeon["Halls of Lightning"] = {
		["zone"] = "Storm Peaks",
		["limit"] = "?",
		["min"] = 80,
		["max"] = 80,
	}
	WhereToNowDatabaseDungeon["The Oculus"] = {
		["zone"] = "Borean Tundra",
		["limit"] = "?",
		["min"] = 80,
		["max"] = 80,
	}
	WhereToNowDatabaseDungeon["Caverns of Time: Culling of Stratholme"] = {
		["zone"] = "Tanaris",
		["limit"] = "?",
		["min"] = 80,
		["max"] = 80,
	}
	WhereToNowDatabaseDungeon["Utgarde Pinnacle"] = {
		["zone"] = "Howling Fjord",
		["limit"] = "?",
		["min"] = 80,
		["max"] = 80,
	}
	WhereToNowDatabaseDungeon["Ahn'kahet: The Old Kingdom"] = {
		["zone"] = "Dragonblight",
		["limit"] = "?",
		["min"] = "?",
		["max"] = "?",
	}
	WhereToNowDatabaseDungeon["The Violet Hold"] = {
		["zone"] = "Crystalsong Forest",
		["limit"] = "?",
		["min"] = "?",
		["max"] = "?",
	}
	WhereToNowDatabaseDungeon["Gundrak"] = {
		["zone"] = "Zul'Drak",
		["limit"] = "?",
		["min"] = "?",
		["max"] = "?",
	}
end