﻿local Z = AceLibrary("Babble-Zone-2.2")
local F = AceLibrary("Babble-Faction-2.2")
local C = AceLibrary("Babble-Class-2.2")
local P = AceLibrary("Babble-SpellTree-2.2")
local I = AceLibrary("Babble-Inventory-2.2")
local B = AceLibrary("Babble-Boss-2.2")
local L = AceLibrary("AceLocale-2.2"):new("Whats")


WhatsFactionInfo = {
	[0] = L["Reputation"],
	[1] = {
		[0] = L["Original"],
		[1] = {
			[0] = F["Argent Dawn"],
		},
		[2] = {
			[0] = F["Zandalar Tribe"],
		},
		[3] = {
			[0] = F["Thorium Brotherhood"],
		},
		[4] = {
			[0] = F["Cenarion Circle"],
		},
		[5] = {
			[0] = F["Timbermaw Hold"],
		},
		[6] = {
			[0] = F["Darkmoon Faire"],
		},
		[7] = {
			[0] = F["Brood of Nozdormu"],
		},
	},
	[2] = {
		[0] = L["Burning Crusade"],
		[1] = {
			[0] = F["The Aldor"],
		},
		[2] = {
			[0] = F["The Scryers"],
		},
		[3] = {
			[0] = F["Honor Hold"],
		},
		[4] = {
			[0] = F["Thrallmar"],
		},
		[5] = {
			[0] = F["Cenarion Expedition"],
		},
		[6] = {
			[0] = F["The Sha'tar"],
		},
		[7] = {
			[0] = F["Lower City"],
		},
		[8] = {
			[0] = F["Keepers of Time"],
		},
		[9] = {
			[0] = F["The Mag'har"],
		},
		[10] = {
			[0] = F["Kurenai"],
		},
		[11] = {
			[0] = F["Sporeggar"],
		},
		[12] = {
			[0] = F["The Consortium"],
		},
		[13] = {
			[0] = F["The Scale of the Sands"],
		},
		[14] = {
			[0] = F["The Violet Eye"],
		},
		[15] = {
			[0] = F["Tranquillien"],
		},
		[16] = {
			[0] = F["Sha'tari Skyguard"],
		},
		[17] = {
			[0] = F["Netherwing"],
		},
		[18] = {
			[0] = F["Ashtongue Deathsworn"],
		},
		[19] = {
			[0] = F["Shattered Sun Offensive"],
		},
	},
}

WhatsStandingInfo = {
	[4] = F["Neutral"],
	[5] = F["Friendly"],
	[6] = F["Honored"],
	[7] = F["Revered"],
	[8] = F["Exalted"],
}

WhatsArenaInfo = {
	[0] = L["Arena"],
	[1] = {
		[0] = string.format(L["Season %d"], 1),
	},
	[2] = {
		[0] = string.format(L["Season %d"], 2),
	},
	[3] = {
		[0] = string.format(L["Season %d"], 3),
	},
}

WhatsPointInfo = {
	[0] = L["PvP"],
	[1] = {
		[0] = L["Original"],
		[1] = {
			[0] = F["Horde"],
		},
		[2] = {
			[0] = F["Alliance"],
		},
	},
	[2] = {
		[0] = L["Burning Crusade"],
		[1] = {
			[0] = F["Horde"],
		},
		[2] = {
			[0] = F["Alliance"],
		},
	},
}

WhatsClassInfo = {
	[1] = {
		[0] = C["Warrior"],
		[1] = {
			[0] = P["Protection"],
		},
		[2] = {
			[0] = P["Arms"] .."/"..P["Fury"],
		},
	},
	[2] = {
		[0] = C["Paladin"],
		[1] = {
			[0] = P["Retribution"],
		},
		[2] = {
			[0] = P["Holy"].."-"..L["Spell Damage"],
		},
		[3] = {
			[0] = P["Holy"] .."-"..L["Healing"],
		},
		[4] = {
			[0] = P["Holy"],
		},
		[5] = {
			[0] = P["Protection"],
		},
	},
	[3] = {
		[0] = C["Shaman"],
		[1] = {
			[0] = P["Enhancement"],
		},
		[2] = {
			[0] = P["Elemental"],
		},
		[3] = {
			[0] = P["Restoration"],
		},
	},
	[4] = {
		[0] = C["Hunter"],
	},
	[5] = {
		[0] = C["Rogue"],
	},
	[6] = {
		[0] = C["Druid"],
		[1] = {
			[0] = P["Feral Combat"],
		},
		[2] = {
			[0] = P["Balance"],
		},
		[3] = {
			[0] = P["Restoration"],
		},
	},
	[7] = {
		[0] = C["Priest"],
		[1] = {
			[0] = P["Holy"],
		},
		[2] = {
			[0] = P["Shadow"],
		},
	},
	[8] = {
		[0] = C["Mage"],
	},
	[9] = {
		[0] = C["Warlock"],
		[1] = {
			[0] = L["Spell Damage"],
		},
		[2] = {
			[0] = L["Crits"],
		},
	},
}

WhatsBGInfo = {
	[0] = L["BattleGround"],
	[1] = {
		[0] = F["Frostwolf Clan"],
	},
	[2] = {
		[0] = F["Stormpike Guard"],
	},
	[3] = {
		[0] = F["The Defilers"],
	},
	[4] = {
		[0] = F["The League of Arathor"],
	},
	[5] = {
		[0] =F["Warsong Outriders"],
	},
	[6] = {
		[0] = F["Silverwing Sentinels"],
	},
}

WhatsExchangeInfo = {
	[0] = L["Exchange"],
	[1] = {
		[0] = L["Badge of Justice"],
	},
	[2] = {
		[0] = L["Badge of Justice"].."(2.3)",
	},
	[3] = {
		[0] = L["Badge of Justice"].."(2.4)",
	},
	[4] = {
		[0] = L["Badge of Justice"].."(PvP)",
	},
	[5] = {
		[0] = L["Badge of Justice"].."("..L["Armory"]..")",
	},
	[6] = {
		[0] = L["Spirit Shard"],
	},
	[7] = {
		[0] = L["Halaa"],
	},
	[8] = {
		[0] = F["Thrallmar"].."-"..L["Mark of Thrallmar"],
	},
	[9] = {
		[0] = F["Honor Hold"].."-"..L["Mark of Honor Hold"],
	},
	[10] = {
		[0] = Z["Zangarmarsh"].."-"..L["Mark of Thrallmar"],
	},
	[11] = {
		[0] = Z["Zangarmarsh"].."-"..L["Mark of Honor Hold"],
	},
	[12] = {
		[0] = F["Ogri'la"],
	}
}

WhatsExchangeNPCInfo = {
	[1] = L["G'eras"],
	[2] = L["G'eras"].."(2.3)",
	[3] = L["G'eras"].."(2.4)",
	[4] = L["Badge of Justice"].."("..L["PvP"]..")",
	[5] = L["Armory"],
	[6] = L["Spirit Sage Gartok"].."/"..L["Spirit Sage Zran"],
	[7] = L["Halaa"],
	[8] = Z["Hellfire Peninsula"].." - "..L["Battlecryer Blackeye"],
	[9] = Z["Hellfire Peninsula"].." - "..L["Warrant Officer Tracy Proudwell"],
	[10] = Z["Zangarmarsh"].." - "..L["Horde Field Scout"],
	[11] = Z["Zangarmarsh"].."-"..L["Alliance Field Scout"],
	[12] = F["Ogri'la"],
}

WhatsSetItemInfo = {
	[0] = L["Set Item"],
	[1] = {
		[0] = L["Raid"],
		[1] = {
			[0] = string.format(L["T%s"], 1),
			[1] = {
				[0] = C["Warrior"],
				["item"] = {16866, 16868, 16865, 16861, 16863, 16864, 16867, 16862},
			},
			[2] = {
				[0] = C["Paladin"],
				["item"] = {16854, 16856, 16853, 16857, 16860, 16858, 16855, 16859},
			},
			[3] = {
				[0] = C["Shaman"],
				["item"] = {16842, 16844, 16841, 16840, 16839, 16838, 16843, 16837},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {16846, 16848, 16845, 16850, 16852, 16851, 16847, 16849},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {16821, 16823, 16820, 16825, 16826, 16827, 16822, 16824},
			},
			[6] = {
				[0] = C["Druid"],
				["item"] = {16834, 16836, 16833, 16830, 16831, 16828, 16835, 16829},
			},
			[7] = {
				[0] = C["Priest"],
				["item"] = {16813, 16816, 16815, 16819, 16812, 16817, 16814, 16811},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {16795, 16797, 16798, 16799, 16801, 16802, 16796, 16800},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {16808, 16807, 16809, 16804, 16805, 16806, 16810, 16803},
			},
		},
		[2] = {
			[0] = string.format(L["T%s"], 2),
			[1] = {
				[0] = C["Warrior"],
				["item"] = {16963, 16961, 16966, 16959, 16964, 16960, 16962, 16965},
			},
			[2] = {
				[0] = C["Paladin"],
				["item"] = {16955, 16953, 16958, 16951, 16956, 16952, 16954, 16957},
			},
			[3] = {
				[0] = C["Shaman"],
				["item"] = {16947, 16945, 16950, 16943, 16948, 16944, 16946, 16949},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {16939, 16937, 16942, 16935, 16940, 16936, 16938, 16941},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {16908, 16832, 16905, 16911, 16907, 16910, 16909, 16906},
			},
			[6] = {
				[0] = C["Druid"],
				["item"] = {16900, 16902, 16897, 16904, 16899, 16903, 16901, 16898},
			},
			[7] = {
				[0] = C["Priest"],
				["item"] = {16921, 16924, 16923, 16926, 16920, 16925, 16922, 16919},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {16914, 16917, 16916, 16918, 16913, 16818, 16915, 16912},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {16929, 16932, 16931, 16934, 16928, 16933, 16930, 16927},
			},
		},
		[3] = {
			[0] = string.format(L["T%s"], 2.5),
			[1] = {
				[0] = C["Warrior"],
				["item"] = {21329, 21330, 21331, 21332, 21333},
			},
			[2] = {
				[0] = C["Paladin"],
				["item"] = {21387, 21391, 21389, 21390, 21388},
			},
			[3] = {
				[0] = C["Shaman"],
				["item"] = {21372, 21376, 21374, 21375, 21373},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {21366, 21367, 21370, 21368, 21365},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {21360, 21361, 21364, 21362, 21359},
			},
			[6] = {
				[0] = C["Druid"],
				["item"] = {21353, 21354, 21357, 21356, 21355},
			},
			[7] = {
				[0] = C["Priest"],
				["item"] = {21348, 21350, 21351, 21352, 21349},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {21347, 21345, 21343, 21346, 21344},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {21337, 21335, 21334, 21336, 21338},
			},
		},
		[4] = {
			[0] = string.format(L["T%s"], 3),
			[1] = {
				[0] = C["Warrior"],
				["item"] = {22418, 22419, 22416, 22423, 22421, 22422, 22417, 22420, 23059},
			},
			[2] = {
				[0] = C["Paladin"],
				["item"] = {22428, 22429, 22425, 22424, 22426, 22431, 22427, 22430, 23066},
			},
			[3] = {
				[0] = C["Shaman"],
				["item"] = {22466, 22467, 22464, 22471, 22469, 22470, 22465, 22468, 23065},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {22438, 22439, 22436, 22443, 22441, 22442, 22437, 22440, 23067},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {22478, 22479, 22476, 22483, 22481, 22482, 22477, 22480, 23060},
			},
			[6] = {
				[0] = C["Druid"],
				["item"] = {22490, 22491, 22488, 22495, 22493, 22494, 22489, 22492, 23064},
			},
			[7] = {
				[0] = C["Priest"],
				["item"] = {22514, 22515, 22512, 22519, 22517, 22518, 22513, 22516, 23061},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {22498, 22499, 22496, 22503, 22501, 22502, 22497, 22500, 23062},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {22506, 22507, 22504, 22511, 22509, 22510, 22505, 22508, 23063},
			},
		},
		[5] = {
			[0] = string.format(L["T%s"], 4),
			[1] = {
				[0] = C["Warrior"],
				[1] = {
					[0] = P["Protection"],
					["item"] = {29011, 29016, 29012, 29017, 29015},
				},
				[2] = {
					[0] = P["Arms"] .."/"..P["Fury"],
					["item"] = {29021, 29023, 29019, 29020, 29022},
				},
			},
			[2] = {
				[0] = C["Paladin"],
				[1] = {
					[0] = P["Holy"],
					["item"] = {29061, 29064, 29062, 29065, 29063},
				},
				[2] = {
					[0] = P["Retribution"],
					["item"] = {29073, 29075, 29071, 29072, 29074},
				},
				[3] = {
					[0] = P["Protection"],
					["item"] = {29068, 29070, 29068, 29067, 29069},
				},
			},
			[3] = {
				[0] = C["Shaman"],
				[1] = {
					[0] = P["Restoration"],
					["item"] = {29028, 29031, 29029, 29032, 29030},
				},
				[2] = {
					[0] = P["Enhancement"],
					["item"] = {29040, 29043, 29038, 29039, 29042},
				},
				[3] = {
					[0] = P["Elemental"],
					["item"] = {29035, 29037, 29033, 29034, 29036},
				},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {29081, 29084, 29082, 29085, 29083},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {29044, 29047, 29045, 29048, 29046},
			},
			[6] = {
				[0] = C["Druid"],
				[1] = {
					[0] = P["Restoration"],
					["item"] = {29086, 29089, 29087, 29090, 29088},
				},
				[2] = {
					[0] = P["Feral Combat"],
					["item"] = {29098, 29100, 29096, 29097, 29099},
				},
				[3] = {
					[0] = P["Balance"],
					["item"] = {29093, 29095, 29091, 29092, 29094},
				},
			},
			[7] = {
				[0] = C["Priest"],
				[1] = {
					[0] = P["Holy"],
					["item"] = {29049, 29054, 29050, 29055, 29053},
				},
				[2] = {
					[0] = P["Shadow"],
					["item"] = {29058, 29060, 29056, 29057, 29059},
				},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {29076, 29079, 29077, 29080, 29078},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {28963, 28967, 28964, 28968, 28966},
			},
		},
		[6] = {
			[0] = string.format(L["T%s"], 5),
			[1] = {
				[0] = C["Warrior"],
				[1] = {
					[0] = P["Protection"],
					["item"] = {30115, 30117, 30113, 30114, 30116},
				},
				[2] = {
					[0] = P["Arms"] .."/"..P["Fury"],
					["item"] = {30120, 30122, 30118, 30119, 30121},
				},
			},
			[2] = {
				[0] = C["Paladin"],
				[1] = {
					[0] = P["Holy"],
					["item"] = {30136, 30138, 30134, 30135, 30137},
				},
				[2] = {
					[0] = P["Retribution"],
					["item"] = {30125, 30127, 30123, 30124, 30126},
				},
				[3] = {
					[0] = P["Protection"],
					["item"] = {30131, 30133, 30129, 30130, 30132},
				},
			},
			[3] = {
				[0] = C["Shaman"],
				[1] = {
					[0] = P["Restoration"],
					["item"] = {30166, 30168, 30164, 30165, 30167},
				},
				[2] = {
					[0] = P["Enhancement"],
					["item"] = {30190, 30194, 30185, 30189, 30192},
				},
				[3] = {
					[0] = P["Elemental"],
					["item"] = {30171, 30173, 30169, 30170, 30172},
				},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {30141, 30143, 30139, 30140, 30142},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {30146, 30149, 30144, 30145, 30148},
			},
			[6] = {
				[0] = C["Druid"],
				[1] = {
					[0] = P["Restoration"],
					["item"] = {30219, 30221, 30216, 30217, 30220},
				},
				[2] = {
					[0] = P["Feral Combat"],
					["item"] = {30228, 30230, 30222, 30223, 30229},
				},
				[3] = {
					[0] = P["Balance"],
					["item"] = {30233, 30235, 30231, 30232, 30234},
				},
			},
			[7] = {
				[0] = C["Priest"],
				[1] = {
					[0] = P["Holy"],
					["item"] = {30152, 30154, 30150, 30151, 30153},
				},
				[2] = {
					[0] = P["Shadow"],
					["item"] = {30161, 30163, 30159, 30160, 30162},
				},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {30206, 30210, 30196, 30205, 30207},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {30212, 30215, 30214, 30211, 30213},
			},
		},
		[7] = {
			[0] = string.format(L["T%s"], 6),
			[1] = {
				[0] = C["Warrior"],
				[1] = {
					[0] = P["Protection"],
					["item"] = {30974, 30980, 30976, 30970, 30978, 34442, 34547, 34568},
				},
				[2] = {
					[0] = P["Arms"] .."/"..P["Fury"],
					["item"] = {30972, 30979, 30975, 30969, 30977, 34441, 34546, 34569},
				},
			},
			[2] = {
				[0] = C["Paladin"],
				[1] = {
					[0] = P["Retribution"],
					["item"] = {30989, 30997, 30990, 30982, 30993, 34431, 34485, 34561},
				},
				[2] = {
					[0] = P["Protection"],
					["item"] = {30987, 30998, 30991, 30985, 30995, 34433, 34488, 34560},
				},
				[3] = {
					[0] = P["Holy"],
					["item"] = {30988, 30996, 30992, 30983, 30994, 34432, 34487, 34559},
				},
			},
			[3] = {
				[0] = C["Shaman"],
				[1] = {
					[0] = P["Enhancement"],
					["item"] = {31015, 31024, 31018, 31011, 31021, 34439, 34545, 34567},
				},
				[2] = {
					[0] = P["Elemental"],
					["item"] = {31014, 31023, 31017, 31008, 31020, 34437, 34542, 34566},
				},
				[3] = {
					[0] = P["Restoration"],
					["item"] = {31012, 31022, 31016, 31007, 31019, 34438, 34543, 34565},
				},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {31003, 31006, 31004, 31001, 31005, 34443, 34549, 34570},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {31027, 31030, 31028, 31026, 31029, 34448, 34558, 34575},
			},
			[6] = {
				[0] = C["Druid"],
				[1] = {
					[0] = P["Feral Combat"],
					["item"] = {31039, 31048, 31042, 31034, 31044, 34444, 34556, 34573},
				},
				[2] = {
					[0] = P["Balance"],
					["item"] = {31040, 31049, 31043, 31035, 31046, 34446, 34555, 34572},
				},
				[3] = {
					[0] = P["Restoration"],
					["item"] = {31037, 31047, 31041, 31032, 31045, 34445, 34554, 34571},
				},
			},
			[7] = {
				[0] = C["Priest"],
				[1] = {
					[0] = P["Holy"],
					["item"] = {31063, 31069, 31066, 31060, 31068, 34435, 34527, 34562},
				},
				[2] = {
					[0] = P["Shadow"],
					["item"] = {31064, 31070, 31065, 31061, 31067, 34434, 34528, 34563},
				},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {31056, 31059, 31057, 31055, 31058, 34447, 34557, 34574},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {31051, 31054, 31052, 31050, 31053, 34436, 34541, 34564},
			},
		},
	},
	[2] = {
		[0] = L["Intance"],
		[1] = {
			[0] = Z["Scarlet Monastery"],
			[1] = {
				[0] = L["Chain of the Scarlet Crusade"],
				["item"] = {10330, 10328, 10331, 10329, 10332, 10333},
			},
		},
		[2] = {
			[0] = Z["Upper Blackrock Spire"],
			[1] = {
				[0] = L["Dal'Rend's Arms"],
				["item"] = {12940, 12939},
			},
		},
		[3] = {
			[0] = Z["Blackrock Depths"],
			[1] = {
				[0] = L["The Gladiator"],
				["item"] = {11726, 11728, 11729, 11730, 11731},
			},
		},
		[4] = {
			[0] = Z["Lower Blackrock Spire"],
			[1] = {
				[0] = L["Spider's Kiss"],
				["item"] = {13183, 13218},
			},
		},
		[5] = {
			[0] = Z["Stratholme"],
			[1] = {
				[0] = L["The Postmaster"],
				["item"] = {13388, 13389, 13390, 13391, 13392},
			},
		},
		[6] = {
			[0] = Z["Scholomance"],
			[1] = {
				[0] = L["Cadaverous Garb"],
				["item"] = {14636, 14637, 14638, 14640, 14641},
			},
			[2] = {
				[0] = L["Necropile Raiment"],
				["item"] = {14626, 14629, 14631, 14632, 14633},
			},
			[3] = {
				[0] = 	L["Bloodmail Regalia"],
				["item"] = {14614, 14616, 14615, 14611, 14612},
			},
			[4] = {
				[0] = L["Deathbone Guardian"],
				["item"] = {14624, 14622, 14620, 14623, 14621},
			},
		},
		[7] = {
			[0] = Z["The Deadmines"],
			[1] = {
				[0] = L["Defias Leather"],
				["item"] = {10399, 10403, 10402, 10401, 10400},
			},
		},
		[8] = {
			[0] = Z["Ragefire Chasm"],
			[1] = {
				[0] = L["Embrace of the Viper"],
				["item"] = {10412, 10411, 10413, 10410, 6473},
			},
		},
		[9] = {
			[0] = Z["Zul'Gurub"],
			[1] = {
				[0] = L["Major Mojo Infusion"],
				["item"] = {19898, 19925},
			},
			[2] = {
				[0] = L["Overlord's Resolution"],
				["item"] = {19873, 19912},
			},
			[3] = {
				[0] = L["Prayer of the Primal"],
				["item"] = {19863, 19920},
			},
			[4] = {
				[0] = L["Primal Blessing"],
				["item"] = {19896, 19910},
			},
			[5] = {
				[0] = L["The Twin Blades of Hakkari"],
				["item"] = {19865, 19866},
			},
			[6] = {
				[0] = L["Zanzil's Concentration"],
				["item"] = {19905, 19893},
			},
		},
		[10] = {
			[0] = L["World Drop"],
			[1] = {
				[0] = L["Ironweave Battlesuit"],
				["item"] = {22306, 22311, 22313, 22302, 22304, 22305, 22303, 22301},
			},
			[2] = {
				[0] = L["Shard of the Gods"],
				["item"] = {17082, 17064},
			},
			[3] = {
				[0] = L["Spirit of Eskhandar"],
				["item"] = {18203, 18202, 18204, 18205},
			},
			[4] = {
				[0] = L["The Twin Stars"],
				["item"] = {31339, 31338},
			},
		},
		[11] = {
			[0] = L["Naxxramas Open Event"],
			[1] = {
				[0] = L["Battlegear of Undead Slaying"],
				["item"] = {23090, 23087, 23078},
			},
			[2] = {
				[0] = L["Garb of the Undead Slayer"],
				["item"] = {23088, 23082, 23092},
			},
			[3] = {
				[0] = L["Regalia of Undead Cleansing"],
				["item"] = {23091, 23084, 23085},
			},
			[4] = {
				[0] = L["Undead Slayer's Armor"],
				["item"] = {23081, 23089, 23093},
			},
		},
		[12] = {
			[0] = Z["Silithus"],
			[1] = {
				[0] = L["Twilight Trappings"],
				["item"] = {20406, 20408, 20407},
			},
		},
		[13] = {
			[0] = string.format(L["T%s"], 1),
			[1] = {
				[0] = C["Warrior"],
				["item"] = {16736, 16734, 16735, 16730, 16737, 16731, 16732, 16733},
			},
			[2] = {
				[0] = C["Paladin"],
				["item"] = {16723, 16725, 16722, 16726, 16724, 16728, 16729, 16727},
			},
			[3] = {
				[0] = C["Shaman"],
				["item"] = {16673, 16670, 16671, 16667, 16672, 16668, 16669, 16666},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {16680, 16675, 16681, 16677, 16674, 16678, 16679, 16676},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {16713, 16711, 16710, 16721, 16708, 16709, 16712, 16707},
			},
			[6] = {
				[0] = C["Druid"],
				["item"] = {16716, 16715, 16714, 16720, 16706, 16718, 16719, 16717},
			},
			[7] = {
				[0] = C["Priest"],
				["item"] = {16696, 16691, 16697, 16693, 16692, 16695, 16694, 16690},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {16685, 16683, 16686, 16684, 16687, 16689, 16688, 16682},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {16702, 16703, 16699, 16701, 16700, 16704, 16698, 16705},
			},
		},
		[14] = {
			[0] = string.format(L["T%s"], 2),
			[1] = {
				[0] = C["Warrior"],
				["item"] = {21994, 21995, 21996, 21997, 21998, 21999, 22000, 22001},
			},
			[2] = {
				[0] = C["Paladin"],
				["item"] = {22086, 22087, 22088, 22089, 22090, 22091, 22092, 22093},
			},
			[3] = {
				[0] = C["Shaman"],
				["item"] = {22095, 22096, 22097, 22098, 22099, 22100, 22101, 22102},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {22010, 22011, 22061, 22013, 22015, 22016, 22017, 22060},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {22002, 22003, 22004, 22005, 22006, 22007, 22008, 22009},
			},
			[6] = {
				[0] = C["Druid"],
				["item"] = {22106, 22107, 22108, 22109, 22110, 22111, 22112, 22113},
			},
			[7] = {
				[0] = C["Priest"],
				["item"] = {22078, 22079, 22080, 22081, 22082, 22083, 22084, 22085},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {22062, 22063, 22064, 22065, 22066, 22067, 22068, 22069},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {22070, 22071, 22072, 22073, 22074, 22075, 22076, 22077},
			},
		},
		[15] = {
			[0] = string.format(L["T%s"], 3),
			[1] = {
				[0] = C["Warrior"],
				["item"] = {28350, 27803, 28205, 27475, 27977},
			},
			[2] = {
				[0] = C["Paladin"],
				["item"] = {28285, 27739, 28203, 27535, 27839},
			},
			[3] = {
				[0] = C["Shaman"],
				["item"] = {28349, 27802, 28231, 27510, 27909},
			},
			[4] = {
				[0] = C["Hunter"],
				["item"] = {28275, 27801, 28228, 27474, 27874},
			},
			[5] = {
				[0] = C["Rogue"],
				["item"] = {28414, 27776, 28204, 27509, 27908},
			},
			[6] = {
				[0] = C["Druid"],
				["item"] = {28348, 27737, 28202, 27468, 27873},
			},
			[7] = {
				[0] = C["Priest"],
				["item"] = {28413, 27775, 28230, 27536, 27875},
			},
			[8] = {
				[0] = C["Mage"],
				["item"] = {28278, 27738, 28229, 27508, 27838},
			},
			[9] = {
				[0] = C["Warlock"],
				["item"] = {28415, 27778, 28232, 27537, 27948},
			},
			[10] = {
				[0] = I["Cloth"],
				["item"] = {28193, 27796, 28191, 27465, 27907},
			},
			[11] = {
				[0] = I["Leather"],
				["item"] = {28224, 27797, 28264, 27531, 27837},
			},
			[12] = {
				[0] = I["Mail"],
				["item"] = {28192, 27713, 28401, 27528, 27936},
			},
			[13] = {
				[0] = I["Plate"],
				["item"] = {28225, 27771, 28403, 27497, 27870},
			},
		},
	},
	[3] = {
		[0] = L["Trade Skill"],
		[1] = {
			[0] = L["Blacksmithing"],
			[1] = {
				[0] = L["Adamantite Battlegear"],
				["item"] = {23507, 23508, 23506},
			},
			[2] = {
				[0] = L["Bloodsoul Embrace"],
				["item"] = {19690, 19691, 19692},
			},
			[3] = {
				[0] = L["Burning Rage"],
				["item"] = {23522, 23521, 23520},
			},
			[4] = {
				[0] = L["Enchanted Adamantite Armor"],
				["item"] = {23509, 23512, 23511, 23510},
			},
			[5] = {
				[0] = L["Faith in Felsteel"],
				["item"] = {23519, 23518, 23517},
			},
			[6] = {
				[0] = L["Fel Iron Chain"],
				["item"] = {23490, 23491, 23493, 23494},
			},
			[7] = {
				[0] = L["Fel Iron Plate"],
				["item"] = {23489, 23488, 23487, 23482, 23484},
			},
			[8] = {
				[0] = L["Imperial Plate"],
				["item"] = {12424, 12426, 12425, 12422, 12427, 12429, 12428},
			},
			[9] = {
				[0] = L["Khorium Ward"],
				["item"] = {23523, 23525, 23524},
			},
			[10] = {
				[0] = L["Shadow Guard"],
				["item"] = {23513, 23516, 23514, 23515},
			},
			[11] = {
				[0] = L["The Darksoul"],
				["item"] = {19693, 19694, 19695},
			},
		},
		[2] = {
			[0] = L["Tailoring"],
			[1] = {
				[0] = L["Arcanoweave Vestments"],
				["item"] = {21868, 21866, 21867},
			},
			[2] = {
				[0] = L["Battlecast Garb"],
				["item"] = {24267, 24263},
			},
			[3] = {
				[0] = L["Bloodvine Garb"],
				["item"] = {19682, 19683, 19684},
			},
			[4] = {
				[0] = L["Imbued Netherweave"],
				["item"] = {21862, 21861, 21859, 21860},
			},
			[5] = {
				[0] = L["Netherweave Vestments"],
				["item"] = {21855, 21854, 21852, 21851, 21849, 21853, 21850},
			},
			[6] = {
				[0] = L["Primal Mooncloth"],
				["item"] = {21875, 21874, 21873},
			},
			[7] = {
				[0] = L["Shadow's Embrace"],
				["item"] = {21871, 21869, 21870},
			},
			[8] = {
				[0] = L["Soulcloth Embrace"],
				["item"] = {21865, 21864, 21863},
			},
			[9] = {
				[0] = L["Spellstrike Infusion"],
				["item"] = {24266, 24262},
			},
			[10] = {
				[0] = L["The Unyielding"],
				["item"] = {24255, 24249},
			},
			[11] = {
				[0] = L["Whitemend Wisdom"],
				["item"] = {24264, 24261},
			},
			[12] = {
				[0] = L["Wrath of Spellfire"],
				["item"] = {21848, 21847, 21846},
			},
		},
		[3] = {
			[0] = L["Leatherworking"],
			[1] = {
				[0] = L["Black Dragon Mail"],
				["item"] = {16984, 15050, 15052, 15051},
			},
			[2] = {
				[0] = L["Blue Dragon Mail"],
				["item"] = {15048, 20295, 15049},
			},
			[3] = {
				[0] = L["Blood Tiger Harness"],
				["item"] = {19688, 19689},
			},
			[4] = {
				[0] = L["Devilsaur Armor"],
				["item"] = {15062, 15063},
			},
			[5] = {
				[0] = L["Fel Skin"],
				["item"] = {25685, 25686, 25687},
			},
			[6] = {
				[0] = L["Felscale Armor"],
				["item"] = {25657, 25656, 25655, 25654},
			},
			[7] = {
				[0] = L["Felstalker Armor"],
				["item"] = {25695, 25697, 25696},
			},
			[8] = {
				[0] = L["Fury of the Nether"],
				["item"] = {25694, 25693, 25692},
			},
			[9] = {
				[0] = L["Green Dragon Mail"],
				["item"] = {15045, 15046, 20296},
			},
			[10] = {
				[0] = L["Ironfeather Armor"],
				["item"] = {15066, 15067},
			},
			[11] = {
				[0] = L["Netherscale Armor"],
				["item"] = {29516, 29517, 29515},
			},
			[12] = {
				[0] = L["Netherstrike Armor"],
				["item"] = {29521, 29520, 29519},
			},
			[13] = {
				[0] = L["Primal Batskin"],
				["item"] = {19685, 19687, 19686},
			},
			[14] = {
				[0] = L["Primal Intent"],
				["item"] = {29527, 29526, 29525},
			},
			[15] = {
				[0] = L["Scaled Draenic Armor"],
				["item"] = {25661, 25659, 25662, 25660},
			},
			[16] = {
				[0] = L["Stormshroud Armor"],
				["item"] = {15056, 15057, 15058, 21278},
			},
			[17] = {
				[0] = L["Strength of the Clefthoof"],
				["item"] = {25691, 25690, 25689},
			},
			[18] = {
				[0] = L["Thick Draenic Armor"],
				["item"] = {25668, 25669, 25670, 25671},
			},
			[19] = {
				[0] = L["Volcanic Armor"],
				["item"] = {15053, 15054, 15055},
			},
			[20] = {
				[0] = L["Wild Draenish Armor"],
				["item"] = {25673, 25674, 25675, 25676},
			},
			[21] = {
				[0] = L["Windhawk Armor"],
				["item"] = {29523, 29524, 29522},
			},
		},
	},
	[4] = {
		[0] = L["PvP"],
		[1] = {
			[0] = string.format(L["T%s"], 0.5),
			[1] = {
				[0] = C["Warrior"],
				[1] = {
					[0] = L["Savage Plate Battlegear"],
					["item"] = {35407, 35408, 35409, 35410, 35411, 35478}
				},
			},
			[2] = {
				[0] = C["Paladin"],
				[1] = 	{
					[0] = L["Crusader's Scaled Battledgear"],
					["item"] = {35412, 35413, 35414, 35415, 35416, 35477}
				},
				[2] = 	{
					[0] = L["Crusader's Ornamented Battledgear"],
					["item"] = {35402, 35403, 35404, 35405, 35406, 35476}
				},
			},
			[3] = {
				[0] = C["Shaman"],
				[1] = {
					[0] = L["Seer's Linked Battlegear"],
					["item"] = {35381, 35382, 35383, 35384, 35385, 35474}
				},
				[2] = {
					[0] = L["Seer's Mail Battlegear"],
					["item"] = {35386, 35387, 35388, 35389, 35390, 35472}
				},
				[3] = {
					[0] = L["Seer's Ringmail Battlegear"],
					["item"] = {35391, 35392, 35393, 35394, 35395, 35473}
				},
			},
			[4] = {
				[0] = C["Hunter"],
				[1] = {
					[0] = L["Stalker's Chain Battlegear"],
					["item"] = {35376, 35377, 35378, 35379, 35380, 35475}
				},
			},
			[5] = {
				[0] = C["Rogue"],
				[1] = {
					[0] = L["Opportunist's Battlegear"],
					["item"] = {35366, 35367, 35368, 35369, 35370, 35468}
				},
			},
			[6] = {
				[0] = C["Druid"],
				[1] = {
					[0] = L["Dragonhide Battlegear"],
					["item"] = {35356, 35357, 35358, 35359, 35360, 35469}
				},
				[2] = {
					[0] = L["Kodohide Battlegear"],
					["item"] = {35361, 35362, 35363, 35364, 35365, 35470}
				},
				[3] = {
					[0] = L["Wyrmhide Battlegear"],
					["item"] = {35371, 35372, 35373, 35374, 35375, 35471}
				},
			},
			[7] = {
				[0] = C["Priest"],
				[1] = {
					[0] = L["Mooncloth Battlegear"],
					["item"] = {35333, 35334, 35335, 35336, 35337, 35467}
				},
				[2] = {
					[0] = L["Satin Battlegear"],
					["item"] = {35338, 35339, 35340, 35341, 35342, 35466}
				},
			},
			[8] = {
				[0] = C["Mage"],
				[1] = {
					[0] = L["Evoker's Silk Battlegear"],
					["item"] = {35343, 35344, 35345, 35346, 35347, 35465}
				},
			},
			[9] = {
				[0] = C["Warlock"],
				[1] = {
					[0] = L["Dreadweave Battlegear"],
					["item"] = {35328, 35329, 35330, 35331, 35332, 35464}
				},
			},
		}
	}
}


WhatsItemType = {
	["B"] = I["Bag"],
	["BB"] = I["Bag"],
	["BL"] = L["Leatherworking Bag"],
	["BE"] = L["Engineering Bag"],
	["BN"] = L["Enchanting Bag"],
	["BJ"] = L["Gem Bag"],
	["BH"] = L["Herb Bag"],
	["BS"] = L["Soul Bag"],
	["BM"] = L["Mining Bag"],
	["O"] = L["Others"],
	["OP"] = L["Mini Pet"],
	["OR"] = L["Reagent"],
	["OF"] = L["Festival"],
	["W"] = I["Weapon"],
	["WO"] = L["Others"],
	["WFp"] = I["Fishing Pole"],
	["WD"] = I["Daggers"],
	["WDh"] = I["Daggers"].." - "..I["Off Hand"],
	["WDm"] = I["Daggers"].." - "..I["Main Hand"],
	["WWd"] = I["Wand"],
	["WCb"] = I["Crossbow"],
	["WSt"] = I["Two-Handed Swords"],
	["WXt"] = I["Two-Handed Axes"],
	["WHt"] = I["Two-Handed Maces"],
	["WF"] = I["Fist Weapons"],
	["WFh"] = I["Fist Weapons"].." - "..I["Off Hand"],
	["WFm"] = I["Fist Weapons"].." - "..I["Main Hand"],
	["WPt"] = I["Polearms"],
	["WSf"] = I["Staff"],
	["WGn"] = I["Guns"],
	["WTh"] = I["Thrown"],
	["WSo"] = I["One-Handed Swords"],
	["WSh"] = I["One-Handed Swords"].." - "..I["Off Hand"],
	["WSm"] = I["One-Handed Swords"].." - "..I["Main Hand"],
	["WXo"] = I["One-Handed Axes"],
	["WXh"] = I["One-Handed Axes"].." - "..I["Off Hand"],
	["WXm"] = I["One-Handed Axes"].." - "..I["Main Hand"],
	["WHo"] = I["One-Handed Maces"],
	["WHh"] = I["One-Handed Maces"].." - "..I["Off Hand"],
	["WHm"] = I["One-Handed Maces"].." - "..I["Main Hand"],
	["WBw"] = I["Bows"],
	["A"] = L["Armor"],
	["AL"] = I["Leather"],
	["ALc"] = I["Leather"].." - "..I["Chest"],
	["ALl"] = I["Leather"].." - "..I["Legs"],
	["ALh"] = I["Leather"].." - "..I["Head"],
	["ALf"] = I["Leather"].." - "..I["Feet"],
	["ALn"] = I["Leather"].." - "..I["Hands"],
	["ALr"] = I["Leather"].." - "..I["Wrist"],
	["ALs"] = I["Leather"].." - "..I["Shoulder"],
	["ALw"] = I["Leather"].." - "..I["Waist"],
	["AO"] = L["Others"],
	["AN"] = I["Neck"],
	["AOa"] = I["Held in Off-Hand"],
	["AOi"] = I["Shirt"],
	["AF"] = I["Ring"],
	["AOr"] = I["Trinket"],
	["AS"] = I["Shield"],
	["AM"] = I["Mail"],
	["AMc"] = I["Mail"].." - "..I["Chest"],
	["AMl"] = I["Mail"].." - "..I["Legs"],
	["AMh"] = I["Mail"].." - "..I["Head"],
	["AMf"] = I["Mail"].." - "..I["Feet"],
	["AMn"] = I["Mail"].." - "..I["Hands"],
	["AMr"] = I["Mail"].." - "..I["Wrist"],
	["AMs"] = I["Mail"].." - "..I["Shoulder"],
	["AMw"] = I["Mail"].." - "..I["Waist"],
	["AB"] = I["Libram"],
	["AR"] = I["Idol"],
	["AC"] = I["Cloth"],
	["ACc"] = I["Cloth"].." - "..I["Chest"],
	["ACl"] = I["Cloth"].." - "..I["Legs"],
	["CO"] = I["Cloak"],
	["ACh"] = I["Cloth"].." - "..I["Head"],
	["ACf"] = I["Cloth"].." - "..I["Feet"],
	["ACn"] = I["Cloth"].." - "..I["Hands"],
	["ACr"] = I["Cloth"].." - "..I["Wrist"],
	["ACs"] = I["Cloth"].." - "..I["Shoulder"],
	["ACw"] = I["Cloth"].." - "..I["Waist"],
	["AT"] = I["Totem"],
	["AP"] = I["Plate"],
	["APc"] = I["Plate"].." - "..I["Chest"],
	["APl"] = I["Plate"].." - "..I["Legs"],
	["APh"] = I["Plate"].." - "..I["Head"],
	["APf"] = I["Plate"].." - "..I["Feet"],
	["APn"] = I["Plate"].." - "..I["Hands"],
	["APr"] = I["Plate"].." - "..I["Wrist"],
	["APs"] = I["Plate"].." - "..I["Shoulder"],
	["APw"] = I["Plate"].." - "..I["Waist"],
	["G"] = L["Gems"],
	["GY"] = L["Gems"].." - "..L["Yellow"],
	["GG"] = L["Gems"].." - "..L["Green"],
	["GL"] = L["Gems"].." - "..L["Prismatic"],
	["GV"] = L["Gems"].." - "..L["Purple"],
	["GM"] = L["Gems"].." - "..L["Meta"],
	["GN"] = L["Gems"],
	["GO"] = L["Gems"].." - "..L["Orange"],
	["GB"] = L["Gems"].." - "..L["Blue"],
	["GR"] = L["Gems"].." - "..L["Red"],
	["C"] = L["Consumable"],
	["CS"] = L["Scrolls"],
	["CP"] = I["Potion"],
	["CB"] = I["Bandage"],
	["CE"] = L["Elixir"],
	["CC"] = L["Consumable"],
	["CI"] = L["Item Enchant"],
	["CF"] = L["Flask"],
	["CK"] = I["Food"].." & "..I["Drink"],
	["K"] = I["Key"],
	["R"] = L["Reagent"],
	["E"] = L["Recipe"],
	["EL"] = L["Recipe"].." - "..L["Leatherworking"],
	["EE"] = L["Recipe"].." - "..L["Engineering"],
	["EF"] = L["Recipe"].." - "..L["Fishing"],
	["EB"] = L["Recipe"].." - "..L["Blacksmithing"],
	["EN"] = L["Recipe"].." - "..L["Enchanting"],
	["EJ"] = L["Recipe"].." - "..L["Jewelcrafting"],
	["EA"] = L["Recipe"].." - "..L["Alchemy"],
	["EC"] = L["Recipe"].." - "..L["Cooking"],
	["ED"] = L["Recipe"].." - "..L["First Aid"],
	["ET"] = L["Recipe"].." - "..L["Tailoring"],
	["EK"] = L["Book"],
	["D"] = L["Trade Goods"],
	["Q"] = L["Quest"],
	["F"] = L["Projectile"],
	["FP"] = I["Bullet"],
	["FA"] = I["Arrow"],
	["H"] = I["Quiver"],
	["HP"] = I["Ammo Pouch"],
	["HA"] = I["Quiver"],
}

WhatsItemMenu = {
	["B"] = I["Bag"],
	["BB"] = I["Bag"],
	["BL"] = I["Bag"],
	["BE"] = I["Bag"],
	["BN"] = I["Bag"],
	["BJ"] = I["Bag"],
	["BH"] = I["Bag"],
	["BS"] = I["Bag"],
	["BM"] = I["Bag"],
	["O"] = L["Others"],
	["OP"] = L["Mini Pet"],
	["OR"] = L["Reagent"],
	["OF"] = L["Festival"],
	["W"] = I["Weapon"],
	["WO"] = I["Weapon"],
	["WFp"] = I["Fishing Pole"],
	["WD"] = I["One-Hand"].." "..I["Weapon"],
	["WDh"] = I["Off Hand"],
	["WDm"] = I["One-Hand"].." "..I["Weapon"],
	["WWd"] = L["Range Weapon"],
	["WCb"] = L["Range Weapon"],
	["WSt"] = I["Two-Hand"].." "..I["Weapon"],
	["WXt"] = I["Two-Hand"].." "..I["Weapon"],
	["WHt"] = I["Two-Hand"].." "..I["Weapon"],
	["WF"] = I["One-Hand"].." "..I["Weapon"],
	["WFh"] = I["Off Hand"],
	["WFm"] = I["One-Hand"].." "..I["Weapon"],
	["WPt"] = I["Two-Hand"].." "..I["Weapon"],
	["WSf"] = I["Two-Hand"].." "..I["Weapon"],
	["WGn"] = L["Range Weapon"],
	["WTh"] = L["Range Weapon"],
	["WSo"] = I["One-Hand"].." "..I["Weapon"],
	["WSh"] = I["Off Hand"],
	["WSm"] = I["One-Hand"].." "..I["Weapon"],
	["WXo"] = I["One-Hand"].." "..I["Weapon"],
	["WXh"] = I["Off Hand"],
	["WXm"] = I["One-Hand"].." "..I["Weapon"],
	["WHo"] = I["One-Hand"].." "..I["Weapon"],
	["WHh"] = I["Off Hand"],
	["WHm"] = I["One-Hand"].." "..I["Weapon"],
	["WBw"] = L["Range Weapon"],
	["A"] = L["Armor"],
	["AL"] = I["Leather"],
	["ALc"] = I["Leather"],
	["ALl"] = I["Leather"],
	["ALh"] = I["Leather"],
	["ALf"] = I["Leather"],
	["ALn"] = I["Leather"],
	["ALr"] = I["Leather"],
	["ALs"] = I["Leather"],
	["ALw"] = I["Leather"],
	["AO"] = L["Others"],
	["AN"] = I["Neck"],
	["AOa"] = I["Held in Off-Hand"],
	["AOi"] = I["Shirt"],
	["AF"] = I["Ring"],
	["AOr"] = I["Trinket"],
	["AS"] = I["Shield"],
	["AM"] = I["Mail"],
	["AMc"] = I["Mail"],
	["AMl"] = I["Mail"],
	["AMh"] = I["Mail"],
	["AMf"] = I["Mail"],
	["AMn"] = I["Mail"],
	["AMr"] = I["Mail"],
	["AMs"] = I["Mail"],
	["AMw"] = I["Mail"],
	["AB"] = I["Relic"],
	["AR"] = I["Relic"],
	["AC"] = I["Cloth"],
	["ACc"] = I["Cloth"],
	["ACl"] = I["Cloth"],
	["CO"] = I["Cloak"],
	["ACh"] = I["Cloth"],
	["ACf"] = I["Cloth"],
	["ACn"] = I["Cloth"],
	["ACr"] = I["Cloth"],
	["ACs"] = I["Cloth"],
	["ACw"] = I["Cloth"],
	["AT"] = I["Relic"],
	["AP"] = I["Plate"],
	["APc"] = I["Plate"],
	["APl"] = I["Plate"],
	["APh"] = I["Plate"],
	["APf"] = I["Plate"],
	["APn"] = I["Plate"],
	["APr"] = I["Plate"],
	["APs"] = I["Plate"],
	["APw"] = I["Plate"],
	["G"] = L["Gems"],
	["GY"] = L["Gems"],
	["GG"] = L["Gems"],
	["GL"] = L["Gems"],
	["GV"] = L["Gems"],
	["GM"] = L["Gems"],
	["GN"] = L["Gems"],
	["GO"] = L["Gems"],
	["GB"] = L["Gems"],
	["GR"] = L["Gems"],
	["C"] = L["Consumable"],
	["CS"] = L["Scrolls"],
	["CP"] = I["Potion"],
	["CB"] = I["Bandage"],
	["CE"] = L["Elixir"],
	["CC"] = L["Consumable"],
	["CI"] = L["Item Enchant"],
	["CF"] = L["Flask"],
	["CK"] = I["Food"].." & "..I["Drink"],
	["K"] = I["Key"],
	["R"] = L["Reagent"],
	["E"] = L["Recipe"],
	["EL"] = L["Recipe"].." - "..L["Leatherworking"],
	["EE"] = L["Recipe"].." - "..L["Engineering"],
	["EF"] = L["Recipe"].." - "..L["Fishing"],
	["EB"] = L["Recipe"].." - "..L["Blacksmithing"],
	["EN"] = L["Recipe"].." - "..L["Enchanting"],
	["EJ"] = L["Recipe"].." - "..L["Jewelcrafting"],
	["EA"] = L["Recipe"].." - "..L["Alchemy"],
	["EC"] = L["Recipe"].." - "..L["Cooking"],
	["ED"] = L["Recipe"].." - "..L["First Aid"],
	["ET"] = L["Recipe"].." - "..L["Tailoring"],
	["EK"] = L["Book"],
	["D"] = L["Trade Goods"],
	["Q"] = L["Quest"],
	["F"] = L["Projectile"],
	["FP"] = L["Projectile"],
	["FA"] = L["Projectile"],
	["H"] = I["Quiver"],
	["HP"] = I["Quiver"],
	["HA"] = I["Quiver"],
}

WhatsMainMenu = {
	[0] = "|CFF00CED1W|r|CFFFFFFFFhats|r",
	[1] = WhatsMobInfo,
	[2] = WhatsExchangeInfo,
	[3] = WhatsFactionInfo,
	[4] = WhatsArenaInfo,
	[5] = WhatsBGInfo,
	[6] = WhatsPointInfo,
	[7] = WhatsSetItemInfo,
	[8] = WhatsFieldInfo,
}

WhatsTokenTable = {
	[29753] = B["Magtheridon"],
	[29754] = B["Magtheridon"],
	[29755] = B["Magtheridon"],
	[29756] = B["The Curator"],
	[29757] = B["The Curator"],
	[29758] = B["The Curator"],
	[29759] = B["Prince Malchezaar"],
	[29760] = B["Prince Malchezaar"],
	[29761] = B["Prince Malchezaar"],
	[29762] = B["High King Maulgar"],
	[29763] = B["High King Maulgar"],
	[29764] = B["High King Maulgar"],
	[29765] = B["Gruul the Dragonkiller"],
	[29766] = B["Gruul the Dragonkiller"],
	[29767] = B["Gruul the Dragonkiller"],
	[30236] = B["Kael'thas Sunstrider"],
	[30237] = B["Kael'thas Sunstrider"],
	[30238] = B["Kael'thas Sunstrider"],
	[30239] = B["Leotheras the Blind"],
	[30240] = B["Leotheras the Blind"],
	[30241] = B["Leotheras the Blind"],
	[30242] = B["Lady Vashj"],
	[30243] = B["Lady Vashj"],
	[30244] = B["Lady Vashj"],
	[30245] = B["Fathom-Lord Karathress"],
	[30246] = B["Fathom-Lord Karathress"],
	[30247] = B["Fathom-Lord Karathress"],
	[30248] = B["Void Reaver"],
	[30249] = B["Void Reaver"],
	[30250] = B["Void Reaver"],
	[31089] = B["Illidan Stormrage"],
	[31090] = B["Illidan Stormrage"],
	[31091] = B["Illidan Stormrage"],
	[31092] = B["Azgalor"],
	[31093] = B["Azgalor"],
	[31094] = B["Azgalor"],
	[31095] = B["Archimonde"],
	[31096] = B["Archimonde"],
	[31097] = B["Archimonde"],
	[31098] = B["Illidari Council"],
	[31099] = B["Illidari Council"],
	[31100] = B["Illidari Council"],
	[31101] = B["Mother Shahraz"],
	[31102] = B["Mother Shahraz"],
	[31103] = B["Mother Shahraz"],
	[34848] = B["Kalecgos"],
	[34851] = B["Kalecgos"],
	[34852] = B["Kalecgos"],
	[34853] = B["Brutallus"],
	[34854] = B["Brutallus"],
	[34855] = B["Brutallus"],
	[34856] = B["Felmyst"],
	[34857] = B["Felmyst"],
	[34858] = B["Felmyst"],
}
