﻿Whats = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "FuBarPlugin-2.0")

local TipHooker = AceLibrary("TipHooker-1.0")
local SharedMedia = AceLibrary("SharedMedia-1.0")
local DD = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("Whats")

local self = Whats

local _G = _G

local menuTable = { }
local WhatsSearchList = { }
local WhatsResultList = { }
local WhatsZoneTable = nil
local ItemColorTable = {
	[0] = "9d9d9d",
	[1] = "ffffff",
	[2] = "1eff00",
	[3] = "0070dd",
	[4] = "a335ee",
	[5] = "ff8000",
	[6] = "e6cc80",
}
local itemTypeTable = {
	[1] = "I",
	[2] = "E",
	[3] = "F",
	[4] = "A",
	[5] = "B",
	[6] = "P",
}


Whats.Option = { 
	name = L["Whats"],
	desc = L["Whats Option"],
	type = "group", 
	args = {
		Open = {
			name = L["Open"],
			order = 1,
			type = "execute",
			desc = L["Display Whats Menu"],
			func = function() self:OnClick() DD:Close() end,
		},
		Search = {
			name = L["Search"],
			order = 3,
			type = "text",
			usage = L["Item ID or Item name"],
			desc = L["Searching Items"],
			get = false,
			set = function(t) self.Search(t) end
		},
		SaveData = {
			name = L["Save Data"],
			order = 4,
			type = "toggle",
			desc = L["Toggle saving WhatsItemDB"],
			get = function() return self.db.profile.savedata end,
			set = function() self.db.profile.savedata = not self.db.profile.savedata end
		},
		Lock = {
			name = L["Lock"],
			order = 5,
			type = "toggle",
			desc = L["Toggle movable"],
			get = function() return self.db.profile.lock end,
			set = function() self.db.profile.lock = not self.db.profile.lock end
		},
		MobTooltip = {
			name = L["Mob Tooltip"],
			order = 5,
			type = "toggle",
			desc = L["Toggle show mob tooltip"],
			get = function() return self.db.profile.mobTooltip end,
			set = function() 
				self.db.profile.mobTooltip = not self.db.profile.mobTooltip 
				if self.db.profile.mobTooltip == true then
					self:RegisterEvent("ZONE_CHANGED", "ZoneUpdate")
					self:RegisterEvent("ZONE_CHANGED_INDOORS", "ZoneUpdate")
					self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "ZoneUpdate")
				--	self:RegisterEvent("MINIMAP_ZONE_CHANGED", "ZoneUpdate")
					self:RegisterEvent("PLAYER_ENTERING_WORLD", "ZoneUpdate")
					self:ZoneUpdate()

					TipHooker:Hook(self.UnitTooltip, "unit")
				else
					self:UnregisterEvent("ZONE_CHANGED")
					self:UnregisterEvent("ZONE_CHANGED_INDOORS")
					self:UnregisterEvent("ZONE_CHANGED_NEW_AREA")
				--	self:UnregisterEvent("MINIMAP_ZONE_CHANGED")
					self:UnregisterEvent("PLAYER_ENTERING_WORLD")

					TipHooker:Unhook(self.UnitTooltip, "unit")
				end
			end
		},
		Appearance = {
			type = "group",
			name = L["Appearance"],
			order = 2,
			desc = L["Set Whats Displey Option."],
			args = {
				Menu = {
					type = "group",
					name = L["Menu"],
					order = 1,
					desc = L["Menu Option"],
					args = {
						Border = {
							type = "text",
							name = L["Border"],
							desc = L["Set Border of Whats menu"],
							validate = SharedMedia:List('border'),
							get = function() return self.db.profile.menuborder end,
							set = function(b) 
								self.db.profile.menuborder = b
								Whats:ApplySetting()
							end
						},
						Width = {
							name = L["Width"],
							type = "range",
							desc = L["Set width of Whats menu."],
							min = 100,
							max = 200,
							step = 10,
							get = function() return self.db.profile.menuWidth end,
							set = function(r) 
								self.db.profile.menuWidth = r 
								Whats:ApplySetting()
							end
						},
						Height = {
							name = L["Height"],
							type = "range",
							desc = L["Set height of Whats menu."],
							min = 10,
							max = 30,
							step = 1,
							get = function() return self.db.profile.menuHeight end,
							set = function(h) 
								self.db.profile.menuHeight = h
								Whats:ApplySetting()
							end
						},
						Color = {
							name = L["Color"],
							desc = L["Set color of Whats menu."],
							type = "color",
							get = function() return self.db.profile.Mcolor.r, self.db.profile.Mcolor.g, self.db.profile.Mcolor.b, self.db.profile.Mcolor.a end,
							set = function(r, g, b, a) self.db.profile.Mcolor.r, self.db.profile.Mcolor.g, self.db.profile.Mcolor.b, self.db.profile.Mcolor.a = r, g, b, a 
								Whats:ApplySetting()
							end,
						},
						Texture = {
							name = L["Texture"],
							type = "text",
							desc = L["Set texture of Whats menu."],
							validate = SharedMedia:List('background'),
							get = function() return self.db.profile.menutexture end,
							set = function(t) 
								self.db.profile.menutexture = t 
								Whats:ApplySetting()
							end
						},
						Font = {
							name = L["Font"],
							type = "text",
							desc = L["Set font of Whats menu."],
							validate = SharedMedia:List('font'),
							get = function() return self.db.profile.menufont end,
							set = function(f) 
								self.db.profile.menufont = f 
								Whats:ApplySetting()
							end
						},
						FontSize = {
							name = L["Font Size"],
							type = "range",
							desc = L["Set font size of Whats menu"],
							min = 5,
							max = 20,
							step = 1,
							get = function() return self.db.profile.menufontsize end,
							set = function(s) 
								self.db.profile.menufontsize = s
								Whats:ApplySetting()
							end
						},
						Growth = {
							name = L["Direction"],
							type = "text",
							desc = L["Set growth direction of Whats menu"],
							validate = {["U"] = L["Up"], ["D"] = L["Down"], ["L"] = L["Left"], ["R"] = L["Right"]},
							get = function() return self.db.profile.growth end,
							set = function(g) 
								self.db.profile.growth = g 
								Whats:ApplySetting()
							end

						},
					}
				},
				SubMenu = {
					type = "group",
					name = L["Sub Menu"],
					order = 2,
					desc = L["Sub Menu Option"],
					args = {
						Border = {
							type = "text",
							name = L["Border"],
							desc = L["Set Border of Whats sub menu"],
							validate = SharedMedia:List('border'),
							get = function() return self.db.profile.submenuborder end,
							set = function(b) 
								self.db.profile.submenuborder = b
								Whats:ApplySetting()
							end
						},
						Width = {
							name = L["Width"],
							type = "range",
							desc = L["Set width of Whats sub menu."],
							min = 100,
							max = 200,
							step = 10,
							get = function() return self.db.profile.submenuWidth end,
							set = function(r) 
								self.db.profile.submenuWidth = r 
								Whats:ApplySetting()
							end
						},
						Height = {
							name = L["Height"],
							type = "range",
							desc = L["Set height of Whats sub menu."],
							min = 10,
							max = 30,
							step = 1,
							get = function() return self.db.profile.submenuHeight end,
							set = function(h) 
								self.db.profile.submenuHeight = h
								Whats:ApplySetting()
							end
						},
						Color = {
							type = "color",
							name = L["Color"],
							desc = L["Set color of Whats sub menu."],
							get = function() return self.db.profile.Scolor.r, self.db.profile.Scolor.g, self.db.profile.Scolor.b, self.db.profile.Scolor.a end,
							set = function(r, g, b, a) self.db.profile.Scolor.r, self.db.profile.Scolor.g, self.db.profile.Scolor.b, self.db.profile.Scolor.a = r, g, b, a 
								Whats:ApplySetting()
							end,
						},
						Texture = {
							name = L["Texture"],
							type = "text",
							desc = L["Set texture of Whats sub menu."],
							validate = SharedMedia:List('background'),
							get = function() return self.db.profile.submenutexture end,
							set = function(t) 
								self.db.profile.submenutexture = t 
								Whats:ApplySetting()
							end
						},
						Font = {
							name = L["Font"],
							type = "text",
							desc = L["Set font of Whats sub menu."],
							validate = SharedMedia:List('font'),
							get = function() return self.db.profile.submenufont end,
							set = function(f) 
								self.db.profile.submenufont = f 
								Whats:ApplySetting()
							end
						},
						FontSize = {
							name = L["Font Size"],
							type = "range",
							desc = L["Set font size of Whats sub menu"],
							min = 5,
							max = 20,
							step = 1,
							get = function() return self.db.profile.submenufontsize end,
							set = function(s) 
								self.db.profile.submenufontsize = s
								Whats:ApplySetting()
							end
						},
						Location = {
							name = L["Location"],
							type = "text",
							desc = L["Set sub menu location."],
							validate = { ["U"] = L["Right"].."/"..L["Up"], ["D"] = L["Left"].."/"..L["Down"]},
							get = function() return self.db.profile.submenulocation end,
							set = function(l) 
								self.db.profile.submenulocation = l
								Whats:ApplySetting()
							end

						},
					}
				},
				Button = {
					type = "group",
					name = L["Button"],
					order = 3,
					desc = L["Button Option"],
					args = {
						Type = {
							type = "text",
							name = L["Type"],
							desc = L["Set item button type"],
							order = 1,
							validate = {["B"] = L["Button"], ["L"] = L["List"]},
							get = function() return self.db.profile.buttonOrlist end,
							set = function(t) 
								self.db.profile.buttonOrlist = t
								Whats:ApplySetting()
							end
						},
						Border = {
							type = "text",
							name = L["Border"],
							desc = L["Set Border of Whats item button"],
							validate = SharedMedia:List('border'),
							get = function() return self.db.profile.buttonborder end,
							set = function(b) 
								self.db.profile.buttonborder = b
								Whats:ApplySetting()
							end
						},
						Width = {
							name = L["Width"],
							type = "range",
							desc = L["Set width of Whats item button."],
							min = 100,
							max = 200,
							step = 10,
							get = function() return self.db.profile.buttonWidth end,
							set = function(r) 
								self.db.profile.buttonWidth = r 
								Whats:ApplySetting()
							end
						},
						Height = {
							name = L["Height"],
							type = "range",
							desc = L["Set height of Whats item button."],
							min = 10,
							max = 30,
							step = 1,
							get = function() return self.db.profile.buttonHeight end,
							set = function(h) 
								self.db.profile.buttonHeight = h
								Whats:ApplySetting()
							end
						},
						Color = {
							type = "group",
							name = L["Color"],
							desc = L["Set color of Whats item button"],
							args = {
								Checked = {
									type = "color",
									name = L["Chached Item"],
									desc = L["Set color of chached item button."],
									get = function() return self.db.profile.Ccolor.r, self.db.profile.Ccolor.g, self.db.profile.Ccolor.b, self.db.profile.Ccolor.a end,
									set = function(r, g, b, a) self.db.profile.Ccolor.r, self.db.profile.Ccolor.g, self.db.profile.Ccolor.b, self.db.profile.Ccolor.a = r, g, b, a 
										Whats:ApplySetting()
									end,
								},
								Unchecked = {
									type = "color",
									name = L["Unchached Item"],
									desc = L["Set color of unchached item button"],
									get = function() return self.db.profile.Ucolor.r, self.db.profile.Ucolor.g, self.db.profile.Ucolor.b, self.db.profile.Ucolor.a end,
									set = function(r, g, b, a) self.db.profile.Ucolor.r, self.db.profile.Ucolor.g, self.db.profile.Ucolor.b, self.db.profile.Ucolor.a = r, g, b, a 
										Whats:ApplySetting()
									end,
								},
								Nochecked = {
									type = "color",
									name = L["No chached Item"],
									desc = L["Set color of no chached item button."],
									get = function() return self.db.profile.Ncolor.r, self.db.profile.Ncolor.g, self.db.profile.Ncolor.b, self.db.profile.Ncolor.a end,
									set = function(r, g, b, a) self.db.profile.Ncolor.r, self.db.profile.Ncolor.g, self.db.profile.Ncolor.b, self.db.profile.Ncolor.a = r, g, b, a 
										Whats:ApplySetting()
									end,
								},
							}
						},
						Texture = {
							name = L["Texture"],
							type = "text",
							desc = L["Set texture of Whats item button."],
							validate = SharedMedia:List('background'),
							get = function() return self.db.profile.buttontexture end,
							set = function(t) 
								self.db.profile.buttontexture = t 
								Whats:ApplySetting()
							end
						},
						Font = {
							name = L["Font"],
							type = "text",
							desc = L["Set font of Whats item button."],
							validate = SharedMedia:List('font'),
							get = function() return self.db.profile.buttonfont end,
							set = function(f) 
								self.db.profile.buttonfont = f 
								Whats:ApplySetting()
							end
						},
						FontSize = {
							name = L["Font Size"],
							type = "range",
							desc = L["Set font size of Whats item button"],
							min = 5,
							max = 20,
							step = 1,
							get = function() return self.db.profile.buttonfontsize end,
							set = function(s) 
								self.db.profile.buttonfontsize = s
								Whats:ApplySetting()
							end
						},
						Location = {
							name = L["Location"],
							type = "text",
							desc = L["Set item button location"],
							validate = { ["U"] = L["Right"].."/"..L["Up"], ["D"] = L["Left"].."/"..L["Down"]},
							get = function() return self.db.profile.buttonlocation end,
							set = function(l) 
								self.db.profile.buttonlocation = l
								Whats:ApplySetting()
							end

						},
						Column = {
							name = L["Column"],
							type = "range",
							desc = L["Set column of item button"],
							min = 2,
							max = 4,
							step = 1,
							get = function() return self.db.profile.column end,
							set = function(c) 
								self.db.profile.column = c 
								Whats:ApplySetting()
							end
						}
					}
				},
			},
		}
	}
}

Whats.hasIcon = "Interface\\Icons\\INV_Misc_QuestionMark"
Whats.defaultPosition = "RIGHT"
Whats.defaultMinimapPosition = 285
Whats.tooltipHiddenWhenEmpty = true
Whats.cannotDetachTooltip = true
Whats.hasNoColor = true
Whats.hideWithoutStandby = true
Whats.independentProfile = true
Whats.OnMenuRequest = Whats.Option

function Whats:OnInitialize()
	local defaultfont
	if GetLocale() == "koKR" then
		defaultfont = "기본글꼴"
	else
		defaultfont = "Arial Narrow"
	end

	self:RegisterDB("WhatsDB")
	self:RegisterDefaults("profile", 
		{
			menuWidth = 100,
			menuHeight = 25,
			menutexture = "Blizzard Tooltip",
			menuborder = "Blizzard Dialog",
			menufont = defaultfont,
			menufontsize = 12,
			Mcolor = {r = 1, g = 1, b = 1, a = 1 },
			growth = "D",

			submenuWidth = 100,
			submenuHeight = 15,
			submenutexture = "Blizzard Tooltip",
			submenuborder = "Blizzard Dialog",
			submenufont = defaultfont,
			submenufontsize = 12,
			Scolor = {r = 1, g = 1, b = 1, a = 1 },
			submenulocation = "D",

			buttonOrlist = "B",
			buttonWidth = 128,
			buttonHeight = 28,
			buttontexture = "Blizzard Tooltip",
			buttonborder = "Blizzard Dialog",
			buttonfont = defaultfont,
			buttonfontsize = 10,
			Ccolor = {r = 0.2, g = 0.2, b = 1, a = 0.8 },
			Ucolor = {r = 0.2, g = 1, b = 0.2, a = 0.8 },
			Ncolor = {r = 1, g = 0.2, b = 0.2, a = 0.8 },
			column = 2,
			buttonlocation = "U",

			savedata = true,
			mobTooltip = false,
			lock = false,
			LocX = 0,
			LocY = 0,

			Rcolor = {r = 1, g = 1, b = 1, a = 1 },
			Favorite = {
				[0] = L["Favorite"],
			}
		}
	)
	self:RegisterChatCommand({"/Whats"}, self.Option)
	if WhatsItemDB == nil or self.db.profile.savedata == false then
		WhatsItemDB = { }
	end

	if WhatsDB.Data ~= nil then
		WhatsDB.Data = { }
	end
	table.insert(WhatsMainMenu, self.db.profile.Favorite)

	self:RegisterChatCommand({'/ws'}, self.Search)
	self:RegisterChatCommand({'/wm'}, self.Memo)
end

function Whats:OnEnable()
	TipHooker:Hook(self.ProcessTooltip, "item")

	if Links then
		Links:AddToMenu(L["|CFF00CED1W|r|CFFFFFFFFhats|r: Link Drop Info"], 
		function (_, _, link)
			local itemid = tonumber(select(3, strfind(link, "item:(%d+):")))
			if WhatsItemInfo[itemid] then
				local text = self:GetPasteText(itemid)
				for temp in string.gmatch(text, "([^$]+)") do
					if not ChatFrameEditBox:IsVisible() then
						ChatFrameEditBox:Show()
					end
					ChatFrameEditBox:Insert("Whats: ".. select(2, GetItemInfo(itemid)) .. " "..temp)
					ChatEdit_SendText(ChatFrameEditBox, 1);
					ChatEdit_OnEscapePressed(ChatFrameEditBox);
				end
			end
		end)
		--[[,
		function (_, _, link)
			local itemid = tonumber(select(3, strfind(link, "item:(%d+):")))
			if WhatsItemInfo[itemid] then
				return true
			else
				return false
			end
		end)]]
		Links:AddToMenu(L["|CFF00CED1W|r|CFFFFFFFFhats|r: Edit Item Memo"], 
		function (_, _, link)
			local itemid = tonumber(select(3, strfind(link, "item:(%d+):")))
			Whats.SetMemo(itemid)
		end)
	end
	if self.db.profile.mobTooltip then
		self:RegisterEvent("ZONE_CHANGED", "ZoneUpdate")
		self:RegisterEvent("ZONE_CHANGED_INDOORS", "ZoneUpdate")
		self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "ZoneUpdate")
	--	self:RegisterEvent("MINIMAP_ZONE_CHANGED", "ZoneUpdate")
		self:RegisterEvent("PLAYER_ENTERING_WORLD", "ZoneUpdate")
		self:RegisterEvent("UPDATE_MOUSEOVER_UNIT")
		TipHooker:Hook(self.UnitTooltip, "unit")
	end

end

function Whats:ZoneUpdate()
	local Con, Zone

	if ( GetCurrentMapContinent() == 1 ) then
		Con = 2
	elseif ( GetCurrentMapContinent() == 2 ) then
		Con = 1
	elseif ( GetCurrentMapContinent() == 3 ) then
		Con = 3
	end

	if Con ~= nil then
		if IsInInstance() then
			for k, v in pairs(WhatsMobInfo[Con]) do
				if v[0] == GetRealZoneText() then
					Zone = tonumber(k)
					break;
				end
			end
			if Zone ~= nil then
				WhatsZoneTable = {"I", Con, Zone}
				return;
			end
		else
			for k, v in pairs(WhatsFieldInfo[Con]) do
				if v[0] == GetRealZoneText() then
					Zone = tonumber(k)
					break;
				end
			end
			if Zone ~= nil then
				WhatsZoneTable = {"F", Con, Zone}
				return;
			end
		end
	end
	WhatsZoneTable = nil
end

function Whats:OnDisable()
	TipHooker:Unhook(self.ProcessTooltip, "item")
end

function Whats:GetLink(itemid)

	local colorCode = "ffff0000"
	local name = itemid
	local server_realm = GetRealmName():trim();
	local _, link = GetItemInfo(itemid)
	
	if link == nil then
		if ISyncDB and ISyncDB["account"][1] and ISyncDB["account"][1]["names"][itemid] then
			colorCode = ISyncDB["account"][1]["items"][itemid] and "ff"..ItemColorTable[tonumber(strsub(ISyncDB["account"][1]["items"][itemid], 1, 1))]
			name = ISyncDB["account"][1]["names"][itemid]
		elseif ISyncDB and ISyncDB["account"][server_realm] and ISyncDB["account"][server_realm]["names"][itemid] then
			colorCode = ISyncDB["account"][server_realm]["items"][itemid] and "ff"..ItemColorTable[tonumber(strsub(ISyncDB["account"][server_realm]["items"][itemid], 1, 1))]
			name = ISyncDB["account"][server_realm]["names"][itemid]
		elseif ItemLinks then
			for name, value in pairs(ItemLinks) do
				if value.i == itemid then
					colorCode = value.c
					name = name
				end
			end
		elseif self.db.profile.savedata and WhatsItemDB[itemid] and select(3, string.find(WhatsItemDB[itemid], "%[(.+)%]")) and strlen(select(3, string.find(WhatsItemDB[itemid], "%[(.+)%]"))) > 1 then
			return WhatsItemDB[itemid]
		end
		if type(name) == "number" then
			return nil
		else
			return "|c"..colorCode.."|Hitem:"..itemid..":0:0:0:0:0:0:0|h["..name.."]|h|r"
		end
		return nil
	else
		if self.db.profile.savedata and select(3, string.find(link, "%[(.+)%]")) and strlen(select(3, string.find(link, "%[(.+)%]"))) > 1 then
			WhatsItemDB[itemid] = link
		end
		return link
	end
end

function Whats:UPDATE_MOUSEOVER_UNIT()
	if UnitName("mouseover") then
		self.UnitTooltip(GameTooltip, "mouseover")
	end
end

function Whats.UnitTooltip(tooltip, unit)
	local num
	if WhatsZoneTable ~= nil then
		local Type, Con, Zone = unpack(WhatsZoneTable)
		name = UnitName(unit)
		num = 1
		local flag = false
		if Type == "I" then
			local num = 1
			while ( WhatsMobInfo[Con][Zone][num]) do
				if WhatsMobInfo[Con][Zone][num][0] == name then
					flag = true
					break;
				end
				num = num+1
			end
			if flag == true then
				tooltip:AddLine(L["|CFF00CED1W|r|CFFFFFFFFhats: Drop Item|r"], 1, 1, 1, 1)
				for k, v in pairs(WhatsItemInfo) do
					local f  = flase
					local source = strsplit("/", v, 6)
					for mobCode in string.gmatch(source, "([^%s]+)") do
						local temp = strsplit("|", mobCode, 2)
						local t_drop, t_con, t_ins, t_type, t_mob = strsplit(":", temp, 5)
						if t_mob == nil then 
							t_mob = t_type
							t_type = ""
						end
						if t_drop == "I" and tonumber(t_con) == Con and tonumber(t_ins) == Zone and tonumber(t_mob) == num then
							if GetCurrentDungeonDifficulty() == 2 then
								if t_type == "b" or t_type == "h" then
									f = true
									break
								end
							elseif t_type ~= "h" then
								f = true
								break;
							end
						end
					end
					if f then
						local itemid = tonumber(k)
						if self:GetLink(itemid) == nil then
							tooltip:AddLine("item:"..itemid, 1, 1, 1, 1)
						else
							tooltip:AddLine(self:GetLink(itemid), 1, 1, 1, 1)
						end
					end
				end
				tooltip:Show()
			end
		else
			while ( WhatsFieldInfo[Con][Zone][num]) do
				if WhatsFieldInfo[Con][Zone][num][0] == name then
					flag = true
					break;
				end
				num = num + 1
			end
			if flag == true then
				tooltip:AddLine(L["|CFF00CED1W|r|CFFFFFFFFhats: Drop Item|r"], 1, 1, 1, 1)
				local n = 1
				while (WhatsFieldInfo[Con][Zone][num]["item"][n]) do
					if self:GetLink(WhatsFieldInfo[Con][Zone][num]["item"][n]) == nil then
						tooltip:AddLine("item:"..WhatsFieldInfo[Con][Zone][num]["item"][n], 1, 1, 1, 1)
					else
						tooltip:AddLine(self:GetLink(WhatsFieldInfo[Con][Zone][num]["item"][n]), 1, 1, 1, 1)
					end
					n = n + 1
				end
				tooltip:Show()
			end
		end
	end
	
end

function Whats.ProcessTooltip(tooltip, name, link)
	local _, _, itemid = strfind(link, "item:(%d+):")
	if itemid then
		itemid = tonumber(itemid)
		if self.db.profile.savedata and not WhatsItemDB[itemid] and select(3, string.find(link, "%[(.+)%]")) and strlen(select(3, string.find(link, "%[(.+)%]"))) > 1 then
			WhatsItemDB[itemid] = link
		end
		Whats:AddInfoToTooltip(itemid, tooltip)
		tooltip:Show()
	end
end

function Whats:AddInfoToTooltip(itemid, tooltip)
	if WhatsItemInfo[itemid] and tooltip ~= nil then
		local source, _, slot = strsplit("/", WhatsItemInfo[itemid], 6)
		local text = nil
		local LastZone = nil
		local zone
		for temp in string.gmatch(source, "([^%s]+)") do
			if text == nil then
				local mob
				mob, zone = self:GetText(temp, slot, false)
				text = mob
				LastZone = zone
			else
				local mob
				mob, zone = self:GetText(temp, slot, false)
				if LastZone == zone then
					text = text.."/"..mob
					LastZone = zone
				else
					if LastZone ~= nil then
						text = text..LastZone
					end
					tooltip:AddLine("|CFF00CED1W|r|CFFFFFFFFhats: "..text.."|r", 1, 1, 1, 1)
					text = mob
					if zone ~= nil then
						LastZone = zone
					end
				end
			end
		end
		if LastZone ~= nil and zone ~= nil then
			text = text..LastZone
		end

		if text ~= nil then
			tooltip:AddLine("|CFF00CED1W|r|CFFFFFFFFhats: "..text.."|r", 1, 1, 1, 1)
		end
	end
	if WhatsDB ~= nil and WhatsDB.Data ~= nil and WhatsDB.Data[itemid] ~= nil then
		tooltip:AddLine("|CFF00CED1M|r|CFFFFFFFFemo: "..WhatsDB.Data[itemid].."|r", 1, 1, 1, 1)
	end
end

function Whats:GetPasteText(itemid)
	local source, _, slot = strsplit("/", WhatsItemInfo[itemid], 6)
	local text = nil
	local LastZone = nil
	local zone
	for temp in string.gmatch(source, "([^%s]+)") do
		if text == nil then
			local mob
			mob, zone = self:GetText(temp, slot, true)
			text = mob
			LastZone = zone
		else
			local mob
			mob, zone = self:GetText(temp, slot, true)
			if LastZone ~= zone then
				if LastZone ~= nil then
					text = text..LastZone.."$"..mob
				else
					text = text.."$"..mob
				end
			else
				text = text.."/"..mob
			end
			LastZone = zone
		end
	end
	if LastZone ~= nil and zone ~= nil then
		text = text..LastZone
	end
	return text
end

function Whats:GetText(source, slot, chat)

	local type = strsub(source, 1, 1)
	if type == "I" then
		return self.InstanceDrop(source, slot, chat)
	elseif type =="E" then
		return self.ExchangeItem(source, slot, chat)
	elseif type =="A" then
		return self.ArenaItem(source, slot, chat)
	elseif type =="P" then
		return self.PvPItem(source, slot, chat)
	elseif type =="F" then
		return self.ReputationItem(source, slot, chat)
	elseif type =="B" then
		return self.BattleGroundItem(source, slot, chat)
	elseif type =="T" then
		return self.TokenItem(source, slot, chat)
	elseif type =="S" then
		return self.StaticDrop(source, slot, chat)
	end
end

function Whats.InstanceDrop(source, slot, chat)

	local White, ColorEnd, insColor
	local text = ""
	local tem, require = strsplit("|", source, 2)
	local _, ConNum, InsNum, InsType, MobNum = strsplit(":", tem, 5)
	if MobNum == nil then
		MobNum = InsType
		InsType = nil
	end

	if chat ~= true then
		if InsType == "h" then
			insColor = "|CFFFF69B4"
		elseif InsType == "b" then
			insColor = "|CFF6495ED"
		else
			insColor = "|CFF90EE90"
		end
		ColorEnd = "|r"
		White = "|CFFFFFFFF"
	else
		insColor = ""
		ColorEnd = ""
		White = ""
	end

	if require ~= nil then
		for item,num in string.gmatch(require,"(%d+):?(%d*)") do
			if item ~= nil and item ~= "" then
				item = tonumber(item)
				if item < 10000 then
					if WhatsTrashMobInfo[item] then
						text = WhatsTrashMobInfo[item]
					end
				else
					local n = self:GetLink(item)
					if n ~= nil then
						text = text..n
					else
						text = text.."Item:"..item
					end
					if num ~= nil and num ~= "" and num ~= "1" then
						text = text.."x"..num.." "
					else
						text = text.." "
					end
					if WhatsItemInfo[item] then
						local s, _, l = strsplit("/", WhatsItemInfo[item], 6)
						s = strsplit("|", s, 2)
						text = text.."("
						for temp in string.gmatch(s, "([^%s]+)") do
							if strsub(select(3, string.find(temp, "(%a+):")), 1, 1) == "I" then
								text = text..self.InstanceDrop(temp, l, false)
							end
						end
						text = text..")"
					end
				end
			end
		end
	end

	return White..WhatsMobInfo[tonumber(ConNum)][tonumber(InsNum)][tonumber(MobNum)][0]..(text ~= "" and "("..text..")" or "")..ColorEnd, insColor.."<"..WhatsMobInfo[tonumber(ConNum)][tonumber(InsNum)][0]..(InsType == "h" and "("..L["Hard"]..")" or InsType == "b" and "("..L["Both"]..")" or "")..">"..ColorEnd
end

function Whats.StaticDrop(source, slot, chat)
	local White, ColorEnd, MobXY
	local _, ConNum, ZoneNum, MobNum = strsplit(":", source, 4)

	if chat ~= true then
		ColorEnd = "|r"
		White = "|CFFFFFFFF"
	else
		ColorEnd = ""
		White = ""
	end

	if WhatsFieldInfo[tonumber(ConNum)][tonumber(ZoneNum)][tonumber(MobNum)]["xy"] then
		MobXY = "("..WhatsFieldInfo[tonumber(ConNum)][tonumber(ZoneNum)][tonumber(MobNum)]["xy"]..")"
	else
		MobXY = ""
	end

	return White..WhatsFieldInfo[tonumber(ConNum)][tonumber(ZoneNum)][tonumber(MobNum)][0]..MobXY..ColorEnd, White.."<"..WhatsFieldInfo[tonumber(ConNum)][tonumber(ZoneNum)][0]..">"..ColorEnd
end

function Whats.ExchangeItem(source, slot, chat)

	local temp, require = strsplit("|", source, 2)

	local nn, text

	local _, _, npc, npcinfo = string.find(temp, "(%d+):?(%d*)")
	npc = tonumber(npc)
	
	nn = WhatsExchangeNPCInfo[npc]

	if npc == 12 and ( require == "" or require == nil ) then
		nn = nn .." "..L["Drop"]
	end

	if slot ~= nil then
		nn = nn.." ".. WhatsItemMenu[slot].." "
	end

	if require ~= nil then
		text = ":"
		for item,num in string.gmatch(require,"(%d+):?(%d*)") do
			if item ~= nil and item ~= "" then
				item = tonumber(item)
				local n = self:GetLink(item)
				if n ~= nil then
					text = text..n
				else
					text = text.."Item:"..item
				end
				if num ~= nil and num ~= "" and num ~= "1" then
					text = text.."x"..num.." "
				else
					text = text.." "
				end
			end
		end
	end


	return nn, text
end

function Whats.ArenaItem(source, slot, chat)
	local tempA, tempB = strsplit("|", source, 2)

	local _, season, class, sub = strsplit(":", tempA, 4)
	local point, require = strsplit("$", tempB, 2)

	season = tonumber(season)
	class = tonumber(class)
	sub = tonumber(sub)

	text = L["Arena"] .. " ".. string.format(L["Season %d"], season).." :"
	
	if class > 0 and WhatsClassInfo[class] then
		text = text.." "..WhatsClassInfo[class][0].." "
		if sub > 0 and WhatsClassInfo[class][sub]then
			text = text .."("..WhatsClassInfo[class][sub][0]..") "
		end
	elseif slot ~= nil then
		text = text.." "..WhatsItemMenu[slot].." "
	end

	if season > 1 then
		text = text.." "..L["Arena"] .. " " ..L["Point"].." "..select(3, strfind(point, "(%d+)"))..L["p"].. " "
	else
		text = text.." "..L["PvP"] .. " ".. L["Point"] .. " " ..point..L["p"].. " "
		for item,num in string.gmatch(require,"(%d+):?(%d*)") do
			if item ~= nil and item ~= "" then
				item = tonumber(item)
				local n = self:GetLink(item)
				if n ~= nil then
					text = text..n
				else
					text = text.."Item:"..item
				end
				if num ~= nil and num ~= "" and num ~= "1" then
					text = text.."x"..num.." "
				else
					text = text.." "
				end
			end
		end
	end

	return text
end

local FactionColor = {  -- from FuBar_FactionFU
	[1] = {r = 0.55, g = 0, b = 0},			-- hated
	[2] = {r = 1, g = 0, b = 0},			-- hostile
	[3] = {r = 1, g = 0.55, b = 0},			-- unfriendly
	[4] = {r = 0.75, g = 0.75, b = 0.75},	-- neutral
	[5] = {r = 1, g = 1, b = 1},			-- friendly
	[6] = {r = 0, g = 1, b = 0},			-- honored
	[7] = {r = 0.25, g = 0.4, b = 0.9},		-- reverted
	[8] = {r = 0.6, g = 0.2, b = 0.8},		-- exalted
}

function Whats.ReputationItem(source, slot, chat)


	local expantion, faction, class, sub, standing, require, text
	local tempA, tempB = strsplit("|", source, 2)
	_, expantion, faction, class, sub = strsplit(":", tempA, 5)
	if tempB ~= nil then
		standing, require = strsplit("$", tempB, 2)
		standing = select(3, strfind(standing, "(%d+)"))
	end

	expantion = tonumber(expantion)
	faction = tonumber(faction)
	class = tonumber(class)
	sub = tonumber(sub)

	text = WhatsFactionInfo[expantion][faction][0]

	if standing ~= nil and standing ~= "" and standing ~= "0" then
		if chat == true then
			text = text.." "..WhatsStandingInfo[tonumber(standing)]..":"
		else
			local color = FactionColor[tonumber(standing)]
			text = text.." "..("|cff%02x%02x%02x"):format(color.r * 255, color.g * 255, color.b * 255)..WhatsStandingInfo[tonumber(standing)].."|r:"
		end
	else
		text = text..":"
	end

	if class > 0 and WhatsClassInfo[class] then
		text = text.." "..WhatsClassInfo[class][0].." "
		if sub > 0 and WhatsClassInfo[class][sub]then
			text = text .."("..WhatsClassInfo[class][sub][0]..") "
		end
	elseif slot ~= nil then
		text = text.." "..WhatsItemMenu[slot].." "
	end
	
	if require ~= nil then
		for item,num in string.gmatch(require,"(%d+):?(%d*)") do
			if item ~= nil and item ~= "" then
				item = tonumber(item)
				local n = self:GetLink(item)
				if n ~= nil then
					text = text..n
				else
					text = text.."Item:"..item
				end
				if num ~= nil and num ~= "" and num ~= "1" then
					text = text.."x"..num.." "
				else
					text = text.." "
				end
				if WhatsItemInfo[item] then
					local s, _, l = strsplit("/", WhatsItemInfo[item], 6)
					s = strsplit("|", s, 2)
					text = text.."("
					for temp in string.gmatch(s, "([^%s]+)") do
						if strsub(select(3, string.find(temp, "(%a+):")), 1, 1) == "I" then
							text = text..self.InstanceDrop(temp, l, false)
						end
					end
					text = text..")"
				end
			end
		end
	end

	
	return text
end

function Whats.BattleGroundItem(source, slot, chat)
	local point, require, text
	local tempA, tempB = strsplit("|", source, 2)
	local faction, point, require, bz, text

	point, require = strsplit("$", tempB, 2)

	bz = WhatsBGInfo[tonumber(select(2, strsplit(":", tempA, 2)))][0]
	text = slot ~= nil and "-"..WhatsItemMenu[slot].." : " or " : "

	if point and point ~= "" and tonumber(point) > 0 then
		text = text..L["PvP"] .. " ".. L["Point"] .. " "..point..L["p"].." "
	end
	
	if require ~= nil then
		for item,num in string.gmatch(require,"(%d*):?(%d*)") do
			if item ~= nil and item ~= "" then
				item = tonumber(item)
				local n = self:GetLink(item)
				if n ~= nil then
					text = text..n
				else
					text = text.."Item:"..item
				end
				if num ~= nil and num ~= "" and num ~= "1" then
					text = text.."x"..num.." "
				else
					text = text.." "
				end
			end
		end
	end
	
	return bz, text
end

function Whats.PvPItem(source, slot, chat)
	local expantion, faction, class, sub, point, require, f, text
	local tempA, tempB = strsplit("|", source, 2)

	_, expantion, faction, class, sub = strsplit(":", tempA, 5)

	expantion = tonumber(expantion)
	faction = tonumber(faction)
	class = tonumber(class)
	sub = tonumber(sub)

	f = WhatsPointInfo[expantion][faction][0]
	text = " "..WhatsPointInfo[0].. "("..WhatsPointInfo[expantion][0]..")"
		
	if class > 0 and WhatsClassInfo[class] then
		text = text.." - "..WhatsClassInfo[class][0]
		if sub > 0 and WhatsClassInfo[class][sub]then
			text = text .." ("..WhatsClassInfo[class][sub][0]..")"
		end
	elseif slot ~= nil then
		text = text.." - "..WhatsItemMenu[slot]
	end
	
	if tempB ~= nil then
		point, require = strsplit("$", tempB, 2)
		point = tonumber(point)

		if point ~= 0 then
			text = text.." : ".. L["PvP"] .. " ".. L["Point"] .. " "..point..L["p"].." "
		else
			text = text.. " : "
		end

		if require ~= nil then
			for item,num in string.gmatch(require,"(%d+):?(%d*)") do
				if item ~= nil and item ~= "" then
					item = tonumber(item)
					local n = self:GetLink(item)
					if n ~= nil then
						text = text..n
					else
						text = text.."Item:"..item
					end
					if num ~= nil and num ~= "" and num ~= "1" then
						text = text.."x"..num.." "
					else
						text = text.." "
					end
				end
			end
		end
	else
		text = text.." : "..L["Sold Out"]
	end
	
	return f, text
end

function Whats.TokenItem(source, slot, chat)
	local tier, class, sub, require, text
	local typeinfo, require = strsplit("|", source, 2)

	_, tier, class, sub = strsplit(":", typeinfo, 4)

	tier = tonumber(tier)
	class = tonumber(class)
	sub = tonumber(sub)

	text = string.format(L["T%s"], tier)

	if class > 0 and WhatsClassInfo[class] then
		text = text.." "..WhatsClassInfo[class][0].." "
		if sub > 0 and WhatsClassInfo[class][sub]then
			text = text .."("..WhatsClassInfo[class][sub][0]..") "
		end
	end
	if class == 0 and sub == 0 then
		return L["Exchange"].." : "..string.format(L["T%d Token"], tier)
	end

	for item in string.gmatch(require,"(%d+)") do
		if item ~= nil and item ~= "" then
			item = tonumber(item)
			local n = self:GetLink(item)
			if n ~= nil then
				text = text..n.." "
			else
				text = text.."Item:"..item.." "
			end
			text = text.."("..WhatsTokenTable[item]..")"
		end
	end

	return text
end

function Whats.PrintResult()
	self:CancelScheduledEvent('WhatsPrintSearch')
	for k, v in pairs(WhatsResultList) do
		if GetItemInfo(v) then
			self.Search(v)
		else
			DEFAULT_CHAT_FRAME:AddMessage("|CFF00CED1W|r|CFFFFFFFFhats|r : "..v.." -  "..L["No Data"], 1, 1, 1)
		end
		table.remove(WhatsResultList, tonumber(k))
		if #WhatsResultList == 0 then
			DEFAULT_CHAT_FRAME:AddMessage("|CFF00CED1W|r|CFFFFFFFFhats|r : "..L["Searching Finished"], 1, 1, 1)
		else
			Whats:ScheduleRepeatingEvent('WhatsPrintSearch', Whats.PrintResult, 1.5, Whats)
		end
	end
end

function Whats.SearchResult()
	self:CancelScheduledEvent('WhatsIDSearch')
	for k, v in pairs(WhatsSearchList) do
		table.remove(WhatsSearchList, tonumber(k))
		table.insert(WhatsResultList, v)
		if #WhatsSearchList > 0 and not Whats:IsEventScheduled('WhatsIDSearch') then
			GameTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE")
			GameTooltip:SetHyperlink("item:"..v)
			GameTooltip:Hide()
			Whats:ScheduleRepeatingEvent('WhatsIDSearch', Whats.SearchResult, 1.5, Whats)
			return
		end
		if #WhatsSearchList == 0 then
			Whats:ScheduleRepeatingEvent('WhatsPrintSearch', Whats.PrintResult, 1.5, Whats)
		end
	end
end

function Whats.Search(temp)
	if tonumber(temp) then
		local id = tonumber(temp)
		if GetItemInfo(id) then
			if WhatsItemInfo[id] then
				local text = self:GetPasteText(id)
				DEFAULT_CHAT_FRAME:AddMessage("|CFF00CED1W|r|CFFFFFFFFhats|r :"..select(2, GetItemInfo(id)).." - "..text, 1, 1, 1)
			else
				if select(3, string.find(select(2, GetItemInfo(id)), "%[(.+)%]")) and self.db.profile.savedata then
					WhatsItemDB[id] = select(2, GetItemInfo(id))
				end
				DEFAULT_CHAT_FRAME:AddMessage("|CFF00CED1W|r|CFFFFFFFFhats|r :"..select(2, GetItemInfo(id)), 1, 1, 1)
			end
		else
			WhatsSearchList[#WhatsSearchList+1] = id

			if not Whats:IsEventScheduled('WhatsIDSearch') then
				GameTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE")
				GameTooltip:SetHyperlink("item:"..id)
				GameTooltip:Hide()
				Whats:ScheduleRepeatingEvent('WhatsIDSearch', Whats.SearchResult, 1.5, Whats)
			end
		end
	elseif temp == "" or temp == nil then
		DEFAULT_CHAT_FRAME:AddMessage("|CFF00CED1W|r|CFFFFFFFFhats|r : "..L["For Searching, need Item ID or Item name"], 1, 1, 1)
	else
		local num = 0
		if (ISyncDB) then
			if (ISyncDB["account"]["dboptions"]["sameserv"][1] == 1) then
				for k, v in pairs(ISyncDB["account"][1]["names"]) do
					if (strfind(v, temp)) then
						Whats.Search(tonumber(k))
						num = num + 1
					end
				end
			else
				local server_realm = GetRealmName():trim();
				for k, v in pairs(ISyncDB["account"][server_realm]["names"]) do
					if (strfind(v, temp)) then
						Whats.Search(tonumber(k))
						num = num + 1
					end
				end
			end
		elseif ItemLinks then
			for name, value in pairs(ItemLinks) do
				if strfind(name, temp) then
					local id = tonumber(strsub(value.i, "(%d+):"))
					Whats:Search(id)
					num = num + 1
				end
			end
		else
			for k, v in pairs(WhatsItemDB) do
				if strfind(select(3, string.find(v, "%[(.+)%]")), temp) then
					Whats.Search(tonumber(k))
					num = num + 1
				end
			end
		end
		if num == 0 then
			DEFAULT_CHAT_FRAME:AddMessage("|CFF00CED1W|r|CFFFFFFFFhats|r :"..temp.." -  "..L["No Data"], 1, 1, 1)
		else
			DEFAULT_CHAT_FRAME:AddMessage("|CFF00CED1W|r|CFFFFFFFFhats|r : "..string.format(L["Found %d items"], num), 1, 1, 1)
		end
	end
end

function Whats.Memo(msg)
	local itemid, memo = strsplit(" ", msg, 2)
	itemid = tonumber(itemid)
	WhatsDB.Data[itemid] = memo
end

function Whats.SetMemo(itemid)
	local text
	if WhatsDB.Data[itemid] then
		text = "/wm "..itemid.." "..WhatsDB.Data[itemid]
	else
		text = "/wm "..itemid.." "
	end
	if not ChatFrameEditBox:IsVisible() then
		ChatFrameEditBox:Show()
	end
	ChatFrameEditBox:Insert(text)
end

function Whats:OnClick(...)
	if _G["WhatsMenu0"] and _G["WhatsMenu0"]:IsVisible() then
		local num = 0
		while (_G["WhatsMenu"..num]) do
			_G["WhatsMenu"..num]:Hide()
			num = num + 1
		end
		num = 1
		while (_G["WhatsSubMenu"..num]) do
			_G["WhatsSubMenu"..num]:Hide()
			num = num + 1
		end
		num = 1
		while (_G["WhatsButton"..num]) do
			_G["WhatsButton"..num]:Hide()
			num = num + 1
		end
	else
		local frame = self:Openmenu(0, WhatsMainMenu)
		frame.pattern = ""
	end
end

function Whats:Openmenu(num, table)
	if _G["WhatsMenu"..num] then
		local 	n = 1
		while (_G["WhatsButton"..n]) do
			_G["WhatsButton"..n]:Hide()
			n = n + 1
		end

		local frame = _G["WhatsMenu"..num]
		frame:Show()
		frame.text:SetText(table[0])
		frame.index = num
		frame.table = table
		frame.title = table[0]
		return frame
	else
		local n = 1
		while (_G["WhatsButton"..n]) do
			_G["WhatsButton"..n]:Hide()
			n = n + 1
		end
		return self:CreateMenuFrame(num, table)
	end

end

function Whats:OpenSubMenu(num, name, table, level)
	if _G["WhatsSubMenu"..num] then
		local 	n = 1

		local frame = _G["WhatsSubMenu"..num]
		frame:Show()
		frame.text:SetText(name)
		frame.index = num
		frame.table = table
		frame.title = name
		frame.level = level
		return frame
	else
		local n = 1
		while (_G["WhatsButton"..n]) do
			_G["WhatsButton"..n]:Hide()
			n = n + 1
		end
		return self:CreateSubMenuFrame(num, name, table, level)
	end

end

function Whats:OpenButton(num, itemid)

	local frame

	if _G["WhatsButton"..num] then
		frame = _G["WhatsButton"..num]
	else
		frame = self:CreateButton(num)
	end

	frame.link = nil
	frame.itemid = itemid

	local r, t, x
	if WhatsItemInfo[itemid] then
		_, r, t, _, _, x = strsplit("/", WhatsItemInfo[itemid], 6)
	end

	local icon = select(10, GetItemInfo(itemid))
	if icon ~= nil and icon ~= "" then
		_G["WhatsButton"..num.."Icon"]:SetTexture(icon)

	else
		if x ~= nil then
			_G["WhatsButton"..num.."Icon"]:SetTexture("Interface\\Icons\\"..x)
		else
			_G["WhatsButton"..num.."Icon"]:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")
		end
	end

	local name = select(2, GetItemInfo(itemid))
	if name ~= nil then
		frame.itemname:SetText(name)
		frame.link = name
		_G["WhatsButton"..num]:SetBackdropColor(self.db.profile.Ccolor.r, self.db.profile.Ccolor.g, self.db.profile.Ccolor.b, self.db.profile.Ccolor.a)
	else
		local link = self:GetLink(itemid)
		if link ~= nil then
			frame.itemname:SetText(link)
			_G["WhatsButton"..num]:SetBackdropColor(self.db.profile.Ucolor.r, self.db.profile.Ucolor.g, self.db.profile.Ucolor.b, self.db.profile.Ucolor.a)
		else
			if r ~= nil then
				local colorCode = ItemColorTable[tonumber(r)]
				frame.itemname:SetText("|cff"..colorCode.."["..itemid.."]|r")
			else
				frame.itemname:SetText("|cffff0000["..itemid.."]|r")
			end
			_G["WhatsButton"..num]:SetBackdropColor(self.db.profile.Ncolor.r, self.db.profile.Ncolor.g, self.db.profile.Ncolor.b, self.db.profile.Ncolor.a)
		end
	end

	if self.db.profile.buttonOrlist == "B" then
		if t ~= nil then
			frame.itemtype:SetText(WhatsItemType[t])
		else
			frame.itemtype:SetText(L["Unchecked"])
		end
		frame.itemtype:Show()
	else
		frame.itemtype:Hide()
	end

	frame:Show()
end

function Whats:OpenList(temp)
	if type(temp) == "table" then
		local num = 1
		for _, v in pairs(temp) do
			Whats:OpenButton(num, tonumber(v))
			num = num + 1
		end

	else
		local drop, con, ins, type, mob = strsplit(":", temp, 5)
		local num = 1

		if mob == nil then
			mob = type
			type = ""
		end
		drop = itemTypeTable[tonumber(drop)]
		for k, v in pairs(WhatsItemInfo) do
			local flag  = flase
			local source = strsplit("/", v, 6)
			for mobCode in string.gmatch(source, "([^%s]+)") do
				local temp = strsplit("|", mobCode, 2)
				local t_drop, t_con, t_ins, t_type, t_mob = strsplit(":", temp, 5)
				if t_mob == nil then 
					t_mob = t_type
					t_type = ""
				end
				if drop == t_drop and t_con == con and t_ins == ins and t_mob == mob then
					if type == t_type or t_type == "b" or ( type == "n" and t_type == "" ) then
						flag = true
						break
					end
				end
			end
			if flag then
				local itemid = tonumber(k)
				Whats:OpenButton(num, itemid)
				num = num + 1
			end
		end
	end
end

function Whats:createWaypoint(frame)
	local _, Con, Zone, Mob = strsplit(":", frame.pattern, 4)
	local x, y = strsplit("/",	frame.table["xy"], 2)
	Cartographer_Waypoints:AddWaypoint(NotePoint:new(WhatsFieldInfo[tonumber(Con)][tonumber(Zone)][0], tonumber(x)/100, tonumber(y)/100, "|CFF00CED1W|r|CFFFFFFFFhats\n"..WhatsFieldInfo[tonumber(Con)][tonumber(Zone)][tonumber(Mob)][0].."|r"))
end

function Whats:MenuClick(frame, button)
	if button == "RightButton" then
		if frame.table["xy"] and Cartographer_Waypoints then
			DD:Open(frame,
				"point", function() return "TOPLEFT", "TOPRIGHT" end,
				"dontHook", true,
				"children", function ()
				DD:AddLine(
					"text", L["Set waypoint."],
					"func", function ()
						self:createWaypoint(frame)
						DD:Close()
					end)
				DD:AddLine(
					"text", L["Close"],
					"func", function ()
						DD:Close()
					end)
			end)
		end

	else

		local index = tonumber(frame.index)
		local temp = frame.table
		local pattern = frame.pattern

		local n = index + 1
		while (_G["WhatsMenu"..n]) do
			_G["WhatsMenu"..n]:Hide()
			n = n + 1
		end

		n = 1
		while ( _G["WhatsButton"..n] ) do
			_G["WhatsButton"..n]:Hide()
			n = n + 1
		end
		n = 1
		if temp["hard"] and frame.title ~= L["Normal"] and frame.title ~= L["Hard"] then
			local submenu = self:OpenSubMenu(1, L["Normal"], temp, index)
			submenu.pattern = pattern..":n"

			submenu = self:OpenSubMenu(2, L["Hard"], temp, index)
			submenu.pattern = pattern..":h"
			n = 3
		elseif temp[0] and temp[1] then
			local num = 1
			while (temp[num]) do
				local table = temp[num]
				if frame.title == L["Normal"] and table["OH"] then
				else
					local submenu = self:OpenSubMenu(n, table[0], table, index)
					if pattern == "" then
						submenu.pattern = num
					else
						submenu.pattern = pattern..":"..num
					end
					n = n + 1
				end
				num = num + 1
			end
		elseif not temp[0] then
			if temp[1] then				
				local num = 1
				while (temp[1][num]) do
					local table = temp[1][num]
					local submenu = self:OpenSubMenu(n, table[0], table, index)
					submenu.pattern = pattern
					num = num + 1
					n = n + 1
				end
			end
			if frame.table[2] then				
				local num = 1
				while (temp[2][num]) do
					local table = temp[2][num]
					local submenu = self:OpenSubMenu(n, table[0], table, index)
					submenu.pattern = pattern
					num = num + 1
					n = n + 1
				end
			end
		end

		if temp["item"] and not temp[1] then
		elseif ( strsub(pattern, 1, 1) == "1" and index > 3) then
		else
			while (_G["WhatsSubMenu"..n]) do
				_G["WhatsSubMenu"..n]:Hide()
				n = n + 1
			end
		end
	end


end

function Whats:SubMenuClick(frame, button)
	if button == "RightButton" then

	else

		local level = tonumber(frame.level)
		local temp = frame.table

		local menu = self:Openmenu(level+1, temp)
		if frame.title == L["Normal"] or frame.title == L["Hard"] then
			menu.title = frame.title
			menu.text:SetText(frame.title)
		end
		if not temp[1] and not temp["item"] then
			self:GetTable(frame.pattern)
			if strsub(frame.pattern, 1,1) ~= "1" then
				menu.table = menuTable
			end
		end
		
		menu.pattern = frame.pattern
		self:MenuClick(menu, nil)
		if menu.table["item"] then
			self:OpenList(menu.table["item"])
		elseif not menu.table[1] then
			self:GetTable(menu.pattern)
		end
	end

end

function Whats:GetTable(text)
	local a, b, c, d = strsplit(":", text, 4)
	a = itemTypeTable[tonumber(a)]
	if a == "I" then
		self:OpenList(text)
		return
	end
	local num = 1
	local s

	menuTable = { }

	for k, v in pairs(WhatsItemInfo) do
		local source, _, slot = strsplit("/", v, 6)
		for mobCode in string.gmatch(source, "([^%s]+)") do
			local flag  = false
			local class, sub, check
			local temp_a = strsplit("|", mobCode, 2)
			local t_a, t_b, t_c, t_d, t_e = strsplit(":", temp_a, 5)
			if c ~= nil and a == t_a and b == t_b and c == t_c then
				flag = true
			elseif c == nil and a == t_a and b == t_b  then
				flag = true
			end

			if flag == true then
				if t_a == "F" then
					class = t_d
					sub = st_e
				elseif t_a == "A" then
					class = t_c
					sub = t_d
				elseif t_a == "P" then
					class = t_d
					sub = t_e
				elseif t_a == "E" or t_a == "B" then
					class = nil
					sub = nil
				end
				if class ~= nil then
					class = tonumber(class)
					if sub ~= nil then
						sub = tonumber(sub)
					end
				end
				if class ~= nil and class > 0 then
					if not menuTable[1] then
						menuTable[1] = {
						}
					end
					if not menuTable[1][class] then
						menuTable[1][class] = {
							[0] = WhatsClassInfo[class][0],
							["item"] = {
							}
						}
					end
					if sub ~= nil and sub > 0 then
						if not menuTable[1][class][sub] then
							menuTable[1][class][sub] = {
								[0] = WhatsClassInfo[class][sub][0],
								["item"] = {
								}
							}
						end
						table.insert(menuTable[1][class][sub]["item"], k)
					else
						table.insert(menuTable[1][class]["item"], k)
					end
				else
					if not menuTable[2] then
						menuTable[2] = {
						}
					end
					local num = 1
					local flag = true
					while (menuTable[2][num] ) do
						if menuTable[2][num][0] == WhatsItemMenu[slot] then
							table.insert(menuTable[2][num]["item"], k)
							flag = false
							break;
						end
						num = num + 1
					end
					if flag == true then
						menuTable[2][num] = {
							[0] = WhatsItemMenu[slot],
							["item"] = {
							},
						}
						table.insert(menuTable[2][num]["item"], k)
					end
				end
			end
		end
	end
end

function Whats:HideTooltip(frame)
	GameTooltip:Hide()
end

function Whats:ShowTooltip(frame)
	local itemid = frame.itemid
	
	local _, Link = GetItemInfo(frame.itemid)
	if Link then
		GameTooltip:SetOwner(this, "ANCHOR_NONE")
		GameTooltip:SetPoint("TOPLEFT", frame.icon, "BOTTOMLEFT", -2, 3)
		GameTooltip:SetHyperlink(Link)
		GameTooltip:Show()
	else
		GameTooltip:SetOwner(this, "ANCHOR_NONE")
		GameTooltip:SetPoint("TOPLEFT", frame.icon, "BOTTOMLEFT", -2, 3)
		GameTooltip:SetText(frame.itemname:GetText(), 1, 0, 0, 1)
		GameTooltip:AddLine("\n");
		GameTooltip:AddLine(L["This Item is not found, click to query server.\n|cFFFF2222WARNING: This WILL disconnect you if the server has not seen the item.|r"], NORMAL_FONT_COLOR.r, NORMAL_FONT_COLOR.g, NORMAL_FONT_COLOR.b, 1)
		GameTooltip:AddLine("\n");
		self:AddInfoToTooltip(itemid, GameTooltip)
		GameTooltip:Show()
	end
end

function Whats:ClickItem(frame, button)
	if frame.link ~= nil then
		if button == "RightButton" then
			DD:Open(frame,
				"point", function() return "TOPLEFT", "TOPRIGHT" end,
				"dontHook", true,
				"children", function(level)
				if level == 1 then
					DD:AddLine(
						"text", L["Link in chat"],
						"level", 1,
						"value", "Top",
						"func", function ()
							if not ChatFrameEditBox:IsVisible() then
								ChatFrame_OpenChat (frame.link)
							else
								ChatFrameEditBox:Insert(frame.link)
							end
							DD:Close()
						end)
					DD:AddLine(
						"text", L["Dressup"],
						"level", 1,
						"value", "Top",
						"func", function ()
							DressUpItemLink(frame.link)
							DD:Close()
						end)
					DD:AddLine(
						"text", L["Link Drop Info"], 
						"level", 1,
						"value", "Top",
						"func", function ()
							local itemid = tonumber(select(3, strfind(frame.link, "item:(%d+):")))
							local text = self:GetPasteText(itemid)
							for temp in string.gmatch(text, "([^$]+)") do
								if not ChatFrameEditBox:IsVisible() then
									ChatFrameEditBox:Show()
								end
								ChatFrameEditBox:Insert("Whats: ".. select(2, GetItemInfo(itemid)) .. " "..temp)
								ChatEdit_SendText(ChatFrameEditBox, 1);
								ChatEdit_OnEscapePressed(ChatFrameEditBox);
							end
							DD:Close()
						end)
					DD:AddLine(
						"text", L["Favorite"], 
						"hasArrow", true,
						"value", "F"
--						"arg1", frame
					)
					DD:AddLine(
						"text", L["Edit Item Memo"], 
						"level", 1,
						"hasArrow", true,
						"hasEditBox", true,
						"editBoxText", WhatsDB.Data and WhatsDB.Data[frame.itemid] or nil,
						'editBoxFunc', function(memo)
							if memo ~= "" and memo ~= nil then
								WhatsDB.Data[frame.itemid] = memo
							else
								WhatsDB.Data[frame.itemid] = nil
							end
							DD:Close()
						end)
					DD:AddLine(
						"text", L["Close"],
						"level", 1,
						"value", "Top",
						"func", function ()
							DD:Close()
						end)
				elseif level == 2 then
					DD:AddLine(
						"text", L["Add Item in New Favorite Item List."],
						"hasArrow", true,
						"hasEditBox", true,
						"editBoxText", Fname,
						'editBoxFunc', function(Fname)
							if Fname ~= nil and Fname ~= "" then
								local num = 1
								local flag = false
								while ( self.db.profile.Favorite[num] ) do
									if self.db.profile.Favorite[num][0] == Fname then
										flag = true
										break;
									end
									num = num + 1;
								end
								if flag ~= true then
									local temp = {
										[0] = Fname,
										["item"] = {}
									}
									table.insert(temp["item"], frame.itemid)
									table.insert(self.db.profile.Favorite, temp)
									DD:Close()
								end
							else
								DEFAULT_CHAT_FRAME:AddMessage(L["List name must be String."], 1, 0, 0)
							end
						end
					)
					DD:AddLine(
						"text", L["Add or Remove in Favorite Item List."],
						"hasArrow", true,
						"value", "A"
--						"arg1", frame
					)
				elseif level ==3 then
					local num = 1
					while ( self.db.profile.Favorite[num]) do
						local n = num
						local t = 1
						local flag = false
						while ( self.db.profile.Favorite[num]["item"][t] ) do
							if self.db.profile.Favorite[num]["item"][t] == frame.itemid then
								flag = true
								break;
							end
							t = t + 1
						end
						if flag ~= true then
							DD:AddLine(
								"text", self.db.profile.Favorite[n][0].." "..L["Add"],
								"isRadio", true,
								"arg1", n,
								"func", function()
									if #(self.db.profile.Favorite[n]["item"]) < 25 then
										table.insert(self.db.profile.Favorite[n]["item"], frame.itemid)
									else
										DEFAULT_CHAT_FRAME:AddMessage(L["List is Full"])
									end
									DD:Close()
								end
							)
						else
							DD:AddLine(
								"text", self.db.profile.Favorite[n][0].." "..L["Remove"],
								"isRadio", true,
								"arg1", n,
								"func", function()
									table.remove(self.db.profile.Favorite[n]["item"], t)
									if #(self.db.profile.Favorite[n]["item"]) == 0 then
										table.remove(self.db.profile.Favorite, n)
									end
									DD:Close()
								end
							)
						end
						num = num + 1
					end
				end
			end)
		else
			if IsControlKeyDown() then
				DressUpItemLink(frame.link);
			elseif IsShiftKeyDown() then
				if not ChatFrameEditBox:IsVisible() then
					ChatFrameEditBox:Show()
				end
				ChatFrameEditBox:Insert(frame.link)
			elseif	 IsAltKeyDown() then
				local text = self:GetPasteText(frame.itemid)
				for temp in string.gmatch(text, "([^$]+)") do
					if not ChatFrameEditBox:IsVisible() then
						ChatFrameEditBox:Show()
					end
					ChatFrameEditBox:Insert("Whats: ".. select(2, GetItemInfo(frame.itemid)) .. " "..temp)
					ChatEdit_SendText(ChatFrameEditBox, 1);
					ChatEdit_OnEscapePressed(ChatFrameEditBox);
				end
			else
				if Links then
					Links:OpenLink(nil, frame.link)
				else
					ShowUIPanel(ItemRefTooltip)
					if not ItemRefTooltip:IsVisible() then
						ItemRefTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE")
					end
					ItemRefTooltip:SetHyperlink(frame.link)
				end
			end
		end
	else
		GameTooltip:SetOwner(this, "ANCHOR_PRESERVE")
		GameTooltip:SetHyperlink("item:" .. frame.itemid)
		GameTooltip:Hide()
		local ScheduleName = "WhatsShowItem"..frame.index
		local num = frame.index
		local itemid = frame.itemid
		Whats:ScheduleRepeatingEvent(ScheduleName, function() self:CancelScheduledEvent(ScheduleName) self:OpenButton(num, itemid) end, 2, Whats)
		
	end
end

function Whats:StopMovingOrSizing(frame)

	frame:StopMovingOrSizing()

	local x = ( frame:GetLeft() + frame:GetRight() ) / 2 
	local y = ( frame:GetTop() + frame:GetBottom() ) / 2 

	self.db.profile.LocX = (x-(UIParent:GetWidth()/2))/UIParent:GetEffectiveScale()
	self.db.profile.LocY = (y-(UIParent:GetHeight()/2))/UIParent:GetEffectiveScale()
end

function Whats:CreateMenuFrame(index, table)
	local frame = CreateFrame("BUTTON", 'WhatsMenu'..index, index == 0 and UIParent or _G["WhatsMenu"..index-1])

	frame.index = index
	frame.table = table

	frame:SetFrameStrata("DIALOG")
	frame:SetWidth(self.db.profile.menuWidth)
	frame:SetHeight(self.db.profile.menuHeight)
	frame:SetBackdrop(
		{
			bgFile = SharedMedia:Fetch('background', self.db.profile.menutexture),
			edgeFile = SharedMedia:Fetch('border', self.db.profile.menuborder),
			tile="false",
			edgeSize = 8,
			insets = {
						left = 0,
						right = 0,
						top = 0,
						bottom = 0
					}
		})
	frame:SetBackdropColor(self.db.profile.Mcolor.r, self.db.profile.Mcolor.g, self.db.profile.Mcolor.b, self.db.profile.Mcolor.a)
	if index == 0 then
		frame:SetMovable(true)
		frame:SetScript("OnMouseDown", function() if self.db.profile.lock ~= true then frame:StartMoving() end end)
		frame:SetScript("OnMouseUp", function(frame) Whats:StopMovingOrSizing(frame) end)
	end

	frame:SetScript("OnClick", function(frame, button) self:MenuClick(frame, button) end)

	frame:EnableMouse(true)

	frame:RegisterForDrag("LeftButton", "RightButton")
	frame:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp","Button4Up","Button5Up")

	frame.text = frame:CreateFontString("WhatsMenu"..index.."Title","OVERLAY","GameFontNormal")
	frame.text:SetFont(SharedMedia:Fetch('font', self.db.profile.menufont), self.db.profile.menufontsize)
	frame.text:SetText(frame.table[0])
	frame.text:SetPoint("CENTER", frame, "CENTER", 0, 0)
	frame.title = frame.table[0]

	frame.pattern = nil

	frame:ClearAllPoints()
	
	if index ~= 0 then
		if self.db.profile.growth == "U" then
			frame:SetPoint("BOTTOM", _G["WhatsMenu"..index-1], "TOP", 0, 2)
		elseif self.db.profile.growth == "D" then
			frame:SetPoint("TOP", _G["WhatsMenu"..index-1], "BOTTOM", 0, -2)
		elseif self.db.profile.growth == "L" then
			frame:SetPoint("TOPRIGHT", _G["WhatsMenu"..index-1], "TOPLEFT", -2, 0)
		elseif self.db.profile.growth == "R" then
			frame:SetPoint("TOPLEFT", _G["WhatsMenu"..index-1], "TOPRIGHT", 2, 0)
		end
	else
		frame:SetPoint("CENTER", UIParent, "CENTER", self.db.profile.LocX, self.db.profile.LocY)
	end
	return frame
end

function Whats:CreateSubMenuFrame(index, name, table, level)
	local frame = CreateFrame("BUTTON", 'WhatsSubMenu'..index, index == 1 and _G["WhatsMenu0"] or _G["WhatsSubMenu"..index-1])

	frame.index = index
	frame.table = table
	frame.level = level

	frame:SetFrameStrata("DIALOG")
	frame:SetWidth(self.db.profile.submenuWidth)
	frame:SetHeight(self.db.profile.submenuHeight)
	frame:SetBackdrop(
		{
			bgFile = SharedMedia:Fetch('background', self.db.profile.submenutexture),
			edgeFile = SharedMedia:Fetch('border', self.db.profile.submenuborder),
			tile="false",
			edgeSize = 8,
			insets = {
						left = 0,
						right = 0,
						top = 0,
						bottom = 0
					}
		})
	frame:SetBackdropColor(self.db.profile.Scolor.r, self.db.profile.Scolor.g, self.db.profile.Scolor.b, self.db.profile.Scolor.a)

	frame:SetScript("OnClick", function(frame, button) self:SubMenuClick(frame, button) end)

	frame:EnableMouse(true)

	frame:RegisterForDrag("LeftButton", "RightButton")
	frame:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp","Button4Up","Button5Up")

	frame.text = frame:CreateFontString("WhatsSubMenu"..index.."Title","OVERLAY","GameFontNormal")
	frame.text:SetFont(SharedMedia:Fetch('font', self.db.profile.submenufont), self.db.profile.submenufontsize)
	frame.text:SetText(name)
	frame.text:SetPoint("CENTER", frame, "CENTER", 0, 0)

	frame.pattern = nil

	frame:ClearAllPoints()
	
	if self.db.profile.growth == "U" then
		if self.db.profile.submenulocation == "U" then
			if index == 1 then
				frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "TOPRIGHT", -2, 0)
			else
				frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..index-1], "TOP", 0, -2)
			end
		else
			if index == 1 then
				frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "TOPLEFT", -2, 0)
			else
				frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..index-1], "TOP", 0, -2)
			end
		end
	elseif self.db.profile.growth == "D" then
		if self.db.profile.submenulocation == "U" then
			if index == 1 then
				frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "TOPRIGHT", -2, 0)
			else
				frame:SetPoint("TOP", _G["WhatsSubMenu"..index-1], "BOTTOM", 0, -2)
			end
		else
			if index == 1 then
				frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "TOPLEFT", -2, 0)
			else
				frame:SetPoint("TOP", _G["WhatsSubMenu"..index-1], "BOTTOM", 0, -2)
			end
		end
	elseif self.db.profile.growth == "R" then
		if self.db.profile.submenulocation == "U" then
			if index == 1 then
				frame:SetPoint("BOTTOMLEFT", _G["WhatsMenu0"], "TOPLEFT", 0, 0)
			else
				frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..index-1], "TOP", 0, 2)
			end
		else
			if index == 1 then
				frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "BOTTOMLEFT", 0, 0)
			else
				frame:SetPoint("TOP", _G["WhatsSubMenu"..index-1], "BOTTOM", 0, -2)
			end
		end
	elseif self.db.profile.growth == "L" then
		if self.db.profile.submenulocation == "U" then
			if index == 1 then
				frame:SetPoint("BOTTOMRIGHT", _G["WhatsMenu0"], "TOPRIGHT", 0, 0)
			else
				frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..index-1], "TOP", 0, 2)
			end
		else
			if index == 1 then
				frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "BOTTOMRIGHT", 0, 0)
			else
				frame:SetPoint("TOP", _G["WhatsSubMenu"..index-1], "BOTTOM", 0, -2)
			end
		end
	end

	frame:Show()
	return frame
end

function Whats:CreateButton(index)
	local index = tonumber(index)
	local frame = CreateFrame("Button", "WhatsButton"..index, index == 1 and _G["WhatsMenu0"] or _G["WhatsButton"..index-1])
	frame.index = index
	frame.itemid = nil
	frame.link = nil

	frame:SetFrameStrata("DIALOG")
	frame:SetWidth(self.db.profile.buttonWidth)
	frame:SetHeight(self.db.profile.buttonHeight)
	frame:SetBackdrop(
		{
			bgFile = SharedMedia:Fetch('background', self.db.profile.buttontexture),
			edgeFile = SharedMedia:Fetch('border', self.db.profile.buttonborder),
			tile="false",
			edgeSize = 8,
			insets = {
						left = 0,
						right = 0,
						top = 0,
						bottom = 0
					}
		})
	frame:SetBackdropColor(1, 1, 1)
	frame:EnableMouse(true)
	frame:EnableKeyboard(true)

	frame.icon = frame:CreateTexture("WhatsButton"..index.."Icon", "ARTWORK") 
	frame.icon:SetHeight(self.db.profile.buttonHeight - 2)
	frame.icon:SetWidth(self.db.profile.buttonHeight - 2)
	frame.icon:ClearAllPoints();
	frame.icon:SetPoint("TOPLEFT", frame, "TOPLEFT", 1, -1)
	frame.icon:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")

	frame:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp","Button4Up","Button5Up")

	frame:SetScript("OnLeave", function(frame)  self:HideTooltip(frame)end)
	frame:SetScript("OnEnter", function(frame) self:ShowTooltip(frame) end)
	frame:SetScript("OnClick", function(frmae, button)  self:ClickItem(frame, button) end)

	frame.itemname = frame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
	frame.itemname:SetFont(SharedMedia:Fetch('font', self.db.profile.buttonfont), self.db.profile.buttonfontsize)
	frame.itemname:SetText("")
	frame.itemname:SetPoint("TOPLEFT", frame.icon, "TOPRIGHT", 2, -1)

	frame.itemtype = frame:CreateFontString(nil, "OVERLAY", "GameFontNormal")
	frame.itemtype:SetFont(SharedMedia:Fetch('font', self.db.profile.buttonfont), self.db.profile.buttonfontsize)
	frame.itemtype:SetText("")
	frame.itemtype:SetPoint("BOTTOMLEFT", frame.icon, "BOTTOMRIGHT", 2, 1)

	frame:ClearAllPoints()

	if self.db.profile.growth == "U" then
		if self.db.profile.submenulocation == "U" then
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("BOTTOMLEFT", _G["WhatsSubMenu1"], "BOTTOMRIGHT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPLEFT", _G["WhatsButton"..index-1], "TOPRIGHT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("BOTTOMRIGHT", _G["WhatsMenu0"], "BOTTOMLEFT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			end
		else
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("BOTTOMLEFT", _G["WhatsMenu0"], "BOTTOMRIGHT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPLEFT", _G["WhatsButton"..index-1], "TOPRIGHT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("BOTTOMRIGHT", _G["WhatsSubMenu1"], "BOTTOMLEFT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			end
		end
	elseif self.db.profile.growth == "D" then
		if self.db.profile.submenulocation == "U" then
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("TOPLEFT", _G["WhatsSubMenu1"], "TOPRIGHT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPLEFT", _G["WhatsButton"..index-1], "TOPRIGHT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "TOPLEFT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			end
		else
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "TOPRIGHT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPLEFT", _G["WhatsButton"..index-1], "TOPRIGHT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("TOPRIGHT", _G["WhatsSubMenu1"], "TOPLEFT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			end
		end
	elseif self.db.profile.growth == "R" then
		if self.db.profile.submenulocation == "U" then
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("BOTTOMLEFT", _G["WhatsSubMenu1"], "BOTTOMRIGHT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPLEFT", _G["WhatsButton"..index-1], "TOPRIGHT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "BOTTOMLEFT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			end
		else
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("BOTTOMLEFT", _G["WhatsMenu0"], "TOPLEFT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPLEFT", _G["WhatsButton"..index-1], "TOPRIGHT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("TOPLEFT", _G["WhatsSubMenu1"], "TOPRIGHT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPLEFT", _G["WhatsButton"..index-1], "TOPRIGHT", 1, 0)
				end
			end
		end
	elseif self.db.profile.growth == "L" then
		if self.db.profile.submenulocation == "U" then
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("BOTTOMRIGHT", _G["WhatsSubMenu1"], "BOTTOMLEFT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "BOTTOMRIGHT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			end
		else
			if self.db.profile.buttonlocation == "U" then
				if index == 1 then
					frame:SetPoint("BOTTOMRIGHT", _G["WhatsMenu0"], "TOPRIGHT", 2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("BOTTOM", _G["WhatsButton"..index-self.db.profile.column], "TOP", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			else
				if index == 1 then
					frame:SetPoint("TOPRIGHT", _G["WhatsSubMenu1"], "TOPLEFT", -2, 0)
				elseif index > self.db.profile.column and mod(index, self.db.profile.column) == 1 then
					frame:SetPoint("TOP", _G["WhatsButton"..index-self.db.profile.column], "BOTTOM", 0, 1)
				else
					frame:SetPoint("TOPRIGHT", _G["WhatsButton"..index-1], "TOPLEFT", 1, 0)
				end
			end
		end
	end

	return frame
end




function Whats:ApplySetting()
	local num = 0
	while ( _G["WhatsMenu"..num] ) do

		local frame = _G["WhatsMenu"..num]

		frame:SetWidth(self.db.profile.menuWidth)
		frame:SetHeight(self.db.profile.menuHeight)
		frame:SetBackdrop(
			{
				bgFile = SharedMedia:Fetch('background', self.db.profile.menutexture),
				edgeFile = SharedMedia:Fetch('border', self.db.profile.menuborder),
				tile="false",
				edgeSize = 8,
				insets = {
							left = 0,
							right = 0,
							top = 0,
							bottom = 0
						}
			})
		frame:SetBackdropColor(self.db.profile.Mcolor.r, self.db.profile.Mcolor.g, self.db.profile.Mcolor.b, self.db.profile.Mcolor.a)
		frame.text:SetFont(SharedMedia:Fetch('font', self.db.profile.menufont), self.db.profile.menufontsize)
		frame.text:SetPoint("CENTER", frame, "CENTER", 0, 0)
		
		if num ~= 0 then
			frame:ClearAllPoints()
			if self.db.profile.growth == "U" then
				frame:SetPoint("BOTTOM", _G["WhatsMenu"..num-1], "TOP", 0, 2)
			elseif self.db.profile.growth == "D" then
				frame:SetPoint("TOP", _G["WhatsMenu"..num-1], "BOTTOM", 0, -2)
			elseif self.db.profile.growth == "L" then
				frame:SetPoint("TOPRIGHT", _G["WhatsMenu"..num-1], "TOPLEFT", -2, 0)
			elseif self.db.profile.growth == "R" then
				frame:SetPoint("TOPLEFT", _G["WhatsMenu"..num-1], "TOPRIGHT", 2, 0)
			end
		end
		num = num + 1
	end

	num = 1
	while ( _G["WhatsSubMenu"..num] ) do

		local frame = _G["WhatsSubMenu"..num]

		frame:SetWidth(self.db.profile.submenuWidth)
		frame:SetHeight(self.db.profile.submenuHeight)
		frame:SetBackdrop(
			{
				bgFile = SharedMedia:Fetch('background', self.db.profile.submenutexture),
				edgeFile = SharedMedia:Fetch('border', self.db.profile.submenuborder),
				tile="false",
				edgeSize = 8,
				insets = {
							left = 0,
							right = 0,
							top = 0,
							bottom = 0
						}
			})
		frame:SetBackdropColor(self.db.profile.Scolor.r, self.db.profile.Scolor.g, self.db.profile.Scolor.b, self.db.profile.Scolor.a)

		frame.text:SetFont(SharedMedia:Fetch('font', self.db.profile.submenufont), self.db.profile.submenufontsize)
		frame.text:SetPoint("CENTER", frame, "CENTER", 0, 0)

		frame:ClearAllPoints()
		
		if self.db.profile.growth == "U" then
			if self.db.profile.submenulocation == "U" then
				if num == 1 then
					frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "TOPRIGHT", -2, 0)
				else
					frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..num-1], "TOP", 0, -2)
				end
			else
				if num == 1 then
					frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "TOPLEFT", -2, 0)
				else
					frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..num-1], "TOP", 0, -2)
				end
			end
		elseif self.db.profile.growth == "D" then
			if self.db.profile.submenulocation == "U" then
				if num == 1 then
					frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "TOPRIGHT", -2, 0)
				else
					frame:SetPoint("TOP", _G["WhatsSubMenu"..num-1], "BOTTOM", 0, -2)
				end
			else
				if num == 1 then
					frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "TOPLEFT", -2, 0)
				else
					frame:SetPoint("TOP", _G["WhatsSubMenu"..num-1], "BOTTOM", 0, -2)
				end
			end
		elseif self.db.profile.growth == "R" then
			if self.db.profile.submenulocation == "U" then
				if num == 1 then
					frame:SetPoint("BOTTOMLEFT", _G["WhatsMenu0"], "TOPLEFT", 0, 0)
				else
					frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..num-1], "TOP", 0, 2)
				end
			else
				if num == 1 then
					frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "BOTTOMLEFT", 0, 0)
				else
					frame:SetPoint("TOP", _G["WhatsSubMenu"..num-1], "BOTTOM", 0, -2)
				end
			end
		elseif self.db.profile.growth == "L" then
			if self.db.profile.submenulocation == "U" then
				if num == 1 then
					frame:SetPoint("BOTTOMRIGHT", _G["WhatsMenu0"], "TOPRIGHT", 0, 0)
				else
					frame:SetPoint("BOTTOM", _G["WhatsSubMenu"..num-1], "TOP", 0, 2)
				end
			else
				if num == 1 then
					frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "BOTTOMRIGHT", 0, 0)
				else
					frame:SetPoint("TOP", _G["WhatsSubMenu"..num-1], "BOTTOM", 0, -2)
				end
			end
		end
		num = num + 1
	end

	num = 1

	while ( _G["WhatsButton"..num] ) do

		local frame = _G["WhatsButton"..num]
		frame:SetWidth(self.db.profile.buttonWidth)
		frame:SetHeight(self.db.profile.buttonHeight)
		frame:SetBackdrop(
			{
				bgFile = SharedMedia:Fetch('background', self.db.profile.buttontexture),
				edgeFile = SharedMedia:Fetch('border', self.db.profile.buttonborder),
				tile="false",
				edgeSize = 8,
				insets = {
							left = 0,
							right = 0,
							top = 0,
							bottom = 0
						}
			})
		frame.icon:SetHeight(self.db.profile.buttonHeight - 2)
		frame.icon:SetWidth(self.db.profile.buttonHeight - 2)
		frame.icon:ClearAllPoints();
		frame.icon:SetPoint("TOPLEFT", frame, "TOPLEFT", 1, -1)

		frame.itemname:SetFont(SharedMedia:Fetch('font', self.db.profile.buttonfont), self.db.profile.buttonfontsize)
		frame.itemtype:SetFont(SharedMedia:Fetch('font', self.db.profile.buttonfont), self.db.profile.buttonfontsize)
		frame.itemtype:SetPoint("BOTTOMLEFT", frame.icon, "BOTTOMRIGHT", 2, 1)

		frame:ClearAllPoints()

		local itemid = frame.itemid		
		local r, t, x
		if WhatsItemInfo[itemid] then
			_, r, t = strsplit("/", WhatsItemInfo[itemid], 6)
		end

		local name = select(2, GetItemInfo(itemid))
		if name ~= nil then
			frame.itemname:SetText(name)
			frame.link = name
			_G["WhatsButton"..num]:SetBackdropColor(self.db.profile.Ccolor.r, self.db.profile.Ccolor.g, self.db.profile.Ccolor.b, self.db.profile.Ccolor.a)
		else
			local link = self:GetLink(itemid)
			if link ~= nil then
				frame.itemname:SetText(link)
				_G["WhatsButton"..num]:SetBackdropColor(self.db.profile.Ucolor.r, self.db.profile.Ucolor.g, self.db.profile.Ucolor.b, self.db.profile.Ucolor.a)
			else
				if r ~= nil then
					local colorCode = ItemColorTable[tonumber(r)]
					frame.itemname:SetText("|cff"..colorCode.."["..itemid.."]|r")
				else
					frame.itemname:SetText("|cffff0000["..itemid.."]|r")
				end
				_G["WhatsButton"..num]:SetBackdropColor(self.db.profile.Ncolor.r, self.db.profile.Ncolor.g, self.db.profile.Ncolor.b, self.db.profile.Ncolor.a)
			end
		end

		if self.db.profile.buttonOrlist == "B" then
			if t ~= nil then
				frame.itemtype:SetText(WhatsItemType[t])
			else
				frame.itemtype:SetText(L["Unchecked"])
			end
			frame.itemtype:Show()
		else
			frame.itemtype:Hide()
		end
	
		if self.db.profile.growth == "U" then
			if self.db.profile.submenulocation == "U" then
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("BOTTOMLEFT", _G["WhatsSubMenu1"], "BOTTOMRIGHT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPLEFT", _G["WhatsButton"..num-1], "TOPRIGHT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("BOTTOMRIGHT", _G["WhatsMenu0"], "BOTTOMLEFT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				end
			else
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("BOTTOMLEFT", _G["WhatsMenu0"], "BOTTOMRIGHT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPLEFT", _G["WhatsButton"..num-1], "TOPRIGHT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("BOTTOMRIGHT", _G["WhatsSubMenu1"], "BOTTOMLEFT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				end
			end
		elseif self.db.profile.growth == "D" then
			if self.db.profile.submenulocation == "U" then
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("TOPLEFT", _G["WhatsSubMenu1"], "TOPRIGHT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPLEFT", _G["WhatsButton"..num-1], "TOPRIGHT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "TOPLEFT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				end
			else
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "TOPRIGHT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPLEFT", _G["WhatsButton"..num-1], "TOPRIGHT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("TOPRIGHT", _G["WhatsSubMenu1"], "TOPLEFT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				end
			end
		elseif self.db.profile.growth == "R" then
			if self.db.profile.submenulocation == "U" then
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("BOTTOMLEFT", _G["WhatsSubMenu1"], "BOTTOMRIGHT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPLEFT", _G["WhatsButton"..num-1], "TOPRIGHT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("TOPLEFT", _G["WhatsMenu0"], "BOTTOMLEFT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				end
			else
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("BOTTOMLEFT", _G["WhatsMenu0"], "TOPLEFT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPLEFT", _G["WhatsButton"..num-1], "TOPRIGHT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("TOPLEFT", _G["WhatsSubMenu1"], "TOPRIGHT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPLEFT", _G["WhatsButton"..num-1], "TOPRIGHT", 1, 0)
					end
				end
			end
		elseif self.db.profile.growth == "L" then
			if self.db.profile.submenulocation == "U" then
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("BOTTOMRIGHT", _G["WhatsSubMenu1"], "BOTTOMLEFT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("TOPRIGHT", _G["WhatsMenu0"], "BOTTOMRIGHT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				end
			else
				if self.db.profile.buttonlocation == "U" then
					if num == 1 then
						frame:SetPoint("BOTTOMRIGHT", _G["WhatsMenu0"], "TOPRIGHT", 2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("BOTTOM", _G["WhatsButton"..num-self.db.profile.column], "TOP", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				else
					if num == 1 then
						frame:SetPoint("TOPRIGHT", _G["WhatsSubMenu1"], "TOPLEFT", -2, 0)
					elseif num > self.db.profile.column and mod(num, self.db.profile.column) == 1 then
						frame:SetPoint("TOP", _G["WhatsButton"..num-self.db.profile.column], "BOTTOM", 0, 1)
					else
						frame:SetPoint("TOPRIGHT", _G["WhatsButton"..num-1], "TOPLEFT", 1, 0)
					end
				end
			end
		end
		num = num + 1
	end

end


