--[[
Name: WeaponRebuff (Redux2) - 3.0f
Revision: $Rev: 51475 $
Date: $LastChangedDate: 2007-10-09 05:02:16 -0400 (Tue, 09 Oct 2007) $
Author(s): Vincent (vincent@silverdaggers.net)
Website: http://www.wowinterface.com/downloads/info5604-WeaponRebuffRedux2.html
Documentation: http://www.wowinterface.com/downloads/info5604-WeaponRebuffRedux2.html
Description: Monitors and simplifies the tedius act of reapplying buffs to weapons
	(Original Weapon Rebuff by thomas kriegel - opt)
Optional Dependencies: Waterfall
]]

-- [[ Ace-isms ]] ---------------------------------------------------------------------------
WeaponRebuff = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceEvent-2.0", "AceConsole-2.0")
local T         = AceLibrary("AceLocale-2.2"):new("WeaponRebuff")
local waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0")


-- [ Initial Load ] --
function WeaponRebuff:OnInitialize()
	-- [[ Setup Tooltips ]] -------------------------------
		-- [[ Tooltip that's read for buffs ]] --
	wrItemTempTooltip = CreateFrame("GameTooltip", "wrItemTempTooltip", nil, "GameTooltipTemplate")
	wrItemTempTooltip:SetOwner(UIParent, "ANCHOR_NONE")

		-- [[ Tooltip that shows remembered buffs ]] --
	wrRememberedBuffsTooltip = CreateFrame("GameTooltip", "wrRememberedBuffsTooltip", UIParent, "GameTooltipTemplate")
	
		-- [[ This tooltip added to attempt to prevent/preclude behavior [doxxx]@wowinterface was ]] --
		-- [[ reporting where over time the first line of text of tooltips was reset to a smaller ]] --
		-- [[ font.  Removed using GameToolTip directly (which should be safe, so I'm lead to     ]] --
		-- [[ lead to believe) and now create our own tooltip for it.  Unsure if this is a 'fix'  ]] --
		-- [[ or not since I've never heard of this before and I'm utterly unable to reproduce it.]] --	
	wrBuffSelectorTooltip = CreateFrame("GameTooltip", "wrBuffSelectorTooltip", UIParent, "GameTooltipTemplate")

	-- [[ Setup Profile Database ]] ------------------------
	self:RegisterDB("WeaponRebuffDB")
	self:RegisterDBDefaults()

	-- [[ Fishing Force-Set ]] --
	self:Toggle_FishingMode(true) -- (in FuBar) to clean before we load data

	-- [[ Load a Buncha Crap ]] ----------------------------
	WeaponRebuff:LoadTables()  -- (this file)
	WeaponRebuff:Fubar_Setup() -- FuBar
	WeaponRebuff:LoadMedia()   -- Config
	WeaponRebuff:LoadOptions() -- Config
	
	
	-- [[ Typical AddOn "I'm Alive!" Spam ]] ---------------
	WeaponRebuff.ChatPrintClean("|caaff0000WeaponRebuff|r "..wrColor.gold.."v3.0|r "..wrColor.softblue.."(svn "..self:GetFirstNumber("$Rev: 51475 $")..")|r "..T["WEAPONREBUFF_HELPMSG_CMDLINETEXT"])
end


-- [ OnPLAYER_REGEN_DISABLED ] --
function WeaponRebuff:OnPLAYER_REGEN_DISABLED()
	
	-- [ Set Selector Type ] --
	WeaponRebuffCombat.createMode = "preCombat"

	-- [ Drop menu ] --
	if self.db.profile.wrOpenOnCombat == 1 then
		-- [ Open On Combat (auto-open) ] --
		if not WeaponRebuffMenu:IsShown() then
			WeaponRebuffMenu:Show()
		end
	else
		if WeaponRebuffMenu:IsShown() then
			WeaponRebuffMenu:Hide()
		end		
	end
		
end

-- [ OnPLAYER_REGEN_ENABLED ] --
function WeaponRebuff:OnPLAYER_REGEN_ENABLED()
	local sdp = self.db.profile

	-- [ Set Selector Type ] --
	WeaponRebuffCombat.createMode = ""
	
	-- [ Open On Combat (autoclose) ] --
	if sdp.wrOpenOnCombat == 1 then
		WeaponRebuffMenu:Hide()
	end
		
	-- [ Reset Size and Position ] --
	if WeaponRebuffCombat.ResetPos then
	  WeaponRebuffCombat.ResetPos = false
		self:ResetSizeAndPosition()
	end
	
	-- [ ResizeButton ] --
	if WeaponRebuffCombat.ResizeButton then
		WeaponRebuffCombat.ResizeButton = false
		self:ResizeButton(sdp.wrButtonSize)
	end
	
	-- [ Set Delayed Buffs ] --
	if not (WeaponRebuffCombat.mhBuffReset == "") then
		self:SetBuffAttribute(WeaponRebuffCombat.mhBuffReset, WeaponRebuffCombat.mhBuffResetType, "16")
		WeaponRebuffCombat.mhBuffReset     = ""
		WeaponRebuffCombat.mhBuffResetType = 0
	 	self:PositionButtonText()
	end 
	
	if not (WeaponRebuffCombat.ohBuffReset == "")  then
		self:SetBuffAttribute(WeaponRebuffCombat.ohBuffReset, WeaponRebuffCombat.ohBuffResetType, "17")
		WeaponRebuffCombat.ohBuffReset     = ""
		WeaponRebuffCombat.ohBuffResetType = 0
	 	self:PositionButtonText()
	end
	
	-- [ Update Window Display ] --
	WeaponRebuff:UpdateTextures()
	
end

function WeaponRebuff:ItemBuffButton_OnUpdate()
	WeaponRebuff:ItemBuff_UpdateText(16);
	if WeaponRebuff.db.profile.wrDisableOffhandButton == 0 then
		WeaponRebuff:ItemBuff_UpdateText(17)
	end 
	
	-- [[ FuBar Update Routine ]] --
	WeaponRebuff:Update()
	
end

function WeaponRebuff:OnEnable()
	-- [[ Register Events ]] --
	WeaponRebuff:RegisterEvent("UNIT_INVENTORY_CHANGED", "InventoryChange")
	WeaponRebuff:RegisterEvent("PLAYER_REGEN_DISABLED",  "OnPLAYER_REGEN_DISABLED")
	WeaponRebuff:RegisterEvent("PLAYER_REGEN_ENABLED",   "OnPLAYER_REGEN_ENABLED")

	-- [[ Setup Window ]] --
-- DEBUGGING:
self:CreateRebuffFrame()

	local sdp = self.db.profile
	WeaponRebuff:ResizeButton(sdp.wrButtonSize);
	WeaponRebuffFrame:SetFrameStrata(sdp.wrFrameStrata)
	WeaponRebuff:UpdateTextures();
	
	-- [[ Setup Buff Window Briefly ]] --
	-- Necessary to do both for bug-checking and for show-on-combat=enabled --
	WeaponRebuff:ShowBuffSelectorMenu() -- create
	WeaponRebuff:ShowBuffSelectorMenu()	-- toggle off
	
  -- [[ Register Timers ]] --
  wrUpdateButtons = WeaponRebuff:ScheduleRepeatingEvent(WeaponRebuff.ItemBuffButton_OnUpdate, 1, self)

	-- [[ Show Window ]] --
	WeaponRebuff:UpdateTextures()
end

function WeaponRebuff:OnDisable()
	-- [[ Hide Window ]] --
  wrMainhandButton:Hide()
  wrOffhandButton:Hide()	
end

function WeaponRebuff:OnProfileDisable()
  -- this is called every time your profile changes (before the change)
	-- intentionally left blank
end

function WeaponRebuff:OnProfileEnable()
  -- this is called every time your profile changes (after the change)
	-- intentionally left blank
end


function WeaponRebuff:SaveVariables()
	local sdp = self.db.profile
	if sdp.wrFishingMode then
		sdp.RememberBuffFishingName = RememberBuff[16].BuffName
		sdp.RememberBuffFishingType = RememberBuff[16].BuffType
	else
		sdp.RememberBuffMainhandName = RememberBuff[16].BuffName
		sdp.RememberBuffOffhandName  = RememberBuff[17].BuffName
		sdp.RememberBuffMainhandType = RememberBuff[16].BuffType
		sdp.RememberBuffOffhandType  = RememberBuff[17].BuffType
	end
end

-- [ Bag / Item Data ] ------------------------------
function WeaponRebuff:GetItemName(bag, slot)
 -- Courtesy Capnbry @ capnbry.net/wow
  local linktext = nil;
  
  if (bag == -1) then
  	linktext = GetInventoryItemLink("player", slot);
  else
  	linktext = GetContainerItemLink(bag, slot);
  end

  if linktext then
    local _,_,name = string.find(linktext, "^.*%[(.*)%].*$");
    return name;
  else
    return "";
  end;
end;

--[[ Print Messages -------------------------------------------------------------- ]]

-- [[Q&D call for debugging --
wrp = function( msgKey, msgHighlight, msgAdditional, r, g, b )
	WeaponRebuff.ChatPrint( msgKey, msgHighlight, msgAdditional, r, g, b )
end 
----------------------------]]

WeaponRebuff.ChatPrint = function( msgKey, msgHighlight, msgAdditional, r, g, b )
    local msgOutput = DEFAULT_CHAT_FRAME;
    if msgKey				 == "" then return; end;
    if msgKey        == nil then msgKey = "<nomsg>"; end;    
    if msgHighlight  == nil or msgHighlight  == "" then msgHighlight  = " "; end;
    if msgAdditional == nil or msgAdditional == "" then msgAdditional = " "; end;
    if( msgOutput ) then
        msgOutput:AddMessage( "|caaff0000WeaponRebuff|r|caaffff00>|r "..msgKey.." |caaaaddff"..msgHighlight.."|r"..msgAdditional, r, g, b );
    end
end

WeaponRebuff.ChatPrintShort = function( msgKey, msgHighlight, msgAdditional, r, g, b )
    local msgOutput = DEFAULT_CHAT_FRAME;
    if msgKey				 == "" then return; end;
    if msgHighlight  == nil or msgHighlight  == "" then msgHighlight  = " "; end;
    if msgAdditional == nil or msgAdditional == "" then msgAdditional = " "; end;
    if( msgOutput ) then
        msgOutput:AddMessage( "|caaff0000WR|r|caaffff00>|r "..msgKey.." |caaaaddff"..msgHighlight.."|r"..msgAdditional, r, g, b );
    end
end

WeaponRebuff.ChatPrintClean = function( msgKey )
    local msgOutput = DEFAULT_CHAT_FRAME;
    if msgKey == "" then return; end;
    if( msgOutput ) then
        msgOutput:AddMessage( msgKey );
    end
end

--[[ Inventory Delta ------------------------------------------------------------- ]]
function WeaponRebuff:InventoryChange()
	self:UpdateTextures();
	self:ItemBuffButton_OnUpdate() -- Speeds up the text matching the icons (under 1sec)
end

--[[ Debuging -------------------------------------------------------------- ]]

function WeaponRebuff:ShowDebugInfo()
	local sdp = self.db.profile

	WeaponRebuff.ChatPrint("wrEnableShowText ", 				 		 sdp.wrEnableShowText);
	WeaponRebuff.ChatPrint("wrInvisibleAddon ", 				 		 sdp.wrInvisibleAddon);
	WeaponRebuff.ChatPrint("wrDisableOffhandButton ", 	 		 sdp.wrDisableOffhandButton);
	WeaponRebuff.ChatPrint("RememberBuff[16].BuffName ", 		 RememberBuff[16].BuffName);
	WeaponRebuff.ChatPrint("RememberBuff[16].BuffType ", 		 RememberBuff[16].BuffType);
	WeaponRebuff.ChatPrint("RememberBuff[17].BuffName ", 		 RememberBuff[17].BuffName);
	WeaponRebuff.ChatPrint("RememberBuff[17].BuffType ", 		 RememberBuff[17].BuffType);
		
	WeaponRebuff.ChatPrint("wrSoundAlarms_lost ", 					 sdp.wrSoundAlarms_lost);           		  
	WeaponRebuff.ChatPrint("wrTextAlarms_lost ",						 sdp.wrTextAlarms_lost);             		 
	WeaponRebuff.ChatPrint("wrSoundAlarms_warning ", 				 sdp.wrSoundAlarms_warning);           		  
	WeaponRebuff.ChatPrint("wrTextAlarms_warning ",					 sdp.wrTextAlarms_warning);             		 
	WeaponRebuff.ChatPrint("wrBuffItemsAlarms ",						 sdp.wrBuffItemsAlarms);           		 
	WeaponRebuff.ChatPrint("wrButtonSize ",						 	 		 sdp.wrButtonSize);           
	
	WeaponRebuff.ChatPrint("wrWarnThreshold_BuffItems ",		 sdp.wrWarnThreshold_BuffItems);     
	WeaponRebuff.ChatPrint("wrWarnThreshold_inSeconds ",		 sdp.wrWarnThreshold_inSeconds);
	WeaponRebuff.ChatPrint("wrEnableSideBySide ",		 				 sdp.wrEnableSideBySide);			
	WeaponRebuff.ChatPrint("wrFrameStrata ",		 				     sdp.wrFrameStrata);

	WeaponRebuff.ChatPrint("wrMenuButtonSize_NonCombat ",		 sdp.wrMenuButtonSize_NonCombat);           
	WeaponRebuff.ChatPrint("wrMenuDirection_NonCombat ",	 	 sdp.wrMenuDirection_NonCombat);
	WeaponRebuff.ChatPrint("wrButtonType_NonCombat ",				 sdp.wrButtonType_NonCombat);
	WeaponRebuff.ChatPrint("wrMenuPoin_NonCombat ", 	 			 sdp.wrMenuPoint_NonCombat);
	WeaponRebuff.ChatPrint("wrFontSize_NonCombat ",	 				 sdp.wrFontSize_NonCombat);

	WeaponRebuff.ChatPrint("wrMenuButtonSize_Combat ",			 sdp.wrMenuButtonSize_Combat);           
	WeaponRebuff.ChatPrint("wrMenuDirection_Combat ",	 			 sdp.wrMenuDirection_Combat);
	WeaponRebuff.ChatPrint("wrButtonType_Combat ",					 sdp.wrButtonType_Combat);
	WeaponRebuff.ChatPrint("wrMenuPoint_Combat ",	 				   sdp.wrMenuPoint_Combat);
	WeaponRebuff.ChatPrint("wrFontSize_Combat ",	 				   sdp.wrFontSize_Combat);

	WeaponRebuff.ChatPrint("wrOpenOnCombat ",	 				     	 sdp.wrOpenOnCombat);

end

--[[ Alarms -------------------------------------------------------------- ]]

function WeaponRebuff:SetAlarmState_fmSlot(slotAlarmState, slot)
	if ( slot == 16 ) then
		wr.alarm.AlarmState16 = slotAlarmState
	elseif ( slot == 17 ) then
		wr.alarm.AlarmState17 = slotAlarmState
	end
end

function WeaponRebuff:AnnounceMsg(msg, R, B, G)	
	WeaponRebuff_InfodumpFrame:AddMessage(msg, R, B, G, 1, UIERRORS_HOLD_TIME);
end	

function WeaponRebuff:inCombat()
	if UnitAffectingCombat("player") then
		return true
	else
		return false
	end
end

function WeaponRebuff:SlotContainsSignalableItem(slot)
  -- basically, if no texture, we shouldn't do signal an alert -- cheezy but it works
	return GetInventoryItemTexture("player", slot)
end

--[[ Item Control ---------------------------------------------------------------- ]]
function WeaponRebuff:LocateBuffItems()
	local sdp = WeaponRebuff.db.profile
	local wepBuffs
	local buffItemTable = {};
	
	if sdp.wrFishingMode then
	 	-- If in Fishing Mode then only show lures
		for _, wepBuffs in pairs(sdp.itemLures) do	
			WeaponRebuff:SeekBuffItems_mkTable(wepBuffs, buffItemTable)
		end
	else
		-- [[ Poisons ]] --
		if sdp.useCat_ItemPoisons then	
			for _, wepBuffs in pairs(sdp.itemPoisons) do	
				WeaponRebuff:SeekBuffItems_mkTable(wepBuffs, buffItemTable)
			end
		end
  	
		-- [[ Oils ]] --
		if sdp.useCat_ItemOils then
			for _, wepBuffs in pairs(sdp.itemOils) do	
				WeaponRebuff:SeekBuffItems_mkTable(wepBuffs, buffItemTable)
			end
		end
		
		-- [[ Stones (weight/sharpening) ]] --
		if sdp.useCat_ItemStones then
			for _, wepBuffs in pairs(sdp.itemStones) do	
				WeaponRebuff:SeekBuffItems_mkTable(wepBuffs, buffItemTable)
			end
		end
		
		-- [[ Lures ]] --
		if sdp.useCat_ItemLures then
			for _, wepBuffs in pairs(sdp.itemLures) do	
				WeaponRebuff:SeekBuffItems_mkTable(wepBuffs, buffItemTable)
			end
		end
		
		-- [[ Misc ]] --
		if sdp.useCat_ItemMisc then
			for _, wepBuffs in pairs(sdp.itemMisc) do	
				WeaponRebuff:SeekBuffItems_mkTable(wepBuffs, buffItemTable)
			end
		end
	end
	
	return buffItemTable;
end

function WeaponRebuff:SeekBuffItems_mkTable(wepBuffs, buffItemTable)
	local i, bagSlots, bagId, icon, quantity
	local itemName

	for i=0, 4 do
		bagSlots = GetContainerNumSlots(i)
		if (bagSlots > 0) then
		
			for j=1, bagSlots do
				itemName = self:GetItemName(i, j)
    
				if (itemName == wepBuffs) then
					icon, quantity = GetContainerItemInfo(i, j)
					
					local t = buffItemTable[itemName]
					
					if (t == nil) then
						t = { name=itemName, icon=icon, quantity=0 }
						buffItemTable[itemName] = t
					end
					
					t.quantity = t.quantity + quantity
				end
			
			end				
			
		end		
		
	end
	
end

--[[ Loding/Saving and Controls -------------------------------------------------- ]]

function WeaponRebuff:LoadTables()
  -- [[ ToDo: Optimize this...mess ]] --
  -- [ Quick Colors ] ---------------------------
	wrColor = {
		["red"]        = "|caaff0000",
		["yellow"]     = "|caaffff00",
		["green"]      = "|caa00ff00",
		["copper"]     = "|caaeda55f",
		["lte_blue"]   = "|caaaaddff",
		["orange"]     = "|caaff7f00",
		["white"]      = "|caaffffff",
	 	["silver"]     = "|caac7c7cf",
		["gold"]       = "|caaffd700", 
		["softblue"]   = "|caa637bd1",
		["powderblue"] = "|caa8888e5"
	}

  -- [ MiniMap/FuBar Button Options ] -- 
	wrButtonOptions = {
		["OPEN_Configuration"]      = T["OPEN_Configuration"],
		["TOGGLE_2BuffMode"]        = T["TOGGLE_2BuffMode"],
		["TOGGLE_BuffSelector"]     = T["TOGGLE_BuffSelector"],
		["TOGGLE_ShowInCombat"]     = T["TOGGLE_ShowInCombat"],
		["TOGGLE_ShowWeaponRebuff"] = T["TOGGLE_ShowWeaponRebuff"],
		["TOGGLE_FishingMode"]      = T["TOGGLE_FishingMode"]
	}		

  -- [ Buff Table ] ----------------------------
  local sdp = self.db.profile
	RememberBuff = {}
	RememberBuff[16]={BuffName = sdp.RememberBuffMainhandName, BuffType = sdp.RememberBuffMainhandType}
	RememberBuff[17]={BuffName = sdp.RememberBuffOffhandName,  BuffType = sdp.RememberBuffOffhandType }	
	
	-- [[ Data Control Array ]] ----------------------------
	WeaponRebuffInfo = {
		wrPositionLocked = true,
		BuffTable = {}
	}

  -- [ In-Combat Catcher ] ----------------------
	WeaponRebuffCombat = {
		["mhBuffReset"] = "",
		["mhBuffResetType"] = 0,
		["ohBuffReset"] = "",
		["ohBuffResetType"] = 0,
		["ResetPos"] = nil,
		["ResizeButton"] = nil,
		["createMode"] = ""
	}
	
  -- [ Alarm and Data Tracker ] -----------------
	wr = {
		["LastBuff"] = "",
		["alarm"] = {
			["AlarmState16"] = "Sleeping",
			["AlarmState17"] = "Sleeping"
		},
		["wrBuffsTillClose"]        = 0 -- for TwoBuffMode tracking
	}				
		
end

function WeaponRebuff:RegisterDBDefaults()
		self:RegisterDefaults('profile', {
		pos = {
			rebuffwindow = {
				px  = 1,
				py  = -245,
				rel = "TOPLEFT"
			},			
			buffselector = {
				px = 0,
				py = 0
			}
		},
		
																						     -- [ NON-COMBAT ] --
  	wrButtonType_Combat = 0,								     -- use Button Type (1=Text / 0=Icon)
  	wrMenuDirection_Combat = "Left to Right",	   -- Menu Growth Direction
  	wrMenuPoint_Combat = "BOTTOMLEFT",			     -- Menu Attach Point
  	wrMenuButtonSize_Combat = 22, 					     -- size of buff menu buttons
  	wrFontSize_Combat = 14,									     -- Font Size for selector button text
                                                 
																						     -- [ COMBAT ] --
  	wrButtonType_NonCombat = 0,							     -- use Button Type (1=Text / 0=Icon)
  	wrMenuDirection_NonCombat = "Left to Right", -- Menu Growth Direction
  	wrMenuPoint_NonCombat = "BOTTOMLEFT",				 -- Menu Attach Point
  	wrMenuButtonSize_NonCombat = 22, 						 -- size of buff menu buttons
  	wrFontSize_NonCombat = 14,									 -- Font Size for selector button text
                                            		 
																								 -- [ SAVED DATA ] --
		RememberBuffMainhandName = "-none-",    		 -- buff on MH
		RememberBuffOffhandName = "-none-",		  		 -- buff on OH
		RememberBuffFishingName = "-none-",		  		 -- buff on OH
		RememberBuffMainhandType = 0,								 -- type of MH buff
		RememberBuffOffhandType = 0,								 -- type of OH buff
		RememberBuffFishingType = 0,								 -- type of MH buff
                                            		 
																								 -- [ OPTIONS ] --
    wrButtonSize = 16,											     -- size of wr buttons
    wrFontSize = 10,											       -- size of wr button font strings
		wrFont = "Friz Quandrata TT",								 -- font name
    wrFontFile = [[Fonts\FRIZQT__.TTF]],				 -- font file
    
    tooltips = {																 -- [ TOOLTIPS ] --
      holdkey = "Shift", 												 -- key to hold for main tooltips
    	rebuffpos = "ANCHOR_BOTTOMLEFT",					 -- tooltip anchor
    	buffselector = "ANCHOR_BOTTOMLEFT"         -- buff selector anchor
    },
    
    TruncateBuffText = false, 								   -- truncates the () from stuff like sharpening stones, etc
    wrInvisibleAddon = 0,												 -- Show/Hide WR interface
    wrEnableShowText = 1,									  		 -- Show/Hide WR text
    wrDisableOffhandButton = 0,									 -- hides offhand button
  	wrEnableSideBySide = false,                      -- turns off text and displays icons side-by-side
  	wrFrameStrata = "LOW",									     -- Framestrata HIGH, MEDIUM, LOW, BACKGROUND, DIALOG, TOOLTIP
  	wrOpenOnCombat = 0,											     -- Open on Entering Combat
		wrBuffItemsAlarms = 1,											 -- alarms for charges
  	wrWarnThreshold_BuffItems = 5,				       -- warning threshold for buffing items
  	wrSoundAlarms_warning = 1,									 -- WARNING sound alarms
  	wrTextAlarms_warning = 1,  									 -- WARNING text alarms
  	wrWarnThreshold_inSeconds = 60,              -- WARNING threshold in seconds
  	wrSoundAlarms_lost = 1,									     -- LOST sound alarms
  	wrTextAlarms_lost = 1,  									   -- LOST text alarms
  	wrSoundIndex_BuffWarning = "Cherink",		     -- buff warning sound index
  	wrSoundIndex_BuffLost = "Murloc Aggro Old",  -- bufflost warning sound index
  	wr2BuffMode = false,												 -- closes the buff selector after 2 instead of 1 buff
																						     -- [ BUFF SELF ADMINISTRATION ] --  	
  	spellNames  = T.spellNames,									 -- default list of Buffing Spell names in country language

  	wrFishingMode = false,                       -- "Fishing Mode" toggle
		
  	useCat_ItemMisc    = true,									 -- Enable/Disable using buff item categories in searches
  	useCat_ItemOils    = true,									 -- Enable/Disable using buff item categories in searches
  	useCat_ItemStones  = true,									 -- Enable/Disable using buff item categories in searches
  	useCat_ItemLures   = true,									 -- Enable/Disable using buff item categories in searches
  	useCat_ItemPoisons = true,									 -- Enable/Disable using buff item categories in searches
  	
  	itemPoisons = T.itemPoisons,                 -- default list of buffing items in categories
  	itemOils    = T.itemOils,                    -- default list of buffing items in categories
  	itemStones  = T.itemStones,                  -- default list of buffing items in categories
  	itemLures   = T.itemLures,                   -- default list of buffing items in categories
  	itemMisc    = T.itemMisc,   								 -- default list of buffing items in categories

																						     -- [ Suppressed Buffs ] --  	
		suppBuffs		= T.suppressedbuffs,	           -- Array of suppressed buffs (green, no alerts)

																						     -- [ CLICK BEHAVIORS ] --  	
  	fubar_click 		 = "OPEN_Configuration",     -- Behavior when click is pressed
  	fubar_shiftclick = "TOGGLE_FishingMode",	   -- Behavior when shift-click is pressed
  	fubar_ctrlclick  = "TOGGLE_2BuffMode",	     -- Behavior when ctrl-click is pressed
  	
  	textPos = "RIGHT", -- TOP, BOTTOM, LEFT, RIGHT

	})

	if not self.db.char.ready30rel then 
		self:SetProfile('char')
		WeaponRebuff.ChatPrint("Profile", "has been reset for 3.0+ version")
		self.db.char.ready30rel = true
	end

end	


--[[ End Weapon Rebuff (Redux2) -------------------------------------------------------------- ]]
