--[[ RebuffWindow -------------------------------------------------------------- ]]
local T = AceLibrary("AceLocale-2.2"):new("WeaponRebuff")

--[[ UI Rebuff Buttons and Tooltips -------------------------------------------- ]]

function WeaponRebuff:CreateRebuffFrame()
	local sdp  = self.db.profile
	local sdpp = sdp.pos
	local frame

	-- [[ START WEAPON REBUFF FRAME ]] ---------------------------------------------------
	frame = CreateFrame("Frame", "WeaponRebuffFrame", UIParent, "SecureFrameTemplate")

	-- [[ One of these days, this might be an option ----------------------------------
--	 frame:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
--	 	                  edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
--	                     tile = true, tileSize = 16, edgeSize = 16, 
--	                     insets = { left = 4, right = 4, top = 4, bottom = 4 }
--	                    }
--	 	)
--	 frame:SetBackdropColor(0, 0, 0, 1)
--	 frame:SetBackdropBorderColor(1, .6, 0, 1)
	-- -------------------------------------------------------------------------- ]] --

	-- [ Drag Setup ] --
	frame:EnableMouse(true)
	frame:SetMovable(true)

	-- [ Window Position ] --
	frame:SetWidth(1)
 	frame:SetHeight(1)
	frame:ClearAllPoints()
	self:RestorePosition()
	frame:Show()
	
	-- [[ END WEAPON REBUFF FRAME ]] -----------------------------------------------------
	
	-- [[ START REBUFF BUTTONS ]] -----------------------------------------------------	
	local MHbutton, OHbutton
	MHbutton = CreateFrame("Button", "wrMainhandButton", frame, "SecureActionButtonTemplate")
  MHbutton:SetPoint("TOPLEFT", frame, "TOPLEFT", 7, -7)
	MHbutton:SetScript("OnEnter", loadstring("WeaponRebuff_ShowCurrentBuffsTooltips();"));
	MHbutton:SetScript("OnLeave", function() wrRememberedBuffsTooltip:Hide() end);
	self:SetRebuffButtonAttributes(MHbutton, 16)

	OHbutton = CreateFrame("Button", "wrOffhandButton", frame, "SecureActionButtonTemplate")
	OHbutton:SetPoint("TOPLEFT", MHbutton, "BOTTOMLEFT", 0, -2)
	OHbutton:SetScript("OnEnter", loadstring("WeaponRebuff_ShowCurrentBuffsTooltips();"));
	OHbutton:SetScript("OnLeave", function() wrRememberedBuffsTooltip:Hide() end);
	self:SetRebuffButtonAttributes(OHbutton, 17)
	
	-- [ Font Strings and Initial Text ] --
	local fString 
	
	fString = frame:CreateFontString("wrMainhandButton".."Text", "ARTWORK")
	fString:SetParent(MHbutton)
	fString:SetFont(sdp.wrFontFile, sdp.wrFontSize, "")
	fString:SetTextColor(1, 0, 0)
	fString:SetText("<<"..sdp.RememberBuffMainhandName..">>")
	
	fString = frame:CreateFontString("wrOffhandButton".."Text", "ARTWORK")
	fString:SetParent(OHbutton)
	fString:SetFont(sdp.wrFontFile, sdp.wrFontSize, "")
	fString:SetTextColor(1, 0, 0)
	fString:SetText("<<"..sdp.RememberBuffOffhandName..">>")
	
	-- [ Set Identity Attributes ] --
	WeaponRebuff:SetBuffAttribute(RememberBuff[16].BuffName, RememberBuff[16].BuffType, "16")	
	WeaponRebuff:SetBuffAttribute(RememberBuff[17].BuffName, RememberBuff[17].BuffType, "17")
	-- [[ END REBUFF BUTTONS ]] -----------------------------------------------------	

end

function WeaponRebuff:SetRebuffButtonAttributes(frame, id)
	frame:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
	frame:SetHighlightTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Highlight") -- alphaMode="ADD" 

	-- [ dragging ] --
  frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnDragStart", function()
		if not WeaponRebuffInfo.wrPositionLocked then
			WeaponRebuffFrame:StartMoving()
		end		
	end)
	
	frame:SetScript("OnDragStop", function()
		if not WeaponRebuffInfo.wrPositionLocked then
				WeaponRebuffFrame:StopMovingOrSizing()
				self:SavePosition()				
		end		
	end)

  -- [ clicking ] --
	frame:RegisterForClicks("LeftButtonUp", "RightButtonUp")
	frame:SetScript("OnMouseUp", function()
		if ( WeaponRebuffInfo.wrPositionLocked and arg1 == "RightButton" ) then
			WeaponRebuff:ShowBuffSelectorMenu()
		end
	end)
	
	frame:SetScript("PostClick", function()
		if ( WeaponRebuffInfo.wrPositionLocked and arg1 == "LeftButton") then
			WeaponRebuff:Rebuff(id);
		end
	end)

	frame:SetAttribute("type", "item")    -- [ Act as a Button ] --
	frame:SetAttribute("type2", "")       -- [ do NOT act as a Button ] --	
	frame:SetAttribute("shift-type2", "") -- [ deaden shift-right-click ] --
	frame:SetAttribute("item", nil)
	frame:SetAttribute("spell", nil)
	frame:SetAttribute("unit", "player")
	frame:SetAttribute("target-slot1", nil)
	frame:SetAttribute("target-slot2", nil)
	
	frame:Show()
end

function WeaponRebuff_ShowCurrentBuffsTooltips()
local sdpt = WeaponRebuff.db.profile.tooltips
local showtooltip = false

	if sdpt.holdkey == "[none]" then
		showtooltip = true
	elseif sdpt.holdkey == "Shift" then
		if IsShiftKeyDown() then showtooltip = true	end
	elseif sdpt.holdkey == "Ctrl" then
		if IsControlKeyDown() then showtooltip = true end
	elseif sdpt.holdkey == "Alt" then
		if IsAltKeyDown() then showtooltip = true	end		
	end

	if showtooltip then
		wrRememberedBuffsTooltip:SetOwner(this, "ANCHOR_"..sdpt.rebuffpos)
		wrRememberedBuffsTooltip:ClearLines()
		wrRememberedBuffsTooltip:SetFrameStrata("TOOLTIP")
		wrRememberedBuffsTooltip:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
	                                     edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
	                                     tile = true, tileSize = 16, edgeSize = 16, 
	                                     insets = { left = 4, right = 4, top = 4, bottom = 4 }
	                                    }
		)
		wrRememberedBuffsTooltip:SetBackdropColor(0, 0, 0, 1)
		wrRememberedBuffsTooltip:SetBackdropBorderColor(1, .6, 0, 1)
		
		wrRememberedBuffsTooltipTextLeft1:SetFontObject("GameFontNormal")
		wrRememberedBuffsTooltip:AddLine("Remembered Buffs", 0,1,0);
	
		wrRememberedBuffsTooltipTextLeft2:SetFontObject("GameFontHighlightSmall")
		wrRememberedBuffsTooltip:AddLine(wrColor.gold..RememberBuff[16].BuffName.."\n"..wrColor.copper..RememberBuff[17].BuffName, 1,1,1	);
	
		wrRememberedBuffsTooltip:Show();
	end
end


--[[ UI Manipulation ----------------------------------------------------------- ]]
function WeaponRebuff:UpdateTextures()
	local sdp = self.db.profile
	
	if ( sdp.wrInvisibleAddon == 0 ) then
		-- [ Visible: Show if not in combat ] -- 
		if not self:inCombat() then
    	wrMainhandButton:Show();
      wrOffhandButton:Show();
    end
    
		-- [ Update texture if valid item...otherwise hide it ] -- 
		if self:SlotContainsSignalableItem(16) then
    	wrMainhandButton:SetNormalTexture(GetInventoryItemTexture("player", 16));
    else
    	if not self:inCombat() then
	   		wrMainhandButton:Hide();
    	end
    end

		-- [ Update texture if valid item...otherwise hide it ] -- 
    if ( sdp.wrDisableOffhandButton == 0 and self:SlotContainsSignalableItem(17) ) then
    	wrOffhandButton:SetNormalTexture(GetInventoryItemTexture("player", 17));
    else
			if not self:inCombat() then
    		wrOffhandButton:Hide();
    	end
    end
    
	else
		-- [ Invisible: Hide if not in combat ] -- 
		if not self:inCombat() then
			wrMainhandButton:Hide();
	  	wrOffhandButton:Hide();
	  end
  end
  
end


--[[ UI Controls --------------------------------------------------------------- ]]

function WeaponRebuff:ResizeButton()
	local sdp = WeaponRebuff.db.profile

--	if size == "" or size == 0 then size = 16; end;

  if not WeaponRebuff:inCombat() then
		if sdp.wrEnableSideBySide then
		  -- With SidebySide, put text under buttons to avoid potential problems
			
			-- [[ Resize MH/OH buttons ]] ---------------
			wrMainhandButton:SetWidth(sdp.wrButtonSize)
			wrMainhandButton:SetHeight(sdp.wrButtonSize)
			
			wrOffhandButton:SetWidth(sdp.wrButtonSize)
			wrOffhandButton:SetHeight(sdp.wrButtonSize)
			
			-- [[ Repos OH button ]] ------------------	  	
			wrOffhandButton:ClearAllPoints()
			wrOffhandButton:SetPoint("LEFT", wrMainhandButton, "RIGHT", 1, 0)
		
			-- [[ Position MH/OH text ]] ---------------
			self:PositionButtonText()


		else
			-- [[ Resize MH/OH buttons ]] ---------------
			wrMainhandButton:SetWidth(sdp.wrButtonSize)
			wrMainhandButton:SetHeight(sdp.wrButtonSize)
			 	
			wrOffhandButton:SetWidth(sdp.wrButtonSize)
			wrOffhandButton:SetHeight(sdp.wrButtonSize)
						
			-- [[ Repos OH button ]] ------------------			
			wrOffhandButton:ClearAllPoints()
			wrOffhandButton:SetPoint("TOPLEFT", wrMainhandButton, "BOTTOMLEFT", 0, -2);
			
			-- [[ Position MH/OH text ]] ---------------
			self:PositionButtonText()
						
		end
	else
		WeaponRebuffCombat.ResizeButton = true
	end
		
end

function WeaponRebuff:PositionButtonText()
	-- [[ Position MH/OH text ]] ---------------
	local vOffset, hOffset = 0, 0 
	local width, height = 0, 0
	local sdp = self.db.profile
	
	if sdp.wrEnableSideBySide then
		hOffset = sdp.wrButtonSize
	else
	  vOffset = sdp.wrButtonSize
	end
	
	-- [ Height / Width ] ------------
	-- width = wrMainhandButtonText:GetStringWidth()
	-- if wrOffhandButtonText:GetStringWidth() > width then
	-- 	width = wrOffhandButtonText:GetStringWidth()
	-- end
	-- width = width + 4 -- offsetting
	-- 
	-- height = wrMainhandButtonText:GetHeight()
	-- if wrOffhandButtonText:GetHeight() > height then
	-- 	height = wrOffhandButtonText:GetHeight()
	-- end
	-- ---------------------------------

	-- [[ Layout Spectra should backgrounds be implemented ----------------
	-- -- Text Right --
	-- MH Button | MH text
	-- OH Button | OH Text
	--	[] WeaponRebuffFrame:SetWidth(wrMainhandButton:GetWidth() + 14 + width)
	--	[] WeaponRebuffFrame:SetHeight(wrMainhandButton:GetWidth()*2 + 16)
	-- 
	-- -- Text Left
	-- MH text | MH Button
	-- OH text | OH Button
	-- 
	-- -- Text Top --
	-- MH Text
	-- OH Text
	-- MH Button | OH Button
	-- OH | Button
	-- 
	-- -- Text Bottom --
	-- MH Button | OH Button
	-- OH Button
	-- MH Text
	-- OH Text
  -- -------------------------------------------------------------- ]] --
	
	wrMainhandButtonText:ClearAllPoints()
	wrOffhandButtonText:ClearAllPoints()

 	wrMainhandButtonText:SetFont(sdp.wrFontFile, sdp.wrFontSize, "")
  wrOffhandButtonText:SetFont(sdp.wrFontFile, sdp.wrFontSize, "")
	
	if sdp.textPos == "RIGHT" then
		wrMainhandButtonText:SetPoint("LEFT", wrMainhandButton, "RIGHT", hOffset+2, 2)
	  wrOffhandButtonText:SetPoint("LEFT",  wrOffhandButton,  "RIGHT", 2, 2)
	end
	
	if sdp.textPos == "LEFT" then
		wrMainhandButtonText:SetPoint("RIGHT", wrMainhandButton, "LEFT", -2, 2)
	  wrOffhandButtonText:SetPoint("RIGHT",  wrOffhandButton,  "LEFT", -2, 2)
	end
	
	if sdp.textPos == "TOP" then
	  wrOffhandButtonText:SetPoint("BOTTOMLEFT",  wrMainhandButton,    "TOPLEFT", 0, 3)
		wrMainhandButtonText:SetPoint("BOTTOMLEFT", wrOffhandButtonText, "TOPLEFT", 0, 3)
	end
	
	if sdp.textPos == "BOTTOM" then
		wrMainhandButtonText:SetPoint("TOPLEFT", wrMainhandButton,     "BOTTOMLEFT", 0, -3 - vOffset)
		wrOffhandButtonText:SetPoint("TOPLEFT",  wrMainhandButtonText, "BOTTOMLEFT", 0, -3)
	end

end


function WeaponRebuff:ResetSizeAndPosition()
	local sdp = self.db.profile
	sdp.wrButtonSize = 16
--	sdp.wrFontSize = 

	self:ResizeButton()
	WeaponRebuffFrame:ClearAllPoints()
	WeaponRebuffFrame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 1, -245)
	self:SavePosition()
end

--[[ Save/Restore Frame Positions ---------------------------------------------- ]]
function WeaponRebuff:SavePosition()
	local frame
	local sdpp = self.db.profile.pos
		
	frame = getglobal("WeaponRebuffFrame")

	_, _, sdpp.rebuffwindow.rel, sdpp.rebuffwindow.px, sdpp.rebuffwindow.py = frame:GetPoint()


--	sdpp.rebuffwindow.px = frame:GetLeft() * scale
--	sdpp.rebuffwindow.py = frame:GetTop()  * scale

--	frame = getglobal("WeaponRebuffMenu")	
--	sdpp.buffselector.px = frame:GetLeft() * scale
--	sdpp.buffselector.py = frame:GetTop()  * scale
end

function WeaponRebuff:RestorePosition()
	local frame, menuframe
	local sdpp = self.db.profile.pos

	frame     = getglobal("WeaponRebuffFrame")
--	menuframe = getglobal("WeaponRebuffMenu")	

	frame:ClearAllPoints()

	frame:SetPoint("TOPLEFT", UIParent, sdpp.rebuffwindow.rel, sdpp.rebuffwindow.px, sdpp.rebuffwindow.py)
	
-- frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", sdpp.rebuffwindow.px / scale, sdpp.rebuffwindow.py / scale)

--	menuframe:ClearAllPoints()
--	menuframe:SetPoint("TOPLEFT", frame, "TOPLEFT", sdpp.buffselector.px / scale, sdpp.buffselector.py / scale)

end

--[[ End RebuffWindow ---------------------------------------------------------- ]]

