-- [[ FuBar Setup / Maintenance ]] --
local T = AceLibrary("AceLocale-2.2"):new("WeaponRebuff");
local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0")

function WeaponRebuff:Fubar_Setup()

	self.hasIcon = "Interface\\AddOns\\WeaponRebuff\\icon.tga"
	self.hasNoText = false
	self.defaultPosition = 'CENTER'
	self.clickableTooltip = true -- nothing clickable on it but it always annoys me when it disappers so easily
	self.cannotDetachTooltip = true
	self.blizzardTooltip = false
	self.hideWithoutStandby = true

	self:SetIcon(true) -- default of icon.tga
	
  -- [ FuBar Data Table ] -------------------------	
	wrFubar = {
		["MainHand_ItemType"] = "",
		["Caption"]           = "",
		["Tooltip_Main"]      = "",
		["TimeLeftMain"]      = wrColor.red.."-",
		["Tooltip_Off"]       = "",
		["TimeLeftOff"]       = wrColor.red.."-",
		["DisableOffhand"]    = 0
	}
  -------------------------------------------------
		
end

-- [[ Tooltip ]] --------------------------------------------------------
-- [[ :UpdateData()  :UpdateText()  :UpdateTooltip() ]] -----------------

function WeaponRebuff:UpdateData()
	-- No innards to update
end

function WeaponRebuff:UpdateText()
	-- Update PlugIn Text
	if wrColor and wrFubar then -- works around different timing problems at startup
		if wrFubar.Caption == nil then -- waiting for WeaponRebuff (Redux) to update
			self:SetText("WR "..wrColor.lte_blue.."(loading)")
		else
			self:SetText("WR "..wrFubar.Caption)
		end
	end
end

function WeaponRebuff:OnTooltipUpdate()
	local cat = tablet:AddCategory('columns', 2)
	local sdp = self.db.profile
	
	cat:AddLine('text', "")

	cat:AddLine(
		'text' , wrFubar.MainHand_ItemType,
		'text2', wrFubar.Tooltip_Main
	)

	if sdp.wrDisableOffhandButton == 0 then
		cat:AddLine(
			'text' , T["FWR_TOOLTIP_PREFIX_OFFHAND"],
			'text2', wrFubar.Tooltip_Off
		)
	end

	tablet:SetHint("\n"..wrColor.orange.."Click:|r "..T[sdp.fubar_click].."\n"..wrColor.copper.."Shift-Click:|r "..T[sdp.fubar_shiftclick].."\n"..wrColor.gold.."Ctrl-Click:|r "..T[sdp.fubar_ctrlclick])
end
	
function WeaponRebuff:OnClick()
	local sdp = self.db.profile
	
	if IsControlKeyDown() then
  	self:handleClick(sdp.fubar_ctrlclick)
  elseif IsShiftKeyDown() then
  	self:handleClick(sdp.fubar_shiftclick)
  else
  	self:handleClick(sdp.fubar_click)
	end

end

function WeaponRebuff:handleClick(op)
	local sdp = self.db.profile
	
	if op == "OPEN_Configuration" then
		if waterfall then
			waterfall:Open("WeaponRebuff")
		else
			WeaponRebuff:Print("Waterfall-1.0 is required to access the GUI.")
		end		
		return
	elseif op == "TOGGLE_2BuffMode" then
			sdp.wr2BuffMode = not sdp.wr2BuffMode
			if sdp.wr2BuffMode then
				WeaponRebuff.ChatPrint("Two-Buff Mode Toggled ", "On" )
			else
				WeaponRebuff.ChatPrint("Two-Buff Mode Toggled ", "Off" )
			end
	
		return
	elseif op == "TOGGLE_BuffSelector" then
		WeaponRebuff:ShowBuffSelectorMenu()		
		return
	elseif op == "TOGGLE_FishingMode" then
		self:Toggle_FishingMode(false)
	elseif op == "TOGGLE_ShowInCombat" then
		if sdp.wrOpenOnCombat == 1 then
			sdp.wrOpenOnCombat = 0
			WeaponRebuff.ChatPrint("Auto-Show Buff Selector in Combat Toggled ", "Off")
		else
			sdp.wrOpenOnCombat = 1						
			WeaponRebuff.ChatPrint("Auto-Show Buff Selector in Combat Toggled ", "On")
		end
		return
	elseif op == "TOGGLE_ShowWeaponRebuff" then
		if sdp.wrInvisibleAddon == 1 then
			sdp.wrInvisibleAddon = 0
			WeaponRebuff.ChatPrint("Hide WeaponRebuff Toggled", "Off")
		else
			sdp.wrInvisibleAddon = 1
			WeaponRebuff.ChatPrint("Hide WeaponRebuff Toggled", "On")
		end
		WeaponRebuff:UpdateTextures();		
		return
	else
		WeaponRebuff.ChatPrint("Unknown Click Signal", op)
	end

end

function WeaponRebuff:Toggle_FishingMode(isStartup)
	local sdp = self.db.profile
	
	if isStartup then
		sdp.wrFishingMode = false -- force off
	else
		sdp.wrFishingMode = not sdp.wrFishingMode -- Toggle	

		if sdp.wrFishingMode then
			-- [ Set Fishing Remembered Buff ] --
			RememberBuff[16].BuffName = sdp.RememberBuffFishingName
			RememberBuff[16].BuffType	= sdp.RememberBuffFishingType

			-- [ Slash User ] --
			WeaponRebuff.ChatPrint("Fishing Mode", "Enabled" )			
		else
			-- [ Set Weapon Remembered Buff ] --
			RememberBuff[16].BuffName = sdp.RememberBuffMainhandName
			RememberBuff[16].BuffType = sdp.RememberBuffMainhandType
			
			-- [ Slash User ] --
			WeaponRebuff.ChatPrint("Fishing Mode", "Disabled" )			
		end
					
	end
	
end

--[[ Plugin Helper Functions -------------------------------------------------------------- ]]
function WeaponRebuff:SetPluginData_fmSlot(slot, TimeRemaining, wrSuffix, wrColor, text)
	-- 	"|caaaaddff".."|r"

		local sdp = self.db.profile
		
		-- [ Tooltip Proper ] --
		if ( slot == 16 ) then	
			wrFubar.TimeLeftMain = wrColor..TimeRemaining..wrSuffix.."|r"
			wrFubar.Tooltip_Main = wrColor..text.."|r"
		elseif ( slot == 17 ) then
			wrFubar.TimeLeftOff = wrColor..TimeRemaining..wrSuffix.."|r"
			wrFubar.Tooltip_Off = wrColor..text.."|r"
		end

		-- [ Caption ] --
		if sdp.wrFishingMode then
			wrFubar.DisableOffhand = 1
			wrFubar.Caption = "F"..wrFubar.TimeLeftMain
			wrFubar.MainHand_ItemType = T["FWR_TOOLTIP_PREFIX_MAINHAND_FISHING"]
		else
			wrFubar.MainHand_ItemType = T["FWR_TOOLTIP_PREFIX_MAINHAND"]
			if self.db.profile.wrDisableOffhandButton == 1 or not self:SlotContainsSignalableItem(17) then
				wrFubar.DisableOffhand = 1
				wrFubar.Caption = "m"..wrFubar.TimeLeftMain
			else 
				wrFubar.DisableOffhand = 0
				wrFubar.Caption =  "m"..wrFubar.TimeLeftMain.." / ".."o"..wrFubar.TimeLeftOff
			end	
		end
	

end