--[[ Core Functions -------------------------------------------------------------- ]]
local T      = AceLibrary("AceLocale-2.2"):new("WeaponRebuff")
local SMedia = AceLibrary("SharedMedia-1.0")

function WeaponRebuff:ItemBuff_UpdateText(slot)
  -- Updates button text and signals alarms --
	local sdp = self.db.profile
	
	if self:SlotContainsSignalableItem(slot) then -- if nothing in the slot, just move along, nothing to see here...  
  
		local wrTimeRemaining = 0;	
		local index, field;
		local text, msgText, textToUpdate, slotAlarmState = "";
		local bName, bTime = ""; 
			
		local slotAlarmState = getglobal("WeaponRebuff_AlarmState"..slot);
	
		if ( slot == 16 ) then
			textToUpdate = "wrMainhandButtonText";
			msgText = T["WEAPONREBUFF_TRAILINGTEXT_MAINHAND"]
			slotAlarmState = wr.alarm.AlarmState16
		elseif ( slot == 17 ) then
			textToUpdate = "wrOffhandButtonText";
			msgText = T["WEAPONREBUFF_TRAILINGTEXT_OFFHAND"]
			slotAlarmState = wr.alarm.AlarmState17
		else
			return
		end
		
		local fontString = getglobal(textToUpdate);	
			
	  wrItemTempTooltip:SetInventoryItem("player", slot);
	
		for index = 16, 6, -1 do -- we find buffs faster on higher-end weapons this way
			field = getglobal("wrItemTempTooltipTextLeft"..index);
		
			if( field ) then
				text = field:GetText();			
				if( text ) then	
					if( string.find(text, "%(%d+ "..T["WR_MINUTE"].."%)") ) then	
					  -- Bifurcate the incoming data b/c we don't know 
						bName, bTime = self:GetNameandTime(text);					
	
						-- only set this forward if we have a good buff
						if slotAlarmState ~= "TickingDown" then
							self:SetAlarmState_fmSlot("TickingDown", slot)
						end
						
						-- grab the number if it's there... --------------------------------------------
						wrTimeRemaining = self:GetFirstNumber(bTime)
						self:SetPluginData_fmSlot(slot, wrTimeRemaining, "m", wrColor.powderblue, text);
						-- -----------------------------------------------------------------------------
												
						if sdp.wrEnableShowText == 1 then	
							fontString:SetTextColor(0.5, 0.5, 0.9);
							
							if sdp.TruncateBuffText then
								fontString:SetText(bName.." ("..bTime);
							else
								fontString:SetText(text); 
							end
						else
							fontString:SetText("");
						end
									
						return;
					elseif( string.find(text, "%(%d+ "..T["WR_SECOND"].."%)") ) then			
					  -- Bifrucate the incoming data b/c we don't know 
						bName, bTime = self:GetNameandTime(text)
	
						-- grab the number if it's there... --------------------------------------------
						wrTimeRemaining = self:GetFirstNumber(bTime)
						if self:BuffSuppressed() then
							self:SetPluginData_fmSlot(slot, wrTimeRemaining, "s", wrColor.green, text);
						else
							self:SetPluginData_fmSlot(slot, wrTimeRemaining, "s", wrColor.yellow, text);						
						end
						-- -----------------------------------------------------------------------------
	
						-- Store Current buff for Windfury despazification
						wr["LastBuff"] = bName
	
						-- Alarms
						if slotAlarmState ~= "WarningSounded" and not self:BuffSuppressed() then
						
							if tonumber(wrTimeRemaining) < tonumber(sdp.wrWarnThreshold_inSeconds) then
								if sdp.wrSoundAlarms_warning == 1 then
									local sound = SMedia:Fetch("sound", sdp.wrSoundIndex_BuffWarning)
									if sound then
										PlaySoundFile(sound)										
									end							
								end
								
								if sdp.wrTextAlarms_warning == 1 then
									self:AnnounceMsg(bName..T["WEAPONREBUFF_MSG_BUFFABOUTTOEXPIRE"]..msgText, 1, 1, 0);
								end
								
								self:SetAlarmState_fmSlot("WarningSounded", slot);
							
							end	
							
						end
					
						if sdp.wrEnableShowText == 1 then
						  if self:BuffSuppressed() then -- give green "suppressed" text color
								fontString:SetTextColor(0, 1, 0);
						  else
								fontString:SetTextColor(1, 1, 0);
							end
							
							if sdp.TruncateBuffText then
								fontString:SetText(bName.." ("..bTime);
							else
								fontString:SetText(text); 
							end

						else
							fontString:SetText("");
						end
	
						return
					end
				end	
			end
		end
		
		-- If we're still here, we've no buffs		
		self:SetPluginData_fmSlot(slot, "-", "", wrColor.red, "<<"..RememberBuff[slot].BuffName..">>")
	
		if slotAlarmState ~= "Sleeping" then
			if slotAlarmState == "TickingDown" or ( slotAlarmState == "WarningSounded" and tonumber(wrTimeRemaining) >= 5) then
				-- Automatic Suppress, assumed wep swap --
			else
				-- Alarms
				if sdp.wrSoundAlarms_lost == 1 and not self:BuffSuppressed() then
				
					local sound = SMedia:Fetch("sound", sdp.wrSoundIndex_BuffLost)
					if sound then
						PlaySoundFile(sound)					
					end			
	
				end
				
				if sdp.wrTextAlarms_lost == 1 then						
					self:AnnounceMsg("***"..T["WEAPONREBUFF_MSG_BUFFEXPIRED"]..msgText.."***", 1, 0, 0)
				end
			end
			
			self:SetAlarmState_fmSlot("Sleeping", slot)
		end	
	
		if sdp.wrEnableShowText == 1 then
			fontString:SetTextColor(1, 0, 0)
			if RememberBuff[slot].BuffName then		
				fontString:SetText("<<"..RememberBuff[slot].BuffName..">>")
			else
				fontString:SetText("")
			end
		else
			fontString:SetText("");
		end
	else
		-- [ Clear any warnings for the slot since it's no longer valid ] -- 
		self:SetAlarmState_fmSlot("Sleeping", slot)

		-- [ And update buff text ] --
		if sdp.wrEnableShowText == 1 then

			if ( slot == 16 ) then
				textToUpdate = "wrMainhandButtonText"	
			elseif ( slot == 17 ) then
				textToUpdate = "wrOffhandButtonText"
			end

			local fontString = getglobal(textToUpdate)
			fontString:SetTextColor(1, .34, 0)
			fontString:SetText("[Item Unequipped]")
			
		end
	end -- if self:SlotContainsSignalableItem(slot)
		
end

function WeaponRebuff:BuffSuppressed()
	-- [ Process Suppressed (green) Buffs ] --
	local sdp = self.db.profile
	
	for _, sBuff in pairs(sdp.suppBuffs) do
		if string.find(wr["LastBuff"], sBuff) then
		 return true 
		end
	end

	return false

end

function WeaponRebuff:Rebuff(slot)
  if ( RememberBuff[slot].BuffName and RememberBuff[slot].BuffName ~= "-none-" ) then

  	local rec = WeaponRebuffInfo.BuffTable[ RememberBuff[slot].BuffName ]  	
  	if rec then
			self:CheckThreshold(rec.name, rec.quantity)
		end

		-- self:Apply(RememberBuff[slot].BuffName,RememberBuff[slot].BuffType,slot);
	else
	
	WeaponRebuff.ChatPrint("dun rem nuttin")
	
		UIErrorsFrame:AddMessage(ERROR_NO_BUFFS_REMEMBERED, 0.66, 0.66, 0.86, 1.0, UIERRORS_HOLD_TIME);
	end
end

function WeaponRebuff:CheckThreshold(name, quantity)
	local sdp = self.db.profile
	if quantity < sdp.wrWarnThreshold_BuffItems then
		local hasOnly 
		if quantity == 0 then hasOnly = " has " else hasOnly = " has only " end
		self:AnnounceMsg(name..hasOnly..quantity.." items remaining", 1, 0, 0)
	end
end

function WeaponRebuff:GetBagInfo(item)
	if ( item == nil or item == "") then
		return -1,-1,-1;
	end
	local itemBag = 0;
  local itemSlot = 0;
  local itemCount = 0;

    for checkbag=4, 0, -1 do
		local size = GetContainerNumSlots(checkbag);
		if (size > 0) then
			for checkslot=1, size, 1 do			
			
				local _, count = GetContainerItemInfo(checkbag, checkslot);
				if (count) then
					local itemName = nil;
					local bagitemname = WeaponRebuff:GetItemName(checkbag, checkslot);
					if (bagitemname ~= nil) then
					if ( bagitemname == item ) then
							itemCount = itemCount + count;
							itemBag = checkbag;
							itemSlot = checkslot;
						end
					end
				end
			end
		end
	end
	return itemBag, itemSlot, itemCount;
end

function WeaponRebuff:GetSpellId(spellName)
	if ( spellName == nil or spellName == "") then
		return;
	end
	local i = 1;
	local spellId = 0;
	local searchName, rankname, spellTexture;
	searchName,rankName = GetSpellName(i,"spell");
	while (searchName) do
		if ( searchName == spellName ) then
			spellId = i;
			spellTexture = GetSpellTexture(i,"spell");
		end
		i = i + 1;
		searchName,rankName = GetSpellName(i,"spell");
	end
	return spellId, spellTexture;
end


--[[ Core Extended  -------------------------------------------------------------- ]]
function WeaponRebuff:GetNameandTime(text)
	local bNmSplit, bName, bTime = 0;
	bNmSplit = string.find(text, " (", 1, 1);

	bName = string.sub(text, 1, bNmSplit-1)	
	if bName == "Sharpened" or bName == "Weighted" then
		bNmSplit = string.find(text, " (", bNmSplit+1, 1)
		bTime = string.sub(text, bNmSplit+2, -1)
	else
		bTime = string.sub(text, bNmSplit+2, -1)
	end

	return bName, bTime
end

function WeaponRebuff:GetFirstNumber(text)
	local w = 0;
	for w in string.gmatch(text, "%d+") do
		return tonumber(w)
	end
	return w
end			

--[[ End Core Functions -------------------------------------------------------------- ]]

