--[[ Configuration & Options Window ------------------------------------------------------ ]]
local T = AceLibrary("AceLocale-2.2"):new("WeaponRebuff")
local waterfall = AceLibrary:HasInstance("Waterfall-1.0") and AceLibrary("Waterfall-1.0")
local SMedia    = AceLibrary("SharedMedia-1.0")
local SMedia_Sounds = SMedia:List("sound")
local SMedia_Fonts  = SMedia:List("font")

--(SML:Fetch("font", layout.textTLfont)

-- [[ SharedMediaLib Goodies ]] --
function WeaponRebuff:LoadMedia()
-- [[ Register WeaponRebuff Sound Options with SharedMedia ]] -----------------------------------------
	SMedia:Register("sound", "BellTollHorde"				, [[Sound\Doodad\BellTollHorde.wav]]									)
	SMedia:Register("sound", "BellTollAlliance"			, [[Sound\Doodad\BellTollAlliance.wav]]								)
	SMedia:Register("sound", "BellTollNightElf"			, [[Sound\Doodad\BellTollNightElf.wav]]								)
	SMedia:Register("sound", "AntiHoly"							, [[Sound\Spells\AntiHoly.wav]]												)
	SMedia:Register("sound", "iTellMessage"					, [[Sound\interface\iTellMessage.wav]]								)
	SMedia:Register("sound", "AuctionWindowOpen"		, [[Sound\interface\AuctionWindowOpen.wav]]						)
	SMedia:Register("sound", "FriendJoin"						, [[Sound\interface\FriendJoin.wav]]									)
	SMedia:Register("sound", "Murloc Aggro Old"			, [[Sound\Creature\Murloc\mMurlocAggroOld.wav]]			  )
	SMedia:Register("sound", "Cherink"              , [[Interface\AddOns\WeaponRebuff\sounds\cherink.wav]])
	SMedia:Register("sound", "DMF"   								, [[Sound\Music\ZoneMusic\DMF_L70ETC01.mp3]]   				)
	SMedia:Register("sound", "WR Custom Losing Buff", [[Interface\AddOns\WeaponRebuff\sounds\warning.wav]])
	SMedia:Register("sound", "WR Custom LostBuff"   , [[Interface\AddOns\WeaponRebuff\sounds\lost.wav]]   )
	
end 

-- [[ 3.0 Options ]] -------------
function WeaponRebuff:LoadOptions()
	local sdp = WeaponRebuff.db.profile
	local options = {
		type='group',
		order=1,
		args = {
		  -- [[ S P A C E R S ]] --
		  hdr1 = {
				type = "header",
				name = " ",
				cmdHidden = true,
				order=1
			},	
			hdr2 = {
				type = "header",
				name = "WeaponRebuff Options",
				cmdHidden = true,
				order=2
			},
			hdr3 = {
				type = "header",
				name = " ",
				cmdHidden = true,
				order=3
			},	
		  -- [[ / S P A C E R S ]] --	
		  
		  -- [[ Root Options ]] --
			lock = {
				type = "toggle",
				name = "Lock",
				desc = "Lock the WeaponRebuff window position",
				get = function()
					return WeaponRebuffInfo.wrPositionLocked
				end,
				set = function(v)
					WeaponRebuffInfo.wrPositionLocked = v
				end,
				order=4
			},	
			debug = {
				type = "execute",
				name = "debug",
				desc = "dump data states",
				hidden = true,
				func = function()
					WeaponRebuff:ShowDebugInfo()
				end,
				order=5
			},			
		  config =  {
		  	type = "execute",
		  	name = "Config Dialog",
		  	desc = "GUI Config Dialog",
		  	func = function()
		  		if waterfall then
						waterfall:Open("WeaponRebuff")
					else
						WeaponRebuff:Print("Waterfall-1.0 is required to access the GUI.")
					end
		  	end,
		  	order=6
		  },
		  openselector = {
		  	type = "execute",
		  	name = "Show Buff Selector",
		  	desc = "Show Buff Selector",
		  	func = function()
		  	  WeaponRebuff:ShowBuffSelectorMenu()
		  	end,
		  	order=7
		  },
		  	 
		  -- [[ FuBar/MiniMap Action ]] --
			fubarbehavior = {
				type = "group",
				name = "FuBar/MiniMap",
				desc = "Options for behavior of MiniMap / FuBar Icon",
				order= 11,
				args = {
				  click = {
 						type = "text",
						name = "Click Behavior",
						desc = "Select 'Click' behavior",
						get = function()
							return self.db.profile.fubar_click
						end,
						set = function(v)
							self.db.profile.fubar_click = v
						end,
						validate = wrButtonOptions,
						order = 1
				  },
				  shiftclick = {
 						type = "text",
						name = "Shift-Click Behavior",
						desc = "Select 'Shift-Click' behavior",
						get = function()
							return self.db.profile.fubar_shiftclick
						end,
						set = function(v)
							self.db.profile.fubar_shiftclick = v
						end,
						validate = wrButtonOptions,
						order = 2
				  },
				  ctrlclick = {
 						type = "text",
						name = "Ctrl-Click Behavior",
						desc = "Select 'Ctrl-Click' behavior",
						get = function()
							return self.db.profile.fubar_ctrlclick
						end,
						set = function(v)
							self.db.profile.fubar_ctrlclick = v
						end,
						validate = wrButtonOptions,
						order = 3
				  }
				}
			},

  	 		  	 	  
			-- [[ Display Configuration]] -- 
			display = {
				type = "group",
				name = "Display",
				desc = "Display Options",
				order= 11,
				args = {				
					rebuffwindow = {
						type = "group",
						name = "Rebuff Window",
						desc = "Rebuff Window Options",
						order= 1,
						args = {									
						  hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=1
							},	
						  resetpos = {
						  	type = "execute",
						  	name = "Reset Window Position",
						  	desc = "Reset Window Size and Position to default (center, left) ",
						  	order=2,
						  	func = function()
						  		WeaponRebuff:ResetSizeAndPosition()
						  	end
						  },
						  hdr2 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=3
							},	
							hideframe = {
								type = "toggle",
								name = "Hide WeaponRebuff",
								desc = "Hide WeaponRebuff Window",
								get = function()
									if WeaponRebuff.db.profile.wrInvisibleAddon == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)	
									if v then
										WeaponRebuff.db.profile.wrInvisibleAddon = 1;
									else
										WeaponRebuff.db.profile.wrInvisibleAddon = 0;						
									end
									WeaponRebuff:UpdateTextures();
								end,
								order = 4
							},
						  hdr3 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=5
							},	
							framestrata = {
								type = "text",
								name = "Set Frame Strata",
								desc = "Set Frame Strata so that it is above/below other interface elements",
								get = function()
									return WeaponRebuff.db.profile.wrFrameStrata
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrFrameStrata = v
									WeaponRebuffFrame:SetFrameStrata(v)
								end,
								validate = { 'BACKGROUND', 'LOW', 'MEDIUM', 'HIGH', 'DIALOG', 'TOOLTIP' },
								order = 7
							}
						}
					},
					buttons = {
						type = "group",
						name = "Button Options",
						desc = "Rebuff Button Options",
						order= 2,
						args = {									
						  hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=1
							},	
						  hdr2 = {
								type = "header",
								name = "Button Options",
								cmdHidden = true,
								order=2
							},	
							horizontalicons = {
								type = "toggle",
								name = "Horizontal Icons",
								desc = "Display Icons horizontally instead of vertically",
								get = function()
									return WeaponRebuff.db.profile.wrEnableSideBySide
								end,
								set = function(v)	
									local sdp = self.db.profile
									sdp.wrEnableSideBySide = v
									if v and ( sdp.textPos == "RIGHT" or sdp.textPos == "LEFT" ) then
										sdp.textPos = "BOTTOM"
									end
									WeaponRebuff:ResizeButton(WeaponRebuff.db.profile.wrButtonSize)
								end,
								order = 3
							},					
							disableoffhand = {
								type = "toggle",
								name = "Disable Offhand Button",
								desc = "Disable Offhand Button",
								get = function()
									if WeaponRebuff.db.profile.wrDisableOffhandButton == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)	
									if v then
										WeaponRebuff.db.profile.wrDisableOffhandButton = 1;
									else
										WeaponRebuff.db.profile.wrDisableOffhandButton = 0;						
									end
									WeaponRebuff:UpdateTextures()
								end,
								order = 4
							},
							buttonsize = {
								type = "range",
								name = "Button Size",
								desc = "Main Window Button Size",
								step = 1,
								min = 1,
								max = 100,
								isPercent = false,
								get = function()
									return self.db.profile.wrButtonSize
								end,
								set = function(v)
									self.db.profile.wrButtonSize = v
									WeaponRebuff:ResizeButton()
								end,
								order = 5
							},
						  hdr3 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=6
							},	
						  hdr4 = {
								type = "header",
								name = "Text Options",
								cmdHidden = true,
								order=7
							},	
							showbufftext = {
								type = "toggle",
								name = "Show active buff information",
								desc = "Show information about the active buff",
								get = function()
									if sdp.wrEnableShowText == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)	
									if v then
										sdp.wrEnableShowText = 1;
									else
										sdp.wrEnableShowText = 0;						
									end
								end,
								order = 8
							},
							truncatetext = {
								type = "toggle",
								name = "Truncate Buff Text",
								desc = "Truncates the (paraenthetical descriptors) some weapon buffs have",
								get = function()
									return sdp.TruncateBuffText 
								end,
								set = function(v)	
									sdp.TruncateBuffText = v
								end,
								order = 8
							},							
							textpos = {
								type = "text",
								name = "Set Text Position",
								desc = "Set Text Position",
								get = function()
									return WeaponRebuff.db.profile.textPos
								end,
								set = function(v)
									WeaponRebuff.db.profile.textPos = v
									self:ResizeButton(sdp.wrButtonSize)
								end,
								validate = { 'TOP', 'BOTTOM', 'LEFT', 'RIGHT' },
								order = 9			
							},					
							setfont = {
								type = "text",
								name = "Buff Info Font",
								desc = "Buff Info Font",
								get = function()
									return self.db.profile.wrFont
								end,
								set = function(v)
									local sdp = self.db.profile
									sdp.wrFont = v
									sdp.wrFontFile = SMedia:Fetch("font", v)
									self:PositionButtonText()
								end,
								validate = SMedia_Fonts,
								order=10				
							},
							fontsize = {
								type = "range",
								name = "Font Size",
								desc = "Main Window Font Size",
								step = 1,
								min = 1,
								max = 38,
								isPercent = false,
								get = function()
									return self.db.profile.wrFontSize
								end,
								set = function(v)
									self.db.profile.wrFontSize = v
									WeaponRebuff:ResizeButton()
								end,
								order = 11
							},
						}
					},					
					tooltips = {
						type = "group",
						name = "Tooltip Options",
						desc = "Tooltip Options",
						order= 3,
						args = {									
						  hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=1
							},
						  hdr2 = {
								type = "header",
								name = "Rebuff Button Tooltips",
								cmdHidden = true,
								order=2
							},
							keymodifier = {
								type = "text",
								name = "Modifier (hold key then mouse over buttons)",
								desc = "Modifier to display Rebuff Button Tooltips",
								get = function()
									return WeaponRebuff.db.profile.tooltips.holdkey
								end,
								set = function(v)
									WeaponRebuff.db.profile.tooltips.holdkey = v

								end,
								validate = {"[none]", "Shift", "Ctrl", "Alt"},
								order = 3			
							},					
							rebuffbuttons = {
								type = "text",
								name = "Rebuff Button Tooltip Position",
								desc = "Rebuff Button Tooltip Position",
								get = function()
									return WeaponRebuff.db.profile.tooltips.rebuffpos
								end,
								set = function(v)
									WeaponRebuff.db.profile.tooltips.rebuffpos = v

								end,
								validate = {"TOPRIGHT", "RIGHT", "BOTTOMRIGHT", "TOPLEFT", "LEFT", "BOTTOMLEFT", "CURSOR"},
								order = 4			
							},					
						  hdr3 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=5
							},
						  hdr4 = {
								type = "header",
								name = "Buff Selector Tooltips",
								cmdHidden = true,
								order=6
							},
							buffselector = {
								type = "text",
								name = "Buff Selector Tooltip Position",
								desc = "Buff Selector Tooltip Position",
								get = function()
									return WeaponRebuff.db.profile.tooltips.buffselector
								end,
								set = function(v)
									WeaponRebuff.db.profile.tooltips.buffselector = v
								end,
								validate = {"TOPRIGHT", "RIGHT", "BOTTOMRIGHT", "TOPLEFT", "LEFT", "BOTTOMLEFT", "CURSOR"},
								order = 7	
							},					
						}				
					}				
				}
			},	
			-- [[ Alerts Configuration]] -- 
			alerts = {
				type = "group",
				name = "Alerts and Warnings",
				desc = "Alerts and Warnings",
				order= 12,
				args = {
					buffitems = {
						type = "group",
						name = "Buffing Items Warning Options",
						desc = "Buffing Items Warning Options",
						order= 1, 
						args = {
							usewarnings = {
								type = "toggle",
								name = "Use Buff-Items Warnings",
								desc = "Use Buff-Items Warnings",
								get = function()
									if WeaponRebuff.db.profile.wrBuffItemsAlarms == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)
									if v then
										WeaponRebuff.db.profile.wrBuffItemsAlarms = 1
									else
										WeaponRebuff.db.profile.wrBuffItemsAlarms = 0
									end
								end,
								order=1
							},
							warncount = {				
								type = "range",
								name = "Buff Item Count Warning Threshold",
								desc = "Warns when the number of buffing items (e.g., poisons, stones, lures) is below the set threshold",
								step = 1,
								min = 1,
								max = 100,
								isPercent = false,
								get = function()
									return WeaponRebuff.db.profile.wrWarnThreshold_BuffItems
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrWarnThreshold_BuffItems = v
								end,
								order = 2
							}
						}
					},
					suppressedbuffs = {
						type = "group",
						name = "Alert Suppression",
						desc = "Alert Suppression Options",
						order= 2, 
						args = {					
						  -- [[ S P A C E R S ]] --
						  supp_hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=4
							},	
							supp_hdr2 = {
								type = "header",
								name = "Manage Alarm Suppressions",
								cmdHidden = true,
								order=5
							},
						  -- [[ / S P A C E R S ]] --	
		  
							suppression_add = {
								type = "text",
								name = "Add Buff",
								desc = "Adds a Buff to the suppression list",
								usage = "",
								get = function() return end,
								set = function(v)
									local isUnique = self:IsUniqueItemName_inSuppList(v)
									if isUnique then
										tinsert(sdp.suppBuffs, tostring(v)) 
									else
										WeaponRebuff.ChatPrint(v.." is duplicated in suppression list. "..wrColor.gold.."Adding Skipped")
									end
								end,
								order = 8
							},
							suppression_remove = {
								type = "text",
								name = "Remove buff",
								desc = "Remove buff from the suppression list",
								current = "",							
								get = function() return  end,
								set = function(v)
									local sdp = WeaponRebuff.db.profile
									for i,v2 in ipairs(sdp.suppBuffs) do 
										if v == v2 then 
											tremove(sdp.suppBuffs, i) 
										end 
									end 
								end,
								-- validate = { } , 
								validate = sdp.suppBuffs,
								order = 9
							},							
							suppression_default = {
								type = "execute",
								name = "Restore Defaults",
								desc = "Restores the default suppression list",
								func = function()
									local sdp = WeaponRebuff.db.profile
									for i,v in ipairs(sdp.suppBuffs) do
        						sdp.suppBuffs[i] = nil
    							end
    
    							for k,v in pairs(T.suppressedbuffs) do
        						table.insert(sdp.suppBuffs, v)
    							end
								end,
								order = 10
							},
						},					
					},
				 	fadingbuffs = {
						type = "group",
						name = "Buff-Fading Alert Options",
						desc = "Buff-Fading Alert Options",
						order= 3,
						args = {
							textalert = {
								type = "toggle",
								name = "Use Text Alert",
								desc = "Use Text Alert",
								get = function()
									if WeaponRebuff.db.profile.wrTextAlarms_warning == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)
									if v then
										WeaponRebuff.db.profile.wrTextAlarms_warning = 1
									else
										WeaponRebuff.db.profile.wrTextAlarms_warning = 0
									end
								end,
								order=1
							},
							soundalert = {
								type = "toggle",
								name = "Use Sound Alert",
								desc = "Use Sound Alert",
								get = function()
									if WeaponRebuff.db.profile.wrSoundAlarms_warning == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)
									if v then
										WeaponRebuff.db.profile.wrSoundAlarms_warning = 1
									else
										WeaponRebuff.db.profile.wrSoundAlarms_warning = 0
									end
								end,
								order=2
							},
							warnseconds = {
								type = "range",
								name = "Weapon Buff Loss-Warning Threshold",
								desc = "Weapon Buff Loss-Warning Threshold (in seconds)",
								step = 1,
								min = 1,
								max = 60,
								isPercent = false,
								get = function()
									return WeaponRebuff.db.profile.wrWarnThreshold_inSeconds
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrWarnThreshold_inSeconds = v
								end,
								order=3
							},
							setsound = {
								type = "text",
								name = "Buff-Warning Sound",
								desc = "Buff-Warning Sound",
								get = function()
									return WeaponRebuff.db.profile.wrSoundIndex_BuffWarning
								end,
								set = function(v)
									PlaySoundFile(SMedia:Fetch("sound", v))
									WeaponRebuff.db.profile.wrSoundIndex_BuffWarning = v													
								end,
								validate = SMedia_Sounds,
								order=4					
							}
						}					
					},
					lostbuffs = {
						type = "group",
						name = "Buff-Lost Alert Options",
						desc = "Buff-Lost Alert Options",
						order= 4,
						args = {
							textalert = {
								type = "toggle",
								name = "Use Text Alert",
								desc = "Use Text Alert",
								get = function()
									if WeaponRebuff.db.profile.wrTextAlarms_lost == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)
									if v then
										WeaponRebuff.db.profile.wrTextAlarms_lost = 1
									else
										WeaponRebuff.db.profile.wrTextAlarms_lost = 0
									end
								end,
								order=1
							},
							soundalert = {
								type = "toggle",
								name = "Use Sound Alert",
								desc = "Use Sound Alert",
								get = function()
									if WeaponRebuff.db.profile.wrSoundAlarms_lost == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)
									if v then
										WeaponRebuff.db.profile.wrSoundAlarms_lost = 1
									else
										WeaponRebuff.db.profile.wrSoundAlarms_lost = 0
									end
								end,
								order=2
							},
							setsound = {
								type = "text",
								name = "Buff-Lost Sound",
								desc = "Buff-Lost Sound",
								get = function()
									return WeaponRebuff.db.profile.wrSoundIndex_BuffLost
								end,
								set = function(v)
									PlaySoundFile(SMedia:Fetch("sound", v))
									WeaponRebuff.db.profile.wrSoundIndex_BuffLost = v																										
								end,
								validate = SMedia_Sounds,
								order=3					
							}
						}					
					}
					
				}
			},
			-- [[ Buff Selector ]] -- 
			buffselector = {
				type = "group",
				name = "Buff Selector",
				desc = "Options for the Buff Selector bar",
				order= 13,
				args = {
					autoshowcombat = {
						type = "toggle",
						name = "Auto-Show Buff Selector on Combat",
						desc = "Auto-Show Buff Selector on Combat",
						get = function()
							if WeaponRebuff.db.profile.wrOpenOnCombat == 1 then
								return true
							else
								return false
							end
						end,
						set = function(v)	
							if v then
								WeaponRebuff.db.profile.wrOpenOnCombat = 1;
							else
								WeaponRebuff.db.profile.wrOpenOnCombat = 0;						
							end
						end,
						order=1
					},
					twobuffmode = {
						type = "toggle",
						name = "Use Two-Buff Mode",
						desc = "Two-Buff Mode closes the Buff Selector after 2 buffs instead of 1",
						get = function()
							return WeaponRebuff.db.profile.wr2BuffMode
						end,
						set = function(v)	
							WeaponRebuff.db.profile.wr2BuffMode = v
						end,
						order=2
					},
	
					noncombat = {
						type = "group",
						name = "Non-Combat Options",
						desc = "Non-Combat Options",
						order=3,
						args = {
							menudirection = {
								type = "text",
								name = "Set Menu Direction",
								desc = "Set Menu Direction",
								get = function()
									return WeaponRebuff.db.profile.wrMenuDirection_NonCombat							
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrMenuDirection_NonCombat = v
									WeaponRebuff:SetMenuDirection(0, v)
								end,
								validate = {'Left to Right', 'Right to Left', 'Top to Bottom', 'Bottom to Top'}
							},
							attachpoint = {
								type = "text",
								name = "Set Attach Point",
								desc = "Set Attach Point",
								get = function()
									return WeaponRebuff.db.profile.wrMenuPoint_NonCombat
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrMenuPoint_NonCombat = v
									WeaponRebuff:SetMenuAnchorPoint(0, v)
								end,
								validate = {'TOPLEFT', 'TOPRIGHT', 'BOTTOMLEFT', 'BOTTOMRIGHT'}
							},
							
							textselector = {
								type = "toggle",
								name = "Use Text Selector",
								desc = "Use Text Selector",
								get = function()
									if WeaponRebuff.db.profile.wrButtonType_NonCombat == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)	
									if v then
										WeaponRebuff.db.profile.wrButtonType_NonCombat = 1;
									else
										WeaponRebuff.db.profile.wrButtonType_NonCombat = 0;						
									end
								end,
							},
							fontsize = {
								type = "range",
								name = "Font Size",
								desc = "Font Size",
								step = 1,
								min = 1,
								max = 100,
								isPercent = false,
								get = function()
									return WeaponRebuff.db.profile.wrFontSize_NonCombat
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrFontSize_NonCombat = v
								end,
						
							},
							
							iconsize = {
								type = "range",
								name = "Icon Size",
								desc = "Icon Size",
								step = 1,
								min = 1,
								max = 100,
								isPercent = false,
								get = function()
									return WeaponRebuff.db.profile.wrMenuButtonSize_NonCombat
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrMenuButtonSize_NonCombat = v
								end,
	
							}
						}
					},
	
					combat = {
						type = "group",
						name = "Combat Options",
						desc = "Combat Options",
						order=4,
						args = {
							menudirection = {
								type = "text",
								name = "Set Menu Direction",
								desc = "Set Menu Direction",
								get = function()
									return WeaponRebuff.db.profile.wrMenuDirection_Combat
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrMenuDirection_Combat = v
									WeaponRebuff:SetMenuDirection(0, v)
								end,
								validate = {'Left to Right', 'Right to Left', 'Top to Bottom', 'Bottom to Top'}
	
							},
							attachpoint = {
								type = "text",
								name = "Set Attach Point",
								desc = "Set Attach Point",
								get = function()
									return WeaponRebuff.db.profile.wrMenuPoint_Combat
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrMenuPoint_Combat = v
									WeaponRebuff:SetMenuAnchorPoint(1, v)
								end,
								validate = {'TOPLEFT', 'TOPRIGHT', 'BOTTOMLEFT', 'BOTTOMRIGHT'}
							},
							textselector = {
								type = "toggle",
								name = "Use Text Selector",
								desc = "Use Text Selector",
								get = function()
									if WeaponRebuff.db.profile.wrButtonType_NonCombat == 1 then
										return true
									else
										return false
									end
								end,
								set = function(v)	
									if v then
										WeaponRebuff.db.profile.wrButtonType_NonCombat = 1;
									else
										WeaponRebuff.db.profile.wrButtonType_NonCombat = 0;						
									end
								end,
							},
							fontsize = {
								type = "range",
								name = "Font Size",
								desc = "Font Size",
								step = 1,
								min = 1,
								max = 100,
								isPercent = false,
								get = function()
									return WeaponRebuff.db.profile.wrFontSize_Combat
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrFontSize_Combat = v
								end,
						
							},
							
							iconsize = {
								type = "range",
								name = "Icon Size",
								desc = "Icon Size",
								step = 1,
								min = 1,
								max = 100,
								isPercent = false,
								get = function()
									return WeaponRebuff.db.profile.wrMenuButtonSize_Combat
								end,
								set = function(v)
									WeaponRebuff.db.profile.wrMenuButtonSize_Combat = v
								end,
	
							}
						}
					},
	
					
				}
			},
			-- [[ Buff Lists ]] -- 
			bufflists = {
				type = "group",
				name = "Buff Lists",
				desc = "User Modifiable Lists of Buffing Items and Spell Buffs",
--				desc = "Item Buff Lists and Spell Buff Lists have a set of defaults; however, Blizzard's updates (and this author's luck in catching them) being what they are, this facility allows you to add them as you find them without waiting for a mod update -- that said, once you add one to your list, please PM :D\n(As a side effect, you can list pretty much -any- spell/item and have it show up in the Buff Selector)",
				order= 14,
				args = {
					itembuffs = {
						type = "group",
						name = "Item Buffs",
						desc = "Buffs that derive from inventory items",
						args = {
							
				--[[ POISON LIST ]] --
						  -- [[ S P A C E R S ]] --
						  poison_hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=4
							},	
							poison_hdr2 = {
								type = "header",
								name = "Manage Poison",
								cmdHidden = true,
								order=5
							},
						  -- [[ / S P A C E R S ]] --	
		  
							poison_use = {
								type = "toggle",
								name = "Use Poisons",
								desc = "Include Poisons in Buff Selector",
								get = function() return sdp.useCat_ItemPoisons end,
								set = function() sdp.useCat_ItemPoisons = not sdp.useCat_ItemPoisons end,
								order=7
							},	
							poison_add = {
								type = "text",
								name = "Add Buff",
								desc = "Adds a Buff to the list",
								usage = "",
								get = function() return end,
								set = function(v)
									local isUnique, DupedInList = self:IsUniqueItemName(v)
									if isUnique then
										tinsert(sdp.itemPoisons, tostring(v)) 
									else
										WeaponRebuff.ChatPrint(v.." is duplicated in list: ", DupedInList, ". "..wrColor.gold.."Adding Skipped")
									end
								end,
								order = 8
							},
							poison_remove = {
								type = "text",
								name = "Remove buff from list",
								desc = "Remove buff from list",
								current = "",							
								get = function() return  end,
								set = function(v)
									local sdp = WeaponRebuff.db.profile
									for i,v2 in ipairs(sdp.itemPoisons) do 
										if v == v2 then 
											tremove(sdp.itemPoisons, i) 
										end 
									end 
								end,
								-- validate = { } , 
								validate = sdp.itemPoisons,
								order = 9
							},							
							poison_default = {
								type = "execute",
								name = "Restore Defaults",
								desc = "Restores the default list of buffs",
								func = function()
									local sdp = WeaponRebuff.db.profile
									for i,v in ipairs(sdp.itemPoisons) do
        						sdp.itemPoisons[i] = nil
    							end
    
    							for k,v in pairs(T.itemPoisons) do
        						table.insert(sdp.itemPoisons, v)
    							end
								end,
								order = 10
							},

				--[[ OILS LIST ]] --
						  -- [[ S P A C E R S ]] --
						  oils_hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=11
							},	
							oils_hdr2 = {
								type = "header",
								name = "Manage Oils",
								cmdHidden = true,
								order=12
							},
						  -- [[ / S P A C E R S ]] --	
		  
							oils_use = {
								type = "toggle",
								name = "Use Oils",
								desc = "Include Oils in Buff Selector",
								get = function() return sdp.useCat_ItemOils end,
								set = function() sdp.useCat_ItemOils = not sdp.useCat_ItemOils end,
								order=14
							},	
							oils_add = {
								type = "text",
								name = "Add Buff",
								desc = "Adds a Buff to the list",
								usage = "",
								get = function() return end,
								set = function(v) 
									local isUnique, DupedInList = self:IsUniqueItemName(v)
									if isUnique then
										tinsert(sdp.itemOils, tostring(v)) 
									else
										WeaponRebuff.ChatPrint(v.." is duplicated in list: ", DupedInList, ". "..wrColor.gold.."Adding Skipped")
									end
								end,
								order = 15
							},
							oils_remove = {
								type = "text",
								name = "Remove buff from list",
								desc = "Remove buff from list",
								current = "",							
								get = function() return  end,
								set = function(v)
									local sdp = WeaponRebuff.db.profile
									for i,v2 in ipairs(sdp.itemOils) do 
										if v == v2 then 
											tremove(sdp.itemOils, i) 
										end 
									end 
								end,
								-- validate = { } , 
								validate = sdp.itemOils,
								order = 16
							},							
							oils_default = {
								type = "execute",
								name = "Restore Defaults",
								desc = "Restores the default list of buffs",
								func = function()
									local sdp = WeaponRebuff.db.profile
									for i,v in ipairs(sdp.itemOils) do
        						sdp.itemOils[i] = nil
    							end
    
    							for k,v in pairs(T.itemOils) do
        						table.insert(sdp.itemOils, v)
    							end
								end,
								order = 17
							},							
						
						
				--[[ STONES LIST ]] --
						  -- [[ S P A C E R S ]] --
						  stones_hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=18
							},	
							stones_hdr2 = {
								type = "header",
								name = "Manage Weight/Sharpening Stones",
								cmdHidden = true,
								order=19
							},
							stones_hdr3 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=20
							},	
						  -- [[ / S P A C E R S ]] --	
		  
							stones_use = {
								type = "toggle",
								name = "Use Weight/Sharpening Stones",
								desc = "Include Weight/Sharpening Stones in Buff Selector",
								get = function() return sdp.useCat_ItemStones end,
								set = function() sdp.useCat_ItemStones = not sdp.useCat_ItemStones end,
								order=21
							},	
							stones_add = {
								type = "text",
								name = "Add Buff",
								desc = "Adds a Buff to the list",
								usage = "",
								get = function() return end,
								set = function(v) 
									local isUnique, DupedInList = self:IsUniqueItemName(v)
									if isUnique then
										tinsert(sdp.itemStones, tostring(v)) 
									else
										WeaponRebuff.ChatPrint(v.." is duplicated in list: ", DupedInList, ". "..wrColor.gold.."Adding Skipped")
									end
								end,
								order = 22
							},
							stones_remove = {
								type = "text",
								name = "Remove buff from list",
								desc = "Remove buff from list",
								current = "",							
								get = function() return  end,
								set = function(v)
									local sdp = WeaponRebuff.db.profile
									for i,v2 in ipairs(sdp.itemStones) do 
										if v == v2 then 
											tremove(sdp.itemStones, i) 
										end 
									end 
								end,
								-- validate = { } , 
								validate = sdp.itemStones,
								order = 23
							},							
							stones_default = {
								type = "execute",
								name = "Restore Defaults",
								desc = "Restores the default list of buffs",
								func = function()
									local sdp = WeaponRebuff.db.profile
									for i,v in ipairs(sdp.itemStones) do
        						sdp.itemStones[i] = nil
    							end
    
    							for k,v in pairs(T.itemStones) do
        						table.insert(sdp.itemStones, v)
    							end
								end,
								order = 24
							},						
						
						
				--[[ LURES LIST ]] --
						  -- [[ S P A C E R S ]] --
						  lures_hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=25
							},	
							lures_hdr2 = {
								type = "header",
								name = "Manage Lures",
								cmdHidden = true,
								order=26
							},
							lures_hdr3 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=27
							},	
						  -- [[ / S P A C E R S ]] --	
		  
							lures_use = {
								type = "toggle",
								name = "Use Lures",
								desc = "Include Lures in Buff Selector",
								get = function() return sdp.useCat_ItemLures end,
								set = function() sdp.useCat_ItemLures = not sdp.useCat_ItemLures end,
								order=28
							},	
							lures_add = {
								type = "text",
								name = "Add Buff",
								desc = "Adds a Buff to the list",
								usage = "",
								get = function() return end,
								set = function(v) 
									local isUnique, DupedInList = self:IsUniqueItemName(v)
									if isUnique then
										tinsert(sdp.itemLures, tostring(v)) 
									else
										WeaponRebuff.ChatPrint(v.." is duplicated in list: ", DupedInList, ". "..wrColor.gold.."Adding Skipped")
									end
								end,
								order = 29
							},
							lures_remove = {
								type = "text",
								name = "Remove buff from list",
								desc = "Remove buff from list",
								current = "",							
								get = function() return  end,
								set = function(v)
									local sdp = WeaponRebuff.db.profile
									for i,v2 in ipairs(sdp.itemLures) do 
										if v == v2 then 
											tremove(sdp.itemLures, i) 
										end 
									end 
								end,
								-- validate = { } , 
								validate = sdp.itemLures,
								order = 30
							},							
							lures_default = {
								type = "execute",
								name = "Restore Defaults",
								desc = "Restores the default list of buffs",
								func = function()
									local sdp = WeaponRebuff.db.profile
									for i,v in ipairs(sdp.itemLures) do
        						sdp.itemLures[i] = nil
    							end
    
    							for k,v in pairs(T.itemLures) do
        						table.insert(sdp.itemLures, v)
    							end
								end,
								order = 31
							},
						
						
				--[[ MISC LIST ]] --
						  -- [[ S P A C E R S ]] --
						  misc_hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=32
							},	
							misc_hdr2 = {
								type = "header",
								name = "Manage Misc Buffing Items",
								cmdHidden = true,
								order=33
							},
							misc_hdr3 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=34
							},	
						  -- [[ / S P A C E R S ]] --	

							misc_use = {
								type = "toggle",
								name = "Use Misc Buffs",
								desc = "Include Misc Buffs in Buff Selector",
								get = function() return sdp.useCat_ItemMisc end,
								set = function() sdp.useCat_ItemMisc = not sdp.useCat_ItemMisc end,
								order=35
							},
							misc_add = {
								type = "text",
								name = "Add Buff",
								desc = "Adds a Buff to the list",
								usage = "",
								get = function() return end,
								set = function(v) 
									local isUnique, DupedInList = self:IsUniqueItemName(v)
									if isUnique then
										tinsert(sdp.itemMisc, tostring(v)) 
									else
										WeaponRebuff.ChatPrint(v.." is duplicated in list: ", DupedInList, ". "..wrColor.gold.."Adding Skipped")
									end
								end,
								order = 36
							},
							misc_remove = {
								type = "text",
								name = "Remove buff from list",
								desc = "Remove buff from list",
								current = "",							
								get = function() return  end,
								set = function(v)
									local sdp = WeaponRebuff.db.profile
									for i,v2 in ipairs(sdp.itemMisc) do 
										if v == v2 then 
											tremove(sdp.itemMisc, i) 
										end 
									end 
								end,
								-- validate = { } , 
								validate = sdp.itemMisc,
								order = 37
							},							
							misc_default = {
								type = "execute",
								name = "Restore Defaults",
								desc = "Restores the default list of buffs",
								func = function()
									local sdp = WeaponRebuff.db.profile
									for i,v in ipairs(sdp.itemMisc) do
        						sdp.itemMisc[i] = nil
    							end
    
    							for k,v in pairs(T.itemMisc) do
        						table.insert(sdp.itemMisc, v)
    							end
								end,
								order = 38
							},						
						
						
						}
					},				
					spellbuffs = {
						type = "group",
						name = "Spell Buffs",
						desc = "Buffs that derive from spells",
						args = {
						
						  -- [[ S P A C E R S ]] --
						  hdr1 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=1
							},	
							hdr2 = {
								type = "header",
								name = "Manage Spell-Based Buffs",
								cmdHidden = true,
								order=2
							},
							hdr3 = {
								type = "header",
								name = " ",
								cmdHidden = true,
								order=3
							},	
						  -- [[ / S P A C E R S ]] --							
						
						
							add = {
								type = "text",
								name = "Add Buff",
								desc = "Adds a Buff to the list",
								usage = "",
								get = function() return end,
								set = function(v) 
									local sdp = WeaponRebuff.db.profile
									tinsert(sdp.spellNames, tostring(v)) 
								end,
								order = 4
							},
							remove = {
								type = "text",
								name = "Remove buff from list",
								desc = "Remove buff from list",
								current = "",							
								get = function() return  end,
								set = function(v)
									local sdp = WeaponRebuff.db.profile
									for i,v2 in ipairs(sdp.spellNames) do 
										if v == v2 then 
											tremove(sdp.spellNames, i) 
										end 
									end 
								end,
								-- validate = { } , 
								validate = sdp.spellNames,
								order = 5
							},
							
							default = {
								type = "execute",
								name = "Restore Defaults",
								desc = "Restores the default list of buffs",
								func = function()
									local sdp = WeaponRebuff.db.profile
									for i,v in ipairs(sdp.spellNames) do
        						sdp.spellNames[i] = nil
    							end
    
    							for k,v in pairs(T.spellNames) do
        						table.insert(sdp.spellNames, v)
    							end    							
								end,
								order = 6
							}
						}
					}			
				}
			},
			
			
	 		-- [[ S P A C E R S ]] --
			hdr4 = {
				type = "header",
				name = " " ,
				cmdHidden = true,
				order=18
			},	
			hdr5 = {
				type = "header",
				name = "FuBar Options",
				cmdHidden = true,
				order=19
			}
		  -- [[ / S P A C E R S ]] --		
		}
	}
	
	-- [[ Register Chat Commands ]] --
	WeaponRebuff:RegisterChatCommand({"/wr", "/weaponrebuff"}, options, "WEAPONREBUFF")
	
	-- [[ FuBar Options Menu Setup ]] --
	WeaponRebuff.OnMenuRequest = options
	
	-- [[ Setup Waterfall for Config Menu ]] --
	if waterfall then
		waterfall:Register("WeaponRebuff", 
			"aceOptions", options,
			"treeType", "SECTIONS",
			"title", "WeaponRebuff Configuration",
			"colorR", 0.4, "colorG", 0.5, "colorB", 0.7	
		)
	end 
	
end


-- [[ Menu Helper Functions ]] ---------------
	-- [ Used in "Add" option of Buff Lists ] --
function WeaponRebuff:IsUniqueItemName(newitem)
	local sdp = self.db.profile

	-- [[ Poisons ]] --
	for _, wepBuffs in pairs(sdp.itemPoisons) do	
		if wepBuffs == newitem then return false, "Poisons" end
	end
  	
	-- [[ Oils ]] --
	for _, wepBuffs in pairs(sdp.itemOils) do	
		if wepBuffs == newitem then return false, "Oils" end
	end
		
	-- [[ Stones (weight/sharpening) ]] --
	for _, wepBuffs in pairs(sdp.itemStones) do	
		if wepBuffs == newitem then return false, "Stones" end
	end

	-- [[ Lures ]] --
	for _, wepBuffs in pairs(sdp.itemLures) do	
		if wepBuffs == newitem then return false, "Lures" end
	end

	-- [[ Misc ]] --
	for _, wepBuffs in pairs(sdp.itemMisc) do	
		if wepBuffs == newitem then return false, "Misc" end
	end
	
	return true
	
end

function WeaponRebuff:IsUniqueItemName_inSuppList(newitem)
	local sdp = self.db.profile

	-- [[ Suppressed Items ]] --
	for _, name in pairs(sdp.suppBuffs) do	
		if name == newitem then return false end
	end
	
	return true
end